/* 
 * simpelt semafor interface/linux v1 af flower frit efter r.stevens.
 * 
 * implementerer f0lgende semafor operationer:
 *
 * id = sem_create(key,initval)		# opret med init value eller aaben.
 * id = sem_open(key)			# aaben eksisterende semafor.
 * sem_wait(id)				# vent = P = --
 * sem_signal(id)			# op = V = ++
 * sem_op(id,amount)			# vent hvis amount < 0
 *					# op hvis amount > 0
 * sem_close(id)			# luk process adgang til semafor.
 * sem_rm(id)				# fjern semaforen fra system.
 *
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

#define BIGCOUNT 10000

/* operation arrays for semop() calls					*/

static struct sembuf op_lock[2] = {
	2, 0, 0,
	2, 1, SEM_UNDO
};

static struct sembuf op_endcreate[2] = {
	1, -1, SEM_UNDO,
	2, -1, SEM_UNDO
};

static struct sembuf op_open[1] = {
	2, -1, SEM_UNDO
};

static struct sembuf op_close[3] = {
	2, 0, 0,
	2, 1, SEM_UNDO,
	1, 1, SEM_UNDO
};

static struct sembuf op_unlock[1] = {
	2, -1, SEM_UNDO
};

static struct sembuf op_op[1] = {
	0, 99, SEM_UNDO
};

/*
union {
	int	val;
	struct semid_ds *buf;
	ushort	*array;
} semctl_arg;
*/

union semun semctl_arg;

void sem_op(int id,int value) {
	if ((op_op[0].sem_op=value)==0)
		printf("cant have value==0\n");
	if (semop(id,&op_op[0],1)<0)
		printf("sem_op error\n");
}

int sem_create(key_t key, int initval) {
	register int	id, semval;

	if (key==IPC_PRIVATE)
		return -1;
	else if (key==(key_t) -1)
		return -1;

again:
	if ((id=semget(key,3,0666|IPC_CREAT))<0)
		return -1;

	if (semop(id,&op_lock[0],2)<0) {
		if (errno==EINVAL)
			goto again;
		printf("cant lock\n");
	}

	semctl_arg.val=0;
	if ((semval=semctl(id,1,GETVAL,semctl_arg))<0)
		printf("cant GETVAL\n");
	if (semval==0) {
		semctl_arg.val=initval;
		if (semctl(id,0,SETVAL,semctl_arg)<0)
			printf("cant SETVAL[0]\n");
		semctl_arg.val=BIGCOUNT;
		if (semctl(id,1,SETVAL,semctl_arg)<0)
			printf("cant SEVAL[1]\n");
	}

	if (semop(id,&op_endcreate[0],2)<0)
		printf("cant end create\n");

	return id;
}

int sem_open(key_t key) {
	register int	id;

	if (key==IPC_PRIVATE)
		return -1;
	else if (key==(key_t) -1)
		return -1;

	if ((id=semget(key,3,0))<0)
		return -1;

	if (semop(id,&op_open[0],1)<0)
		printf("cant open\n");

	return id;
}

/* fjerner sem hvad enten andre processer bruger den eller ej		*/

void sem_rm(int id) {
	semctl_arg.val=0;
	if (semctl(id,0,IPC_RMID,semctl_arg)<0)
		printf("cant IPC_RMID\n");
}

void sem_close(int id) {
	register int	semval;

	if (semop(id,&op_close[0],3)<0)
		printf("cant semop\n");

	semctl_arg.val=0;
	if ((semval=semctl(id,1,GETVAL,semctl_arg))<0)
		printf("cant GETVAL\n");
	if (semval<BIGCOUNT)
		printf("sem[1] > BIGCOUNT\n");
	else if (semval==BIGCOUNT)
		sem_rm(id);
	else
		if (semop(id,&op_unlock[0],1)<0)
			printf("cant unlock\n");
}

void sem_wait(int id) {
	sem_op(id,-1);
}

void sem_signal(int id) {
	sem_op(id,1);
}

