/* 
 * DDDI (DayDream Door Interface) - A C++ Class Interface for DayDream BBS
 * Coding by: bObO/mYSTiC (east@canit.se)
 *
 * You may use this interface freely however you want, I do not care!
 * However, I'd appreciate if you would send and changes/updates/fixes/
 * patches, etc, to me so we can keep a central version of this interface.
 *
 * You may always reach me at east@canit.se, or at IRCNET (nick: east).
 *
 * As usual, I'm always open for suggestions. Feel free to mail me at any
 * time.
 * 
 * Full credits goes to HYDRA for his DDLIB, which this Interface is based 
 * upon.
 *
 * Adios!
 *  - bObO/mYSTiC (east bbs)
 */

#ifndef _DDDI_h_
#define _DDDI_h_

#include <iostream.h>
#include "String.h" /* String-class support, gnu c++ classes */
#include <dd.h>     /* DayDream_DoorMsg struct from original include */

/*************************** - DO NOT CHANGE */
#define DDDI_VERSION 0
#define DDDI_REVISION 12
/*************************** - USED FOR COMPABILITY */

class DDDI
{
public:
  DDDI();                                   /* constructor */
  virtual ~DDDI();                          /* destructor */

  DDDI(const DDDI&);                        /* copy constructor */
  DDDI& operator =(const DDDI&);            /* assignment operator */

  DDDI& operator <<(const char* pbuf);

  virtual void DDDIMain(int argc, String *argv) = 0;  /* pure virtual */
  
  int ConnectToDaydream(const int node);    /* initialize interface to DD */
  void CloseConnection();                   /* close connection */

  void GetDoorArguments(String& str);       /* for main() -> DDDIMain() */

protected:
  static const int DDDI_VER = DDDI_VERSION;
  static const int DDDI_REV = DDDI_REVISION;

  /* send a string to the user with formatted output */
  virtual void SendString(const char* str, ...);

  /* flags for hotkey */
  enum hotkeyflags {
    HOTKEY_YESNO  = 1,  HOTKEY_NOYES = 2, 
    HOTKEY_CURSOR = 3,  HOTKEY_QUICK = 4 };

  /* hotkey - get a single command from user */
  int HotKey(String& str, int flags = HOTKEY_YESNO);

  /* not in use */
  int Prompt(char* buf, int len, int flags);
  int TypeFile(char* buf, int flags);

  void ChangeNodeStatus(const char* buf);
  void WriteLog(const char* buf);

  /*
  int FindUserName(char* buf);
  int System(char* buf, int mode);
  int DoCmd(char* buf);
  int WriteLog(char* buf);
//  int ChangeStatus(char* buf);
  void Pause();
  int JoinConf(int dc, int fl);
  int IsFreeDl(char* buf);
  int FlagFile(char* buf, int i);
  void GetLprs(struct DayDream_LRP* lp);
  void SetLprs(struct DayDream_LPR* lp);
  int IsConfAccess(int num);
  int IsAnyBasesTagged(int conf);
  int IsConfTagged(int conf);
  int IsBaseTagged(int n, int b);
  void GetMprs(struct DayDream_MsgPointers* lp);
  void SetMprs(struct DayDream_MsgPointers* lp);
  int ChangeMsgBase(int base, int flags);
  void SendFiles(char* buf);
  void GetFiles(char* buf);
  int FileAttach();
  int UnflagFile(char* buf);
  int FindFilesToList(char* file, char* list);
  int IsFileTagged(char* buf);
  int DumpFilesToFile(char* str);
  
  void GetStrVal(char* buf, int val);
  void SetStrVal(char* buf, int val);
  int GetIntVal(int val);
  void SetIntVal(int val);
  unsigned long long GetLIntVal(int val);
  void SetLIntVal(int val, unsigned long long new);
  */

  enum { DMSG_CLOSECONNECTION  = 1,  DMSG_SENDSTRING       = 2,  \
         DMSG_PROMPT           = 3,  DMSG_HOTKEY           = 4,  \
         DMSG_TYPEFILE         = 5,  DMSG_FLAGSINGLE       = 6,  \
         DMSG_FINDUSERNAME     = 7,  DMSG_SYSTEM           = 8,  \
         DMSG_DOCMD            = 9,  DMSG_WRITELOG         = 10, \
         DMSG_CHANGENODESTATUS = 11, DMSG_PAUSE            = 12, \
         DMSG_JOINCONF         = 13, DMSG_ISFREEDL         = 14, \
         DMSG_FLAGFILE         = 15, DMSG_GETLPRS          = 16, \
         DMSG_SETLPRS          = 17, DMSG_ISCONFACCESS     = 18, \
         DMSG_ISANYBASESTAGGED = 19, DMSG_ISCONFTAGGED     = 20, \
         DMSG_ISBASETAGGED     = 21, DMSG_GETMPRS          = 22, \
         DMSG_SETMPRS          = 23, DMSG_CHANGEMSGBASE    = 24, \
         DMSG_SENDFILES        = 25, DMSG_GETFILES         = 26, \
         DMSG_FILEATTACH       = 27, DMSG_UNFLAGFILE       = 28, \
         DMSG_FINDFILESTOLIST  = 29, DMSG_ISFILETAGGED     = 30, \
         DMSG_DUMPFILESTOFILE  = 31,
	 DMSG_DOOR_PARAMETERS  = 129 };

private:
  void SendDMsg();                          /* send msg to daydream (mpDMsg) */

  struct DayDream_DoorMsg* mpDMsg;          /* door-msg structure from dd.h */
  int mDSocket;                             /* door socket file descriptor */
};

#endif
