/* 
 * DDDI (DayDream Door Interface) - A C++ Class Interface for DayDream BBS
 * Coding by: Mike Hammarin (east@canit.se)
 *
 * You may use this interface freely however you want, I do not care!
 * However, I'd appreciate if you would send and changes/updates/fixes/
 * patches, etc, to me so we can keep a central version of this interface.
 *
 * You may always reach me at east@canit.se, or at IRCNET (nick: east).
 *
 * As usual, I'm always open for suggestions. Feel free to mail me at any
 * time.
 * 
 * Full credits goes to HYDRA for his DDLIB, which this Interface is based 
 * upon.
 *
 * Adios!
 *  - bObO/mYSTiC (east bbs)
 */

#ifndef _DDDIUserbase_h_
#define _DDDIUserbase_h_

#include <dd.h>

class DDDIUserbase
{
public:
  DDDIUserbase();                   /* constructor */
  DDDIUserbase(int slot);
  DDDIUserbase(const char* uname);
  ~DDDIUserbase();                  /* destructor */

  void SetUserbasePath(const char* path);

  int GetUserbaseFromSlot(int slot);
  int GetUserbaseFromHandle(const char* uname);

  void ClearErrorState() { mErrorState = ERROR_NONE; };

  char *GetHandle();      /* return handle from mpUserbase-> */

protected:
private:
  enum error_state { ERROR_NONE = 0,  ERROR_INVALID_PATH = -1,
		     ERROR_FILE = -2, ERROR_MEMORY       = -3 };

  void InitializeClass();           /* initialize variables */
  void SetErrorState(error_state state)
    { mErrorState = state; };

  char mUserbasePath[100];          /* path to userbase.dat file */
  struct userbase* mpUserbase;

  error_state mErrorState;
};

#endif
