program Last_Xfers;

uses
	dos, crt;

var
  howmuch   : Integer;
  version,
  down_rep,
  up_rep    : String;
	f2,
	f         : text;
	lines,
	wo,wo2,
	i,j       : integer;
	stats     : array [0..8] of string;
	dir,
  dltxt,
	s         : string;

function instr (ch:char; s:string; from: integer): integer;
var
	i:integer;
begin
	instr := 0;
	for i := from to length(s) do begin
		if (s[i]=ch) then begin
			instr := i;
			break;
		end;
	end;
end;

procedure Intro;
begin
  textcolor(7);
  writeln;
  writeln ('--------------------------------------------------');
  writeln (' paranoia last-xfer v'+version+', external list compiler');
  writeln (' (c)''96 by raiden/pna/phat');
	writeln ('--------------------------------------------------');
	if (paramcount <> 1) then begin
		writeln ('This one is for use with the PNA LAST-XFER PPE only!');
		halt;
	end;
	dir := paramstr(1);
end;

function replacestr (s, was, durch:string): string;
var
	a:integer;
begin
	clrscr;
	repeat
		a := pos (was, s);
		if (a <> 0) then begin
			delete (s, a, length(durch));
			insert (durch, s, a);
		end;
	until (a = 0);
	replacestr := s;
end;

procedure Initialize;
begin
  { check for environment variable "PCBDAT" }
  if (getenv('PCBDAT')='') then begin
    textcolor(lightred);
		writeln ('ERROR: Environment variable "PCBDAT" not set, aborting ...'#13#10);
    textcolor(lightgray);
    halt(10);
  end;

  { get path+filename of DOWNLOAD.TXT out of PCBOARD.DAT }
  assign (f, getenv('PCBDAT'));
  {$I-}
  reset(f);
  if (ioresult <> 0) then begin
    textcolor(lightred);
    writeln ('ERROR: PCBOARD.DAT not found, aborting ...'#13#10);
		textcolor(lightgray);
    halt(10);
  end;
  {$I+}
  for i := 1 to 45 do readln (f, dltxt);
  readln (f, dltxt);
  close(f);

  { grab .cfg file }
	assign (f, dir+'PNA-XFER.CFG');
  {$I-}
  reset (f);
  if (ioresult <> 0) then begin
    textcolor(lightred);
    writeln ('ERROR: PNA-XFER.CFG not found, aborting ...'#13#10);
    textcolor(lightgray);
    halt(10);
  end;
  {$I+}
	readln (f, howmuch);
	readln (f, down_rep);
	readln (f, up_rep);
	close (f);
end;

function get_stat (s:string; nummer:integer): string;
var
	durchlauf,
	a:integer;
begin
	if (nummer>1) then begin
		durchlauf := 0;
		repeat
			a := pos (',', s)+1;
			if (a <> 0) then begin
				s := copy (s, a, length(s)-a+1);
				inc (durchlauf);
			end;
		until (a=0) or (durchlauf=nummer-1);
	end;
	a := pos (',', s);
	if (a <> 0) then s := copy (s, 1, a-1);
	get_stat := s;
end;

procedure Compile_List;
var
	stats		: array [1..100] of string [120];
	counter : array [1..7] of integer;
	stat,
	a				: integer;
	zeile		: string;
const
	macro		: array [1..8] of string [10] =
						('%DIR%', '%USER%', '%DATE%', '%TIME%', '%FILE%', '%P%', '%DONTKNOW%', '%CPS%');
begin
	assign (f, dltxt);
	reset (f);
	{$I-}
	if (ioresult <> 0) then begin
		textcolor(lightred);
		writeln ('ERROR: "DOWNLOAD.TXT" not found (used path/file: '+dltxt+'), aborting ...'#13#10);
		textcolor(lightgray);
    halt(10);
  end;
	{$I+}

	{ anzahl der zeilen in download.txt ermitteln }
	while (not eof (f)) do begin
		readln (f, s);
		inc (lines);
	end;
	close (f);
	reset (f);

	{ bis zu den gewnschten letzten xx zeilen lesen }
	for i := 1 to lines-howmuch do readln (f,s);

	{ die letzten xx zeilen einlesen }
	for i := 1 to howmuch do begin
		readln (f,stats[i]);
	end;
	close(f);

	{	for j := 1 to 8 do begin
			wo := pos (',', s);
			stats [i] := copy (s, 1, wo-1);
			s := copy (s, wo+1, length(s));
		end;
	end;}

	assign (f, dir+'pna-xfer.pcb');
	reset (f);
	assign (f2, dir+'xfers.pcb');
	rewrite (f2);

	for i := 1 to 7 do counter[i] := 1;

	while not eof (f) do begin
		readln (f, zeile);
		for stat := 1 to 7 do begin
			repeat
				a := pos (macro [stat], zeile);
				if (a <> 0) then begin
					if (stat=1) then begin
						if (get_stat(stats[counter[stat]],stat)='(U)') then begin
							zeile := copy (zeile, 1, a-1)+up_rep+copy(zeile,a+length(macrO[stat]),length(zeile)-a);
						end else begin
							zeile := copy (zeile, 1, a-1)+down_rep+copy(zeile,a+length(macrO[stat]),length(zeile)-a);
						end;
					end else
						zeile := copy (zeile, 1, a-1)+get_stat(stats[counter[stat]],stat)+copy(zeile,a+length(macrO[stat]),length(zeile)-a);
					inc (counter [stat]);
				end;
			until (a = 0);
		end;
		writeln (f2, zeile);
	end;

	close (f);
	close (f2);
	halt (0);
end;

begin
	version := '2.OO';
	Intro;
	Initialize;
	Compile_List;
end.