UNIT FADER;  {11th June 1996}   {Version 1.1}

INTERFACE

Uses Crt;

var color : array[0..255] of integer;
    loop : integer;
    or_r :  array[0..255] of byte;
    or_g :  array[0..255] of byte;
    or_b :  array[0..255] of byte;
    r :  array[0..255] of integer;
    g :  array[0..255] of integer;
    b :  array[0..255] of integer;

Procedure GetPal(ColorNo : Byte; Var R,G,B : Byte);
  { This reads the values of the Red, Green and Blue values of a certain
    color and returns them to you. }

Procedure Pal(ColorNo : Byte; R,G,B : Byte);
  { This sets the Red, Green and Blue values of a certain color }

Procedure WaitRetrace;
  {  This waits for a vertical retrace to reduce snow on the screen }

PROCEDURE setupcolors(from,too : integer);
  {sets up the palette.  YOU MUST HAVE THIS}

PROCEDURE resetcolors;
  {resets to original palette.  YOU MUST HAVE THIS}

PROCEDURE fadeblacktonorm (from,too : integer);
  {fades the screen from black to normal}

PROCEDURE fadeblacktowhite (from,too : integer);
  {fades the screen from black to white}

PROCEDURE fadewhitetonorm (from,too : integer);
  {fades the screen from white to normal}

PROCEDURE fadenormtowhite (from,too : integer);
  {fades the screen from normal to white}

PROCEDURE fadewhitetoblack (from,too : integer);
  {fades the screen from white to black}

PROCEDURE fadenormtoblack (from,too : integer);
  {fades the screen from normal to black}

IMPLEMENTATION

Procedure GetPal(ColorNo : Byte; Var R,G,B : Byte);
  { This reads the values of the Red, Green and Blue values of a certain
    color and returns them to you. }
Begin
   Port[$3c7] := ColorNo;
   R := Port[$3c9];
   G := Port[$3c9];
   B := Port[$3c9];
End;

Procedure Pal(ColorNo : Byte; R,G,B : Byte);
  { This sets the Red, Green and Blue values of a certain color }
Begin
   Port[$3c8] := ColorNo;
   Port[$3c9] := R;
   Port[$3c9] := G;
   Port[$3c9] := B;
End;

procedure WaitRetrace; assembler;
  {  This waits for a vertical retrace to reduce snow on the screen }
label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
end;


PROCEDURE setupcolors (from,too : integer);        {sets up the palette}
BEGIN
  for loop := 0 to 255 do begin            {gives each color their value}
    color[loop] := loop;
  end;
  for loop := 0 to 255 do begin                {gets the original palette}
    getpal (color[loop],or_r[loop],or_g[loop],or_b[loop]);
  end;
  for loop := from to too do begin     {sets all colors to black}
    pal (color[loop],0,0,0);
    r[loop] := 0;
    g[loop] := 0;
    b[loop] := 0;
  end;
END;

PROCEDURE resetcolors;
BEGIN
  for loop := 0 to 255 do begin               {sets colors to original}
    pal (color[loop],or_r[loop],or_g[loop],or_b[loop]);
  end;
END;

PROCEDURE fadeblacktonorm (from,too : integer);
var counter :integer;
BEGIN
  counter := 1;

  repeat
    for loop := from to too do begin   {increases all colors by one}
      if or_r[loop] > r[loop] then r[loop] := r[loop] + 1;
      if or_g[loop] > g[loop] then g[loop] := g[loop] + 1;
      if or_b[loop] > b[loop] then b[loop] := b[loop] + 1;
      pal(color[loop],r[loop],g[loop],b[loop]);
    end;
    waitretrace;
    counter := counter + 1;               {until each var has been forfilled}
  until  counter = 63;                             {or equals 63}

End;

PROCEDURE fadeblacktowhite (from,too : integer);
var counter :integer;
BEGIN
  counter := 1;
  for loop := from to too do begin            {gives r,g,b variables original}
      r[loop] := 0;                  {values}
      g[loop] := 0;
      b[loop] := 0;
  end;
  repeat
    for loop := from to too do begin   {increases all colors by one}
      if 63 > g[loop] then r[loop] := r[loop] + 1;
      if 63 > g[loop] then g[loop] := g[loop] + 1;
      if 63 > b[loop] then b[loop] := b[loop] + 1;
      pal(color[loop],r[loop],g[loop],b[loop]);
    end;
    waitretrace;
    counter := counter + 1;               {until each var has been forfilled}
  until  counter = 63;                             {or equals 63}
End;

PROCEDURE fadewhitetonorm (from,too : integer);
var counter :integer;
BEGIN
  counter := 1;
    for loop := from to too do begin            {gives r,g,b variables original}
      r[loop] := 63;                  {values}
      g[loop] := 63;
      b[loop] := 63;
    end;
  repeat
    for loop := from to too do begin   {increases all colors by one}
      if r[loop] > or_r[loop] then r[loop] := r[loop] - 1;
      if g[loop] > or_g[loop] then g[loop] := g[loop] - 1;
      if b[loop] > or_b[loop] then b[loop] := b[loop] - 1;
      pal(color[loop],r[loop],g[loop],b[loop]);
    end;
    waitretrace;
    counter := counter + 1;               {until each var has been forfilled}
  until  counter = 63;                             {or equals 63}
End;

PROCEDURE fadenormtowhite (from,too : integer);
var counter :integer;
BEGIN
  counter := 1;
    for loop := from to too do begin            {gives r,g,b variables original}
      r[loop] := or_r[loop];                  {values}
      g[loop] := or_g[loop];
      b[loop] := or_b[loop];
    end;
  repeat
    for loop := from to too do begin   {increases all colors by one}
      if r[loop] < 63 then r[loop] := r[loop] + 1;
      if g[loop] < 63 then g[loop] := g[loop] + 1;
      if b[loop] < 63 then b[loop] := b[loop] + 1;
      pal(color[loop],r[loop],g[loop],b[loop]);
    end;
    waitretrace;
    counter := counter + 1;               {until each var has been forfilled}
  until  counter = 63;                             {or equals 63}
End;

PROCEDURE fadewhitetoblack (from,too : integer);
var counter :integer;
BEGIN
  counter := 1;
    for loop := from to too do begin            {gives r,g,b variables original}
      r[loop] := 63;                  {values}
      g[loop] := 63;
      b[loop] := 63;
    end;
  repeat
    for loop := from to too do begin   {increases all colors by one}
      if 0 < r[loop] then r[loop] := r[loop] - 1;
      if 0 < g[loop] then g[loop] := g[loop] - 1;
      if 0 < b[loop] then b[loop] := b[loop] - 1;
      pal(color[loop],r[loop],g[loop],b[loop]);
    end;
    waitretrace;
    counter := counter + 1;               {until each var has been forfilled}
  until  counter = 63;                             {or equals 63}
End;


PROCEDURE fadenormtoblack (from,too : integer);
var counter : integer;
BEGIN
  counter := 1;
  for loop := from to too do begin            {gives r,g,b variables original}
    r[loop] := or_r[loop];                  {values}
    g[loop] := or_g[loop];
    b[loop] := or_b[loop];
  end;
  repeat
    for loop := from to too do begin                  {decreases pallette from}
      if 0 < r[loop] then r[loop] := r[loop] - 1;      {original to 0}
      if 0 < g[loop] then g[loop] := g[loop] - 1;
      if 0 < b[loop] then b[loop] := b[loop] - 1;
      pal(color[loop],r[loop],g[loop],b[loop]);
    end;
    waitretrace;
    counter := counter + 1;          {repeats until all colors are black}
  until counter = 63;
End;


BEGIN
END.