
Uses User;

Uses Cfg;

// Change the following constants to configure the script;

Const ;
  max_items   = 100;
  searchx     = 9;
  searchy     = 6;
  searchcol   = '|15';

  list_left   = 6;
  list_top    = 15;
  list_width  = 15;
  list_on     = '|15|17';
  list_off    = '|07';
  list_max    = 8;

  morex       = 9;
  morey       = 23;

  HeaderOffset = 233;

  fx          = 28;
  fy          = 8;
  fstr        = 'adb';

  cx = 1;
  cy = 1;
  cwidth = 80;
  cheight = 12;
  cch = ' ';

  scrollheight = 12;
  scroll_maxlines = 100;
  scroll_width = 40;
  scrollx = 31;
  scrolly = 9;

Type ;
  wallline = Record;
    x: Byte;
    y: Byte;
    str: String;
  End;

Type ;
  scrchar = Record;
    ch: char;
    at: Byte;
  End;


Type ;
  TTDFont = Record;
    A     : char;
    // fixed : 13h;
    typo   : Array[1..18] Of char;
    B    : char;
    // fixed : 1Ah;
    fs    : array[1..4] Of Byte;
    // fixed: 55 AA 00 FF;
    NameLen   : Byte;
    FontName  : array[1..12] Of char;
    nouse   : array[1..4] Of Byte;
    // 00 00 00 00;
    FontType  : Byte;
    // Font Type (byte): 00 = Outline, 01 = Block, 02 = Color;
    Spacing   : Byte;
    // 00 to 40d or ;
    BlockSize  : word;
    // Block Size (Word, Little Endian) Size of character data after main;
    // font definition block, including terminating 0 if followed by another;
    // font (last font in collection is not Null terminated;
    CharAddr  : Array[1..94] Of word;
    // 2 bytes (Word, Little Endian) for each character from ASC(33);
    //(“!”) to ASC(126) (“~”) (94 characters total) with the offset;
    //(starting at 0) after the font header definition where the character;
    // data star;
    ;
    //At 233 begins the font data;
  End;

Type ;
  TFontChar = Record;
    width  : Byte;
    height : Byte;
  End;

Var font    : TTDFont;
Var Datapath   : String;
Var FontFile  : String;
Var screen: array[1..79,1..12] Of scrchar;
Var walltext : array[1..5] Of wallline;
Var wallidx : Byte;
Var Totalitems: Byte;
Var Temp      : Byte;
Var Temp2     : Byte;
Var item      : array[1..max_items] Of String;
Var Idx       : Array[1..max_items] Of Byte;
Var TopPage   : Byte;
Var BarPos    : Byte;
Var Done      : Boolean;
Var Ch         : Char;
Var Ch2        : Char;
Var More      : Byte;
Var LastMore  : Byte;
Var CurDir    : String;
Var ti        : Integer;
Var kk        : char;
Var rootdir   : String;
Var ii : Integer;
Var templpath :  String;
Var tx: Byte;
Var ty: Byte;
Var tattr: Byte;

Procedure ClearArea;
Var o: Byte;
Begin
  For o:=1 To cheight Do
    Begin
      GotoXY(cx,cy+o);
      Write(strrep(cch,cwidth));
    End;
End;

Procedure XWindow(H1:String;T,X1,Y1,X2,Y2:Integer);
Var T1,A1,A2,B1,B2  : String;
Begin
  A1 := Int2Str(X1);
  A2 := Int2Str(X2);
  B1 := Int2Str(Y1);
  B2 := Int2Str(Y2);
  T1 := Int2Str(T);
  Write('|#X#'+T1+'#'+H1+'#'+A1+'#'+B1+'#'+A2+'#'+B2+'#');
End;

Procedure Center(s:String; line:byte);
Begin
  GotoXY(40-(length(stripmci(s)) / 2),line);
  Write(s);
End;

Procedure GetTDFHeader(f:String);
Var 
  fptr : File;
  i : Integer;
Begin
  If Not fileexist(f) Then
    Begin
      Writeln('Font file [ '+f+' ]does not exist');
      Pause;
      Halt;
    End;
  fontfile := f;
  fAssign(fptr,f,66);
  fReset(fptr);
  fRead(fptr,font,sizeof(font));
  fClose(fptr);
End;

Procedure TDFWriteCharBL(x,y:Byte;c:char): Byte;
Var 
  fptr : File;
  i : Integer;
  FChar : TFontChar;
  tbyte : array[1..2] Of Byte;
  sx,sy: Byte;
  asc: Byte;
Begin
  If c=' ' Then
    Begin
      tdfwritecharBL := 1;
      Exit;
    End;
  asc := ord(c)-32;
  fAssign(fptr,fontfile,66);
  fReset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fRead(fptr,FChar,sizeof(Fchar));
  tbyte[1] := 32;
  tbyte[2] := 32;
  GotoXY(x,y);
  While tbyte[1]<>0 And Not feof(fptr) Do
    Begin
      fRead(fptr,tbyte[1],1);
      If tbyte[1]=13 Then
        Begin
          GotoXY(x,WhereY+1);
          If WhereY>25 Then Break;
        End;
      Else
        Begin
          fRead(fptr,tbyte[2],1);
          Textcolor(tbyte[2] % 16 + tbyte[2] - (tbyte[2] % 16));
          Write(chr(tbyte[1]));
          If WhereX>79 Then Break;
        End;
    End ;
  fClose(fptr);
  tdfwritecharbl := fchar.width;
End;

Procedure TDFWriteCharCL(x,y:Byte;c:char): Byte;
Var 
  fptr : File;
  i : Integer;
  FChar : TFontChar;
  tbyte : array[1..2] Of Byte;
  sx,sy: Byte;
  asc: Byte;
Begin
  If c=' ' Then
    Begin
      tdfwritecharcl := 1;
      Exit;
    End;
  asc := ord(c)-32;
  fAssign(fptr,fontfile,66);
  fReset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fRead(fptr,FChar,sizeof(Fchar));
  tbyte[1] := 32;
  GotoXY(x,y);
  While tbyte[1]<>0 And Not feof(fptr) Do
    Begin
      fRead(fptr,tbyte[1],1);
      If tbyte[1]=13 Then
        Begin
          GotoXY(x,WhereY+1);
          If WhereY>25 Then Break;
        End;
      Else
        Begin
          Write(chr(tbyte[1]));
          If WhereX>79 Then Break;
        End;
    End ;
  fClose(fptr);
  tdfwritecharcl := fchar.width;
End;

Procedure TDFWrite(x,y:Byte; s:String);
Var 
  i: Byte;
  sx,sy: Byte;
Begin
  GotoXY(x,y);
  sx := x;
  sy := y;
  Case font.fonttype Of ;
    2:
       Begin
         For i:=1 To length(s) Do
           Begin
             sx := sx+tdfwritecharBL(sx,y,s[i])+font.spacing;
           End;
       End;
    1:
       Begin
         For i:=1 To length(s) Do
           Begin
             sx := sx+tdfwritecharCL(sx,y,s[i])+font.spacing;
           End;
       End;
  End;
End;

Procedure BarON;
Begin
  GotoXY (list_left, list_top + BarPos - TopPage);
  Write (list_on+' ' + PadLT(StripMCI(item[BarPos]), list_width, ' ') + '|16');
End;

Procedure BarOFF;
Begin
  GotoXY (list_left, list_top + BarPos - TopPage);
  Write (list_off+' ' + PadLT(item[BarPos], list_width, ' '));
End ;

Procedure clearitems;
Var i: Integer;
Begin
  For i:=1 To max_items Do
    item[i] := '';
  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;
End;

Procedure DrawPage;
Begin
  Temp2 := BarPos;
  For Temp := 0 To (list_max-1) Do
    Begin ;
      BarPos := TopPage + Temp;
      BarOFF;
    End;
  BarPos := Temp2;
  BarON;
End ;

Procedure MainScreen;
Var
  zi:byte
Begin
  ClrScr;
  DispFile (datapath+'xq-dawall'+pathchar+ 'xq-dawall');
  GotoXY(31,23);
  Write('|15PGUP|08/|15PGDN|07 Move Cursor / |07Press |15CTRL-Z |07for Help');
  For zi:=0 to 4 Do Begin
    GotoXY(31,18+zi);
    Write('|08'+Int2Str(zi+1)+'.');
  End;
  GotoXY(31,walltext[wallidx].y);
  Write('|15'+Int2Str(wallidx)+'|08.');
End;

Procedure ShowTemplate(fn:String);
Begin
  gotoxy (1,2);
  dispfile (templpath+fn);
End;

Procedure HelpScreen;
Begin
  ClrScr;
  bufflush;
  DataPath := JustPath(ProgName); ;
  gettdfheader(datapath+'acidscape_sl.tdf');
  // Init the font to use
  font.spacing := 1;
  xwindow(' Keys ',1,20,7,60,20);
  tdfwrite(25,2,'Help') ;
  GotoXY(22,8);
  Write('|15CTRL-S    : |07Save Image to DaWall');
  GotoXY(22,10);
  Write('|15Enter     : |07Select / Apply Changes');
  GotoXY(22,11);
  Write('|15End       : |07Bottom List');
  GotoXY(22,12);
  Write('|15Home      : |07Top List');
  GotoXY(22,13);
  Write('|15Up/Down   : |07Move Templ. Selection');
  GotoXY(22,14);
  Write('|15Escape    : |07Abort / Go Back')
  GotoXY(22,16);
  Write('|15BackSpace : |07Erase Text')
  GotoXY(22,17);
  Write('|15Page Up   : |07Move Text Sel. Up')
  GotoXY(22,18);
  Write ('|15Page Down : |07Move Text Sel. Down')

  center(searchcol+'Press Any Key to Continue...|PN',24);
  mainscreen;
  drawpage;
  bufflush;
End;

Procedure fuckSort;
Var 
  i, j: Integer;
  temp1 : String;
Begin
  For j:=1 To totalitems Do;
  For i := 2 To totalitems Do
    Begin
      If item[i-1]>item[i] Then
        Begin
          temp1 := item[i-1];
          item[i-1] := item[i];
          item[i] := temp1;
        End;

    End;
End;

Procedure saveimagetowall;
Var 
  qx,qy: Byte;
  Fp  : String;
  FG,BG : byte
          pFG,pBG : byte
                    C   : Char;
  S   : String;
Begin
  For qx:=1 To 79 Do;
  For qy:=1 To 12 Do
    Begin
      screen[qx,qy].ch := getcharxy(qx,qy+1);
      screen[qx,qy].at := getattrxy(qx,qy+1);
    End;
  fp := datapath+'xq-dawall'+pathchar+'dawall.ans';
  pFG := 0
         pBG:=0;
  s := '|07|16'
       For qy:=1 To 12 Do Begin
       For qX:=1 To 79 Do
       Begin
       FG := screen[qX,qY].at % 16
       BG:=16+(screen[qX,qY].at / 16)
       If pFG <> FG Then s:=s+'|'+padlt(int2str(fg),2,'0') ;
  If pBG <> BG Then s := s+'|'+padlt(int2str(bg),2,'0') ;
  C := screen[qX,qY].ch
       s:=s+chr(ord(C))
       pFG:=FG
       pBG:=BG;
End;
AppendText(fp,s);
s := '';
End;
End;

Procedure getfiles(dir:String);
Var 
  i: Integer;
Begin
  i := 0;
  //item[1]:='..';
  FindFirst (dir+'*.ans', 63);
  While DosError = 0 Do
    Begin
      If dirname<>'.' And dirname<>'..'Then ;
      If i<=max_items Then
        Begin
          i := i+1;
          item[i] := DirName;
        End;
      FindNext;
    End;
  FindClose;
  fucksort;
  totalitems := i
End;

Procedure editscreen;
Begin

  GetThisUser;
  clearitems;
  getfiles(templpath);

  If Totalitems = 0 Then
    Begin
      WriteLn ('No files or directories to display');
      Writeln('|PA');
      Halt;
    End;

  mainscreen;
  // DispFile (CfgTextPath + 'tdfgallery');

  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;


  DrawPage;

  Repeat;
    More := 0;
    Ch   := ' ';
    Ch2  := ' ';

    If TopPage > 1 Then
      Begin
        More := 1;
        Ch   := Chr(244);
      End;

    If TopPage + (list_max-1) < Totalitems Then
      Begin
        Ch2  := Chr(245);
        More := More + 2;
      End;

    If More <> LastMore Then
      Begin
        LastMore := More;
        GotoXY (morex,morey);
        Write (' |08(|07' + Ch + Ch2 + ' |15m|07ore|08) ');
      End;

    If keypressed Then
      Begin ;
        Ch := ReadKey;
        If IsArrow Then
          Begin
            //HOME key;
            If ch = chr(71) Then
              Begin
                ;
                TopPage := 1;
                BarPos  := 1;
                drawpage;
              End;
            //END Key;
            If ch = chr(79) Then
              Begin
                ;
                If Totalitems > list_max Then
                  Begin
                    TopPage := Totalitems - (list_max-1);
                    BarPos  := Totalitems;
                  End
                Else
                  Begin
                    BarPos  := Totalitems;
                  End;
                drawpage;
              End;

            If Ch = Chr(72) Then
              Begin

                If BarPos > TopPage Then
                  Begin
                    BarOFF;
                    BarPos := BarPos - 1;
                    BarON;
                  End;
                Else;
                If TopPage > 1 Then
                  Begin
                    TopPage := TopPage - 1;
                    BarPos  := BarPos  - 1;
                    DrawPage;
                  End;
              End;

            If Ch = Chr(73) Then
              Begin
                GotoXY(walltext[wallidx].x,walltext[wallidx].y);
                Write('|08|16'+int2str(wallidx));
                If wallidx=1 Then wallidx := 5
                Else wallidx := wallidx-1;
                GotoXY(walltext[wallidx].x,walltext[wallidx].y);
                Write('|15|16'+int2str(wallidx));
              End;

            If Ch = Chr(80) Then
              Begin

                If BarPos < Totalitems Then;
                If BarPos < TopPage + (list_max-1) Then
                  Begin
                    BarOFF;
                    BarPos := BarPos + 1;
                    BarON;
                  End;
                Else;
                If BarPos < Totalitems Then
                  Begin
                    TopPage := TopPage + 1;
                    BarPos  := BarPos  + 1;
                    DrawPage;
                  End;
              End

              If Ch = Chr(81) Then
                Begin
                  GotoXY(walltext[wallidx].x,walltext[wallidx].y);
                  Write('|08|16'+int2str(wallidx));
                  wallidx := wallidx+1;
                  If wallidx>5 Then wallidx := 1;
                  GotoXY(walltext[wallidx].x,walltext[wallidx].y);
                  Write('|15|16'+int2str(wallidx));
                End
                ch := #0;
          End
        Else;

        If Ch = Chr(26) Then
          Begin
            helpscreen;
            Ch := ReadKey;
            ClrScr;
            mainscreen;
            DrawPage;
            //End;
          End;
        Else If Ch =chr(4) Then
               Begin
                 If fileexist(curdir+item[barpos]) Then
                   Begin
                     menucmd('GT',
                             '|#V#1#20#10# Download File #Y-Yes             ,N-No             #');
                     kk := readkey;
                     If upper(kk)='Y' Then MenuCmd ('F3', curdir+item[barpos]);
                     mainscreen;
                     DrawPage;
                   End;
               End
        Else If Ch = Chr(5) Then
               Begin
                 mainscreen;
                 DrawPage;
               End
        Else If Ch = Chr(13) Then
               Begin
                 ;
                 If fileexist(templpath+item[barpos]) Then
                   Begin
                     cleararea;
                     showtemplate(item[barpos]);
                     For ti:=1 To 5 Do
                       Begin
                         getscreeninfo(ti,tx,ty,tattr);
                         GotoXY(tx,ty);
                         Textcolor(tattr);
                         Write(walltext[ti].str);
                       End;

                   End;
               End;
        If Ch = Chr(27) Then
          Begin
            If curdir = rootdir Then Done := True;

          End
        Else;
        If ch = chr(19) Then
          Begin
            menucmd('GT','|#V#1#20#10# Save Image? #Y-Yes             ,N-No             #');
            kk := readkey;
            If upper(kk)='Y' Then
              Begin
                saveimagetowall;
                Halt;
              End;
          End
        Else;
        If ch = chr(8) Then
          Begin
            GotoXY(walltext[wallidx].x+3,walltext[wallidx].y);
            Write(strrep(' ',length(walltext[wallidx].str)));
            walltext[wallidx].str := copy(walltext[wallidx].str,1,length(walltext[wallidx].str)-1);
            GotoXY(walltext[wallidx].x+3,walltext[wallidx].y);
            Write(walltext[wallidx].str);
          End
        Else;
        If ch>=chr(32) And ch<=chr(128) Then
          Begin
            walltext[wallidx].str := walltext[wallidx].str+ch;
            GotoXY(walltext[wallidx].x+3,walltext[wallidx].y);
            Textcolor(7);
            Write(searchcol+walltext[wallidx].str) ;
          End;
      End;

  Until Done;

End;

//Main loop

Begin
  ClrScr;

  If Graphics = 0 Then
    Begin
      Writeln('|16|15No Graphics support. Exiting... |PA');
      Halt;
    End;

  datapath := justpath(progname);
  templpath := datapath+'xq-dawall'+pathchar+'templates'+pathchar;
  wallidx := 1;
  For ti:=1 To 5 Do
    Begin
      walltext[ti].x := 31;
      walltext[ti].y := 17+ti;
      walltext[ti].str := '';
    End;

  If fileexist(datapath+'xq-dawall'+pathchar+'dawall.ans') Then
    Begin
      GotoXY(1,1);
      dispfile(datapath+'xq-dawall'+pathchar+'dawall.ans');
      Textcolor(7);
      If InputNY('Add to DaWall?') Then editscreen;
    End
  Else
    Begin
      editscreen;
      GotoXY (1, 23);
    End;

End
