#!/usr/bin/env python3

from pycrt import *
from countries import *
import time
import xinput
import re
import os
import sys
import sqlite3
import xmenulist
from xbox import *

#Variables
SysDir = sys.path[0]
isarm = False
table = ""

if os.uname()[4].startswith("arm")=='arm':
  isarm = True
  
def cleartext():
  settextattr(7)
  cleararea(27,2,77,23,' ')
    
def connect(filename):
  conn = None
  try:
    conn = sqlite3.connect(filename)
    return conn
  except Error as e:
    print(e)
 
  return conn
  
def showansi(ansifile):
  settextattr(7)
  clrscr()
  dispfile2(SysDir+pathchar+ansifile,0)
   
def show_countries(filename):
  items = []
  for i in range(len(countries) // 2):
    items.append(countries[i*2+1])
  while True:
    showansi('main.ans')
    writexy(6,3,15+7*16,'Countries')
    xmenulist.exit_keys.clear()
    xmenulist.exit_keys.append('#esc')
    xmenulist.exit_keys.append('#ctrlz')
    xmenulist.exit_keys.append('#ctrlf')
    xmenulist.exit_keys.append('#ctrld')
    sel=xmenulist.menulist(items,4,6,23,23)
    if xmenulist.exit_code == '#esc':
      break
    elif xmenulist.exit_code == '#ctrlz':
      showansi('helpc.ans')
      readkey()
    elif xmenulist.exit_code == '#ctrlf':
      find_menu(filename,countries[sel*2])
    elif xmenulist.exit_code == '#ctrld':
      exportcsv(filename,countries[sel*2])
      downloadfile(SysDir+pathchar+countries[sel*2]+'.csv')
      time.sleep(1)
      os.remove(SysDir+pathchar+countries[sel*2]+'.csv')
    elif xmenulist.exit_code == '#enter':
      #show_country(filename,countries[items.index(items[sel])*2])
      show_results(filename,countries[items.index(items[sel])*2+1],"SELECT * FROM "+countries[items.index(items[sel])*2]+" ORDER by downlink ASC",False)

def show_country(filename,country):
  con = connect(filename)  
  items = []
  if con == None:
    ansibox(20,10,50,14,box11)
    writexy(22,11,15,'Could not load database.')
    readkey()
  cursor = con.cursor()
  cursor.execute("SELECT * FROM "+country+" ORDER by downlink ASC")
  records = cursor.fetchall()
  items.clear()
  for row in records:
    items.append(row[14])
  sel = 0
  showansi('main.ans')
  while True:
    writexy(4,3,15+7*16,countries[countries.index(country)*2+1][:20])
    xmenulist.exit_keys.clear()
    xmenulist.exit_keys.append('#esc')
    xmenulist.exit_keys.append('#ctrli')
    sel=xmenulist.menulist(items,4,6,23,23,15,7,sel)
    if xmenulist.exit_code == '#esc':
      break
    elif xmenulist.exit_code == '#ctrli':
      settextattr(7)
      ansibox(10,10,70,15,box12)
      writexy(12,12,15,"Google Maps Link")
      writexy(12,13,7,"https://www.google.gr/maps/@"+records[sel][24]+","+records[sel][23]+",15z")
      readkey()
      showansi('main.ans')
      cleartext()
    elif xmenulist.exit_code == '#enter':
      #cleartext()
      #cursor.execute('SELECT * FROM '+country+' WHERE downlink="'+items[sel]+'"')
      #row = cursor.fetchone()
      writexypipe(27,2,8,20,'Location')
      writexypipe(27,3,8,50,'Area         : |07'+records[sel][22])
      writexypipe(27,4,8,50,'Lat          : |07'+records[sel][24])
      writexypipe(27,5,8,50,'Long         : |07'+records[sel][23])
      writexypipe(27,6,8,50,'Coverage     : |07'+records[sel][18][:30])
      
      writexypipe(27,8,8,20,'Contact')
      writexypipe(27,9,8,50,'ID           : |07'+records[sel][0])
      writexypipe(27,10,8,50,'CallID       : |07'+records[sel][1])
      writexypipe(27,11,8,50,'Downlink     : |07'+records[sel][14])
      writexypipe(27,12,8,50,'Downlink Tone: |07'+records[sel][15])
      writexypipe(27,13,8,50,'Uplink       : |07'+records[sel][3])
      writexypipe(27,14,8,50,'Uplink Tone  : |07'+records[sel][13])
      writexypipe(27,15,8,50,'Offset       : |07'+records[sel][17])
      
      writexypipe(27,17,8,50,'Echolink     : |07'+records[sel][4])
      writexypipe(27,18,8,50,'Modes        : |07'+records[sel][11])
      writexypipe(27,19,8,50,'Status       : |07'+records[sel][21])
      
      writexypipe(27,21,8,50,'Notes        : |07'+records[sel][10])
      writexypipe(27,22,8,50,'Weblinks     : |07'+records[sel][12])
  
  cursor.close()
  
def downloadfile(filename):
  if not os.path.isfile(filename):
    return -1
  os.system('sz -4 '+filename)
  #os.system('/home/pi/mystic/sexyz sz '+filename)
  readkey()

def exportcsv(filename,table):
  con = connect(filename)  
  items = []
  if con == None:
    ansibox(20,10,50,14,box12)
    writexy(22,11,15,'Could not load database.')
    readkey()
    return
  cursor = con.cursor()
  cursor.execute("SELECT * from "+table+";")
  records = cursor.fetchall()
  with open(SysDir+pathchar+table+'.csv','w') as f:
    for row in records:
      for k in range(len(row)-1):
        f.write('"'+row[k]+'",')
      f.write('"'+row[len(row)-1]+'"\n')
  cursor.close()
  con.close()

def show_results(filename,title,sql,global_search):
  con = connect(filename)  
  items = []
  if con == None:
    ansibox(20,10,50,14,box12)
    writexy(22,11,15,'Could not load database.')
    readkey()
    return
  cursor = con.cursor()
  #cursor.execute("SELECT * FROM "+country+" ORDER by downlink ASC")
  if not global_search:
    cursor.execute(sql)
    records = cursor.fetchall()
  else:
    records=[]
    cursor.execute("SELECT name FROM sqlite_master WHERE type='table'")
    for tablerow in cursor.fetchall():
      table = tablerow[0]
      cursor.execute("SELECT * FROM {} WHERE {} LIKE '%{}%'".format(table,sql.split(';')[0],sql.split(';')[1]))
      a = cursor.fetchall()
      if len(a) !=0:
        records.append(a)
    records = [j for i in records for j in i]
  if len(records) == 0:
    ansibox(20,10,50,14,box12)
    writexy(22,12,15,'No matches found...')
    readkey()
    return
  items.clear()
  for row in records:
    items.append(row[1].ljust(8,' ')+"/"+row[14].rjust(9,' '))
  sel = 0
  showansi('main.ans')
  while True:
    writexy(4,3,15+7*16,title[:20])
    xmenulist.exit_keys.clear()
    xmenulist.exit_keys.append('#esc')
    xmenulist.exit_keys.append('#ctrli')
    xmenulist.exit_keys.append('#ctrle')
    xmenulist.exit_keys.append('#ctrlz')
    sel=xmenulist.menulist(items,4,6,23,23,15,7,sel)
    if xmenulist.exit_code == '#esc':
      break
    elif xmenulist.exit_code == '#ctrlz':
      showansi('helpr.ans')
      readkey()
      showansi('main.ans')
    elif xmenulist.exit_code == '#ctrli':
      settextattr(7)
      ansibox(10,10,70,15,box12)
      writexy(12,12,15,"Google Maps Link")
      writexy(12,13,7,"https://www.google.gr/maps/@"+records[sel][24]+","+records[sel][23]+",15z")
      readkey()
      showansi('main.ans')
      cleartext()
    elif xmenulist.exit_code == '#ctrle':
      with open(SysDir+pathchar+'results.csv','w') as f:
        for row in records:
          for k in range(len(row)-1):
            f.write('"'+row[k]+'",')
        f.write('"'+row[len(row)-1]+'"\n')
      downloadfile(SysDir+pathchar+'results.csv')
      time.sleep(1)
      os.remove(SysDir+pathchar+'results.csv')
    elif xmenulist.exit_code == '#enter':
      #cleartext()
      #cursor.execute('SELECT * FROM '+country+' WHERE downlink="'+items[sel]+'"')
      #row = cursor.fetchone()
      writexypipe(27,2,8,20,'Location')
      writexypipe(27,3,8,50,'Area         : |07'+records[sel][22])
      writexypipe(27,4,8,50,'Lat          : |07'+records[sel][24])
      writexypipe(27,5,8,50,'Long         : |07'+records[sel][23])
      writexypipe(27,6,8,50,'Coverage     : |07'+records[sel][18][:30])
      
      writexypipe(27,8,8,20,'Contact')
      writexypipe(27,9,8,50,'ID           : |07'+records[sel][0])
      writexypipe(27,10,8,50,'CallID       : |07'+records[sel][1])
      writexypipe(27,11,8,50,'Downlink     : |07'+records[sel][14])
      writexypipe(27,12,8,50,'Downlink Tone: |07'+records[sel][15])
      writexypipe(27,13,8,50,'Uplink       : |07'+records[sel][3])
      writexypipe(27,14,8,50,'Uplink Tone  : |07'+records[sel][13])
      writexypipe(27,15,8,50,'Offset       : |07'+records[sel][17])
      
      writexypipe(27,17,8,50,'Echolink     : |07'+records[sel][4])
      writexypipe(27,18,8,50,'Modes        : |07'+records[sel][11])
      writexypipe(27,19,8,50,'Status       : |07'+records[sel][21])
      
      writexypipe(27,21,8,50,'Notes        : |07'+records[sel][10])
      writexypipe(27,22,8,50,'Weblinks     : |07'+records[sel][12])
  
  cursor.close()
  con.close()


def find_menu(filename,table):
  items = []
  while True:
    showansi('main.ans')
    writexy(6,3,15+7*16,'Database / Date')
    files = os.listdir(SysDir)
    items.clear()
    items.append('Call ID')
    items.append('Frequency');
    items.append('RepeaterBook ID');
    items.append('Mode');
    items.append('Status');
    items.append('Longitude');
    items.append('Lattitude');
    xmenulist.exit_keys.clear()
    xmenulist.exit_keys.append('#esc')
    sel=xmenulist.menulist(items,4,6,23,23)
    if xmenulist.exit_code == '#esc':
      break
    elif xmenulist.exit_code == '#enter':
      ansibox(10,10,60,14,box12)
      writexy(12,11,7,"Search:")
      query = xinput.input(12,12,15,8,xinput.cs_printable,47,47,chr(176),'')
      if query.strip() == "":
        return -1
      if table == 'global':
        if sel == 0:
          show_results(filename,'Call ID',"call;"+query,True)
        if sel == 1: #freq
          show_results(filename,'Frequency',"downlink;"+query,True)
        if sel == 2: #id
          show_results(filename,'Rep.ID',"id;"+query,True)
        if sel == 3: #mode
          show_results(filename,'Mode',"mode;"+query,True)
        if sel == 4: #status
          show_results(filename,'Status',"status;"+query,True)
        if sel == 5: #long
          show_results(filename,'Longitude',"long;"+query,True)
        if sel == 6: #lat
          show_results(filename,'Lattitude',"lat;"+query,True)
      else:
        if sel == 0:
          show_results(filename,'Call ID',"SELECT * FROM "+table+" WHERE call LIKE '%"+query+"%';",False)
        if sel == 1: #freq
          show_results(filename,'Frequency',"SELECT * FROM "+table+" WHERE downlink LIKE '%"+query+"%';",False)
        if sel == 2: #id
          show_results(filename,'Rep.ID',"SELECT * FROM "+table+" WHERE id LIKE '%"+query+"%';",False)
        if sel == 3: #mode
          show_results(filename,'Mode',"SELECT * FROM "+table+" WHERE mode LIKE '%"+query+"%';",False)
        if sel == 4: #status
          show_results(filename,'Status',"SELECT * FROM "+table+" WHERE status LIKE '%"+query+"%';",False)
        if sel == 5: #long
          show_results(filename,'Longitude',"SELECT * FROM "+table+" WHERE long LIKE '%"+query+"%';",False)
        if sel == 6: #lat
          show_results(filename,'Lattitude',"SELECT * FROM "+table+" WHERE lat LIKE '%"+query+"%';",False)
        
  
def main():
  global table
  items = []
  while True:
    showansi('main.ans')
    writexy(6,3,15+7*16,'Database / Date')
    files = os.listdir(SysDir)
    items.clear()
    for f in files:
      if '.sq3' in f:
        items.append(f[:-4])
    items.sort()
    xmenulist.exit_keys.clear()
    xmenulist.exit_keys.append('#esc')
    xmenulist.exit_keys.append('#ctrlz')
    xmenulist.exit_keys.append('#ctrlf')
    #xmenulist.exit_keys.append('#ctrld')
    sel=xmenulist.menulist(items,4,6,23,23)
    if xmenulist.exit_code == '#esc':
      break
    elif xmenulist.exit_code == '#ctrld':
      downloadfile(SysDir+pathchar+items[sel]+'.sq3')
    elif xmenulist.exit_code == '#ctrlf':
      find_menu(SysDir+pathchar+items[sel]+'.sq3','global')
    elif xmenulist.exit_code == '#ctrlz':
      showansi('helpm.ans')
      readkey()
    elif xmenulist.exit_code == '#enter':
      show_countries(SysDir+pathchar+items[sel]+'.sq3')

ansi_on()
showansi('intro.ans')
time.sleep(2)
main()
