@echo off
chcp 65001 >nul
setlocal enabledelayedexpansion

set "version=1.0"
set "datum=22. Januar 2025"

:main
cls
echo ========================================================
echo                FFmpeg Audio Normalisierer v%version%
echo                Erstellt am: %datum%
echo --------------------------------------------------------
echo Diese Batch-Datei normalisiert die Lautstärke einer Audiodatei
echo und speichert sie in einer neuen Datei mit dem Zusatz '-Normalized'.
echo --------------------------------------------------------
echo Bitte legen Sie diese Batch-Datei in denselben Ordner wie
echo 'ffmpeg.exe', welches Sie von hier herunterladen können:
echo https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest
echo ========================================================
echo.
echo Wählen Sie eine Option:
echo [1] Normalisierungsprozess starten
echo.
echo [D] Verzeichnisinhalt anzeigen
echo [Q] Programm beenden
echo.

set /p option=
if /i "!option!"=="1" goto input
if /i "!option!"=="D" goto directory
if /i "!option!"=="Q" goto end

echo Ungültige Eingabe. Bitte versuchen Sie es erneut.
pause
goto main

:directory
cls
echo ========================================================
echo                    Verzeichnisinhalt
echo ========================================================
echo.
dir /b /o:n /t:w
echo.
echo Sie können den Dateinamen mit der Maus markieren und entweder mit Rechtsklick kopieren oder mit STRG+C.
echo.
pause
goto main

:input
cls
echo ========================================================
echo                FFmpeg Audio Normalisierer v%version%
echo                Erstellt am: %datum%
echo --------------------------------------------------------
echo Diese Batch-Datei normalisiert die Lautstärke einer Audiodatei
echo und speichert sie in einer neuen Datei mit dem Zusatz '-Normalized'.
echo ========================================================
echo.
echo Bitte geben Sie den Namen der Original-Datei ein (mit Erweiterung, z.B. "datei.wav"):
echo Oder ziehen Sie die Datei einfach in dieses Fenster und drücken Sie Enter.
echo.
set /p quelle=

:: Anführungszeichen entfernen, falls vorhanden
set "quelle=!quelle:"=!"

echo.
echo Sie haben !quelle! eingegeben.
echo Das Programm wird den Prozess starten, um die Datei zu normalisieren und die Ausgangsdatei zu erstellen.
echo.

echo Wollen Sie mit diesem Prozess fortfahren? [J]a / [N]ein / [Q]uit
set /p confirm=
if /i "!confirm!"=="J" goto process
if /i "!confirm!"=="N" goto input
if /i "!confirm!"=="Q" goto end

:process
if not exist "ffmpeg.exe" (
    echo.
    echo FFmpeg wurde nicht gefunden. Bitte stellen Sie sicher, dass die Datei 'ffmpeg.exe' im gleichen Verzeichnis wie diese Batch-Datei liegt.
    echo.
    pause
    goto main
)
if not exist "!quelle!" (
    echo.
    echo Die Datei !quelle! wurde nicht gefunden. Bitte überprüfen Sie den Dateinamen und versuchen Sie es erneut.
    echo.
    pause
    goto input
)
set "ausgabe=!quelle!"
set "ausgabe=!ausgabe:.wav=-Normalized.wav!"
ffmpeg.exe -i "!quelle!" -af "loudnorm=I=-10:TP=-1" -ar 48000 -ac 2 -c:a pcm_f32le "!ausgabe!"
if %errorlevel% neq 0 (
    echo.
    echo Fehler bei der Normalisierung. Weitere Details finden Sie in der log.txt Datei.
    echo.
) else (
    echo.
    echo Die Ausgangsdatei "!ausgabe!" wurde erstellt.
    echo.
)
pause
goto main

:end
cls
echo ========================================================
echo Diese Datei wurde von Andreas 'melcom' Urban erstellt.
echo Diese Datei ist frei und kostenlos und darf von jedem
echo verändert und weitergegeben werden.
echo --------------------------------------------------------
echo Bei Fragen können Sie melcom über folgenden Link kontaktieren:
echo https://www.melcom-music.de/p/contact.html
echo ========================================================
echo.
pause
exit
