
/* Events source file */

#include <exec/types.h>
#include <exec/memory.h>
#include <intuition/intuition.h>
#include <intuition/gadgetclass.h>
#include <dos/dos.h>
#include <libraries/asl.h>
#include <workbench/workbench.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/utility_protos.h>
#include <clib/asl_protos.h>
#include <clib/dos_protos.h>
#include <clib/icon_protos.h>
#include <clib/wb_protos.h>

#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/gadtools_pragmas.h>
#include <pragmas/utility_pragmas.h>
#include <pragmas/asl_pragmas.h>
#include <pragmas/dos_pragmas.h>
#include <pragmas/icon_pragmas.h>
#include <pragmas/wb_pragmas.h>

#include "VIC20.h"
#include "VIC20_asm.h"

BOOL mem3k = FALSE;
BOOL mem8k1 = FALSE;
BOOL mem8k2 = FALSE;
BOOL mem8k3 = FALSE;
BOOL speedometer = FALSE;
BOOL interlace = FALSE;
BOOL hires = FALSE;
BOOL multisync = FALSE;
BOOL paddles = FALSE;
BOOL cassette = FALSE;
BOOL diskdrive = FALSE;
UWORD speedgfx = 0x0034;
UBYTE dirName[128] = "";
UBYTE fileName[128] = "";
UBYTE prefName[128] = "VIC20.prefs";
BPTR oldDir = NULL;

/* Prototypes */
 
BOOL EventFunc_CONTINUE(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_RESET(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_LOADPREF(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_SAVEPREF(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_LOADCART(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CHANGEDI(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_ABOUT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_QUIT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_UNEXPAND(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_3KEXP(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_8EXPBLK1(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_8EXPBLK2(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_8EXPBLK3(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_FULLEXPA(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_SPEEDOME(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_SAVESCRE(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_INTERLAC(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_HIRES(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_MULTISYN(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_ABOUTKEY(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_PADDLES(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_DISKDRIV(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CASSETTE(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CHANBUT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_ABOUBUT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_RESEBUT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CONTBUT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
UBYTE *getdirname(struct TMData *, UBYTE *, UBYTE *, struct Window *);
BOOL ReadPrefsFile(UBYTE *,struct TMData *);

/* NewMenu UserData structures */
 
TMOBJECTDATA tmobjectdata_CONTINUE = { EventFunc_CONTINUE };
TMOBJECTDATA tmobjectdata_RESET = { EventFunc_RESET };
TMOBJECTDATA tmobjectdata_LOADPREF = { EventFunc_LOADPREF };
TMOBJECTDATA tmobjectdata_SAVEPREF = { EventFunc_SAVEPREF };
TMOBJECTDATA tmobjectdata_LOADCART = { EventFunc_LOADCART };
TMOBJECTDATA tmobjectdata_CHANGEDI = { EventFunc_CHANGEDI };
TMOBJECTDATA tmobjectdata_ABOUT = { EventFunc_ABOUT };
TMOBJECTDATA tmobjectdata_QUIT = { EventFunc_QUIT };
TMOBJECTDATA tmobjectdata_UNEXPAND = { EventFunc_UNEXPAND };
TMOBJECTDATA tmobjectdata_3KEXP = { EventFunc_3KEXP };
TMOBJECTDATA tmobjectdata_8EXPBLK1 = { EventFunc_8EXPBLK1 };
TMOBJECTDATA tmobjectdata_8EXPBLK2 = { EventFunc_8EXPBLK2 };
TMOBJECTDATA tmobjectdata_8EXPBLK3 = { EventFunc_8EXPBLK3 };
TMOBJECTDATA tmobjectdata_FULLEXPA = { EventFunc_FULLEXPA };
TMOBJECTDATA tmobjectdata_SPEEDOME = { EventFunc_SPEEDOME };
TMOBJECTDATA tmobjectdata_SAVESCRE = { EventFunc_SAVESCRE };
TMOBJECTDATA tmobjectdata_INTERLAC = { EventFunc_INTERLAC };
TMOBJECTDATA tmobjectdata_HIRES = { EventFunc_HIRES };
TMOBJECTDATA tmobjectdata_MULTISYN = { EventFunc_MULTISYN };
TMOBJECTDATA tmobjectdata_ABOUTKEY = { EventFunc_ABOUTKEY };
TMOBJECTDATA tmobjectdata_PADDLES = { EventFunc_PADDLES };
TMOBJECTDATA tmobjectdata_DISKDRIV = { EventFunc_DISKDRIV };
TMOBJECTDATA tmobjectdata_CASSETTE = { EventFunc_CASSETTE };

/* NewGadget UserData structures */
 
TMOBJECTDATA tmobjectdata_CHANBUT = { EventFunc_CHANBUT };
TMOBJECTDATA tmobjectdata_ABOUBUT = { EventFunc_ABOUBUT };
TMOBJECTDATA tmobjectdata_RESEBUT = { EventFunc_RESEBUT };
TMOBJECTDATA tmobjectdata_CONTBUT = { EventFunc_CONTBUT };

/* Menu event functions */
 
BOOL EventFunc_CONTINUE(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR lock;
  oldDir = CurrentDir(lock=Lock(dirName,SHARED_LOCK));
  ContVIC();
  CurrentDir(oldDir);
  UnLock(lock);
  return(FALSE);
  }

BOOL EventFunc_RESET(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR lock;
  oldDir = CurrentDir(lock=Lock(dirName,SHARED_LOCK));
  ResetVIC();
  CurrentDir(oldDir);
  UnLock(lock);
  return(FALSE);
  }

BOOL EventFunc_LOADPREF(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR lock;
  BOOL result = FALSE;
  BOOL retry = TRUE;
  struct FileInfoBlock *fib;
  DisableWindow_VIC20(TMData);
  while(retry)
    {
    retry = FALSE;
    if(getfilename(TMData, "Load Prefs", prefName, 128, window_VIC20, OPENFILE))
      {
      if(fib = AllocMem(sizeof(struct FileInfoBlock), MEMF_CLEAR))
        {
        if(lock = Lock(prefName, ACCESS_READ))
          {
          if(Examine(lock, fib))
            {
            if(fib->fib_Size == 0x0112) 
              result = ReadPrefsFile(prefName, TMData);
	    }
          UnLock(lock);
          }
        FreeMem(fib, sizeof(struct FileInfoBlock));
        }
      if (!result) retry = TM_Request(window_VIC20, "Load Prefs",
	     "Error - Couldn't read prefs file!" "\n"
	     ,
	     "Retry|Cancel", NULL, NULL);
      }
    }
  EnableWindow_VIC20(TMData);
  return(FALSE);
  }

BOOL EventFunc_SAVEPREF(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR file;
  BOOL retry = TRUE;
  BOOL result = FALSE;
  DisableWindow_VIC20(TMData);
  while(retry)
    {
    retry = FALSE;
    if(getfilename(TMData, "Save Prefs", prefName, 128, window_VIC20, SAVEFILE))
      {
      if(file = Open(prefName, MODE_NEWFILE))
        {
        Write(file, &mem3k, 2L);
        Write(file, &mem8k1, 2L);
        Write(file, &mem8k2, 2L);
        Write(file, &mem8k3, 2L);
        Write(file, &interlace, 2L);
        Write(file, &paddles, 2L);
        Write(file, &cassette, 2L);
        Write(file, &diskdrive, 2L);
        Write(file, &speedgfx, 2L);
        Write(file, dirName, 128L);
        Write(file, fileName, 128L);
        Close(file);
        result = TRUE;
        }
      if (!result) retry = TM_Request(window_VIC20, "Save Prefs",
	     "Error - Couldn't save prefs file!" "\n"
	     ,
	     "Retry|Cancel", NULL, NULL);
      }
    }
  EnableWindow_VIC20(TMData);
  return(FALSE);
  }

/*

    VIC20 Cartridge File Format.
    
    0000: "VIC2"
    0004: "0-CA"
    0008: "RTRI"
    000C: "DGE",0x0A
    0010: char[32] name (Name of the cartridge, nullterminated string) 
    0030: uint16 parts (Number of parts)
    0032: Part 1
    xxxx: Part 2
    xxxx: Part n
    
    Each part has the following format.
    
    0000: uint16 type (0=ROM, 1=RAM)
    0002: uint16 address (VIC20 address)
    0004: uint16 length (Nr of data bytes)
    0006: char[] data (The actual data)
    xxxx:

*/

BOOL EventFunc_LOADCART(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR file, lock;
  BOOL retry = TRUE;
  BOOL result = FALSE;
  struct FileInfoBlock *fib;
  DisableWindow_VIC20(TMData);
  while(retry)
    {
    retry = FALSE;
    if(getfilename(TMData, "Load Cartridge", fileName, 128, window_VIC20, OPENFILE))
      {
      *(CartRomMem+4L) = 0x00;
      if(fib = AllocMem(sizeof(struct FileInfoBlock), MEMF_CLEAR))
        {
        if(lock = Lock(fileName, ACCESS_READ))
          {
          if(Examine(lock, fib))
            {
            if(fib->fib_Size == 0x2000)
	      {
	      if(file = Open(fileName, MODE_OLDFILE))
	        {
	        Read(file, CartRomMem, 0x2000);
	        result = TRUE;
	        Close(file);
	        }
              }
            else if(fib->fib_Size == 0x4000)
	      {
	      if(file = Open(fileName, MODE_OLDFILE))
	        {
	        Read(file, CartRomMem, 0x2000);
		Read(file, VIC20Mem+0xE000, 0x2000);
	        result = TRUE;
	        Close(file);
	        }
              }
            else if(fib->fib_Size == 0x6000)
	      {
	      if(file = Open(fileName, MODE_OLDFILE))
	        {
	        Read(file, CartRomMem, 0x2000);
		Read(file, VIC20Mem+0xE000, 0x2000);
		Read(file, VIC20Mem+0xC000, 0x2000);
	        result = TRUE;
	        Close(file);
	        }
              }
            else if(fib->fib_Size == 0x8000)
	      {
	      if(file = Open(fileName, MODE_OLDFILE))
	        {
	        Read(file, CartRomMem, 0x2000);
		Read(file, VIC20Mem+0xE000, 0x2000);
		Read(file, VIC20Mem+0xC000, 0x2000);
		Read(file, VIC20Mem+0xA000, 0x2000);
	        result = TRUE;
	        Close(file);
	        }
              }
	    }
          UnLock(lock);
          }
        FreeMem(fib, sizeof(struct FileInfoBlock));
        }
      if (!result) retry = TM_Request(window_VIC20, "Save Prefs",
	     "Error - Couldn't load cartridge file!" "\n"
	     ,
	     "Retry|Cancel", NULL, NULL);
      }
    }
  EnableWindow_VIC20(TMData);
  return(FALSE);
  }

BOOL EventFunc_CHANGEDI(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  DisableWindow_VIC20(TMData);
  getdirname(TMData, "ChangeDir", dirName, window_VIC20);
  EnableWindow_VIC20(TMData);
  return(FALSE);
  }

BOOL EventFunc_ABOUT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  DisableWindow_VIC20(TMData);
  TM_Request(window_VIC20, "About",
	     "VIC-20 Emulator" "\n"
	     "By Per Hkan Sundell" "\n"
	     "(C) Copyright 1993,96\n"
	     "\n"
	     "Registered to: Public\n"
	     ,
	     "MORE", NULL, NULL);
  TM_Request(window_VIC20, "About",
	     "If you want to support further" "\n"
	     "development of this program and" "\n"
	     "thus want to be a registered user" "\n"
	     "of this program, then send $15 (USD)" "\n"
	     "or equal amount in SEK or DM to:" "\n"
             "\n"
	     "Per Hkan Sundell" "\n"
	     "Grnsvgen 8" "\n"
	     "S-663 34 Skoghall" "\n"
	     "Sweden" "\n"
	     ,
	     "More", NULL, NULL);
  TM_Request(window_VIC20, "About",
	     "If enough people support this" "\n"
	     "program, the registered users" "\n"
	     "will recieve the next updated" "\n"
	     "version" "\n"
	     ,
	     "OK", NULL, NULL);
  EnableWindow_VIC20(TMData);
  return(FALSE);
  }

BOOL EventFunc_QUIT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  LONG num;
  DisableWindow_VIC20(TMData);
  num=TM_Request(window_VIC20, "Quit",
	     "Are you sure that" "\n"
	     "you want to quit?" "\n"
	     ,
	     "OK|CANCEL", NULL, NULL);
  EnableWindow_VIC20(TMData);
  if (oldDir != NULL) CurrentDir(oldDir);
  if (num==1) return(TRUE);
  else return(FALSE);
  }

BOOL EventFunc_UNEXPAND(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem;
  menuItem->Flags = menuItem->Flags & ~CHECKED;
  menuItem->NextItem->Flags = menuItem->NextItem->Flags & ~CHECKED;
  menuItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->Flags & ~CHECKED;
  menuItem->NextItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->NextItem->Flags & ~CHECKED;
  mem3k = FALSE;
  mem8k1 = FALSE;
  mem8k2 = FALSE;
  mem8k3 = FALSE;
  return(FALSE);
  }

BOOL EventFunc_3KEXP(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem;
  mem3k = menuItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_8EXPBLK1(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem->NextItem;
  mem8k1 = menuItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_8EXPBLK2(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem->NextItem->NextItem;
  mem8k2 = menuItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_8EXPBLK3(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem->NextItem->NextItem->NextItem;
  mem8k3 = menuItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_FULLEXPA(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem;
  menuItem->Flags = menuItem->Flags | CHECKED;
  menuItem->NextItem->Flags = menuItem->NextItem->Flags | CHECKED;
  menuItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->Flags | CHECKED;
  menuItem->NextItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->NextItem->Flags | CHECKED;
  mem3k = TRUE;
  mem8k1 = TRUE;
  mem8k2 = TRUE;
  mem8k3 = TRUE;
  return(FALSE);
  }

BOOL EventFunc_SPEEDOME(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  speedometer = TRUE;
  ContVIC();
  speedometer = FALSE;
  return(FALSE);
  }

BOOL EventFunc_SAVESCRE(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  DisableWindow_VIC20(TMData);
  if(getfilename(TMData, "Save Prefs", fileName, 128, window_VIC20, SAVEFILE))
    {
    }
  EnableWindow_VIC20(TMData);
  SaveScreen();
  return(FALSE);
  }

BOOL EventFunc_INTERLAC(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->NextMenu->FirstItem->NextItem->NextItem;
  interlace = menuItem->Flags & CHECKED;
  hires = FALSE;
  multisync = FALSE;
  menuItem->NextItem->Flags &= ~CHECKED;
  menuItem->NextItem->NextItem->Flags &= ~CHECKED;
  return(FALSE);
  }

BOOL EventFunc_HIRES(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->NextMenu->FirstItem->NextItem->NextItem;
  menuItem->Flags &= ~CHECKED;
  interlace = FALSE;
  hires = menuItem->NextItem->Flags & CHECKED;
  multisync = FALSE;
  menuItem->NextItem->NextItem->Flags &= ~CHECKED;
  return(FALSE);
  }

BOOL EventFunc_MULTISYN(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->NextMenu->FirstItem->NextItem->NextItem;
  menuItem->Flags &= ~CHECKED;
  menuItem->NextItem->Flags &= ~CHECKED;
  interlace = FALSE;
  hires = FALSE;
  multisync = menuItem->NextItem->NextItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_ABOUTKEY(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  DisableWindow_VIC20(TMData);
  TM_Request(window_VIC20, "About Keys",
	     "Keyboard Basic Layout:" "\n"
	     "\n"
	     "<- 1 2 3 4 5 6 7 8 9 0 + - " "\n"
	     "    Q W E R T Y U I O P @ *" "\n"
	     "Ctrl A S D F G H J K L : ; = Return" "\n"
	     "Sft ^ Z X C V B N M , . / Sft" "\n"
	     ,
	     "MORE", NULL, NULL);
  TM_Request(window_VIC20, "About Keys",
	     "Special Keys:" "\n"
	     "\n"
	     "C= (Commodore)    Left Amiga" "\n"
	     "STOP              Escape" "\n"
	     "RESTORE           Help" "\n"
	     "HOME              BackSpace" "\n"
	     "DEL               Del" "\n"
	     "=                 F10" "\n"
	     "Arrow Up          F9" "\n"
             "F1 - F8           F1 - F8" "\n"
             "CRSR Down,Right   Cursor keys" "\n"
	     "\n"
	     "Right Amiga + Right Alt: Enter Menu" "\n"
	     ,
	     "OK", NULL, NULL);
  EnableWindow_VIC20(TMData);
  return(FALSE);
  }

BOOL EventFunc_PADDLES(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->NextMenu->NextMenu->FirstItem->NextItem;
  paddles = menuItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_DISKDRIV(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->NextMenu->NextMenu->FirstItem->NextItem->NextItem;
  diskdrive = menuItem->Flags & CHECKED;
  return(FALSE);
  }

BOOL EventFunc_CASSETTE(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->NextMenu->NextMenu->FirstItem->NextItem->NextItem->NextItem;
  cassette = menuItem->Flags & CHECKED;
  return(FALSE);
  }

/* Gadget event functions */
 
BOOL EventFunc_CHANBUT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(EventFunc_CHANGEDI(TMData, imsg, tmobjectdata));
  }

BOOL EventFunc_ABOUBUT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(EventFunc_ABOUT(TMData, imsg, tmobjectdata));
  }

BOOL EventFunc_RESEBUT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR lock;
  oldDir = CurrentDir(lock=Lock(dirName,SHARED_LOCK));
  ResetVIC();
  CurrentDir(oldDir);
  UnLock(lock);
  return(FALSE);
  }

BOOL EventFunc_CONTBUT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  BPTR lock;
  oldDir = CurrentDir(lock=Lock(dirName,SHARED_LOCK));
  ContVIC();
  CurrentDir(oldDir);
  UnLock(lock);
  return(FALSE);
  }

UBYTE *getdirname(struct TMData *TMData, UBYTE *title, UBYTE *buffer, struct Window *window)
  {
  if(buffer && TMData)
    {
    if(AslRequestTags((APTR) TMData->FileRequester,
                      ASL_Hail, title,
                      ASL_Window, window,
                      ASL_FuncFlags, 0L,
		      ASL_ExtFlags1, FIL1F_NOFILES,
                      TAG_DONE))
      {
      strcpy(buffer, TMData->FileRequester->rf_Dir);
      return(buffer);
      }
    }

  return(NULL);
  }

BOOL ReadPrefsFile(UBYTE *title,struct TMData *TMData)
  {
  BOOL result = FALSE;
  BPTR file, lock;
  struct FileInfoBlock *fib;
  struct Menu *menu = menu_VIC20;
  struct MenuItem *menuItem = menu->NextMenu->FirstItem->NextItem;
  if(file = Open(title, MODE_OLDFILE))
    {
    Read(file, &mem3k, 2L);
    Read(file, &mem8k1, 2L);
    Read(file, &mem8k2, 2L);
    Read(file, &mem8k3, 2L);
    Read(file, &interlace, 2L);
    Read(file, &paddles, 2L);
    Read(file, &cassette, 2L);
    Read(file, &diskdrive, 2L);
    Read(file, &speedgfx, 2L);
    Read(file, dirName, 128L);
    Read(file, fileName, 128L);
    Close(file);
    if(fib = AllocMem(sizeof(struct FileInfoBlock), MEMF_CLEAR))
      {
      if(lock = Lock(fileName, ACCESS_READ))
        {
        *(CartRomMem+4L) = 0x00;
        if(Examine(lock, fib))
          {
          if(fib->fib_Size == 0x2000)
	    {
	    if(file = Open(fileName, MODE_OLDFILE))
	      {
	      Read(file, CartRomMem, fib->fib_Size);
	      Close(file);
	      }
            }
	  }
        UnLock(lock);
        }
      FreeMem(fib, sizeof(struct FileInfoBlock));
      }
    result = TRUE;
    menuItem->Flags = menuItem->Flags & ~CHECKED | (mem3k?CHECKED:0L);
    menuItem->NextItem->Flags = menuItem->NextItem->Flags & ~CHECKED | (mem8k1?CHECKED:0L);
    menuItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->Flags & ~CHECKED | (mem8k2?CHECKED:0L);
    menuItem->NextItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->NextItem->Flags & ~CHECKED | (mem8k3?CHECKED:0L);
    menuItem = menu->NextMenu->NextMenu->FirstItem->NextItem->NextItem;
    menuItem->Flags = menuItem->Flags & ~CHECKED | (interlace?CHECKED:0L);
    menuItem = menu->NextMenu->NextMenu->NextMenu->FirstItem->NextItem;
    menuItem->Flags = menuItem->Flags & ~CHECKED | (paddles?CHECKED:0L);
    menuItem->NextItem->Flags = menuItem->NextItem->Flags & ~CHECKED | (cassette?CHECKED:0L);
    menuItem->NextItem->NextItem->Flags = menuItem->NextItem->NextItem->Flags & ~CHECKED | (diskdrive?CHECKED:0L);
    }
  return(result);
  }
