	IFND  VIC20_LIBDEFS_I
VIC20_LIBDEFS_I SET  1

	IFND EXEC_TYPES_I
	INCLUDE "exec/types.i"
	ENDC

	IFND EXEC_LIBRARIES_I
	INCLUDE "exec/libraries.i"
	ENDC

;************************************************************************
; Private definitions for vic20_lib.s
;************************************************************************

VIC20LIB_VERSION	equ	1
VIC20LIB_REVISION	equ	1

VIC20LIB_NAME	MACRO
		dc.b	"vic20.library",0
		ENDM

VIC20LIB_IDSTRING MACRO
		dc.b	"vic20.library 1.1 (19.09.94)",13,10,0
		ENDM

VIC20LIB_COPYRIGHT MACRO
		dc.b	" 1994 by Per Hkan Sundell",0
		ENDM


; ========================================================================;
; === Memory Allocation ==================================================;
; ========================================================================;

PRGMEM_SIZE		equ	$20000
MMUMEM_SIZE		equ	$10000
VIC20MEM_SIZE		equ	$10000
VIDEOMEM_SIZE		equ	($20*$20*8)
COLORMEM_SIZE		equ	($20*$20*2)
MULTICOLORMEM_SIZE	equ	($100*4*8)
HIRESMEM_SIZE		equ	($100*3*4*16)
RASTER1MEM_SIZE		equ	$2000
RASTER2MEM_SIZE		equ	$2000
SAMPLEMEM_SIZE		equ	$4400
SCREENMEM_SIZE		equ	($60*$20*$8*$4)
COPPER1MEM_SIZE		equ	$2000
COPPER2MEM_SIZE		equ	$2000

ALLOC		MACRO	
		move.l	#\2,d0
		move.l	#\3!MEMF_CLEAR,d1
		move.l	a6,-(a7)
		CALLEXEC AllocMem
		move.l	(a7)+,a6
		move.l	d0,\1
		ENDM

FREE		MACRO
		tst.l	\1
		beq.s	.\@
		move.l	#\2,d0
		move.l	\1,a1
		move.l	a6,-(a7)
		CALLEXEC FreeMem
		move.l	(a7)+,a6
		clr.l	\1
.\@
		ENDM

; ========================================================================;
; === VIC20Base ========================================================;
; ========================================================================;

	STRUCTURE VIC20Base,0
	STRUCT	vic_LibNode,LIB_SIZE
	UBYTE	vic_Flags
	UBYTE	vic_Pad
	APTR	vic_SysLib
	APTR	vic_SegList
	APTR	vic_VIC20Mem
	APTR	vic_PrgMem
	APTR	vic_MMUMem
	APTR	vic_RemVideoPixels
	APTR	vic_RemColorMatrix
	APTR	vic_MultiColorTable
	APTR	vic_HiresTable
	APTR	vic_RasterStack1Mem
	APTR	vic_RasterStack2Mem
	APTR	vic_SampleMem
	APTR	vic_Copper1Mem
	APTR	vic_Copper2Mem
	APTR	vic_ScreenMem
	UWORD	vic_OffsetVert
	UWORD	vic_OffsetHoriz
	UWORD	vic_HorizWidth
	UWORD	vic_VertLength
	UWORD	vic_CharAdress
	UWORD	vic_VideoAdress
	UWORD	vic_EmulResourceFlag
	LABEL	vic_SIZEOF

; --- Error --------------------------------------------------------------
VIC_NOMEMORY	equ	-1
VIC_NOLIBRARY	equ	-2
VIC_LIBINUSE	equ	-3

*************************************************************************
* MEMORYCONFIGURATION:                                                  *
* F8000 - F8FFF ;$8000-$8FFF ROM (CHAR)                                 *
* F9000 - F9FFF ;$9000-$9FFF I/O , COLOR RAM                            *
* FA000 - FBFFF ;$A000-$BFFF ROM/RAM/OPEN (EXPANSION)                   *
* FC000 - FDFFF ;$C000-$DFFF ROM (BASIC)                                *
* FE000 - FFFFF ;$E000-$FFFF ROM (KERNAL)                               *
* 02000 - 07FFF ;$2000-$7FFF RAM/ROM/OPEN                               *
* 01000 - 01FFF ;$1000-$2000 RAM                                        *
* 00400 - 00FFF ;$0400-$0FFF RAM/ROM/OPEN                               *
* 00000 - 003FF ;$0000-$03FF RAM                                        *
*************************************************************************
* REGISTER *
* D0=00000000 00000000 00000000 ---AC---
* D1=00000001 -STACK-- 00000000 ---XR---
* D2=00000000 00000000 00000000 ---YR---
* D3=00000000 00000000 N0000000 NZZZZZZZ
* D4=00000000 00000000 D+000000 CCCCCCCC
* D5=00000000 00000000 001BDI00 VVVVVVVV
* D6=00000000 00000000 00000000 --Temp--
* D7=00000000 00000000 --Temp-- --Temp--
* A0=-------- -MEMORY- --BASE-- --------
* A1=-------- -CUSTOM- --CHIP-- --BASE--
* A2=--Temp-- --Temp-- --Temp-- --Temp--
* A3=-MEMORY- -MANAGE- -MENT--- -TABLE--
* A4=--EXTRA- --EMUL-- --PROG-- --BASE--
* A5=-------- --EMUL-- --PROG-- --BASE--
* A6=-------- PROGRAM- COUNTER- --------
* A7=--SUPER- --VISOR- -STACK-- -POINTER
*************************************************************************

*************************************************************************
* INTERNAL DEFINITIONS                                                  *
*************************************************************************
reqNMI		equ	$FFFF9010
reqIRQ		equ	$FFFF9011
reqTRAP		equ	$FFFF9012
indSaveA4	equ	$FFFF9013
regSaveA4	equ	$FFFF9014
flgIrqMastEn	equ	$FFFF9018
reqInterrupt	equ	$FFFF9019
reqPAUSE	equ	$FFFF901A
reqRESET	equ	$FFFF901B
reqQUIT		equ	$FFFF901C
flgOSReadyA1	equ	$FFFF901D
flgOSReadyA2	equ	$FFFF901E
flgOSReadyB1	equ	$FFFF901F
flgOSReadyB2	equ	$FFFF9020
flgRasterIRQ	equ	$FFFF9021
rasterBeamHigh	equ	$FFFF9022
rasterBeam	equ	$FFFF9024
rasterStack	equ	$FFFF9026
rasterStackNr	equ	$FFFF902a
rasterStackRdy	equ	$FFFF902b
rasterBeamNewA1	equ	$FFFF902c
rasterBeamNewA2	equ	$FFFF9030
rasterBeamNewB1	equ	$FFFF9034
rasterBeamNewB2	equ	$FFFF9038
rasterBeamNew	equ	$FFFF903c
RasterStack1Mem	equ	$FFFF9040
RasterStack2Mem	equ	$FFFF9044
OffsetVert	equ	$FFFF9048
OffsetHoriz	equ	$FFFF904a
HorizWidth	equ	$FFFF904c
VertLength	equ	$FFFF904e
CharAdress	equ	$FFFF9050
VideoAdress	equ	$FFFF9052

hunkStatus	equ	$AFFF
hunkDecAdd	equ	$AFFE
hunkDecSub	equ	$AFFD
hunkIfStat	equ	$AFFC
hunkNextInst	equ	$AFFB
hunkNextInst0	equ	$FFFF
hunkNextInst1	equ	$FFFE
hunkNextInst2	equ	$FFFD
*************************************************************************
* MACROS:                                                               *
*************************************************************************
MMU		MACRO
		move.b	0(a3,d7.l),d6
		bne.s	\1
		ENDM

MMU2		MACRO
		move.b	0(a3,d7.l),d6
		bmi.s	\1
		ENDM

ASLIO		MACRO
		jmp	AslIO
		ENDM

LSRIO		MACRO
		jmp	LsrIO
		ENDM

ROLIO		MACRO
		jmp	RolIO
		ENDM

RORIO		MACRO
		jmp	RorIO
		ENDM

INCIO		MACRO
		jmp	IncIO
		ENDM

DECIO		MACRO
		jmp	DecIO
		ENDM

OPER		MACRO
		IFC	'\1','ASL'
		add.b	d6,d6
		scs	d4			;C
		move.w	d6,d3			;N & Z
		ENDC
		IFC	'\1','ROL'
		neg.b	d4			;C
		addx.b	d6,d6
		scs	d4			;X & C
		move.w	d6,d3			;N & Z
		ENDC
		IFC	'\1','LSR'
		lsr.b	#1,d6
		scs	d4			;C
		move.w	d6,d3			;N & Z
		ENDC
		IFC	'\1','ROR'
		neg.b	d4			;C
		roxr.b	#1,d6
		scs	d4			;C
		move.w	d6,d3			;N & Z
		ENDC
		IFC	'\1','DEC'
		subq.b	#1,d6
		move.w	d6,d3			;N & Z
		ENDC
		IFC	'\1','INC'
		addq.b	#1,d6
		move.w	d6,d3			;N & Z
		ENDC
		ENDM	

SPECIO	MACRO
\1					;ASL VIC20 I/O $9000-$9FFF
					;IN: D7=Addr, D6=IOreg
					;OUT: D6=Data, D3,4=Status
					;USAGE; D3,D6,D7,A2
	add.b	d6,d6
	move.w	.JMP(pc,d6.w),d3
	jmp	.JMP(pc,d3.w)
.JMP
	dc.w	.9000-.JMP		;80
	dc.w	.9001-.JMP
	dc.w	.9002-.JMP
	dc.w	.9003-.JMP

	dc.w	.9004-.JMP		;84
	dc.w	.9005-.JMP
	dc.w	.9006-.JMP
	dc.w	.9007-.JMP

	dc.w	.9008-.JMP		;88
	dc.w	.9009-.JMP
	dc.w	.900A-.JMP
	dc.w	.900B-.JMP

	dc.w	.900C-.JMP		;8C
	dc.w	.900D-.JMP
	dc.w	.900E-.JMP
	dc.w	.900F-.JMP

	dc.w	.9110-.JMP		;90
	dc.w	.9111-.JMP
	dc.w	.9112-.JMP
	dc.w	.9113-.JMP

	dc.w	.9114-.JMP		;94
	dc.w	.9115-.JMP
	dc.w	.9116-.JMP
	dc.w	.9117-.JMP

	dc.w	.9118-.JMP		;98
	dc.w	.9119-.JMP
	dc.w	.911A-.JMP
	dc.w	.911B-.JMP

	dc.w	.911C-.JMP		;9C
	dc.w	.911D-.JMP
	dc.w	.911E-.JMP
	dc.w	.911F-.JMP

	dc.w	.9120-.JMP		;A0
	dc.w	.9121-.JMP
	dc.w	.9122-.JMP
	dc.w	.9123-.JMP

	dc.w	.9124-.JMP		;A4
	dc.w	.9125-.JMP
	dc.w	.9126-.JMP
	dc.w	.9127-.JMP

	dc.w	.9128-.JMP		;A8
	dc.w	.9129-.JMP
	dc.w	.912A-.JMP
	dc.w	.912B-.JMP

	dc.w	.912C-.JMP		;AC
	dc.w	.912D-.JMP
	dc.w	.912E-.JMP
	dc.w	.912F-.JMP

	dc.w	.9100-.JMP		;B0

.9000						;Horiz. Cent.
	move.b	$FFFF9000(a0),d6
	OPER \2
	move.b	d6,$FFFF9000(a0)
	and.w	#$007f,d6
	move.w	d6,OffsetHoriz
	Next_Inst
.9001						;Vert. Cent.
	move.b	$FFFF9001(a0),d6
	OPER \2
	move.b	d6,$FFFF9001(a0)
	move.w	d6,OffsetVert
	Next_Inst
.9002						;Columns
	move.b	$FFFF9002(a0),d6
	OPER \2
	move.b	d6,$FFFF9002(a0)
	move.w	d6,d7
	and.w	#$007f,d7
	move.w	d7,HorizWidth
	tst.b	d6
	bmi.s	.90021
	and.w	#$1c00,VideoAdress
	Next_Inst
.90021
	or.w	#$0200,VideoAdress
	Next_Inst
.9003						;Rows
	move.l	rasterBeamNew(a0),d6
	beq.s	.90033
	cmp.l	rasterBeamHigh(a0),d6
	beq.s	.90031
.90033	addq.w	#1,rasterBeam(a0)
	move.b	#$05,flgRasterIRQ(a0)
	cmp.w	#$0138,rasterBeam(a0)
	blt.s	.90031
	move.w	#$4000,$09a(a1)
	move.b	#$08,rasterStackRdy(a0)
	addq.w	#1,rasterBeamHigh(a0)
	clr.w	rasterBeam(a0)
	move.l	rasterStack(a0),a1
	st	(a1)
	lea	$dff000,a1
	not.b	rasterStackNr(a0)
	bne.s	.90032
	move.l	#RasterStack1Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
	bra.s	.90031
.90032	move.l	#RasterStack2Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
.90031	moveq	#$00,d6
	move.b	$FFFF9003(a0),d6
	move.w	rasterBeam(a0),d3
	add.b	d6,d6
	lsr.b	#1,d3
	roxr.b	#1,d6
	OPER \2
	move.b	d6,$FFFF9003(a0)
	move.w	d6,d7
	and.w	#$007e,d7
	lsr.w	#1,d7
	move.w	d7,VertLength
	Next_Inst
.9004						;Raster beam
	move.l	rasterBeamNew(a0),d6
	beq.s	.90043
	cmp.l	rasterBeamHigh(a0),d6
	beq.s	.90041
.90043	addq.w	#1,rasterBeam(a0)
	move.b	#$05,flgRasterIRQ(a0)
	cmp.w	#$0138,rasterBeam(a0)
	blt.s	.90041
	move.w	#$4000,$09a(a1)
	move.b	#$08,rasterStackRdy(a0)
	addq.w	#1,rasterBeamHigh(a0)
	clr.w	rasterBeam(a0)
	move.l	rasterStack(a0),a1
	st	(a1)
	lea	$dff000,a1
	not.b	rasterStackNr(a0)
	bne.s	.90042
	move.l	#RasterStack1Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
	bra.s	.90041
.90042	move.l	#RasterStack2Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
.90041	moveq	#$00,d6
	move.w	rasterBeam(a0),d6
	lsr.w	#1,d6
	OPER \2
	Next_Inst
.9005						;Video address
	move.b	$FFFF9005(a0),d6
	OPER \2
	move.b	d6,$FFFF9005(a0)
	btst	#3,d6
	seq	d7
	and.w	#$0020,d7
	and.w	#$0007,d6
	or.w	d6,d7
	moveq	#$0a,d6
	lsl.w	d6,d7
	move.w	d7,CharAdress
	move.b	$FFFF9005(a0),d7
	lsl.w	#4,d7
	move.b	$FFFF9002(a0),d7
	lsl.w	#2,d7
	and.w	#$1e00,d7
	move.w	d7,VideoAdress
	Next_Inst
.9006						;Light pen X
	move.b	$007(a1),d6
	OPER \2
	Next_Inst
.9007						;Light pen Y
	move.b	$006(a1),d6
	OPER \2
	Next_Inst
.9008						;Paddle X
	move.b	$FFFF9008(a0),d6
	OPER \2
	Next_Inst
.9009						;Paddle Y
	move.b	$FFFF9009(a0),d6
	OPER \2
	Next_Inst
.900A					
	move.b	$FFFF900A(a0),d6
	OPER \2
	move.b	d6,$FFFF900A(a0)
	FIXFREQ	$0a6,1
	Next_Inst
.900B						
	move.b	$FFFF900B(a0),d6
	OPER \2
	move.b	d6,$FFFF900B(a0)
	FIXFREQ	$0b6,2
	Next_Inst
.900C						
	move.b	$FFFF900C(a0),d6
	OPER \2
	move.b	d6,$FFFF900C(a0)
	FIXFREQ	$0c6,4
	Next_Inst
.900D
	move.b	$FFFF900D(a0),d6
	OPER \2
	move.b	d6,$FFFF900D(a0)
	FIXFREQ	$0d6,8
	Next_Inst
.900E
	move.b	$FFFF900E(a0),d6
	OPER \2
	move.b	d6,$FFFF900E(a0)
	tst.b	flgRasterIRQ(a0)
	bne.s	.900E1
.900E3	move.w	d6,d7
	and.w	#$000f,d7
	add.w	d7,d7
	lea	VolumeTable,a2
	move.w	0(a2,d7.w),d7
	move.w	d7,$0a8(a1)
	move.w	d7,$0b8(a1)
	move.w	d7,$0c8(a1)
	move.w	d7,$0d8(a1)
	and.w	#$00f0,d6
	lsr.w	#3,d6
	lea	ColorTable,a2
	move.w	0(a2,d6.w),$184(a1)
	Next_Inst
.900E1	subq.b	#1,flgRasterIRQ(a0)
	beq.s	.900E2
	move.l	rasterStack(a0),a2
	move.w	rasterBeam(a0),(a2)+
	move.b	#$0e,(a2)+
	move.b	d6,(a2)+
	move.l	a2,rasterStack(a0)
	Next_Inst
.900E2
	move.l	#RasterStack1Mem,rasterStack(a0)
	clr.b	rasterStackNr(a0)
	clr.b	rasterStackRdy(a0)
	bra.s	.900E3

.900F
	move.b	$FFFF900F(a0),d6
	OPER \2
	move.b	d6,$FFFF900F(a0)
	tst.b	flgRasterIRQ(a0)
	bne.s	.900F1
.900F3	move.w	d6,d7
	and.w	#$00f0,d6
	lsr.w	#3,d6
	lea	ColorTable,a2
	move.w	0(a2,d6.w),$182(a1)
	and.w	#$0007,d7
	add.w	d7,d7
	move.w	0(a2,d7.w),$180(a1)
	Next_Inst
.900F1	subq.b	#1,flgRasterIRQ(a0)
	beq.s	.900F2
	move.l	rasterStack(a0),a2
	move.w	rasterBeam(a0),(a2)+
	move.b	#$0f,(a2)+
	move.b	d6,(a2)+
	move.l	a2,rasterStack(a0)
	Next_Inst
.900F2
	move.l	#RasterStack1Mem,rasterStack(a0)
	clr.b	rasterStackNr(a0)
	clr.b	rasterStackRdy(a0)
	bra.s	.900F3


.9100						;Includes 9100-910F,
						;9800-9FFF
	moveq	#$00,d6
	OPER \2
	Next_Inst

.9110
	move.b	$FFFF9110(a0),d6	;Output reg
	move.b	$FFFF9112(a0),d7	;DDR
	and.b	d7,d6
	not.b	d7
	and.b	$FFFF9130(a0),d7	;Input reg
	or.b	d7,d6
	OPER \2
	move.b	d6,$FFFF9110(a0)	;Output reg
	and.b	#$67,$FFFF911D(a0)	;Clear CB1,CB2
	Next_Inst
.9111
	move.b	$FFFF9111(a0),d6	;Output reg
	move.b	$FFFF9113(a0),d7	;DDR
	and.b	d7,d6
	not.b	d7
	and.b	$FFFF9131(a0),d7	;Input reg
	or.b	d7,d6
	OPER \2
	move.b	d6,$FFFF9111(a0)	;Output reg
	and.b	#$7c,$FFFF911D(a0)	;Clear CA1,CA2
	Next_Inst
.9112
	move.b	$FFFF9112(a0),d6
	OPER \2
	move.b	d6,$FFFF9112(a0)
	Next_Inst
.9113
	move.b	$FFFF9113(a0),d6
	OPER \2
	move.b	d6,$FFFF9113(a0)
	Next_Inst
.9114
	move.b	$bfd400,d6
	and.b	#$3f,$FFFF911D(a0)
	OPER \2
	move.b	d6,$FFFF9117(a0)
	move.w	$FFFF9116(a0),d7
	CONVTIMER d7
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	Next_Inst
.9115
	move.b	$bfd500,d6
	OPER \2
	move.b	d6,$FFFF9116(a0)
	move.w	$FFFF9116(a0),d7
	and.b	#$fe,$bfde00
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewA1
	CONVTIMER d7
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	or.b	#$11,$bfde00
	and.b	#$3f,$FFFF911D(a0)
	clr.b	flgOSReadyA1(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9116
	move.b	$FFFF9117(a0),d6
	OPER \2
	move.b	d6,$FFFF9117(a0)
	move.w	$FFFF9116(a0),d7
	CONVTIMER d7
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	Next_Inst
.9117
	move.b	$FFFF9116(a0),d6
	OPER \2
	move.b	d6,$FFFF9116(a0)
	move.w	$FFFF9116(a0),d7
	CONVTIMER d7
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	and.b	#$3f,$FFFF911D(a0)
	Next_Inst
.9118
	move.b	$bfd600,d6
	and.b	#$5f,$FFFF911D(a0)
	OPER \2
	move.b	d6,$FFFF9119(a0)
	Next_Inst
.9119
	move.b	$bfd700,d6
	OPER \2
	move.b	d6,$FFFF9118(a0)
	move.w	$FFFF9118(a0),d7
	and.b	#$fe,$bfdf00
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewA2
	CONVTIMER d7
	move.b	d7,$bfd600
	lsr.w	#8,d7
	move.b	d7,$bfd700
	or.b	#$11,$bfdf00
	clr.b	flgOSReadyA2(a0)
	and.b	#$5f,$FFFF911D(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.911A
	move.b	$FFFF911A(a0),d6
	OPER \2
	move.b	d6,$FFFF911A(a0)
	Next_Inst
.911B
	move.b	$FFFF911B(a0),d6
	OPER \2
	move.b	d6,$FFFF911B(a0)
	Next_Inst
.911C
	move.b	$FFFF911C(a0),d6
	OPER \2
	Next_Inst
.911D
	move.b	$FFFF911D(a0),d6
	OPER \2
	not.b	d6
	and.b	#$7f,d6
	and.b	d6,$FFFF911D(a0)
	Next_Inst
.911E
	move.b	$FFFF911E(a0),d6
	or.b	#$80,d6
	OPER \2
	tst.b	d6
	bpl.s	.911E1
	and.b	#$7f,d6
	move.w	#$4000,$09a(a1)
	move.b	$FFFF911E(a0),d7
	or.b	d6,$FFFF911E(a0)
	and.b	$FFFF911D(a0),d7
	bne.s	.911E2
	move.b	$FFFF911D(a0),d7
	and.b	$FFFF911E(a0),d7
	beq.s	.911E2
	move.w	#$a000,$09c(a1)
.911E2	move.w	#$c000,$09a(a1)
	Next_Inst
.911E1	not.b	d6
	and.b	d6,$FFFF911E(a0)
	Next_Inst
.911F
	move.b	$FFFF9111(a0),d6	;Output reg
	move.b	$FFFF9113(a0),d7	;DDR
	and.b	d7,d6
	not.b	d7
	and.b	$FFFF9131(a0),d7	;Input reg
	or.b	d7,d6
	OPER \2
	move.b	d6,$FFFF9111(a0)	;Output reg
	Next_Inst

.9120
	move.b	$FFFF9120(a0),d6	;Output reg
	OPER \2
	move.b	d6,$FFFF9120(a0)	;Output reg
	move.w	#$9200,d7
	move.b	d6,d7			;Low nibble reg
	move.w	d7,a2
	and.w	#$920f,d7
	move.b	0(a0,d7.w),d6
	move.w	a2,d7
	and.w	#$92f0,d7
	and.b	$10(a0,d7.w),d6
	move.b	d6,$FFFF9141(a0)
	and.b	#$67,$FFFF912D(a0)	;Clear CB1,CB2
	Next_Inst
.9121
	move.b	$FFFF9141(a0),d6
	OPER \2
	move.b	D6,$FFFF9121(a0)
	and.b	#$7c,$FFFF912D(a0)	;Clear CA1,CA2
	Next_Inst
.9122
	move.b	$FFFF9122(a0),d6
	OPER \2
	move.b	d6,$FFFF9122(a0)
	Next_Inst
.9123
	move.b	$FFFF9123(a0),d6
	OPER \2
	move.b	d6,$FFFF9123(a0)
	Next_Inst
.9124
	move.b	$bfe401,d6
	and.b	#$3f,$FFFF912D(a0)
	OPER \2
	move.b	d6,$FFFF9127(a0)
	move.w	$FFFF9126(a0),d7
	CONVTIMER d7
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	Next_Inst
.9125
	move.b	$bfe501,d6
	OPER \2
	move.b	d6,$FFFF9126(a0)
	move.w	$FFFF9126(a0),d7
	and.b	#$fe,$bfee01
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewB1
	CONVTIMER d7
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	or.b	#$11,$bfee01
	clr.b	flgOSReadyB1(a0)
	and.b	#$3f,$FFFF912D(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9126
	move.b	$FFFF9127(a0),d6
	OPER \2
	move.b	d6,$FFFF9127(a0)
	move.w	$FFFF9126(a0),d7
	CONVTIMER d7
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	Next_Inst
.9127
	move.b	$FFFF9126(a0),d6
	OPER \2
	move.b	d6,$FFFF9126(a0)
	move.w	$FFFF9126(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	and.b	#$3f,$FFFF912D(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9128
	move.b	$bfe601,d6
	and.b	#$5f,$FFFF912D(a0)
	OPER \2
	move.b	d6,$FFFF9129(a0)
	Next_Inst
.9129
	move.b	$bfe701,d6
	OPER \2
	move.b	d6,$FFFF9128(a0)
	move.w	$FFFF9128(a0),d7
	and.b	#$fe,$bfef01
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewB2
	CONVTIMER d7
	move.b	d7,$bfe601
	lsr.w	#8,d7
	move.b	d7,$bfe701
	or.b	#$11,$bfef01
	clr.b	flgOSReadyB2(a0)
	and.b	#$5f,$FFFF912D(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.912A
	move.b	$FFFF912A(a0),d6
	OPER \2
	move.b	d6,$FFFF912A(a0)
	Next_Inst
.912B
	move.b	$FFFF912B(a0),d6
	OPER \2
	move.b	d6,$FFFF912B(a0)
	Next_Inst
.912C
	move.b	$FFFF912C(a0),d6
	OPER \2
	Next_Inst
.912D
	move.b	$FFFF912D(a0),d6
	OPER \2
	not.b	d6
	and.b	#$7f,d6
	and.b	d6,$FFFF912D(a0)
	Next_Inst
.912E
	move.b	$FFFF912E(a0),d6
	or.b	#$80,d6
	OPER \2
	tst.b	d6
	bpl.s	.912E1
	and.b	#$7f,d6
	or.b	d6,$FFFF912E(a0)
	move.w	#$4000,$09a(a1)
	move.b	$FFFF912E(a0),d7
	and.b	$FFFF912D(a0),d7
	beq.s	.912E2
	tst.b	flgIrqMastEn(a0)
	bne.s	.912E2
	move.w	#$8008,$09c(a1)
.912E2	move.w	#$c000,$09a(a1)
	Next_Inst
.912E1	not.b	d6
	and.b	d6,$FFFF912E(a0)
	Next_Inst
.912F
	move.b	$FFFF9141(a0),d6
	OPER \2
	move.b	d6,$FFFF9121(a0)	;Output reg
	Next_Inst
	ENDM

GETINDXADDR	MACRO
		move.b	(a6)+,d6
		add.b	d1,d6			;X
		lea	0(a0,d6.w),a2
		movep.w	1(a2),d7
		move.b	(a2),d7
		ENDM

GETINDYADDR	MACRO
		move.b	(a6)+,d6
		lea	0(a0,d6.w),a2
		movep.w	1(a2),d7
		move.b	(a2),d7
		add.w	d2,d7			;Y
		ENDM

GETABSADDR	MACRO
		movep.w	1(a6),d7
		move.b	(a6),d7
		addq.l	#2,a6
		ENDM

GETABSXADDR	MACRO
		movep.w	1(a6),d7
		move.b	(a6),d7
		addq.l	#2,a6
		add.w	d1,d7			;X
		ENDM

GETABSYADDR	MACRO
		movep.w	1(a6),d7
		move.b	(a6),d7
		addq.l	#2,a6
		add.w	d2,d7			;Y
		ENDM

INPUT		MACRO
		lea	.\@(pc),a2
		jmp	ReadIO
.\@
		ENDM

_OUTPUT		MACRO
		move.l	d7,a2
		moveq	#$00,d7
		move.b	0(a3,a2.l),d7
		jmp	WriteIO
		ENDM

_OUTPUT2	MACRO
		jmp	WriteIO
		ENDM


PUSHP		MACRO
		lea	.\@(pc),a2
		jmp	IPushP
.\@
		ENDM

PULLP		MACRO
		lea	.\@(pc),a2
		jmp	IPullP
.\@
		ENDM

CheckDecMode	MACRO
		btst	#11,d5
		beq.s	.1\@
		tst.w	d4
		bmi.s	.2\@
		move.l	#$00010000,a2
		add.l	a2,a4
		add.l	a2,a5
		or.w	#$8000,d4
		jmp	.2\@(pc,a2.l)
.1\@		tst.w	d4
		bpl.s	.2\@
		move.l	#$FFFF0000,a2
		add.l	a2,a4
		add.l	a2,a5
		and.w	#$7fff,d4
		jmp	.2\@(pc,a2.l)
.2\@
		ENDM

CheckIntFlag	MACRO
		lea	.\@(pc),a2
		jmp	ICheckIntFlag
.\@
		ENDM

SetAStatus	MACRO
		dc.w	hunkStatus
		ENDM

DecimalMode1	MACRO
		dc.w	hunkDecAdd	;abcd.b d6,d0 - addx.b d6,d0
		ENDM

DecimalMode2	MACRO
		dc.w	hunkDecSub	;sbcd.b	d6,d0 - subx.b d6,d0
		ENDM

IfStatus	MACRO
		dc.w	hunkIfStat
		ENDM

Next_Inst	MACRO
		move.b	(a6)+,-(a7)
		move.w	(a7)+,d7
		clr.b	d7
		jmp	0(a4,d7.w)
		ENDM

NextInst	MACRO
		dc.w	hunkNextInst,hunkNextInst0
		dc.l	$FFFFFFFF
		dc.w	$FFFF
		ENDM

NextInstStat	MACRO
		dc.w	hunkNextInst,hunkNextInst1
		dc.l	$FFFFFFFF
		dc.w	$FFFF
		ENDM

NextInstStat2	MACRO
		dc.w	hunkNextInst,hunkNextInst2
		dc.l	$FFFFFFFF
		dc.w	$FFFF
		ENDM

CHECKMMU	MACRO
		jmp	CheckMMU
		ENDM

CONVTIMER	MACRO
		mulu	#45085,\1
		clr.w	\1
		swap	\1
		ENDM

FIXIRQOCC	MACRO
		move.b	\1(a0),d7
		and.b	\1+1(a0),d7
		beq.s	.1\@
		or.b	#$80,\1(a0)
.1\@		
		ENDM

FIXRASTER	MACRO
		move.w	d7,-(a7)
		mulu	#993,d7
		clr.w	d7
		swap	d7
		add.l	rasterBeamHigh(a0),d7
.1\@		cmp.w	#$0138,d7
		blt.s	.2\@
		swap	d7
		addq.w	#1,d7
		swap	d7
		sub.w	#$0138,d7
		bra.s	.1\@
.2\@		move.l	d7,\1(a0)
		cmp.l	rasterBeamNew(a0),d7
		bls.s	.3\@
		move.l	d7,rasterBeamNew(a0)
.3\@
		moveq	#$00,d7
		move.w	(a7)+,d7
		ENDM

FIXFREQ		MACRO
		bmi.s	.1\@
		move.w	#\2,$096(a1)
		move.w	#$0000,\1+4(a1)
		bra.s	.2\@
.1\@		neg.b	d6
		move.w	#55930,d7
		mulu	d6,d7
		lsr.l	#8,d7
		move.w	d7,\1(a1)
		move.w	#\2+$8000,$096(a1)
.2\@		moveq	#$00,d7
		ENDM

* MACROS FOR USE WITHIN INTERRUPT LEVEL 1-7 CODE ,A3 = VIC20MemBase *

SaveIrqPointer	MACRO
		move.w	#$4000,$009a(a5)
		addq.b	#1,indSaveA4(a3)
		bne.s	.1\@
		move.l	a4,regSaveA4(a3)
		bra.s	.2\@
.1\@		move.l	a4,-(a7)
.2\@
		move.w	#$c000,$009a(a5)
		ENDM

RestIrqPointer	MACRO
		move.w	#$4000,$009a(a5)
		tst.b	indSaveA4(a3)		
		bne.s	.1\@
		move.l	regSaveA4(a3),a4
		clr.l	regSaveA4(a3)
		bra.s	.2\@
.1\@		move.l	(a7)+,a4
.2\@
		subq.b	#1,indSaveA4(a3)		
		move.w	#$c000,$009a(a5)
		ENDM

InvokeInterrupt	MACRO
		move.w	#$4000,$009a(a5)
		addq.b	#1,reqInterrupt(a3)
		bne.s	.2\@
		tst.l	regSaveA4(a3)
		bne.s	.1\@
		subq.l	#4,a4
		bra.s	.2\@
.1\@		subq.l	#4,regSaveA4(a3)
.2\@		clr.b	reqInterrupt(a3)
		move.w	#$c000,$009a(a5)
		ENDM

