{ 権  ZX Spectrum.                                             }
{-----------------------------------                                         }
{(c) 1999 by Flying/Digital Reality                                          }
{஬ ᯠᨡ  ﭪ    প.                    }

Program ZX_Animation_Viewer;

Uses
  ZXA,
  Dos,
  Speccy,
  Video,
  List,
  Keyboard,
  Timer,
  CLParser,
  StringsUnit,
  ExitUnit;

Const
{न 뢮 㬮᪮ ࠭  PC ࠭}
  ScrX = (X_Res-256) div 2;
  ScrY = (Y_Res-192) div 2;

Type
{ 㯠 樨}
  PFrame = ^TFrame;
  TFrame = record
    XPos      : byte;
    YPos      : byte;
    XSize     : byte;
    YSize     : byte;
    FrameSize : word;
    Data      : pointer;
  end;

{ꥪ - ᯨ᮪ 㯠 ஢ 樨}
  PFramesList = ^TFramesList;
  TFramesList = object(TList)
    Procedure DisposeItem(Item:Pointer);virtual;
  end;

Var
  FName:string;
  FileType:TFileType;
  PlayerType:byte;
  Version:byte;
  XPos,YPos:byte;
  XSize,YSize:byte;
  QFrames:byte;
  CurFrame:PFrame;
  Frames:PFramesList;
  PackedScreen:PByteArray;
  ZXScreen:PSpeccyScreen;
  ZXBack:PSpeccyScreen;
  isIndependent:boolean;
  isColumns:boolean;
  BackPict:string;
  i:byte;
  f:file;
  r:boolean;
  s,s1:string;
  D:DirStr;
  N:NameStr;
  E:ExtStr;
{Command line options}
  PlaySpeed:word;
  RepeatDelay:word;
  isLoop:boolean;
  isFrame:boolean;
  isGrid:boolean;
  isSave:boolean;

{  䫠}
Procedure SetFlags(ID:string;Flags:byte);
var
  s:string;
begin
  PlayerType:=Flags and PlayerTypeMask;
  if not PlayerType in [ptNormal,ptLaced,ptC64] then
  begin
    str(PlayerType,s);
    ErrorMessage:='Unsupported player ID ('+s+')';
    halt(exit_CustomError);
  end;
  isColumns:=(Flags and flg_Columns)<>0;
  if not isColumns then
  begin
    ErrorMessage:='Horisontal frames encoding don''t supported by this version of viewer';
    halt(exit_CustomError);
  end;
  if ID=ZXA_ID then
  begin
    isIndependent:=(Flags and flg_Independent)<>0;
    if not isIndependent then
    begin
      ErrorMessage:='Animations with non-independent frames are don''t supported by this version of viewer';
      halt(exit_CustomError);
    end;
  end;
end;

{㧪 ZXF 䠩}
{   ⠭  PackedScreen}
Procedure LoadZXF(FName:string);
var
  f:file;
  s:string;
  flg:byte;
begin
{ଠ 䠩 }
  Assign(f,FName);
{$I-}
  reset(f,1);
{$I+}
  if IOResult<>0 then
  begin
    ErrorMessage:=FName;
    halt(exit_ErrorOpenFile);
  end;
{ய᪠ 䨪 䠩}
  s[0]:=char(ID_Size);
  BlockRead(f,s[1],ID_Size);
{뢠  ଠ 䠩}
  BlockRead(f,Version,SizeOf(byte));
  if (Version>ZXF_Version) then
  begin
    Str(Version,s);
    ErrorMessage:='Unsupported version format ('+s+')';
    halt(exit_CustomError);
  end;
{⥭ .ZXF 䠩}
  BlockRead(f,flg,SizeOf(byte));          { 䫠}
  SetFlags(ZXF_ID,flg);
  BlockRead(f,XPos,SizeOf(byte));
  BlockRead(f,YPos,SizeOf(byte));
  BlockRead(f,XSize,SizeOf(byte));
  BlockRead(f,YSize,SizeOf(byte));
  BlockRead(f,PackedScreen^,FileSize(f)-FilePos(f));
  close(f);
end;

{㧪 ZXA 䠩}
Procedure LoadZXA(FName:string);
var
  f:file;
  s:string;
  i:integer;
  b:byte;
  flg:byte;
  Tab:array [0..$FF] of word;

{楤 ᮧ    樨  㦠 }
{FrameSize - ࠧ  }
Procedure LoadFrame(FrameSize:word);
var
  Frame:PFrame;
begin
  New(Frame);
{뢠 }
  BlockRead(f,Frame^.XPos,SizeOf(byte));
  BlockRead(f,Frame^.YPos,SizeOf(byte));
  BlockRead(f,Frame^.XSize,SizeOf(byte));
  BlockRead(f,Frame^.YSize,SizeOf(byte));
  Frame^.FrameSize:=FrameSize-ZXA_FrameHeaderSize;
  GetMem(Frame^.Data,Frame^.FrameSize);
  BlockRead(f,Frame^.Data^,Frame^.FrameSize);
  Frames^.Insert(Frame)
end;

begin
  Assign(f,FName);
{$I-}
  reset(f,1);
{$I+}
  if IOResult<>0 then
  begin
    ErrorMessage:=FName;
    halt(exit_ErrorOpenFile);
  end;
{ய᪠ 䨪 䠩}
  s[0]:=char(ID_Size);
  BlockRead(f,s[1],ID_Size);
{뢠  ଠ 䠩}
  BlockRead(f,Version,SizeOf(byte));
  if (Version>ZXA_Version) then
  begin
    Str(Version,s);
    ErrorMessage:='Unsupported version format ('+s+')';
    halt(exit_CustomError);
  end;
{⥭ .ZXA 䠩}
  BlockRead(f,QFrames,SizeOf(byte));      {⢮ ஢}
  BlockRead(f,flg,SizeOf(byte));          { 䫠}
  SetFlags(ZXA_ID,flg);
  BlockRead(f,Tab,QFrames*SizeOf(word));  { ᬥ饭 砫    樨}
{८ࠧ ᬥ饭    ࠧ  }
  for i:=QFrames-1 downto 1 do
    Tab[i]:=Tab[i]-Tab[i-1];
{㧪 ஢ 樨}
  for i:=0 to QFrames-2 do        {QFrames-2 - ⮣  ࠧ }
    LoadFrame(Tab[i+1]);          {᫥   ⥭}
                                  {Tab[i+1] - ⮣    ࠧ}
                                  {஢   ⠡ ᬥ饭묨  1}
  LoadFrame(FileSize(f)-FilePos(f));
  close(f);
end;

Procedure SetBackground(ZXScreen:PSpeccyScreen);
var
  i,j:integer;
  color:byte;
begin
  Move(ZXBack^,ZXScreen^,SizeOf(TSpeccyScreen));
  if isGrid then
  begin
    color:=$47;
    for i:=0 to 23 do
    begin
      for j:=0 to 31 do
      begin
         ZXScreen^[$1800+32*i+j]:=color;
         color:=color xor $40;
      end;
      color:=color xor $40;
    end;
    Enable_BlackBright:=true;
  end;
end;

Procedure ViewScreen_Normal(FrameBuf:PSpeccyScreen;PCScreen:word;X,Y:byte);
begin
  SetSpeccyScreen(FrameBuf);
  ViewSpeccyScreen(PCScreen,X,Y);
end;

Procedure ViewScreen_Laced(FrameBuf:PSpeccyScreen;PCScreen:word;X,Y:byte);
begin
  SetSpeccyScreen(FrameBuf);
  ViewSpeccyScreen(PCScreen,X,Y);
end;

Procedure ViewScreen_C64(FrameBuf:PSpeccyScreen;PCScreen:word;X,Y:byte);
var
  Spr:PByteArray;
  Adr:word;
begin
  GetMem(Spr,SizeOf(Spr^));
  SetSpeccyScreen(FrameBuf);
{室  砫 ८ࠧ   ࠩ⮢ ଠ}
  GetSpeccySprite(Spr,XPos,YPos div 8,XSize,YSize div 8,false);
  SetBackground(FrameBuf);
{ ⫨稥  㣨 ⮤  ᭠砫 ந室 뢮 ८ࠧ}
{࠭  㬮᪨ ࠭,  ⥬  뢮  PC ࠭}
{  ᯮ짮 XPos*2  YPos*2 .. 室 ࠦ 뫮 ᦠ}
{ 2 ࠧ  X  Y}
  Adr:=GetScreenAddress(XPos*2,(YPos*2) and $F8); {Y न  뢮 易  ⭠ !}
  asm
    jmp @start
@xs: db 0
@ys: db 0
@start:
    mov al,XSize
    mov [cs:offset @xs],al
    mov al,YSize
    mov [cs:offset @ys],al
    push ds
    lds si,Spr
    les di,FrameBuf
    add di,Adr
    mov ch,cs:[offset @ys]
    shr ch,3            {ࠧ  Y  뢮 易  ⥭ !}
@loop:
    push di
    mov cl,8
    mov ax,di
@loop1:
    mov bx,di
    add bl,$20
    jnc @l1
    add bh,8
@l1:
    push bx
    push di
    mov dl,cs:[offset @xs]
@loop2:
    mov ah,[si]
    inc si
    mov es:[di],ah
    inc di
    mov es:[di],ah
    inc di
    mov es:[bx],ah
    inc bx
    mov es:[bx],ah
    inc bx
    dec dl
    jnz @loop2
    pop di
    add di,$100
    pop bx
    inc bh
    dec cl
    jnz @loop1
    pop dx
    add dl,$40
    jnc @l2
    add dh,8
@l2:
    mov di,dx
    dec ch
    jnz @loop
    pop ds
  end;
  ViewScreen_Normal(FrameBuf,PCScreen,X,Y);
  FreeMem(Spr,SizeOf(Spr^));
end;

Procedure ViewFrame(Frame:PSpeccyScreen;ViewerType:byte);
begin
  case ViewerType of
    ptNormal : ViewScreen_Normal(Frame,ScreenBuf,ScrX,ScrY);
    ptLaced  : ViewScreen_Laced(Frame,ScreenBuf,ScrX,ScrY);
    ptC64    : ViewScreen_C64(Frame,ScreenBuf,ScrX,ScrY);
  end;
end;

{ᯠ 㯠 }
{SrcBuf - 㯠 }
{ZXScr  - ᯠ }
{x,y    - न  孥 㣫   ᯠ }
{xs,ys  - ࠧ   ᯠ }
Procedure UnpackFrame(SrcBuf:PByteArray;ZXScr:PSpeccyScreen;x,y,xs,ys:byte);
Var
  Adr:word;
  Index:word;
  _x,_y:byte;
  b,z:byte;
  sz:word;
  i:integer;

Function ReadData:byte;
begin
  ReadData:=SrcBuf^[Index];
  inc(Index);
end;

{頥 ࠧ ࠡ뢠 }
{Data - 1-   ⥪饩 ᫥⥫쭮}
{StartValue - 砫쭮 祭  ⥪饩 樨}
{ByteLimit - ⢮  ⢥   }
{hasAdd -  ন ࠭ .  (true/false)}
Function GetSize(Data:byte;StartValue,ByteLimit:byte;hasAdd:boolean):word;
var
  sz:word;
  b:byte;
begin
  sz:=Data-StartValue;
  if hasAdd then
  begin
    sz:=sz div 2;
    ByteLimit:=ByteLimit div 2;
  end;
  if sz=0 then
  begin
    b:=ReadData;
    sz:=b;
    if b<ByteLimit then
    begin
      sz:=sz*$100;
      b:=ReadData;
      sz:=sz+b;
    end;
  end;
  GetSize:=sz;
end;

Function GetByte:byte;
begin
  Adr:=GetScreenAddress(x,y);
  GetByte:=ZXScr^[Adr];
end;

Procedure StoreByte(Data:byte);
begin
  Adr:=GetScreenAddress(_x,_y);
  ZXScr^[Adr]:=Data;
  inc(_y);
  if PlayerType=ptLaced then
    inc(_y);
  if _y=y+ys then
  begin
    _y:=y;
    inc(_x);
  end;
end;

Procedure StoreAddByte(Data:byte);
begin
  if (Data and 1)<>0 then
  begin
    z:=ReadData;
    StoreByte(z);
  end;
end;

begin
  _x:=x;
  _y:=y;
  if PlayerType=ptLaced then
    ys:=ys*2;
  Index:=0;
  repeat
    b:=ReadData;
    case b of
      bEnd..bEnd+qEnd-1:
        begin
          break;
        end;
      bSkip..bSkip+qSkip-1:
        begin
          sz:=GetSize(b,bSkip,qSkip,true);
          for i:=0 to sz-1 do
          begin
            z:=GetByte;
            StoreByte(z);
          end;
          StoreAddByte(b);
        end;
      bInverse..bInverse+qInverse-1:
        begin
          sz:=GetSize(b,bInverse,qInverse,true);
          for i:=0 to sz-1 do
          begin
            z:=GetByte;
            z:=z xor $FF;
            StoreByte(z);
          end;
          StoreAddByte(b);
        end;
      bByte..bByte+qByte-1:
        begin
          sz:=GetSize(b,bByte,qByte,true);
          z:=ReadData;
          for i:=0 to sz-1 do
            StoreByte(z);
          StoreAddByte(b);
        end;
      bFillFF..bFillFF+qFillFF-1:
        begin
          sz:=GetSize(b,bFillFF,qFillFF,true);
          for i:=0 to sz-1 do
            StoreByte($FF);
          StoreAddByte(b);
        end;
      bFillZero..bFillZero+qFillZero-1:
        begin
          sz:=GetSize(b,bFillZero,qFillZero,true);
          for i:=0 to sz-1 do
            StoreByte($00);
          StoreAddByte(b);
        end;
      bSequence..bSequence+qSequence-1:
        begin
          sz:=GetSize(b,bSequence,qSequence,false);
          for i:=0 to sz-1 do
          begin
            b:=ReadData;
            StoreByte(b);
          end;
        end;
      bSpecByte..bSpecByte+qSpecByte-1:
        begin
          z:=(b-bSpecByte) div 2;
          StoreByte(SpecBytes[z]);
          StoreAddByte(b);
        end;
    end;
  until false;
end;

Procedure InitScreen;
var
  i,j:integer;
  color:byte;
begin
  SetBackground(ZXScreen);
  SetSpeccyScreen(ZXScreen);
  SetGFXMode;
  ClearScr;
  SetSpeccyPalette;
  SetPaletteItem($FF,$3F,$3F,$3F);
  if isFrame then
  begin
    SetPaletteItem($FE,$00,$3F,$00);
    Rectangle(ScrX-1,ScrY-1,256+2,192+2,$FE);
  end;
end;

Procedure TFramesList.DisposeItem(Item:Pointer);
begin
  FreeMem(PFrame(Item)^.Data,PFrame(Item)^.FrameSize);
  Dispose(PFrame(Item));
end;

Procedure InitMem;
begin
  InitTimer;
  GetMem(PackedScreen,SizeOf(PackedScreen^));
  CreateSpeccyScreen(ZXScreen);
  CreateSpeccyScreen(ZXBack);
  InitCLParser;
  New(Frames,Init);
  PlaySpeed:=5;
  RepeatDelay:=0;
  isLoop:=false;
  isFrame:=false;
  isGrid:=false;
  isSave:=false;
  BackPict:='';
end;

Procedure DoneMem;far;
begin
  Dispose(Frames,Done);
  DoneCLParser;
  DestroySpeccyScreen(ZXBack);
  DestroySpeccyScreen(ZXScreen);
  FreeMem(PackedScreen,SizeOf(PackedScreen^));
  DoneTimer;
end;

BEGIN
  InitMem;
  DoneMemProc:=DoneMem;
  if CLParam^.GetParamCount=0 then
  begin
    writeln('ZX animation viewer v2.00');
    writeln('Special edition for Scenergy #2 disk magazine.');
    writeln('(c) 13.12.1999 by Flying/Digital Reality. Special thanks to Dmitry Pjankov.');
    writeln('Usage: ZXA_VIEW <File> [Parameters]');
    writeln('<File> - .ZXA or .ZXF file to view');
    writeln;
    writeln('Parameters: /|-<key>[:<value>]');
    writeln(' P - play speed');
    writeln(' L - loop playing');
    writeln(' R - delay before repeat playing');
    writeln(' F - show Speccy screen frame');
    writeln(' G - show Speccy screen bright grid');
    writeln(' B - set background picture (only SCR or Hobeta)');
    writeln('SV - save unpacked frames (specify one of following formats: PCX, Hobeta, SCR)');
    halt(exit_Ok);
  end;
  with CLParam^ do
  begin
    if isParamExist(1) and not isKey(1) then
      GetStringParamNum(1,FName);
    if isKeyExist('P') then
      GetWordParamKey('P',PlaySpeed);
    if isKeyExist('L') then
      isLoop:=true;
    if isKeyExist('R') then
      GetWordParamKey('R',RepeatDelay);
    if isKeyExist('F') then
      isFrame:=true;
    if isKeyExist('G') then
      isGrid:=true;
    if isKeyExist('B') then
      GetStringParamKey('B',BackPict);
    if isKeyExist('SV') then
    begin
      GetStringParamKey('SV',s1);
      s:=StrUpCase(s1);
      SaveType:=ft_Invalid;
      if s[1]='P' then
        SaveType:=ft_PCX;
      if s[1]='S' then
        SaveType:=ft_SCR;
      if s[1]='H' then
        SaveType:=ft_Hobeta;
      isSave:=true;
      if SaveType=ft_Invalid then
      begin
        writeln('Warning: format type ''',s1,''' specified into /SV key is not recognized!');
        writeln('         Frames saving disabled.');
        isSave:=false;
      end;
    end;
  end;
  if FName='' then
  begin
    ErrorMessage:='Specify file name to view!';
    halt(exit_CustomError);
  end;
  if BackPict<>'' then
  begin
    FileType:=CheckScreen(BackPict);
    case FileType of
      ft_SCR:
        begin
          Assign(f,BackPict);
{$I-}
          reset(f,1);
{$I+}
          if IOResult<>0 then
          begin
            ErrorMessage:=BackPict;
            halt(exit_ErrorOpenFile);
          end;
          BlockRead(f,ZXBack^,SizeOf(TSpeccyScreen));
          close(f);
        end;
      ft_Hobeta:
        begin
          r:=ReadHobetaFile(BackPict,ZXBack);
          if not r then
          begin
            ErrorMessage:=BackPict;
            halt(exit_ErrorOpenFile);
          end;
        end;
    else
      begin
        writeln('Warning: background picture file format is not recognized');
        repeat
        until KeyPressed;
        EmptyKeyBuffer;
      end;
    end;
  end;
  FileType:=CheckScreen(FName);
  if (FileType=ft_Invalid) then
  begin
    ErrorMessage:='Invalid file format ('+FName+')';
    halt(exit_CustomError);
  end;
  case FileType of
    ft_ZXF:
      begin
        LoadZXF(FName);
        InitScreen;
        UnpackFrame(PackedScreen,ZXScreen,XPos,YPos,XSize,YSize);
        ViewFrame(ZXScreen,PlayerType);
        if isSave then
          SaveScreen(FName,ZXScreen);
        repeat
        until KeyPressed;
        EmptyKeyBuffer;
        SetTextMode;
      end;
    ft_ZXA:
      begin
        LoadZXA(FName);
        InitScreen;
        repeat
          with Frames^ do
          begin
            SetCurrent(0);
            CurFrame:=GetItem;
            ResetTimerTicks;
            for i:=1 to GetSize do
            begin
              Move(CurFrame^.Data^,PackedScreen^,CurFrame^.FrameSize);
              with CurFrame^ do
                UnpackFrame(PackedScreen,ZXScreen,XPos,YPos,XSize,YSize);
              XPos:=CurFrame^.XPos;
              YPos:=CurFrame^.YPos;
              XSize:=CurFrame^.XSize;
              YSize:=CurFrame^.YSize;
              ViewFrame(ZXScreen,PlayerType);
              CurFrame:=GetNext;
              if isSave then
              begin
                FSplit(FName,D,N,E);
                s:=Copy(N,1,5);
                str(i-1,s1);
                while length(s1)<3 do
                  s1:='0'+s1;
                s:=D+s+s1;
                SaveScreen(s,ZXScreen);
              end;
              if ESCPressed then
              begin
                EmptyKeyBuffer;
                SetTextMode;
                halt(exit_Ok);
              end;
              if GetTimerTicks<PlaySpeed then
                repeat until GetTimerTicks>=PlaySpeed;
              ResetTimerTicks;
            end;
            isSave:=false;
            if isLoop then
              begin
                if GetTimerTicks<RepeatDelay then
                  repeat
                    if ESCPressed then
                    begin
                      EmptyKeyBuffer;
                      SetTextMode;
                      halt(exit_Ok);
                    end;
                  until GetTimerTicks=RepeatDelay;
                ResetTimerTicks;
              end
            else
              break;
          end;
        until false;
        EmptyKeyBuffer;
        SetTextMode;
      end;
  end;
END.
