$! Build XBeeb on VMS VAX or Alpha
$!
$! This requires VMS 6.2 onwards and DEC C 5.3 onwards.
$! It has not been tested with VAX C or GNU C on VMS.
$!
$! History:
$!		V01-001		Phil Ottewell		03-Apr-1996
$!		V01-002		Phil Ottewell		05-Mar-1997
$!
$ SET NOON
$ SAY:=WRITE SYS$OUTPUT
$! Avoid picking up local symbols for CC
$ CC:=CC
$ is_alpha = F$GETSYI("NODE_HWTYPE").EQS."ALPH"
$ IF is_alpha
$ THEN
$   obj = "OBJ_ALPHA"
$   exe = "EXE_ALPHA"
$   opt = "OPT_ALPHA"
$ ELSE
$   obj = "OBJ"
$   exe = "EXE"
$   opt = "OPT"
$ ENDIF
$!
$! Check for debug
$!
$ IF P1.EQS."D" .OR. P2.EQS."D"
$ THEN
$   cqual = "/NOOPTIMIZE/DEBUG/STANDARD=VAXC/PREFIX=ALL/OBJECT=.''obj'"
$   lqual = "/TRACE/DEBUG"
$ ELSE
$   cqual = "/OPTIMIZE/NODEBUG/STANDARD=VAXC/PREFIX=ALL/OBJECT=.''obj'"
$   lqual = "/NODEBUG/FULL/CROSS_REFERENCE/MAP"
$ ENDIF
$!
$ this_file = F$ENVIRONMENT("PROCEDURE")
$ this_dev = F$PARSE(this_file,,,"DEVICE")
$ this_dir = F$PARSE(this_file,,,"DIRECTORY")
$ orig_default = F$ENVIRONMENT("DEFAULT")
$ SET DEFAULT 'this_dev''this_dir'
$ SHOW DEFAULT
$!
$ IF P1.EQS."L" .OR. P2.EQS."L" THEN $ GOTO link
$!
$compile:
$ SAY "Compiling all source files for XBeeb ..."
$ old_ver = F$VERIFY(1)
$ CC'cqual'  Beeb.c
$ CC'cqual' Memory.c
$ CC'cqual' Fred.c
$ CC'cqual' Jim.c
$ CC'cqual' Sheila.c
$ CC'cqual' Crtc.c
$ CC'cqual' Acia.c
$ CC'cqual' SerialUla.c
$ CC'cqual' VideoUla.c
$ CC'cqual' RomSelect.c
$ CC'cqual' SystemVia.c
$ CC'cqual' UserVia.c
$ CC'cqual' Disk.c
$ CC'cqual' Econet.c
$ CC'cqual' ADC.c
$ CC'cqual' TubeUla.c
$ CC'cqual' 6522Via.c
$ CC'cqual' Keyboard.c
$ CC'cqual' Screen.c
$ CC'cqual' Modes.c
$ CC'cqual' Teletext.c
$ CC'cqual' Display.c
$ CC'cqual' Sound.c
$ CC'cqual' Bitmap.c
$ CC'cqual' EFS.c
$ CC'cqual' Options.c
$ CC'cqual' InfoWindow.c
$ CC'cqual' KeyMapStrict.c
$ CC'cqual' KeyMapLegend.c
$ ver = F$VERIFY(old_ver)
$!
$link:
$ SAY "Linking XBeeb ..."
$ old_ver = F$VERIFY(1)
$ LINK'lqual'/EXE=XBEEB.'exe' -
Beeb.'obj', Memory, Fred, Jim, Sheila, Crtc, Acia, -
SerialUla, VideoUla, RomSelect, SystemVia, UserVia, -
Disk, Econet, ADC, TubeUla, 6522Via, Keyboard, -
Screen, Modes, Teletext, Display, Sound, Bitmap, EFS, Options, InfoWindow,-
KeyMapStrict, KeyMapLegend,MOTIF.'opt'/OPT
$ ver = F$VERIFY(old_ver)
$!
$ SAY " "
$ SAY "Move the executables to the [.EXE] directory"
$ IF F$SEARCH("[-]EXE.DIR").EQS.""
$ THEN
$   CREATE/DIRECTORY/PROTECTION=(W:RE) [-.EXE]
$   RENAME/LOG *.EXE*; [-.EXE]
$ ENDIF
$!
$ SAY " "
$ SAY "Compile ROM patcher, PCH"
$ SET DEFAULT [-.PCH]
$ CC PCH
$ LINK PCH
$!
$ SAY " "
$ SAY "Compile Teletext fonts"
$ SET DEFAULT [-.FONTS]
$ FONT TTEXT-GRC-LDH.BDF
$ FONT TTEXT-GRC-UDH.BDF
$ FONT TTEXT-GRC.BDF
$ FONT TTEXT-GRS-LDH.BDF
$ FONT TTEXT-GRS-UDH.BDF
$ FONT TTEXT-GRS.BDF
$ FONT TTEXT-STD-LDH.BDF
$ FONT TTEXT-STD-UDH.BDF
$ FONT TTEXT-STD.BDF
$! 
$! Set up the XBEEB symbol
$ SAY " "
$ SAY "Setting up XBEEB symbol and defining BEEB$ROOT: logical"
$ @[-]SETUP
$ SHOW LOGICAL BEEB$ROOT
$ SAY " "
$ SAY "Please create the following directories under your own"
$ SAY "login directory:  [.BBC.ROMS]"
$ SAY "                  [.BBC.SNAPS]"
$ SAY "                  [.BBC.DISKS]"
$ SAY "                  [.BBC.TAPES]"
$ SAY " "
$ SAY "XBeeb looks for the files BEEB$ROOT:[ROMS]OS1_2p1.ROM"
$ SAY "                      and BEEB$ROOT:[ROMS]XDFS0_70.ROM"
$ SAY " "
$ SAY "So COPY XDFS0.70_ROM from the [.ROMS] directory in the distribution"
$ SAY "directory to BEEB$ROOT:[ROMS]xdfs0_70.rom , then run the PCH program
$ SAY "in the distribution's [.PCH] directory to patch the OS 1.2 ROM image"
$ SAY "which you should download from your BBC Micro using (say) Kermit,"
$ SAY "save it as BEEB$ROOT:[ROMS]OS1_2.ROM and run PCH to create"
$ SAY "BEEB$ROOT:[ROMS]OS1_2p1.rom "
$ SAY " "
$ SAY "This is covered in detail in README.VMS, README.; and [.DOC]ROMPATCHES.;"
$ SET DEFAULT 'orig_default'
$ EXIT
