;; DOUBLE DRAGON 
;; 
;; Mastertronic re-release
;;  
;; "Spanish loader"
;;
;; 2nd loader:
;; - ESC will stop loading
;; - checksum byte followed by data
;; - checksum set to 0, then XORed with all bytes following
;;   result must be 0 for loading to be successful.
;; - data is not encrypted
;; - border flashes multi-colours for pilot and data
;; - uses 0x010 block in TZX (Spectrum timings)

09c4 f3        di      
09c5 316009    ld      sp,$0960
;; clear screen
09c8 2100c0    ld      hl,$c000
09cb 1101c0    ld      de,$c001
09ce 01ff3f    ld      bc,$3fff
09d1 3600      ld      (hl),$00
09d3 edb0      ldir    

;; set display mode for title screen
09d5 af        xor     a
09d6 cd2a0b    call    $0b2a

;; set colours for title screen
09d9 21450b    ld      hl,$0b45
09dc cd350b    call    $0b35

09df 21a00f    ld      hl,$0fa0
09e2 11c8af    ld      de,$afc8
09e5 016400    ld      bc,$0064
09e8 edb0      ldir    
;; load screen
09ea dd2100c0  ld      ix,$c000
09ee 110040    ld      de,$4000
09f1 cd0b0a    call    $0a0b
;; load program code
09f4 dd21e40c  ld      ix,$0ce4
09f8 116e3d    ld      de,$3d6e
09fb cd0b0a    call    $0a0b
09fe dd21524a  ld      ix,$4a52
0a02 11d761    ld      de,$61d7
0a05 cd0b0a    call    $0a0b
;; execute program
0a08 c3e40c    jp      $0ce4

;;-------------------------------------------------------------------

;; IX = load address
;; DE = length

0a0b f3        di      
0a0c dd22260b  ld      ($0b26),ix
0a10 ed53280b  ld      ($0b28),de
0a14 08        ex      af,af'
0a15 d9        exx     
0a16 f5        push    af
0a17 d5        push    de
0a18 1610      ld      d,$10				; border select code
0a1a 067f      ld      b,$7f				; I/O address for Gate Array
0a1c d9        exx     
;; index of PSG port A register
0a1d 010ef4    ld      bc,$f40e
0a20 ed49      out     (c),c
;; select PSG register
0a22 01d0f6    ld      bc,$f6d0
0a25 ed49      out     (c),c
0a27 0e10      ld      c,$10
0a29 ed49      out     (c),c
;; set PPI port A to input
0a2b 0192f7    ld      bc,$f792
0a2e ed49      out     (c),c
;; select PSG operation to read, and select keyboard line 8
0a30 0158f6    ld      bc,$f658
0a33 ed49      out     (c),c
;; motor on
0a35 cd0f0b    call    $0b0f

0a38 dd2a260b  ld      ix,($0b26)
0a3c ed5b280b  ld      de,($0b28)
0a40 af        xor     a
0a41 37        scf     
0a42 cd640a    call    $0a64

0a45 f5        push    af
;; set border to black
0a46 01107f    ld      bc,$7f10
0a49 ed49      out     (c),c
0a4b 3e54      ld      a,$54
0a4d ed79      out     (c),a

0a4f f1        pop     af
0a50 08        ex      af,af'
0a51 d9        exx     
0a52 d1        pop     de
0a53 f1        pop     af
0a54 d9        exx     
0a55 08        ex      af,af'
0a56 0182f7    ld      bc,$f782
0a59 ed49      out     (c),c
0a5b 0110f6    ld      bc,$f610
0a5e ed49      out     (c),c
0a60 cd130b    call    $0b13
0a63 c9        ret     

;;---------------------------------------------------------------------

0a64 14        inc     d
0a65 08        ex      af,af'
0a66 15        dec     d
0a67 3ef5      ld      a,$f5
0a69 db00      in      a,($00)
0a6b e680      and     $80
0a6d d9        exx     
0a6e 1e4c      ld      e,$4c			
0a70 d9        exx     
0a71 4f        ld      c,a
0a72 bf        cp      a
0a73 00        nop     

0a74 cde70a    call    $0ae7			; get pulse
0a77 30fa      jr      nc,$0a73         ; (-$06)

;; delay
0a79 211504    ld      hl,$0415
0a7c 10fe      djnz    $0a7c            ; (-$02)
0a7e 2b        dec     hl
0a7f 7c        ld      a,h
0a80 b5        or      l
0a81 20f9      jr      nz,$0a7c         ; 

0a83 cde30a    call    $0ae3			; get wave
0a86 30eb      jr      nc,$0a73         ; 
0a88 069c      ld      b,$9c
0a8a cde30a    call    $0ae3			; get wave
0a8d 30e4      jr      nc,$0a73         ; 
0a8f 3eb9      ld      a,$b9
0a91 b8        cp      b
0a92 30e0      jr      nc,$0a74         ; 
0a94 24        inc     h
0a95 20f1      jr      nz,$0a88         ; 
0a97 06c9      ld      b,$c9
0a99 cde70a    call    $0ae7			; get pulse
0a9c 30d5      jr      nc,$0a73         ; 
0a9e 78        ld      a,b
0a9f fed1      cp      $d1
0aa1 30f4      jr      nc,$0a97         ; 
0aa3 cde70a    call    $0ae7			; get pulse
0aa6 d0        ret     nc

0aa7 d9        exx     
0aa8 1e4a      ld      e,$4a
0aaa d9        exx     
;; initialise checksum
0aab 2600      ld      h,$00
;; timing
0aad 06b0      ld      b,$b0
;; get byte
0aaf 1818      jr      $0ac9            

0ab1 08        ex      af,af'
0ab2 2005      jr      nz,$0ab9         
;; write byte to ram
0ab4 dd7500    ld      (ix+$00),l
0ab7 180a      jr      $0ac3            

;; test sync byte
0ab9 cb19      rr      c
0abb ad        xor     l
0abc c0        ret     nz

0abd 79        ld      a,c
0abe 17        rla     
0abf 4f        ld      c,a
0ac0 13        inc     de
0ac1 1802      jr      $0ac5            ; (+$02)

0ac3 dd23      inc     ix				; increment RAM pointer
0ac5 1b        dec     de				; decrement count
0ac6 08        ex      af,af'
;; get byte
0ac7 06b2      ld      b,$b2
0ac9 2e01      ld      l,$01
0acb cde30a    call    $0ae3			; get wave
0ace d0        ret     nc
0acf 3ec3      ld      a,$c3
0ad1 b8        cp      b
0ad2 cb15      rl      l
0ad4 06b0      ld      b,$b0
0ad6 30f3      jr      nc,$0acb         ; (-$0d)
;; update checksum with byte loaded
0ad8 7c        ld      a,h
0ad9 ad        xor     l
0ada 67        ld      h,a
;; all bytes transfered?
0adb 7a        ld      a,d
0adc b3        or      e
0add 20d2      jr      nz,$0ab1         ; (-$2e)

;; check checksum
0adf 7c        ld      a,h
0ae0 fe01      cp      $01
0ae2 c9        ret     

;;-------------------------------------------------------------------------------------
;; get wave
0ae3 cde70a    call    $0ae7
0ae6 d0        ret     nc
;; get pulse
0ae7 3e16      ld      a,$16
0ae9 3d        dec     a
0aea 20fd      jr      nz,$0ae9         ; (-$03)
0aec a7        and     a
0aed 04        inc     b
0aee c8        ret     z

;; read keyboard line 8 
;; keyboard->PSG I/O port A->PPI port A
0aef 3ef4      ld      a,$f4
0af1 db00      in      a,($00)
0af3 e604      and     $04				; isolate state of ESC key
0af5 ee04      xor     $04				; 0->1, 1->0
										; bit will now be '1' if ESC is pressed, '0' if ESC not pressed
0af7 c0        ret     nz

;; read cassette data input
0af8 3ef5      ld      a,$f5
0afa db00      in      a,($00)
0afc a9        xor     c
0afd e680      and     $80
0aff 28ec      jr      z,$0aed          

0b01 79        ld      a,c
0b02 2f        cpl     
0b03 4f        ld      c,a

0b04 d9        exx     
0b05 ed5f      ld      a,r
0b07 5f        ld      e,a
0b08 ed51      out     (c),d			; select pen
0b0a ed59      out     (c),e			; set ink for selected pen
0b0c d9        exx     
0b0d 37        scf     
0b0e c9        ret     

;;---------------------------------------------------------
;; cassette motor on

0b0f 3e10      ld      a,$10
0b11 1802      jr      $0b15            ; 


;;---------------------------------------------------------
;; cassette motor off

0b13 3eef      ld      a,$ef
0b15 c5        push    bc
0b16 06f6      ld      b,$f6
0b18 ed48      in      c,(c)
0b1a 04        inc     b
0b1b e610      and     $10
0b1d 3e08      ld      a,$08
0b1f 2801      jr      z,$0b22          
0b21 3c        inc     a
0b22 ed79      out     (c),a
0b24 c1        pop     bc
0b25 c9        ret     


;;---------------------------------------------------------
;; storage for load address
0b26 defw 0
;; storage for length
0b28 defw 0

;;---------------------------------------------------------
;; set display mode
;;
;; A = display mode index
;;
;; (this is very similar to firmware function: mc set mode)
0b2a d9        exx     
0b2b cb89      res     1,c
0b2d cb81      res     0,c
0b2f b1        or      c
0b30 4f        ld      c,a
0b31 ed49      out     (c),c
0b33 d9        exx     
0b34 c9        ret     

;;---------------------------------------------------------
;; set colour palette
;;
;; 16 pens + border
;;
;; HL = table of colours defined using hardware colour number (bit 7=0, bit 6 = 1, bit 4..0 = colour code)

0b35 01007f    ld      bc,$7f00			; I/O port of Gate Array and index of first pen (0)

0b38 ed49      out     (c),c			; select pen
0b3a 7e        ld      a,(hl)			; get colour
0b3b 23        inc     hl
0b3c ed79      out     (c),a			; set ink of selected pen
0b3e 0c        inc     c
0b3f 79        ld      a,c
0b40 fe11      cp      $11
0b42 20f4      jr      nz,$0b38         
0b44 c9        ret     

;;---------------------------------------------------------
;; colours for title screen (hardware colour numbers)

0b45 54        ld      d,h				; pen 0
0b46 44        ld      b,h				; pen 1
0b47 55        ld      d,l				; pen 2
0b48 57        ld      d,a				; pen 3
0b49 5c        ld      e,h				; pen 4
0b4a 4c        ld      c,h				; pen 5
0b4b 4e        ld      c,(hl)			; pen 6
0b4c 4a        ld      c,d				; pen 7
0b4d 43        ld      b,e				; pen 8
0b4e 4b        ld      c,e				; pen 9
0b4f 56        ld      d,(hl)			; pen 10
0b50 5e        ld      e,(hl)			; pen 11
0b51 5a        ld      e,d				; pen 12
0b52 51        ld      d,c				; pen 13
0b53 41        ld      b,c				; pen 14
0b54 47        ld      b,a				; pen 15
0b55 54        ld      d,h				; border
