PROGRAM CPE_Setup;

USES CRT;

{$L joystick.obj}

CONST pcnt = 24;
CONST hexnums: ARRAY[0..15] OF CHAR = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

VAR f: FILE OF WORD;
    a: STRING;
    c: CHAR;
    i: INTEGER;
    j: INTEGER;
    jx,jy:LONGINT;
    fault: BOOLEAN;

TYPE preftype = (prefhex, prefyesno, prefcpc, prefprt,
                 prefsound, prefjoy, prefkblang);
     prefgroup= (general, cpe, cpe2);

CONST prefs: ARRAY[0..pcnt] OF
                   RECORD
                     text:   STRING[80];
                     mode:   preftype;
                     defval: WORD;
                     ptype:  prefgroup;
                     value:  WORD;
                   END
    = ( (text: 'Overscan graphics mode'; mode: prefhex; defval: $6A; ptype: cpe),
        (text: 'Double lines in overscan mode'; mode: prefyesno; defval: 1; ptype: cpe),
        (text: 'Keyboard language'; mode: prefkblang; defval: 0; ptype: general),
        (text: 'Installed sound card'; mode: prefsound; defval: 0; ptype: general),
        (text: 'Soundcard base address (0x220)'; mode: prefhex; defval: $220; ptype: general),
        (text: 'Printer port'; mode: prefprt; defval: 1; ptype: general),
        (text: 'Screen length in 50Hz mode (0x6E)'; mode: prefhex; defval: $6E; ptype: cpe),
        (text: 'CPC model'; mode: prefcpc; defval: 3; ptype: general),
        (text: 'Screen refresh rate'; mode: prefhex; defval: 1; ptype: cpe2),
        (text: 'Use VESA mode 800x600'; mode: prefyesno; defval: 0; ptype: cpe2),
        (text: 'Use only a small screen in VESA mode'; mode: prefyesno; defval: 0; ptype: cpe2),
        (text: 'Use graphical menus VESA mode'; mode: prefyesno; defval: $FFFF; ptype: cpe2),
        (text: 'Enable EMS'; mode: prefyesno; defval: $FFFF; ptype: general),
        (text: 'Soundcard interrupt'; mode: prefhex; defval: 11; ptype: general),
        (text: 'Soundcard DMA channel'; mode: prefhex; defval: 1; ptype: general),
        (text: 'DMA buffer size'; mode: prefhex; defval: 512; ptype: general),
        (text: 'Quiet cassette mode'; mode: prefyesno; defval: $FFFF; ptype: general),
        (text: 'Use borders in 800x600 VESA mode'; mode: prefyesno; defval: $FFFF; ptype: cpe2),
        (text: 'Green monitor'; mode: prefyesno; defval: 0; ptype: general),
        (text: 'Use sound'; mode: prefyesno; defval: 0; ptype: general),
        (text: 'Use joystick'; mode: prefyesno; defval: 0; ptype: general),
        (text: 'Calibrate joystick'; mode: prefjoy; defval: 1; ptype: general),
        (text: 'dummy'; mode: prefjoy; defval: 1; ptype: general),
        (text: 'dummy'; mode: prefjoy; defval: 1; ptype: general),
        (text: 'dummy'; mode: prefjoy; defval: 1; ptype: general)
      );

VAR setupmode: prefgroup;
    menuchar: CHAR;

FUNCTION Hex(i: WORD): STRING;
VAR s: STRING;
BEGIN
  s := '';
  REPEAT
    s := hexnums[i AND 15] + s; i := i shr 4;
  UNTIL i = 0;
  Hex := '0x' + s;
END;

FUNCTION YesNo(i: WORD):STRING;
BEGIN
  IF i = 0 THEN YesNo := 'No' ELSE YesNo := 'Yes';
END;

FUNCTION CPC(i: WORD): STRING;
BEGIN
  CASE i OF
    1: CPC := '464';
    2: CPC := '664';
    3: CPC := '6128';
  END;
END;

FUNCTION KBLang(i: WORD): STRING;
BEGIN
  CASE i OF
    0: KBLang := 'Normal (English)';
    1: KBLang := 'French';
    2: KBLang := 'German';
  END;
END;

PROCEDURE GetCPC(VAR w: WORD);
BEGIN
  REPEAT
    Write('Enter 1 for 464, 2 for 664 or 3 for 6128: ');
    Readln(w);
  UNTIL (w>=1) AND (w<=3);
END;

PROCEDURE GetKBLang(VAR w: WORD);
BEGIN
  REPEAT
    Write('Enter 0 for normal (English), 1 for French, 2 for German keyboard: ');
    Readln(w);
  UNTIL (w>=0) AND (w<=2);
END;

FUNCTION SoundCard(i: WORD): STRING;
BEGIN
  CASE i OF
    0: SoundCard := 'None';
    1: SoundCard := 'SoundBlaster';
    2: SoundCard := 'GUS';
  END;
END;

PROCEDURE GetSound(VAR w: WORD);
BEGIN
  REPEAT
    Write('Enter 0 for none, 1 for SoundBlaster and 2 for GUS: ');
    Readln(w);
  UNTIL (w>=0) AND (w<=2);
END;

PROCEDURE GetJoy; far; external;

PROCEDURE GetHex(VAR w: WORD);
VAR a: STRING;
    v: BYTE;
    err: BOOLEAN;
BEGIN
  writeln;
  REPEAT
    err := TRUE;
    write('Enter new value in hexadecimal notation: 0x');
    readln(a);
    IF Length(a) > 4 THEN writeln('Illegal value!') ELSE BEGIN
      w := 0;
      err := FALSE;
      WHILE Length(a) > 0 DO BEGIN
        v := Ord(a[1]);
        IF (v>=97) AND (v<=102) THEN v := v - 32;
        IF (v>=65) AND (v<=70) THEN v := v - 55;
        IF (v>=Ord('0')) AND (v<=Ord('9')) THEN v := v - Ord('0');
        IF v > 15 THEN BEGIN err := TRUE; writeln('Illegal character!'); END;
        w := w*16+v; a:= Copy(a,2,Length(a)-1);
      END;
    END;
  UNTIL NOT err;
END;

PROCEDURE GetYesNo(VAR w: WORD);
VAR a: STRING;
BEGIN
  writeln;
  write('Type Y if you want to enable this option: '); readln(a);
  w := 0;
  IF a[1] = 'Y' THEN w := $FFFF;
  IF a[1] = 'y' THEN w := $FFFF;
END;

PROCEDURE Calibrate;
VAR x,y: WORD;

Function ExistJoy: Boolean;
	VAR Counter: Word;
	BEGIN
	Counter:=$FFFF;
	Port[$201]:=$FF;

	While (Counter<>0) AND (Port[$201] AND 1<>0) DO Dec(Counter);

	ExistJoy:=(Counter<>0);
  END;

Function BottonAPressed: Boolean;
	BEGIN
	BottonAPressed:=(Port[$201] AND 16)=0;
	END;

Function BottonBPressed: Boolean;
	BEGIN
	BottonBPressed:=(Port[$201] AND 32)=0;
	END;

BEGIN
  IF NOT ExistJoy THEN BEGIN
    writeln('No joystick connected! Press a key');
    REPEAT UNTIL KeyPressed;
  END ELSE BEGIN
    writeln('Move joystick to upper left and push button 0!');
    REPEAT	UNTIL BottonAPressed;
    writeln('Getting coordinates');
    GetJoy;
    REPEAT	UNTIL NOT BottonAPressed;
    prefs[pcnt-3].value := jx; prefs[pcnt-2].value := jy;
    writeln('JX: ',jx,' JY: ',jy);

    writeln('Move joystick to lower right and push button 1!');
    REPEAT 	UNTIL BottonBPressed;
    writeln('Getting coordinates');
    GetJoy;
    writeln('JX: ',jx,' JY: ',jy);
    prefs[pcnt-1].value := jx; prefs[pcnt].value := jy;
    x := prefs[pcnt-1].value-prefs[pcnt-3].value; x := x DIV 10;
    prefs[pcnt-3].value := prefs[pcnt-3].value+x;
    prefs[pcnt-1].value := prefs[pcnt-1].value-x;
    y := prefs[pcnt].value-prefs[pcnt-2].value; y := y DIV 10;
    prefs[pcnt-2].value := prefs[pcnt-2].value+y;
    prefs[pcnt].value := prefs[pcnt].value-y;
  END;
END;

PROCEDURE WriteTab(s: STRING);
VAR i: INTEGER;
BEGIN
  Write(s); FOR i := Length(s) TO 40 DO Write(' ');
END;

BEGIN
  ClrScr;
  {$I-}
  Assign(f,'PREFS.CPE'); Reset(f);
  fault := TRUE;
  IF IOResult = 0 THEN BEGIN
    fault := FALSE;
    FOR j := 0 TO pcnt DO BEGIN
      Read(f,prefs[j].value);
      IF IOResult <> 0 THEN BEGIN
        WriteLN('Couldn''t read prefs file, old version? Using defaults.');
        fault := TRUE; j := pcnt;
      END;
    END;
    Close(f);
  END;
  IF fault THEN FOR j := 0 TO pcnt DO prefs[j].value := prefs[j].defval;
  Rewrite(f);
  REPEAT
    ClrScr;
    writeln(' CPE Setup'); writeln;
    writeln('Do you want to '); writeln;
    writeln('1. Edit general setup');
    writeln('2. Edit setup for CPE.EXE');
    writeln('3. Edit setup for CPE2.EXE');
    writeln('0. Exit and save');

    writeln; write('Your choice: '); readln(c);
    CASE c OF
    '1': setupmode := general;
    '2': setupmode := cpe;
    '3': setupmode := cpe2;
    END;
    IF c IN ['1','2','3'] THEN BEGIN
      REPEAT
        ClrScr;
        writeln(' CPE Setup'); writeln;
        menuchar := '1';

        FOR i := 0 TO pcnt-3 DO BEGIN
          IF prefs[i].ptype = setupmode THEN BEGIN
            Write(menuchar,'. ');
            WriteTab(prefs[i].text+':');
            CASE prefs[i].mode OF
              prefhex:   WriteLn(Hex(prefs[i].value));
              prefyesno: WriteLn(YesNo(prefs[i].value));
              prefsound: WriteLn(SoundCard(prefs[i].value));
              prefprt:   WriteLn('LPT',Chr(Ord('0')+prefs[i].value));
              prefcpc:   WriteLn(CPC(prefs[i].value));
              prefkblang:WriteLn(KBLang(prefs[i].value));
              prefjoy:   WriteLn;
            END;
            IF menuchar = '9'
              THEN menuchar := 'A'
              ELSE menuchar := Chr(Ord(menuchar)+1);
          END;
        END;
        WriteLn; writeln('Type 0 to return to main menu!'); writeln;
        write('Which option do you want to change: '); readln(c);
        c := UpCase(c);
        menuchar := '1';
        FOR i := 0 TO pcnt-3 DO BEGIN
          IF (prefs[i].ptype = setupmode) THEN BEGIN
            IF c = menuchar THEN BEGIN
              CASE prefs[i].mode OF
                prefhex,
                prefprt  :   GetHex(prefs[i].value);
                prefyesno: GetYesNo(prefs[i].value);
                prefsound: GetSound(prefs[i].value);
                prefcpc:   GetCPC(prefs[i].value);
                prefkblang:GetKBLang(prefs[i].value);
                prefjoy:   Calibrate;
              END;
            END;
            IF menuchar = '9'
              THEN menuchar := 'A'
              ELSE menuchar := Chr(Ord(menuchar)+1);
          END;
        END;
      UNTIL c = '0';
      c := '.';
    END;
  UNTIL c = '0';
  FOR j:= 0 TO pcnt DO write(f,prefs[j].value);
  Close(f);
END.