 ; miscellaneaous routines

	IDEAL
	INCLUDE "cpe2\macros.inc"

; *** externals for menu
EXTRN FixPrefs:PROC
EXTRN RestoreScreen:PROC,PutChar:PROC,OpenTextScr:PROC
EXTRN MenuVars:WORD,MenuItems:WORD,MenuScr:BYTE
EXTRN SB_Pause:PROC,SB_continue:PROC

; *** externals for LoadROMs, PatchLROM
EXTRN cleanup:PROC,haver5:WORD,haver6:WORD,haver7:WORD
EXTRN quietcas:WORD,cpctype:WORD,CPCKTb:WORD
EXTRN amsdos:BYTE,basic:BYTE,rom7:BYTE,rom5:BYTE,rom6:BYTE
EXTRN CAScont:WORD,CASInH:WORD

; *** externals for keyboard
EXTRN germkey:WORD,intflag:WORD

; *** exports
PUBLIC LoadROMs,Menu,ClearKeyMap,Video,MyKeyInt,SetLEDs

PUBLIC KeyMatrix,keycode,EngNormTab,FrnNormTab,GerNormTab
PUBLIC ColorTab,ColorTabA

P386

GROUP   DGROUP _stack,_data

SEGMENT _text PAGE PUBLIC 'CODE'
ASSUME CS:_text
ASSUME DS:DGROUP

LoadROMs:
	MOV     DX,OFFSET mvr464        ; load lower ROM
	CMP     [cpctype],1
	JE      LMVR_Ok
	MOV     DX,OFFSET mvr664
	CMP     [cpctype],2
	JE      LMVR_Ok
	MOV     DX,OFFSET mvr6128
LMVR_Ok:
	MOV     AX,3d00h
	INT     21h
	JC      cleanup
	MOV     BX,AX
	MOV     AH,3Fh
	MOV     DX,SEG amsdos
	MOV     DS,DX
	MOV     DX,OFFSET amsdos
	MOV     CX,4000h
	INT     21h
	MOV     DX,DGROUP
	MOV     DS,DX
	JC      cleanup
	MOV     AH,3Fh
	MOV     DX,SEG basic
	MOV     DS,DX
	MOV     DX,OFFSET basic
	MOV     CX,4000h
	INT     21h
	MOV     DX,DGROUP
	MOV     DS,DX
	JC      cleanup
	MOV     AH,3Eh
	INT     21h

        MOV     [haver5],0
        MOV     [haver6],0
        MOV     [haver7],0

	MOV     DX,OFFSET mvr7        ; load floppy ROM
	MOV     AX,3d00h
	INT     21h
	JC      nor7
	MOV     BX,AX
	MOV     AH,3Fh
	MOV     DX,SEG rom7
	MOV     DS,DX
	MOV     DX,OFFSET rom7
	MOV     CX,4000h
	INT     21h
	MOV     DX,DGROUP
	MOV     DS,DX
	JC      cleanup
	MOV     AH,3Eh
	INT     21h
        MOV     [haver7],1
nor7:

	MOV     DX,OFFSET r5name
	MOV     AX,3d00h
	INT     21h
	JC      nor5
	MOV     BX,AX
	MOV     AH,3Fh
	MOV     DX,SEG rom5
	MOV     DS,DX
	MOV     DX,OFFSET rom5
	MOV     CX,4000h
	INT     21h
	MOV     DX,DGROUP
	MOV     DS,DX
	JC      nor5
	MOV     AH,3Eh
	INT     21h
        MOV     [haver5],1
nor5:

	MOV     DX,OFFSET r6name
	MOV     AX,3d00h
	INT     21h
	JC      nor6
	MOV     BX,AX
	MOV     AH,3Fh
	MOV     DX,SEG rom6
	MOV     DS,DX
	MOV     DX,OFFSET rom6
	MOV     CX,4000h
	INT     21h
	MOV     DX,DGROUP
	MOV     DS,DX
	JC      nor6
	MOV     AH,3Eh
	INT     21h
        MOV     [haver6],1
nor6:

	Call    PatchLROM
        RET

PatchLROM:
	PUSH    ES
	PUSH    DX
	MOV     DX,SEG amsdos
	MOV     ES,DX
	CMP     [WORD PTR ES:682h],'1v'
	JE      PLRO_464
	CMP     [WORD PTR ES:683h],'2v'
	JE      PLRO_664
	CMP     [WORD PTR ES:69Eh],'3v'
	JE      PLRO_6128
PLRO_end:
	POP     DX
	POP     ES
	RET
PLRO_464:
        MOV     [CPCKtb],1d69h
	MOV     [WORD PTR ES:2836h],0feedh
 ;       MOV     [WORD PTR ES:283fh],0fdedh
 ;       MOV     [WORD PTR ES:2851h],0fcedh
	MOV     [WORD PTR ES:2399h],0fbedh
	MOV     [WORD PTR ES:2a51h+17h],01h
	MOV     [CAScont],02a72h
	MOV     [CASInH],0b807h
        CMP     [quietcas],0
        JE      PLRO_end
        MOV     [BYTE PTR ES:2765h],0C9h
        MOV     [WORD PTR ES:2560h],0530h
        MOV     [WORD PTR ES:2562h],0
	POP     DX
	POP     ES
	RET
PLRO_664:
        MOV     [CPCKtb],1eefh
	MOV     [WORD PTR ES:29A6h],0feedh
 ;       MOV     [WORD PTR ES:29AFh],0fdedh
 ;       MOV     [WORD PTR ES:29C1h],0fcedh
	MOV     [WORD PTR ES:2bc1h+17h],01h
	MOV     [WORD PTR ES:24ech],0fbedh
	MOV     [CAScont],02be2h
	MOV     [CASInH],0b11fh
        CMP     [quietcas],0
        JE      PLRO_end
        MOV     [BYTE PTR ES:28D7h],0C9h
        MOV     [WORD PTR ES:26d4h],0328h
	POP     DX
	POP     ES
	RET
PLRO_6128:
        MOV     [CPCKtb],1eefh
	MOV     [WORD PTR ES:29A6h],0feedh
 ;       MOV     [WORD PTR ES:29AFh],0fdedh
 ;       MOV     [WORD PTR ES:29C1h],0fcedh
	MOV     [WORD PTR ES:2bc1h+17h],01h
	MOV     [WORD PTR ES:24ech],0fbedh
	MOV     [DWORD PTR ES:24eeh],0E126ACCDh ; make it like 664
	MOV     [CAScont],02be2h
	MOV     [CASInH],0b11fh
        CMP     [quietcas],0
        JE      PLRO_end
        MOV     [BYTE PTR ES:28D7h],0C9h
        MOV     [WORD PTR ES:26d4h],0328h
	POP     DX
	POP     ES
	RET

Menu:
	PUSHAD
        CALL    SB_Pause

	MOV     [keycode],0
        CALL    OpenTextScr

	XOR     AX,AX
        XOR     EDX,EDX
	MOV     CX,2000
MENU_Display:
	MOV     AL,[EDX+OFFSET MenuScr]
	MOV     AH,0fh
        CALL    PutChar
	INC     DX
	LOOP    MENU_Display
	MOV     BX,0
MENU_Loop:
	MOV     CX,[MenuItems]
	MOV     BP,OFFSET MenuVars
	MOV     DX,160
MENU_Update:
	MOV     AX,0f58h
	CMP     [WORD PTR BP],0
	JNE     MENU_UdWrite
	MOV     AX,020h
MENU_UdWrite:
        CALL    PutChar
	ADD     BP,2
	ADD     DX,80
	LOOP    MENU_UpDate

	MOV     AX,BX
	ADD     AX,2
	MOV     CX,80
	MUL     CX
        INC     AX
        MOV     DX,AX
        MOV     AX,0F10h
        PUSH    DX
        CALL    PutChar
        POP     DX
MENU_WaitKey:
	CMP     [keycode],0
	JE      MENU_WaitKey

	CMP     [keycode],28
	JE      MENU_End
        CMP     [keycode],1
        JE      MENU_End
        MOV     AX,020h
        CALL    PutChar
	CMP     [keycode],48h
	JNE     MENU_nup
	DEC     BX
	JNS     MENU_LoopEnd
	XOR     BX,BX
	JMP     MENU_LoopEnd
MENU_nup:
	CMP     [keycode],50h
	JNE     MENU_ndn
	INC     BX
	CMP     BX,[MenuItems]
	JC      MENU_LoopEnd
	DEC     BX
	JMP     MENU_LoopEnd
MENU_ndn:
	CMP     [keycode],39h
	JNE     MENU_nspc
	MOV     BP,OFFSET MenuVars
	ADD     BP,BX
	ADD     BP,BX
	XOR     [WORD PTR BP],0ffffh
MENU_nspc:
MENU_LoopEnd:
	MOV     [keycode],0
        PUSH    BX
        CALL    FixPrefs
        POP     BX
	JMP     MENU_Loop
MENU_End:

        CALL    RestoreScreen
	CALL    ClearKeyMap
	MOV     [keycode],0
        CALL    SB_continue
	POPAD
	RET

MyKeyInt:
	PUSH    AX
        PUSH    BX
	PUSH    DS
	PUSH    DI

	CLI
	MOV     AX,DGROUP
	MOV     DS,AX
	IN      AL,60h
	PUSH    AX
	CALL    MKI_Crux
	POP     AX

	XOR     DI,DI
	PUSH    DS
	PUSH    40h
	POP     DS
	TEST    [BYTE PTR DS:97h],2
	JNZ     SHORT MKI_NumLockIsOn
	MOV     DI,128
MKI_NumLockIsOn:
	POP     DS

	CMP     [altcode],1
	JE      SHORT MKI_ThisIsAlt

	CMP     AL,45h          ; Num Lock?
	JNE     SHORT MKI_NotNumLock
	PUSH    DS
	PUSH    40h
	POP     DS
	XOR     [BYTE PTR DS:17h],32
	MOV     AL,[BYTE PTR DS:17h]
	SHR     AL,4
	AND     AL,7
	AND     [BYTE PTR DS:97h],0f8h
	OR      [BYTE PTR DS:97h],AL
	POP     DS
	CALL    SetLEDs
	CLI
	JMP     MKI_End
MKI_NotNumLock:
	CMP     AL,3ah          ; Caps Lock?
	JNE     SHORT MKI_NotCapsLock
	PUSH    AX
	PUSH    DS
	PUSH    40h
	POP     DS
	XOR     [BYTE PTR DS:17h],64
	MOV     AL,[BYTE PTR DS:17h]
	SHR     AL,4
	AND     AL,7
	AND     [BYTE PTR DS:97h],0f8h
	OR      [BYTE PTR DS:97h],AL
	POP     DS
	CALL    SetLEDs
	CLI
	POP     AX
MKI_NotCapsLock:

	CMP     AL,0E0h
	JNE     MKI_NormCodeTab
MKI_AltCodeTab:
	MOV     [altcode],1
	JMP     SHORT MKI_End
MKI_ThisIsAlt:
	MOV     [altcode],0
	ADD     DI,OFFSET AltCodeTab
	JMP     SHORT MKI_PressedCont

MKI_NormCodeTab:
	ADD     DI,OFFSET KeyCodeTab

MKI_PressedCont:
        TEST    AL,80h
        JNZ     SHORT MKI_Released2

	MOV     [keycode],AL
	OR      [intflag],100h
	CMP     [spccode],0
	JNE     MKI_Released2
	MOV     [spccode],AL

MKI_Released2:
        MOV     BL,AL
	AND     AX,7Fh
	ADD     DI,AX
	MOV     AL,[DI]
	CMP     AL,0F0h
	JE      SHORT MKI_End
        MOVZX   DI,AL
	SHR     DI,4
	AND     AX,0fh
        TEST    BL,80h
        JNZ     SHORT MKI_Release
	BTR     [DI+OFFSET KeyMatrix],AX
	JMP     SHORT MKI_End

MKI_Release:
	BTS     [DI+OFFSET KeyMatrix],AX

MKI_End:
	POP     DI
	POP     DS
        POP     BX
	POP     AX
	STI
	IRET

MKI_Crux:
	IN      AL,61h
	MOV     AH,AL
	OUT     61h,AL
	MOV     AL,AH
	OUT     61h,AL

	MOV     AL,20h
	OUT     20h,AL
	RET

SetLEDs:
	PUSH    DS
	PUSH    CX
	PUSH    AX
	CLI
	MOV     CX,200
MKI_Wait64a:
	IN      AL,64h
	AND     AL,2
	LOOPNZ  MKI_Wait64a
	OR      CX,CX
	JE      MKI_SetLED_End
	MOV     AL,0EDh
	OUT     60h,AL
	XOR     CX,CX
MKI_Wait64b:
	IN      AL,64h
	AND     AL,1
	LOOPZ   MKI_Wait64b
	OR      CX,CX
	JE      MKI_SetLED_End
	IN      AL,60h
	CMP     AL,0fah
	JNE     MKI_SetLED_End

	MOV     CX,200
MKI_Wait64c:
	IN      AL,64h
	AND     AL,2
	LOOPNZ  MKI_Wait64c
	OR      CX,CX
	JE      MKI_SetLED_End
	PUSH    DS
	PUSH    40h
	POP     DS
	MOV     AL,[DS:97h]
	POP     DS
	AND     AL,7
	OUT     60h,AL
	XOR     CX,CX
MKI_Wait64d:
	IN      AL,64h
	AND     AL,1
	LOOPZ   MKI_Wait64d
	OR      CX,CX
	JE      MKI_SetLED_End
	IN      AL,60h

MKI_SetLED_End:
	STI
	POP     AX
	POP     CX
	POP     DS
	STI
	RET

ClearKeyMap:
	MOV     [DWORD PTR KeyMatrix],0ffffffffh
	MOV     [DWORD PTR KeyMatrix+4],0ffffffffh
	MOV     [DWORD PTR KeyMatrix+8],0ffffffffh
	MOV     [DWORD PTR KeyMatrix+12],0ffffffffh
	RET

Video:  PUSH    SI
	PUSH    DI
	PUSH    BP
	PUSH    ES

	CLI
	INT     10H
	STI

	POP     ES
	POP     BP
	POP     DI
	POP     SI
	RET

ENDS

SEGMENT _data PAGE PUBLIC 'DATA'

mvr464  db 'ROM\CPC464.ROM',0
mvr664  db 'ROM\CPC664.ROM',0
mvr6128 db 'ROM\CPC6128.ROM',0
mvr7    db 'ROM\CPCADOS.ROM',0
r5name  db 'ROM\ROM5.ROM',0
r6name  db 'ROM\ROM6.ROM',0

ColorTabA   dd    00002400h,00002400h,00003000h,00003C00h
	    dd    00000C00h,00001800h,00001E00h,00002A00h ;4
	    dd    00001800h,00003C00h,00003A00h,00003E00h
	    dd    00001600h,00001A00h,00002800h,00002C00h ; 12
	    dd    00000C00h,00003000h,00002E00h,00003200h
	    dd    00000A00h,00000E00h,00001C00h,00002000h ; 20
	    dd    00001200h,00003600h,00003400h,00003800h
	    dd    00001000h,00001400h,00002200h,00002600h

ColorTab    dd    001f1f1fh,001f1f1fh,00003f1fh,003f3f1fh
	    dd    0000001fh,003f001fh,00001f1fh,003f1f1fh ;4
	    dd    003f001fh,003f3f1fh,003f3f00h,003f3f3fh
	    dd    003f0000h,003f003fh,003f1f00h,003f1f3fh ;12
	    dd    0000001fh,00003f1fh,00003f00h,00003f3fh
	    dd    00000000h,0000003fh,00001f00h,00001f3fh ;20
	    dd    001f001fh,001f3f1fh,001f3f00h,001f3f3fh
	    dd    001f0000h,001f003fh,001f1f00h,001f1f3fh

LABEL KeyMatrix BYTE
	db    0FFH,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	db    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh

	EVEN

LABEL KeyCodeTab BYTE    ; F0 = not on cpc keyboard
 ;                  ESC  1    2    3    4    5    6    7    8    9    0            DEL  TAB
	db    0f0h,082h,080h,081h,071h,070h,061h,060h,051h,050h,041h,040h,031h,030h,097h,084h
 ;             Q    W    E    R    T    Y    U    I    O    P        +    CR  CTRL  A    S
	db    083h,073h,072h,062h,063h,053h,052h,043h,042h,033h,032h,021h,022h,027h,085h,074h
 ;             D    F    G    H    J    K    L            ^  LSH   #'   Z    X    C    V
	db    075h,065h,064h,054h,055h,045h,044h,035h,034h,082h,025h,023h,087h,077h,076h,067h
 ;             B    N    M    ,    .    -   RSH  PRTS ALT  SPC  CAP   F1   F2   F3   F4   F5
	db    066h,056h,046h,047h,037h,036h,025h,0f0h,011h,057h,086h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;             F6   F7   F8   F9   F10  NUM  ROL  N7   N8   N9   N-   N4   N5   N6   N+   N1
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,090h,012h,013h,003h,031h,024h,014h,004h,034h,015h
 ;             N2   N3   N0   N,                 F11  F12
	db    016h,005h,017h,007h,0f0h,0f0h,026h,0F0h,0F0h,026h,026h,026h,026h,026h,026h,026h
	db    0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0f0h,0F0h,0F0h,0F0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h
 ; SECOND ALTERNATIVE: NumLock OFF
 ;                  ESC  1    2    3    4    5    6    7    8    9    0            DEL  TAB
	db    0f0h,082h,080h,081h,071h,070h,061h,060h,051h,050h,041h,040h,031h,030h,097h,084h
 ;             Q    W    E    R    T    Z    U    I    O    P        +    CR  CTRL  A    S
	db    083h,073h,072h,062h,063h,053h,052h,043h,042h,033h,032h,021h,022h,027h,085h,074h
 ;             D    F    G    H    J    K    L            ^  LSH   #'   Y    X    C    V
	db    075h,065h,064h,054h,055h,045h,044h,035h,034h,082h,025h,023h,087h,077h,076h,067h
 ;             B    N    M    ,    .    -   RSH  PRTS ALT  SPC  CAP   F1   F2   F3   F4   F5
	db    066h,056h,046h,047h,037h,036h,025h,0f0h,011h,057h,086h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;             F6   F7   F8   F9   F10  NUM  ROL  N7   N8   N9   N-   N4   N5   N6   N+   N1
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,060h,012h,090h,003h,031h,092h,094h,093h,034h,015h
 ;             N2   N3   N0   N,                 F11  F12
	db    091h,005h,017h,007h,0f0h,0f0h,026h,0F0h,0F0h,026h,026h,026h,026h,026h,026h,026h
	db    0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0f0h,0F0h,0F0h,0F0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h

LABEL AltCodeTab BYTE    ; F0 = not on cpc keyboard
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                                                       ENTER CTRL
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,006h,027h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                               HOME CUUP PGUP      CULF      CURT      ENDE
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,094h,000h,093h,0f0h,010h,0f0h,001h,0f0h,091h
 ;            CUDN PGDN INST DELE
	db    002h,0f0h,092h,020h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ; ALTERNATIVE: NumLock OFF
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                                                       ENTER
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,006h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                               HOME CUUP PGUP      CULF      CURT      ENDE
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,064h,000h,063h,0f0h,010h,0f0h,001h,0f0h,061h
 ;            CUDN PGDN INST DELE
	db    002h,0f0h,062h,020h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
	db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h


	; CPC ROM Keyboard translation key
	; equate original CPC ROM

Label   EngNormTab byte

	DB   0F0h, 0F3h, 0F1h, 089h, 086h, 083h, 08Bh, 08Ah
	DB   0F2h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h,  '[', 00Dh,  ']', 084h, 0FFh,  '\', 0FFh
	DB    '^',  '-',  '@',  'p',  ';',  ':',  '/',  '.'
	DB    '0',  '9',  'o',  'i',  'l',  'k',  'm',  ','
	DB    '8',  '7',  'u',  'y',  'h',  'j',  'n',  ' '
	DB    '6',  '5',  'r',  't',  'g',  'f',  'b',  'v'
	DB    '4',  '3',  'e',  'w',  's',  'd',  'c',  'x'
	DB    '1',  '2', 0FCh,  'q', 009h,  'a', 0FDh,  'z'
	DB   00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   EngShiftTab byte

	DB   0F4h, 0F7h, 0F5h, 089h, 086h, 083h, 08Bh, 08Ah
	DB   0F6h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h,  '{', 00Dh,  '}', 084h, 0FFh,  '`', 0FFh
	DB   0A3h,  '=',  '|',  'P',  '+',  '*',  '?',  '>'
        DB    '_',  ')',  'O',  'I',  'L',  'K',  'M',  '<'
	DB    '(',  "'",  'U',  'Y',  'H',  'J',  'N',  ' '
	DB    '&',  '%',  'R',  'T',  'G',  'F',  'B',  'V'
	DB    '$',  '#',  'E',  'W',  'S',  'D',  'C',  'X'
	DB    '!',  '"', 0FCh,  'Q', 009h,  'A', 0FDh,  'Z'
	DB   00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   EngCtrlTab byte

	DB   0F8h, 0FBh, 0F9h, 089h, 086h, 083h, 08Ch, 08Ah
	DB   0FAh, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h, 01Bh, 00Dh, 01Dh, 084h, 0FFh, 01Ch, 0FFh
	DB   01Eh, 0FFh, 000h, 010h, 0FFh, 0FFh, 0FFh, 0FFh
	DB   01Fh, 0FFh, 00Fh, 009h, 00Ch, 00Bh, 00Dh, 0FFh
	DB   0FFh, 0FFh, 015h, 019h, 008h, 00Ah, 00Eh, 0FFh
	DB   0FFh, 0FFh, 012h, 014h, 007h, 006h, 002h, 016h
	DB   0FFh, 0FFh, 005h, 017h, 013h, 004h, 003h, 018h
	DB   0FFh,  '~', 0FCh, 011h, 0E1h, 001h, 0FEh, 01Ah
	DB   0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 07Fh

Label   EngOtherTab byte

	DB   007h, 003h,  'K', 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	DB   0ABh, 08Fh
SzEngTab        = $ - EngNormTab

	; CPC ROM Keyboard translation key

Label   GerNormTab byte

	DB   0F0h, 0F3h, 0F1h, 089h, 086h, 083h, 08Bh, 08Ah
	DB   0F2h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h,  '[', 00Dh,  ']', 084h, 0FFh,  '\', 0FFh
	DB    '^',  '-',  '@',  'p',  ';',  ':',  '/',  '.'
	DB    '0',  '9',  'o',  'i',  'l',  'k',  'm',  ','
	DB    '8',  '7',  'u',  'z',  'h',  'j',  'n',  ' '
	DB    '6',  '5',  'r',  't',  'g',  'f',  'b',  'v'
	DB    '4',  '3',  'e',  'w',  's',  'd',  'c',  'x'
	DB    '1',  '2', 0FCh,  'q', 009h,  'a', 0FDh,  'y'
	DB   00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   GerShiftTab byte

	DB   0F4h, 0F7h, 0F5h, 089h, 086h, 083h, 08Bh, 08Ah
	DB   0F6h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h,  '{', 00Dh,  '}', 084h, 0FFh,  '`', 0FFh
	DB   0A3h,  '=',  '|',  'P',  '+',  '*',  '?',  '>'
	DB    '_',  ')',  'O',  'I',  'L',  'K',  'M',  '<'
	DB    '(',  "'",  'U',  'Z',  'H',  'J',  'N',  ' '
	DB    '&',  '%',  'R',  'T',  'G',  'F',  'B',  'V'
	DB    '$',  '#',  'E',  'W',  'S',  'D',  'C',  'X'
	DB    '!',  '"', 0FCh,  'Q', 009h,  'A', 0FDh,  'Y'
	DB   00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   GerCtrlTab byte

	DB   0F8h, 0FBh, 0F9h, 089h, 086h, 083h, 08Ch, 08Ah
	DB   0FAh, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h, 01Bh, 00Dh, 01Dh, 084h, 0FFh, 01Ch, 0FFh
	DB   01Eh, 0FFh, 000h, 010h, 0FFh, 0FFh, 0FFh, 0FFh
	DB   01Fh, 0FFh, 00Fh, 009h, 00Ch, 00Bh, 00Dh, 0FFh
	DB   0FFh, 0FFh, 015h, 019h, 008h, 00Ah, 00Eh, 0FFh
	DB   0FFh, 0FFh, 012h, 014h, 007h, 006h, 002h, 016h
	DB   0FFh, 0FFh, 005h, 017h, 013h, 004h, 003h, 018h
	DB   0FFh,  '~', 0FCh, 011h, 0E1h, 001h, 0FEh, 01Ah
	DB   0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 07Fh

Label   GerOtherTab byte

	DB   007h, 003h,  'K', 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	DB   0ABh, 08Fh
SzGerTab        = $ - GerNormTab

	; CPC ROM Keyboard translation key

Label   FrnNormTab byte

	DB   0F0h, 0F3h, 0F1h, 089h, 086h, 083h, 08Bh, 08Ah
	DB   0F2h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
;       DB   010h,  '[', 00Dh,  '}', 084h, 0FFh,  '\', 0FFh
	DB   010h,  '$', 00Dh,  '*', 084h, 0FFh,  '<', 0FFh
;       DB    '#',  ')',  '%',  'p',  ';',  ':',  '/',  '.'
	DB    '=',  ')',  '[',  'p',  '{',  'm',  '!',  ':'
;       DB    '@',  '^',  'o',  'i',  'l',  'k',  'm',  ','
	DB    '@',  '^',  'o',  'i',  'l',  'k',  ',',  ';'
;       DB    '_',  "&",  'u',  'y',  'h',  'j',  'n',  ' '
	DB    '_',  '`',  'u',  'y',  'h',  'j',  'n',  ' '
	DB    '-',  '(',  'r',  't',  'g',  'f',  'b',  'v'
	DB    "'",  '"',  'e',  'z',  's',  'd',  'c',  'x'
;       DB    '&',  '$', 0FCh,  'a', 009h,  'q', 0FDh,  'w'
	DB    '&',  '\', 0FCh,  'a', 009h,  'q', 0FDh,  'w'
	DB   00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   FrnShiftTab byte

	DB   0F4h, 0F7h, 0F5h, 089h, 086h, 083h, 08Bh, 08Ah
	DB   0F6h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
;       DB   010h,  '{', 00Dh,  ']', 084h, 0FFh,  '`', 0FFh
	DB   010h, 0A3H, 00Dh,  '}', 084h, 0FFh,  '>', 0FFh
;       DB   0A3h,  '=',  '|',  'P',  '+',  '*',  '?',  '>'
	DB    '+',  '#',  ']',  'P',  '%',  'M', 0FFH,  '/'
;       DB    '0',  '9',  'O',  'I',  'L',  'K',  'M',  '<'
	DB    '0',  '9',  'O',  'I',  'L',  'K',  '?',  '.'
	DB    '8',  '7',  'U',  'Y',  'H',  'J',  'N',  ' '
	DB    '6',  '5',  'R',  'T',  'G',  'F',  'B',  'V'
	DB    '4',  '3',  'E',  'Z',  'S',  'D',  'C',  'X'
	DB    '1',  '2', 0FCh,  'A', 009h,  'Q', 0FDh,  'W'
	DB   00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   FrnCtrlTab byte

	DB   0F8h, 0FBh, 0F9h, 089h, 086h, 083h, 08Ch, 08Ah
	DB   0FAh, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
	DB   010h, 01Bh, 00Dh, 01Dh, 084h, 0FFh, 01Ch, 0FFh
	DB   01Eh, 0FFh, 000h, 010h, 0FFh, 0FFh, 0FFh, 0FFh
	DB   01Fh, 0FFh, 00Fh, 009h, 00Ch, 00Bh, 00Dh, 0FFh
	DB   0FFh, 0FFh, 015h, 019h, 008h, 00Ah, 00Eh, 0FFh
	DB   0FFh, 0FFh, 012h, 014h, 007h, 006h, 002h, 016h
	DB   0FFh, 0FFh, 005h, 017h, 013h, 004h, 003h, 018h
	DB   0FFh,  '~', 0FCh, 011h, 0E1h, 001h, 0FEh, 01Ah
	DB   0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 07Fh

Label   FrnOtherTab byte

	DB   007h, 003h,  'K', 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	DB   0ABh, 08Fh
SzFrnTab        = $ - FrnNormTab

 ; ************************************************ keyboard
keycode     db    0,0
altcode     dw    0
spccode     db    0,0

ENDS

SEGMENT _stack PARA STACK 'STACK'

ENDS

END
