/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.floppy;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.core.device.floppy.Drive;
import JCPC.ui.Display;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class UPD765A
extends Device {
    protected int counter;
    protected boolean readtrack = false;
    private static final int[] a = new int[]{128, 256, 512, 1024, 2048, 4096, 6144};
    public int[] formatid = new int[]{0, 0, 0, 0};
    protected int actualDrive = 0;
    protected static final int READ_TIME_FM = 192;
    protected static final int READ_TIME_MFM = 128;
    protected static final int POLL_TIME = 8192;
    protected static final int POLL = 0;
    protected static final int SEEK = 1;
    protected static final int READ_ID = 2;
    protected static final int MATCH_SECTOR = 3;
    protected static final int READ = 4;
    protected static final int WRITE = 5;
    protected static final int FORMAT = 6;
    protected static final int[] CMD_PARAMS = new int[]{0, 0, 8, 2, 1, 8, 8, 1, 0, 8, 1, 0, 8, 5, 0, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 8, 0, 0};
    protected static final int D0_BUSY = 1;
    protected static final int D1_BUSY = 2;
    protected static final int D2_BUSY = 4;
    protected static final int D3_BUSY = 8;
    protected static final int COMMAND_BUSY = 16;
    protected static final int EXEC_MODE = 32;
    protected static final int DATA_IN_OUT = 64;
    protected static final int REQ_MASTER = 128;
    protected static final int ST0_NORMAL = 0;
    protected static final int ST0_ABNORMAL = 64;
    protected static final int ST0_INVALID = 128;
    protected static final int ST0_READY_CHANGE = 192;
    protected static final int ST0_NOT_READY = 8;
    protected static final int ST0_HEAD_ADDR = 4;
    protected static final int ST0_EQUIP_CHECK = 16;
    protected static final int ST0_SEEK_END = 32;
    protected static final int ST1_MISSING_ADDR = 1;
    protected static final int ST1_NOT_WRITABLE = 2;
    protected static final int ST1_NO_DATA = 4;
    protected static final int ST1_OVERRUN = 16;
    protected static final int ST1_DATA_ERROR = 32;
    protected static final int ST1_END_CYL = 128;
    protected static final int ST2_MISSING_ADDR = 1;
    protected static final int ST2_BAD_CYLINDER = 2;
    protected static final int ST2_SCAN_NOT_SAT = 4;
    protected static final int ST2_SCAN_EQU_HIT = 8;
    protected static final int ST2_WRONG_CYL = 16;
    protected static final int ST2_DATA_ERROR = 32;
    protected static final int ST2_CONTROL_MARK = 64;
    protected static final int ST3_HEAD_ADDR = 4;
    protected static final int ST3_TWO_SIDE = 8;
    protected static final int ST3_TRACK_0 = 16;
    protected static final int ST3_READY = 32;
    protected static final int ST3_WRITE_PROT = 64;
    protected static final int ST3_FAULT = 128;
    protected int command;
    protected int action;
    protected int[] params = new int[8];
    protected int pcount = 0;
    protected int pindex = 0;
    protected int[] result = new int[7];
    protected int rindex = 0;
    protected int rcount = 0;
    protected Drive activeDrive;
    protected int c;
    protected int h;
    protected int r;
    protected int n;
    protected int offset;
    protected int size;
    protected byte[] buffer;
    protected int count;
    protected int next;
    protected int status;
    protected int st1;
    protected int st2;
    protected int st3;
    protected byte data;
    protected int sectorcount;
    protected int cycleRate;
    protected int countPoll;
    protected int countStep;
    protected int countFM;
    protected int countMFM;
    protected Drive[] drives = new Drive[4];
    protected int[] pcn = new int[4];
    protected int[] ncn = new int[4];
    protected int[] dir = new int[4];
    protected int[] max = new int[4];
    protected int[] st0 = new int[4];
    protected boolean[] ready = new boolean[4];
    protected Device interruptDevice;
    protected int interruptMask;
    private boolean a;
    public int saveTimer = 0;

    public static int getSectorSize(int n) {
        return a[Math.min(n, 6)];
    }

    public static int getCommandSize(int n) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != n) continue;
            return i;
        }
        return 2;
    }

    public UPD765A(int n) {
        super("NEC uPD765AC-2 Floppy Controller");
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.cycleRate = n;
                break;
            }
            default: {
                this.cycleRate = 4;
            }
        }
        this.countPoll = 8192 / this.cycleRate;
        this.countFM = 192 / this.cycleRate;
        this.countMFM = 128 / this.cycleRate;
        this.reset();
    }

    public void setInterruptDevice(Device device, int n) {
        this.interruptDevice = device;
        this.interruptMask = n;
    }

    public void setDrive(int n, Drive drive) {
        this.drives[n] = drive;
        this.a = true;
    }

    public Drive getDrive(int n) {
        return this.drives[n];
    }

    public final int readPort(int n) {
        if ((n & 1) == 0) {
            return this.status;
        }
        if ((this.status & 0xA0) == 128 && this.rcount > 0) {
            this.data = (byte)this.result[this.rindex++];
            if (--this.rcount == 0) {
                this.status &= 0xFFFFFFAF;
            }
        } else if (this.action == 4 && (this.status & 0x80) != 0) {
            this.status &= 0xFFFFFF7F;
        }
        return this.data;
    }

    public final void writePort(int n, int n2) {
        block26: {
            if (n == 64510 || n == 64494) {
                return;
            }
            if ((n & 1) != 0) {
                this.data = (byte)n2;
                if ((this.status & 0xC0) == 128) {
                    if ((this.status & 0x20) != 0) {
                        this.status &= 0xFFFFFF7F;
                        return;
                    }
                    if ((this.status & 0x10) == 0) {
                        this.command = n2;
                        this.status |= 0x10;
                        this.pindex = 0;
                        this.pcount = CMD_PARAMS[n2 &= 0x1F];
                        if (this.pcount == 0) {
                            this.status |= 0x40;
                            this.rindex = 0;
                            this.result[0] = 128;
                            this.rcount = 1;
                            if (n2 == 8) {
                                for (n = 0; n < 4; ++n) {
                                    if (this.st0[n] == 128) continue;
                                    this.result[0] = this.st0[n];
                                    this.st0[n] = 128;
                                    this.result[1] = this.pcn[n];
                                    this.status &= ~(1 << n);
                                    this.rcount = 2;
                                    break block26;
                                }
                                return;
                            }
                        }
                    } else {
                        this.params[this.pindex++] = n2;
                        if (--this.pcount == 0) {
                            if (this.command == 102) {
                                this.command = 102;
                            }
                            new StringBuilder().append("FDC Command ").append(Util.hex((byte)this.command)).append(": ").append(Util.hex((byte)this.params[1])).append("/").append(Util.hex((byte)this.params[2])).append("/").append(Util.hex((byte)this.params[3])).append("/").append(Util.hex((byte)this.params[4])).append(" ");
                            switch (this.command & 0x1F) {
                                case 2: {
                                    this.readTrack();
                                    return;
                                }
                                case 3: {
                                    this.specify();
                                    return;
                                }
                                case 4: {
                                    this.senseDrive();
                                    return;
                                }
                                case 5: {
                                    this.writeSector();
                                    return;
                                }
                                case 6: {
                                    this.readSector();
                                    return;
                                }
                                case 7: {
                                    this.seek(0, 77);
                                    return;
                                }
                                case 8: {
                                    return;
                                }
                                case 9: {
                                    return;
                                }
                                case 10: {
                                    this.readID();
                                    return;
                                }
                                case 12: {
                                    this.readSector();
                                    return;
                                }
                                case 13: {
                                    this.sectorcount = 0;
                                    this.formatTrack();
                                    return;
                                }
                                case 15: {
                                    this.seek(this.params[1], -1);
                                    return;
                                }
                                case 17: 
                                case 25: 
                                case 29: {
                                    return;
                                }
                            }
                            throw new RuntimeException("Invalid command: " + Util.hex((byte)this.command));
                        }
                    }
                }
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.pcount = 0;
        this.pindex = 0;
        this.status = 128;
        this.countStep = 128000 / this.cycleRate;
        this.action = 0;
        this.next = this.countPoll;
    }

    public final void resetb() {
        this.count = 0;
        this.pcount = 0;
        this.pindex = 0;
        this.status = 128;
        this.action = 0;
    }

    public final void initialise() {
        this.count = 0;
        this.pcount = 0;
        this.pindex = 0;
        this.action = 0;
    }

    public final void specify() {
        this.countStep = (16 - (this.params[0] >> 4)) * 8000 / this.cycleRate;
        this.status &= 0xFFFFFFAF;
    }

    public final void senseDrive() {
        int n = this.params[0] & 7;
        int n2 = n & 3;
        this.activeDrive = this.drives[n2];
        if (this.activeDrive != null) {
            if (this.ready[n2] && !this.a) {
                n |= 0x20;
            }
            if (this.activeDrive.getCylinder() == 0) {
                n |= 0x10;
            }
            if (this.activeDrive.getSides() == 2) {
                n |= 8;
            }
            if (this.activeDrive.isWriteProtected()) {
                n |= 0x40;
            }
        }
        this.a = false;
        this.rindex = 0;
        this.result[0] = n;
        this.rcount = 1;
        this.status |= 0x40;
    }

    public final void seek(int n, int n2) {
        this.actualDrive = this.params[0] & 3;
        this.max[this.actualDrive] = n2;
        this.ncn[this.actualDrive] = n;
        this.status &= 0xFFFFFFEF;
        if (this.pcn[this.actualDrive] == n) {
            this.seekEnd(this.actualDrive, 0);
            return;
        }
        this.status |= 1 << this.actualDrive;
        if (this.pcn[this.actualDrive] < n) {
            this.dir[this.actualDrive] = 1;
        } else if (this.pcn[this.actualDrive] > n) {
            this.dir[this.actualDrive] = -1;
        }
        if (this.action != 1) {
            this.action = 1;
            this.next = this.count + this.countStep;
        }
    }

    protected final void seekStep() {
        for (int i = 0; i < 4; ++i) {
            if (this.pcn[i] == this.ncn[i]) continue;
            int n = this.dir[i];
            int n2 = i;
            this.pcn[n2] = this.pcn[n2] + n;
            if (this.drives[i] != null && this.drives[i].step(n)) {
                this.pcn[i] = 0;
            }
            if (this.pcn[i] == this.ncn[i]) {
                this.seekEnd(i, 0);
                continue;
            }
            int n3 = i;
            this.max[n3] = this.max[n3] - 1;
            if (this.max[n3] == 0) {
                this.ncn[i] = this.pcn[i];
                this.seekEnd(i, 80);
                continue;
            }
            this.next = this.count + this.countStep;
            if (this.activeDrive == null) continue;
            this.activeDrive.setActive(false);
        }
    }

    protected final void seekEnd(int n, int n2) {
        this.st0[n] = n2 | 0x20 | n;
        this.dir[n] = 0;
        if ((this.dir[0] | this.dir[1] | this.dir[2] | this.dir[3]) == 0) {
            this.action = 0;
            this.next = this.count + this.countPoll;
            if (this.activeDrive != null) {
                this.activeDrive.setActive(true);
            }
        }
    }

    public final void poll() {
        this.actualDrive = this.params[0] & 3;
        for (int i = 0; i < 4; ++i) {
            boolean bl = this.drives[i] != null && this.drives[i].isReady();
            if (bl == this.ready[i]) continue;
            this.ready[i] = bl;
            this.st0[i] = 0xC0 | (bl ? 0 : 8) | i;
        }
    }

    protected final boolean setupResult() {
        int n = this.params[0] & 7;
        this.a = false;
        this.activeDrive = this.drives[n & 3];
        this.rindex = 0;
        this.result[0] = n | 0x40;
        this.result[1] = 5;
        this.rcount = 2;
        if (this.activeDrive != null && this.activeDrive.isReady()) {
            this.activeDrive.setHead(n >> 2);
            this.activeDrive.setActive(true);
            Display.ledOn = true;
            return true;
        }
        this.result[0] = this.result[0] | 8;
        this.status |= 0x40;
        return false;
    }

    protected final void readID() {
        if (this.setupResult()) {
            this.action = 2;
            this.status ^= 0xC0;
            this.next = this.count + 1200 / this.cycleRate;
        }
    }

    protected final void getNextID() {
        int[] nArray = this.activeDrive.getNextSectorID();
        if (nArray != null) {
            this.result[0] = this.result[0] & 0xFFFFFFBF;
            this.result[2] = 0;
            this.result[1] = 0;
            this.result[3] = nArray[0];
            this.result[4] = nArray[1];
            this.result[5] = nArray[2];
            this.result[6] = nArray[3];
            this.rcount = 7;
        } else {
            Display.ledOn = false;
            this.activeDrive.setActive(false);
        }
        this.status |= 0x80;
        this.action = 0;
        this.next = this.count + this.countPoll;
    }

    protected final void readSectorByte() {
        if (this.offset == this.buffer.length) {
            this.endBuffer(4);
            return;
        }
        this.data = this.buffer[this.offset++];
        this.next = this.count + this.countMFM;
        this.status |= 0x80;
    }

    protected final void readSector() {
        if (this.setupResult()) {
            this.getNextSector(4);
        }
    }

    protected final void readTrack() {
        if (this.setupResult()) {
            this.readtrack = true;
            this.activeDrive.resetSector();
            this.getNextSector(4);
        }
    }

    protected final void formatTrack() {
        if (this.setupResult()) {
            this.getNextFormatID();
        }
    }

    protected void addSector() {
    }

    protected final void getNextFormatID() {
        this.action = 6;
        this.offset = 0;
        this.status = this.status & 0xFFFFFFBF | 0x80 | 0x20;
        this.next = this.count + this.countPoll;
        this.data = (byte)-1;
    }

    protected final void endFormatID() {
        if (this.sectorcount == this.params[3]) {
            this.status &= 0xFFFFFFDF;
            this.status |= 0xC0;
            this.result[0] = this.result[0] & 0xFFFFFFBF;
            this.result[2] = 0;
            this.result[1] = 0;
            this.result[3] = this.params[1];
            this.result[4] = this.params[2];
            this.result[5] = 1;
            this.result[6] = this.params[4];
            this.rcount = 7;
            this.action = 0;
            this.next = this.count + this.countPoll;
            this.activeDrive.setActive(false);
            Display.ledOn = false;
            return;
        }
        this.sectorcount = this.sectorcount + 1 & 0xFF;
        this.getNextFormatID();
    }

    protected final void getNextSector(int n) {
        this.buffer = this.activeDrive.getSector(this.params[1], this.params[2], this.params[3], this.params[4]);
        if (this.readtrack) {
            this.buffer = null;
            this.readtrack = false;
        }
        if (this.buffer != null) {
            this.offset = 0;
            this.action = n;
            this.status = n == 4 ? this.status & 0xFFFFFF7F | 0x40 | 0x20 : this.status & 0xFFFFFFBF | 0x80 | 0x20;
            this.next = this.count + this.getGAP() + this.countPoll;
            this.data = (byte)-1;
            return;
        }
        this.status |= 0x40;
        this.action = 0;
        this.next = this.count + this.countPoll;
        this.activeDrive.setActive(false);
        Display.ledOn = false;
    }

    public int getSectorSize() {
        return this.buffer.length + 32;
    }

    public int getGAP() {
        int n = 146 + this.getSectorSize() * this.activeDrive.getSectorCount();
        n = (6250 - n) / this.activeDrive.getSectorCount();
        n = n + 62 << 5;
        return n;
    }

    protected final void endBuffer(int n) {
        int[] nArray = this.activeDrive.getReadID();
        if (this.params[3] == this.params[5]) {
            this.status &= 0xFFFFFFDF;
            this.status |= 0xC0;
            this.result[0] = this.result[0] & 0x40;
            this.result[1] = 128;
            this.result[2] = 0;
            this.result[3] = this.params[1] = nArray[0];
            this.result[4] = this.params[2] = nArray[1];
            this.result[5] = nArray[2];
            this.result[6] = this.params[4] = nArray[3];
            this.rcount = 7;
            this.action = 0;
            this.next = this.count + this.countPoll;
            this.activeDrive.setActive(false);
            return;
        }
        this.params[3] = this.params[3] + 1 & 0xFF;
        this.getNextSector(n);
    }

    protected final void writeSector() {
        if (this.setupResult()) {
            this.getNextSector(5);
        }
    }

    protected final void writeDeletedData() {
        if (this.setupResult()) {
            this.getNextSector(5);
        }
    }

    protected final void writeSectorByte() {
        this.buffer[this.offset++] = this.data;
        this.data = (byte)-1;
        if (this.offset == this.buffer.length) {
            this.endBuffer(5);
            UPD765A uPD765A = this;
        } else {
            this.next = this.count + this.countMFM;
            this.status |= 0x80;
        }
        this.saveTimer = 1;
    }

    protected final void writeFormatByte() {
        this.formatid[this.offset++] = this.data;
        this.data = (byte)-1;
        if (this.offset == 4) {
            this.endFormatID();
            UPD765A uPD765A = this;
            return;
        }
        this.next = this.count + this.countMFM;
        this.status |= 0x80;
    }

    public final void saveCheck() {
    }

    public final void cycle() {
        if (this.saveTimer != 0) {
            ++this.saveTimer;
            if (this.saveTimer > 1000000) {
                this.activeDrive.saveImage();
                this.saveTimer = 0;
            }
        }
        if (++this.count == this.next) {
            switch (this.action) {
                case 1: {
                    this.seekStep();
                    return;
                }
                case 0: {
                    this.poll();
                    return;
                }
                case 2: {
                    this.getNextID();
                    return;
                }
                case 4: {
                    this.readSectorByte();
                    return;
                }
                case 5: {
                    this.writeSectorByte();
                    return;
                }
                case 6: {
                    this.writeFormatByte();
                }
            }
        }
    }

    public void setForcedHead(int n, int n2) {
        if (this.drives[n2] != null) {
            this.drives[n2].setForcedHead(n);
            this.a = true;
        }
    }

    public int getForcedHead(int n) {
        if (this.drives[n] != null) {
            return this.drives[n].getForcedHead();
        }
        return 0;
    }
}

