/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.io;

import JCPC.core.device.Device;
import JCPC.core.device.IOPort;

public class PPI8255
extends Device {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_C = 2;
    public static final int PORT_CONTROL = 3;
    protected int portLowMask = 1;
    protected int portLowTest = 1;
    protected int portHighMask = 2;
    protected int portHighTest = 2;
    private static int a = 0;
    protected IOPort[] ports = new IOPort[]{new IOPort(0), new IOPort(0), new IOPort(0), new IOPort(255)};

    public PPI8255() {
        super("8255 PPI");
    }

    public void setPortMasks(int n, int n2, int n3, int n4) {
        this.portLowMask = n;
        this.portLowTest = n2;
        this.portHighMask = n3;
        this.portHighTest = n4;
    }

    public int readPort(int n) {
        int n2;
        int n3 = n2 = (n & this.portHighMask) == this.portHighTest ? 2 : 0;
        if ((n & this.portLowMask) == this.portLowTest) {
            ++n2;
        }
        n = this.ports[n2].read();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writePort(int n, int n2) {
        int n3;
        if (n == 64510) return;
        if (n == 64494) {
            return;
        }
        int n4 = n3 = (n & this.portHighMask) == this.portHighTest ? 2 : 0;
        if ((n & this.portLowMask) == this.portLowTest) {
            ++n3;
        }
        if (n3 != 3) {
            this.ports[n3].write(n2);
            return;
        }
        if ((n2 & 0x80) != 0) {
            this.setControl(n2);
            return;
        }
        IOPort iOPort = this.ports[2];
        n3 = 1 << (n2 >> 1 & 7);
        if ((n2 & 1) == 0) {
            iOPort.write(iOPort.readOutput() & (n3 ^ 0xFF));
            return;
        }
        iOPort.write(iOPort.readOutput() | n3);
    }

    public void setReadDevice(int n, Device device, int n2) {
        this.ports[n].setInputDevice(device, n2);
    }

    public void setWriteDevice(int n, Device device, int n2) {
        this.ports[n].setOutputDevice(device, n2);
    }

    protected String readWrite(int n, int n2) {
        if ((this.ports[n].getPortMode() & n2) == 0) {
            return "read";
        }
        return "write";
    }

    public int readOutput(int n) {
        return this.ports[n].readOutput();
    }

    public final String toString() {
        return super.toString() + ": Port A = " + this.readWrite(0, 255) + ", Port B = " + this.readWrite(1, 255) + ", Port C (Upper) = " + this.readWrite(2, 240) + ", Port C (Lower) = " + this.readWrite(2, 15);
    }

    public void setOutputValue(int n, int n2) {
        this.ports[n].setOutput(n2);
    }

    public int getOutputValue(int n) {
        return this.ports[n].getOutput();
    }

    public void setControl(int n) {
        int n2;
        a = n;
        this.ports[3].setOutput(n);
        this.ports[0].setPortMode((n & 0x10) != 0 ? 0 : 255);
        this.ports[1].setPortMode((n & 2) != 0 ? 0 : 255);
        int n3 = n2 = (n & 8) != 0 ? 0 : 240;
        if ((n & 1) == 0) {
            this.ports[2].setPortMode(n2 | 0xF);
        } else {
            this.ports[2].setPortMode(n2);
        }
        this.ports[0].write(0);
        this.ports[1].write(0);
        this.ports[2].write(0);
    }

    public int getControl() {
        return a;
    }

    public int portInputA() {
        return this.readPort(0);
    }

    public int portInputB() {
        return this.readPort(1);
    }

    public int portInputC() {
        return this.readPort(2);
    }
}

