/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.device.crtc.Basic6845;
import JCPC.system.cpc.GateArray;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.swing.JPanel;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Display
extends JPanel {
    public boolean scanlines = false;
    public static final Color LED_ON = new Color(32, 255, 32);
    public static final Color LED_OFF = new Color(32, 96, 32, 192);
    public static final Color LED_BORDER = new Color(96, 64, 64, 160);
    public int storesna;
    public int restoresna;
    public int crtc;
    private URL a;
    private Image a;
    private URL b;
    private Image b;
    private int a;
    public boolean large;
    public static boolean ledOn;
    protected int divider = 1;
    public static final int CENTER = 0;
    public static final Dimension SCALE_1;
    public static final Dimension SCALE_2;
    public static final Dimension SCALE_1x2;
    protected String snapl = "Snapshot loaded... Press F5 to reload";
    protected String snaps = "Snapshot stored... Press F5 to load";
    protected String crtctype = "CRTC type ";
    protected String crtctype2 = "... Press F8 to change";
    protected BufferedImage image;
    protected WritableRaster raster;
    protected int[] pixels;
    protected int imageWidth;
    protected int imageHeight;
    protected int scaleWidth;
    protected int scaleHeight;
    protected Rectangle imageRect;
    protected Rectangle sourceRect = null;
    protected int imagePos = 0;
    protected boolean sameSize;
    protected boolean painted = false;
    public boolean turbo;
    private boolean a = false;

    public Display() {
        this.b = this.getClass().getResource("3disc.gif");
        this.b = this.getToolkit().getImage(this.b);
        this.imageRect = new Rectangle();
        this.enableEvents(4L);
        this.setFocusTraversalKeysEnabled(false);
        this.setRequestFocusEnabled(true);
    }

    public void setImageSize(Dimension dimension, Dimension dimension2) {
        this.imageWidth = dimension.width;
        this.imageHeight = dimension.height;
        this.image = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        this.image.setAccelerationPriority(1.0f);
        this.raster = this.image.getRaster();
        this.pixels = new int[208896];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = -16777216;
        }
        if (dimension2 == null) {
            dimension2 = SCALE_1;
        }
        this.scaleWidth = this.imageWidth * dimension2.width;
        this.scaleHeight = this.imageHeight * dimension2.height;
        this.checkSize();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.paint(graphics);
            graphics.dispose();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.checkSize();
    }

    protected void checkSize() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        this.imageRect = new Rectangle(insets.left + (n - this.scaleWidth) / 2, insets.top + (n2 - this.scaleHeight) / 2, this.scaleWidth, this.scaleHeight);
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void updateImage() {
        this.checkSize();
        if (this.imageRect.width != 0 && this.imageRect.height != 0 && this.isShowing()) {
            this.raster.setDataElements(0, 0, this.imageWidth, this.imageHeight, this.pixels);
            this.repaint(0L, 0, 0, this.large ? 768 : 384, this.large ? 544 : 272);
        }
    }

    protected void paintImage(Graphics graphics) {
        if (!this.large) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics = graphics2D;
        }
        graphics.setFont(new Font("", 1, this.large ? 20 : 10));
        graphics.drawImage(this.image, 0, 0, this.large ? 768 : 384, this.large ? 544 : 272, null);
        if (this.scanlines && this.large) {
            graphics.setColor(Color.black);
            for (int i = 0; i < this.imageRect.height; i += 2) {
                graphics.drawLine(0, i, this.imageRect.width, i);
            }
        }
        if (!this.large) {
            if (ledOn) {
                graphics.setColor(LED_ON);
            } else {
                graphics.setColor(LED_OFF);
            }
            graphics.fillRect(372 * this.divider, 3 * this.divider, 7 * this.divider, 3 * this.divider);
            graphics.setColor(LED_BORDER);
            graphics.drawRect(371 * this.divider, 2 * this.divider, 8 * this.divider, 4 * this.divider);
        } else if (ledOn) {
            graphics.drawImage(this.b, 360 * this.divider, 3 * this.divider, this);
        }
        if (this.turbo) {
            graphics.setColor(LED_ON);
            graphics.fillRect(4 * this.divider, 3 * this.divider, 7 * this.divider, 3 * this.divider);
            graphics.setColor(LED_BORDER);
            graphics.drawRect(3 * this.divider, 2 * this.divider, 8 * this.divider, 4 * this.divider);
        }
        if (this.storesna > 0) {
            graphics.setColor(LED_ON);
            this.restoresna = 0;
            this.crtc = 0;
            graphics.drawString(this.snaps, this.large ? 40 : 20, this.large ? 20 : 10);
            --this.storesna;
        }
        if (this.restoresna > 0) {
            this.crtc = 0;
            this.storesna = 0;
            graphics.setColor(Color.GREEN);
            graphics.drawString(this.snapl, this.large ? 40 : 20, this.large ? 20 : 10);
            --this.restoresna;
        }
        if (this.crtc > 0) {
            this.storesna = 0;
            this.restoresna = 0;
            graphics.setColor(Color.yellow);
            graphics.drawString(this.crtctype + Basic6845.CRTC + this.crtctype2, this.large ? 40 : 20, this.large ? 20 : 10);
            --this.crtc;
        }
        if (this.a > 0) {
            graphics.drawImage(this.a, this.large ? 310 : 120, this.large ? 300 : 150, null);
            --this.a;
        }
        if (GateArray.cpc.saveallowed && GateArray.cpc.storing() != 0) {
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, this.large ? 767 : 383, this.large ? 543 : 271);
            graphics.drawRect(1, 1, this.large ? 765 : 381, this.large ? 541 : 269);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.image != null) {
            this.a = true;
            this.paintImage(graphics);
        }
    }

    public Dimension getPreferredSize() {
        if (this.large) {
            return new Dimension(this.imageRect.width, this.imageRect.height);
        }
        if (!this.a) {
            return new Dimension(382, 270);
        }
        return new Dimension(384, 272);
    }

    static {
        SCALE_1 = new Dimension(1, 1);
        SCALE_2 = new Dimension(2, 2);
        SCALE_1x2 = new Dimension(1, 2);
    }
}

