nolist
run start
org #8000
limit #a6ff
;;write direct "pacman"
read "firmware.asm"
read "keys.asm"
read "inks.asm"
.start
ld sp,#c000
ld a,(sound_queue + 1)		; Identify as 464/6128 firmware
cp #9f
jr nz,is6128
ld a,4
ld (vol8a),a
ld (vol8b),a
ld (vol8c),a
ld a,6
ld (vol12a),a
.is6128
ld hl,ent1
ld a,1
call sound_tone_envelope
ld hl,ent2
ld a,2
call sound_tone_envelope
ld hl,ent3
ld a,3
call sound_tone_envelope
ld hl,ent4
ld a,4
call sound_tone_envelope
ld hl,ent5
ld a,5
call sound_tone_envelope
ld hl,env2
ld a,2
call sound_ampl_envelope

ld de,#80
ld hl,scrtab * #100
.scrtablp
ld (hl),e
inc h
ld (hl),d
dec h
inc l
ld a,d
add 8
ld d,a
and #38
jr nz,scrtablp
ld a,l
or a
jr z,exscrtab
ld a,e
add 80
ld e,a
ld a,d
adc #c0
ld d,a
cp 8
jr nz,scrtablp
ld d,#40
jr scrtablp

.exscrtab
xor a
ld b,a:ld c,a
call scr_set_ink
ld bc,0
call scr_set_border
ld a,1
call setmode
ld c,16
ld a,#ff
ld hl,scrtab * #100 + 8
call clline
ld a,1
ld bc,#1a1a
call scr_set_ink
ld a,2
ld bc,#1818
call scr_set_ink
ld a,3
ld bc,#0606
call scr_set_ink
call kl_l_rom_enable
ld iy,#fff0
ld hl,titletext
ld de,#e8
call printm1dh
ld iy,#00f0
ld de,#266
call printm1
ld de,#320
call printm1
ld e,#70
call printm1
ld de,#410
call printm1
ld e,#60
call printm1
ld e,#ec
call printm1
ld de,#592
call printm1dh
call #bb18
call setticker

.newgame
xor a
ld (firsttime),a
ld r,a
call init
ld a,175
ld (powertime),a
xor a
ld (unk4a),a
ld (palwhite),a       ; Toggles blue/white 26 (11010 to 00010)
ld (level),a
ld h,a
ld l,a
ld (score),a
ld (score + 1),hl
ld a,2
ld (lives),a

.nextlevel
ld hl,#f0f0
ld (score2),hl
ld (score2 + 2),hl
ld (score2 + 4),hl
call initscreen
ld a,#ff
ld (powermask),a
ld a,#ce
ld (numdots),a
ld a,(level)
cp 16
jr c,noadjlev
ld a,15
.noadjlev
xor #0f
add a
add a
add #95
ld l,a
ld h,a
ld (timercount),hl
ld (tickcount),hl
ld hl,dots
ld b,64
call clrmem

.nextlife
ld a,#21
ld (ovlfg),a
ld a,#ff
ld (ovlmask),a
ld de,#3140
ld b,#22
call overlay
ld de,#3640
ld b,#22
call overlay
ld a,(lives)
or a
jr z,nolives
cp 2
jr c,less2
ld a,2
.less2
push af
ld b,a:add a:add a:add b ; * 5
add #2c
ld d,a
ld e,#40
ld b,#18
call overlay
pop af
dec a
jr nz,less2

.nolives
ld a,(level)
ld de,#3c40
ld b,4
.morefruit
push af
push bc
push de
add fruits
ld l,a
ld a,fruits / 256
adc 0
ld h,a
ld b,(hl)
call overlay
pop de
ld a,d
add 5
ld d,a
pop bc
pop af
or a
jr z,endfruit
dec a
djnz morefruit

.endfruit
xor a
ld (powercount),a
ld (ghostpos0 + ghostvuln),a
ld (ghostpos1 + ghostvuln),a
ld (ghostpos2 + ghostvuln),a
ld (ghostpos3 + ghostvuln),a
; Clear some more (#11,#12)

ld (pacdy),a
ld (ready),a
ld (fruit),a
ld (palblue),a
ld (palcount),a
ld (pacspr),a

ld hl,char0
ld de,#00fc
call drawchar

ld hl,#2611
ld (pacpos),hl
ld l,h
inc h
ld (ghostpos3),hl
ld l,#1f
ld (ghostpos1),hl
ld h,#2d
ld (ghostpos0),hl
ld h,#21
ld (ghostpos2),hl

ld ix,ghostpos0
ld de,ghostsize
ld bc,#04fc
ld a,b
ld (paceadd),a
ld a,#18
ld (pacbase),a
xor a
ld (ix + ghostsize + ghostmask),#33
.gholoop
ld (ix + ghostspr),2
ld (ix + ghostdy),1
ld (ix + ghostv0),a  ; 51..54
ld (ix + ghostdx),a
ld (ix + ghostbase),a
ld (ix + ghosteadd),c
add ix,de
djnz gholoop
dec a
ld (ghostpos0 + ghostmask),a
ld (pacmask),a
ld (pacdx),a
ld a,c
ld (ghostpos2 + ghostmask),a
ld (ix + ghostmask - ghostsize),#03

.mainloop
ld hl,timertoggle
ld a,(hl)
.waittoggle
cp (hl)
jr z,waittoggle

; Clear some other stuff
ld b,4
ld a,(level)
ld c,a
ld ix,ghostpos3
ld de,-ghostsize
.gposlp
ld a,(ix + ghostx)
cp #27
jr nz,not27
ld a,(ix + ghosty)
cp #28
jr nz,not27
ld a,15
sub c
jr nc,levok
xor a
.levok
ld (ix + ghostv0),a
ld a,b
dec a
and #02
jr z,usezero
ld a,10
.usezero
ld (ix + ghostv1),a
.not27
add ix,de
djnz gposlp

ld a,(fruit)
or a
jr z,nofruit
ld a,#21
ld (ovlfg),a
ld a,#ff
ld (ovlmask),a
ld de,#2711
ld hl,(pacpos)
ld a,h
cp d
jr nz,decfruit
ld a,l
cp e
jr nz,decfruit
ld a,(level)
add fruits
ld l,a
ld a,fruits / 256
adc 0
ld h,a
ld a,(hl)
sub #0e
add a
add fscores
ld l,a
ld a,fscores / 256
adc 0
ld h,a
ld c,(hl)
inc hl
ld b,(hl)
call addscorebc
ld de,#0102	; Env 1
ld hl,#0081	; Volume 0 ok
ld bc,-1
ld a,#30
call bbcsound1
.erasefruit
ld de,#2711
ld b,#22
call overlay
xor a
ld (fruit),a

.nofruit
call rand
jr nz,norand
ld a,r
and 3
jr nz,norand
call rand
or #f0
ld l,a
ld a,r
and 3
ld h,a
ld (fruitcount),hl
ld a,(level)
add fruits
ld l,a
ld a,fruits / 256
adc 0
ld h,a
ld a,(hl)
ld (fruit),a
jr norand

.decfruit
ld hl,fruitcount
dec (hl)
jr nz,fruitok
inc hl
dec (hl)
bit 7,(hl)
jp nz,erasefruit
.fruitok
ld a,(fruit)
ld b,a
call overlay

.norand
ld de,#0334
ld c,#80
call checkpower
ld de,#4b34
ld c,#20
call checkpower
ld de,#4b10
ld c,#08
call checkpower
ld de,#0310
ld c,#02
call checkpower

ld hl,palcount
inc (hl)
ld a,(hl)
and 7
jr nz,nopal
ld hl,palblue
ld a,(hl)
xor 18  ; Green
ld (hl),a
ld c,a
ld b,0
ld a,6
call scr_set_ink

ld a,(powercount)
or a
jr z,nopal
cp #32
jr nc,nopal
ld hl,palwhite
ld a,(hl)
xor #18
ld (hl),a
xor 26     ; White or blue
ld c,a
ld b,a
ld a,5
call scr_set_ink

.nopal
ld hl,unk4a
ld a,(hl)
or a
jr z,nounk
dec (hl)
jr nz,nounk
ld a,#ff
ld (ghostpos0 + ghostv3),a
ld (ghostpos1 + ghostv3),a
ld (ghostpos2 + ghostv3),a
ld (ghostpos3 + ghostv3),a

.nounk
ld b,5
ld ix,pacpos
.ghostmlp
push bc
ld a,(ix + ghostvuln)
inc a
jp z,vulnghost

ld a,#21
ld (ovlfg),a
xor a
ld (ovlmask),a
ld a,(ix + ghostdx)
or a
jr z,geupdown
ld a,(ix + ghostx)
add (ix + ghosteadd)
ld d,a
ld e,(ix + ghosty)
ld b,#16
jr gedone

.geupdown
ld a,(ix + ghosty)
add (ix + ghosteadd)
ld e,a
ld d,(ix + ghostx)
ld b,#17

.gedone
push ix
call overlay  ; Erase Ghost
pop ix

ld a,(ix + ghostmask)
ld (ovlmask),a
db #dd:ld a,l
cp pacpos    ; Is this pacman?
ld a,#21
jr z,ispac

ld a,(ix + ghostvuln)  ; 124D
or a
jr z,ghostalive
ld a,#ff
ld (ovlmask),a
ld a,#21
ld (ovlfg),a
ld a,(altghspr)
or 12
jr drawit

.ghostalive
ld a,(ix + ghostbase)
or (ix + ghostspr)
or 8

.ispac
ld (ovlfg),a
ld a,(ix + ghostbase)
or (ix + ghostspr)
ld b,a
ld a,(ix + ghostx)
add (ix + ghosty)
and 1
add a
add a
or b

.drawit
ld b,a
ld a,(altghspr)
xor 1
ld (altghspr),a

.drawit2
push ix
ld d,(ix + ghostx)
ld e,(ix + ghosty)
call overlay
pop ix

.ghostcloop
pop bc
ld de,-ghostsize
add ix,de
dec b
jp nz,ghostmlp

ld a,(ready)
or a
jr nz,noready

ld hl,readytext
ld de,#145e
ld c,#0f
call print
ld a,(firsttime)
or a
call z,music
ld b,5
.pauselp0
call pause10
djnz pauselp0
ld hl,readytext
ld de,#145e
ld c,#00
call print
ld a,#ff
ld (ready),a

.noready
ld a,#c3
ld hl,#2cb7
call dohline
ld b,4
ld hl,#3cb7
.nxhline
ld a,#f3
call dohline
djnz nxhline

ld a,(unk4a)
or a
jp nz,contplay

ld a,(pacx)       ; If pacman in tunnel
cp 79
jr c,notunnel

ld hl,ghostpos3 + ghostx
ld de,-ghostsize
ld b,4

.ghbxlp            ; Check for ghosts in tunnel
ld a,(hl)
cp 79
jp nc,deathcheck
add hl,de
djnz ghbxlp
jp contplay

.notunnel
ld b,4
ld hl,ghostpos3 + ghosty
.checkhit
ld a,(pacy)
sub (hl)
inc hl
inc a
cp 3
jr nc,nohit
ld a,(pacx)
sub (hl)
inc a
cp 3
jp c,deathcheck
.nohit
ld de,-ghostsize - 1
add hl,de
djnz checkhit
jp contplay

.death
ld a,2
call flushsound
ld a,6
ld bc,#1212
call scr_set_ink
ld a,#78
ld (deathnote),a
ld c,100
call pause
call eraseghfr
call placedots
ld de,(pacpos)
ld a,#ff
ld (ovlmask),a
ld b,#23
call overlay
call deathsound
xor a
ld (ovlmask),a
ld de,(pacpos)
ld b,#22
call overlay
ld a,#ff
ld (ovlmask),a
ld de,(pacpos)
dec e:dec e
ld b,#24
push de
call overlay
call deathsound
pop de
ld b,#25
push de
call overlay
call deathsound
pop de
ld b,#26
call overlay
call deathsound
ld de,(pacpos)
ld b,#27
call overlay
call deathsound
xor a
ld (ovlmask),a
ld (svol),a
ld de,(pacpos)
ld b,#22
call overlay
call placedots
call queuesound  ; Same channel, volume set to 0 above
ld a,(lives)
dec a
ld (lives),a
jp m,dead
jp nextlife

.deathcheck  ; Ghost is B - 1
inc hl       ; Ghost vulnerable
ld a,(hl)
dec hl
or a
jp z,death
inc a
jp z,nohit

inc hl
ld (hl),#ff
dec hl
call eraseeaten
ld b,0
ld a,(ghostscore)
sla a
ld (ghostscore),a
ld c,a
jr nc,doaddsc
ld bc,#160
ld a,b
ld (powercount),a
.doaddsc
call addscorebc    ; Scores are 20, 40, 80 and 160
ld bc,-1
ld de,#0102
ld hl,#0081
ld a,#48
call bbcsound1
ld a,2
call flushsound

.contplay
ld a,(numdots)
or a
jr nz,stilldots
ld a,(powermask)
cp #55
jp z,leveldone

.stilldots
call placedots
ld a,(unk4a)
or a
jp nz,nopower

.L13fb
ld a,(powercount)
or a
jr z,nopsound
ld b,a
and #07
jr nz,nopsound
ld a,b
cpl
sub #40         ; Pitch varies from 16 (low) to 190 (high)
.vol8c equ $ + 2
ld hl,#0882
ld bc,-1
ld de,#0200	; Envelope 0 - need to modify volume above
cp 60
jr c,dopsound
inc d
cp 103
jr c,dopsound
inc d
cp 147
jr c,dopsound
inc d
.dopsound
call bbcsound1

.nopsound
ld de,(pacpos)
ld a,e
inc a
call mod3
jr nz,noright
ld de,(pacpos)
call wallcolh
cp 8
jr z,noleft
ld a,KEY_Z
call km_test_key
jr z,noleft
ld a,#ff
ld (pacdx),a
xor a
ld (pacdy),a
ld (pacspr),a
ld a,4
ld (paceadd),a

.noleft
ld de,(pacpos)
ld a,d
add 4
ld d,a
call wallcolh
cp 8
jr z,noright
ld a,KEY_X
call km_test_key
jr z,noright
xor a
ld (pacdy),a
inc a
ld (pacdx),a
ld a,3
ld (pacspr),a
ld a,#ff
ld (paceadd),a

.noright
ld a,(pacx)
cp #4c
jr nc,nodown
cp 2
jr c,nodown
call mod3
jr nz,nodown

ld de,(pacpos)
call wallcolv
cp 8
jr z,noup
ld a,KEY_SEMICOLON
call km_test_key
jr z,noup
xor a
ld (pacdx),a
inc a
ld (pacdy),a
ld (pacspr),a
ld a,#fc
ld (paceadd),a

.noup
ld de,(pacpos)
ld a,e
sub 4
ld e,a
call wallcolv
cp 8
jr z,nodown
cp 9
jr z,nodown
ld a,KEY_SLASH
call km_test_key
jr z,nodown
ld a,#ff
ld (pacdy),a
xor a
ld (pacdx),a
inc a
ld (paceadd),a
inc a
ld (pacspr),a

.nodown
ld b,4
ld ix,ghostpos3
.moveghlp
ld a,(ix + ghostvuln)
cp #ff
jr z,nxghost
ld d,(ix + ghostx)
ld e,(ix + ghosty)
ld a,e
add d
inc a
call mod3
jr nz,nxghost
ld a,d
cp #4e
call c,moveghost
.nxghost
ld de,-ghostsize
add ix,de
djnz moveghlp

ld hl,powercount
ld a,(hl)
or a
jr z,nopower
dec (hl)
jr nz,nopower

ld a,2
call flushsound
ld hl,ghostpos3 + ghostvuln
ld de,-ghostsize
ld b,4
.clrghgu
ld a,(hl)
and #40
jr nz,noresgu
ld (hl),0
.noresgu
add hl,de
djnz clrghgu

.nopower
ld ix,pacpos

.movexlp
ld a,(unk4a)
or a
jr z,movex
ld a,(ix + ghostvuln)
inc a
jr nz,nextx
.movex
call wallcolx
cp 8
jr z,nextx
call wallcolx2
cp 6
jr nz,not6
ld a,lx
cp pacpos
jr nz,not6
call powerpill
jr z,movedx
.checkv3
ld a,(ix + ghostv3)  ; TODO - For pacman this is sound buffer
or a
jr nz,movedx
ld a,(timertoggle)
bit 7,a
jp nz,nextx
jr movedx

.not6
ld a,lx
cp pacpos
jr z,movedx

ld a,(ix + ghostdx)   ; 16F6
or a
jr z,nextx
ld a,(ix + ghostvuln)
cp #80
jr z,checkv3
ld a,(ix + ghosty)
cp #20
jr nz,movedx
ld a,(ix + ghostx)
cp #14
jr c,checkv3
cp #3c
jr nc,checkv3

.movedx ; 1714
ld (ix + ghostv3),0  ; TODO - What is this?
ld a,(ix + ghostx)
add (ix + ghostdx)
cp #fb
jr nz,notfb
ld a,#54
.notfb
cp #55
jr nz,not85
ld a,#fc
.not85
ld (ix + ghostx),a
.nextx
ld a,lx
ld de,-ghostsize
add ix,de
cp ghostpos0
jr nz,movexlp

ld ix,pacpos
.moveylp
ld a,(unk4a)
or a
jr z,movey
ld a,(ix + ghostvuln)
inc a
jr nz,nexty
.movey
call wallcoly
cp 8
jr z,nexty
call wallcoly2
cp 6
jr nz,not6b
ld a,lx
cp pacpos
jr nz,not6b
call powerpill
jr z,ispac2

.not6b
ld a,lx
cp pacpos
jr z,ispac2
ld a,(ix + ghostvuln)
cp #80
jr nz,ispac2
ld a,(ix + ghostv3)
or a
jr nz,ispac2
ld a,(timertoggle)
bit 7,a
jr nz,nexty
.ispac2
ld (ix + ghostv3),0
ld a,(ix + ghosty)
add (ix + ghostdy)
ld (ix + ghosty),a
.nexty
ld a,lx
ld de,-ghostsize
add ix,de
cp ghostpos0
jr nz,moveylp
call checkdots
jp mainloop

.moveghost
ld a,(ix + ghostv0)
or a
jr z,v0n0
ld a,(ix + ghostv1)
or a
jr z,incv1
cp #0a
jr nz,v0n0
.incv1
inc a
ld (ix + ghostv1),a
bit 0,b
jp z,ghleft
jp ghright

.v0n0      ; 14e9
ld a,d
sub #1d
cp #12
jr nc,nobox
ld a,e
sub #18
cp #0c
jr nc,nobox

call rand  ; If ghost in box
and #07
jp nz,ghup
call rand
add a
jp c,ghleft
jp ghright

.nobox     ; 150e
ld a,(ix + ghostdx)
or a
jp nz,ghlr
call wallcolh      ; Ghost going up/down - check left wall
ld hy,a            ; HY = 01
ld e,(ix + ghosty)
ld a,(ix + ghostx)
add 4
ld d,a
call wallcolh      ; Check right wall
ld ly,a            ; LY = 00
cp 8
jr nz,chkdir
ld a,hy
cp 8
ret z               ; If both left and right walls, no change
.chkdir
call wallcoly       ; Check wall in direction travelled
cp 8
jr nz,contupdown
ld a,ly             ; Hit a wall up/down
cp 8
jp z,ghleft         ; If wall on right, go left
ld a,hy
cp 8
jp z,ghright        ; If wall on left, go right

ld a,(ix + ghostv0) ; ??
or a
jr nz,L15c2
ld a,(pacx)
cp (ix + ghostx)
jp nc,ghright       ; If pacman X >= ghost X, go right
jp ghleft           ; Else go left

.contupdown         ; 155C - Continue up/down
ld a,(ix + ghostv0)
or a
jr nz,L15C2
ld a,ly             ; Right wall?
cp 8
jr z,isrwall
ld a,hy             ; Left wall?
cp 8
jr z,islwall
call rand           ; No left or right walls, randomly go left/right maybe
add a
jr c,islwall

.isrwall
call rand           ; Mostly follow pacman
ret z

ld a,(pacy)
cp (ix + ghosty)
jr nc,ygtpac
bit 7,(ix + ghostdy) ; If Y > Pacman Y and going up
jp z,ghlifnv         ; Go left if not vulnerable
ret

.ygtpac    ; 1585
bit 7,(ix + ghostdy) ; Else if Y <= Pacman Y and going down
jp nz,ghlifnv        ; Go left if not vulnerable
ret

.islwall
call rand            ; Usually follow pacman
ret z
ld a,(pacy)
cp (ix + ghostdy)
jr nc,ygtpac2
bit 7,(ix + ghostdy) ; If Y > Pacman Y and going up
jp z,ghrifnv         ; Go right if not vulnerable
ret

.ygtpac2    ; 15A2
bit 7,(ix + ghostdy) ; If Y <= Pacman Y and going down
jp nz,ghrifnv        ; Go right if not vulnerable
ret

.L15C2
dec (ix + ghostv0)
ld a,(ix + ghostv1)
ld c,a  ; X
add ghdirs
ld l,a
ld a,ghdirs / 256
adc 0
ld h,a
ld e,(hl)
ld a,c
inc a
cp #12
jr nz,not12
ld a,#0c
.not12
cp #0a
jr nz,not0a
ld a,#05
.not0a
ld (ix + ghostv1),a
bit 0,e
jr z,L15F2
ld a,b
dec a
and #01
add a
xor e
cp #03
jp z,ghright
jp ghleft

.L15F2
ld a,e
cp #02
jp z,ghdown
jp ghup

.ghlr      ; 15F9
push de
call wallcolv
pop de
ld hy,a    ; Above
ld d,(ix + ghostx)
ld a,(ix + ghosty)
sub 4
ld e,a
call wallcolv
ld ly,a    ; Below
cp 8
jr nz,nowa
ld a,hy
cp 8
ret z
.nowa          ; No wall above
call wallcolx  ;Collsion in direction
cp 8
jr nz,nowal
ld a,hy
cp 8
jp z,ghdown
ld a,ly
cp 8
jp z,ghup
ld a,(ix + ghostv0)
or a
jr nz,L15C2
ld a,(pacy)
cp (ix + ghosty)
jp c,ghup
jp ghdown

.nowal       ; No wall in movement dir
ld a,(ix + ghostv0)
or a
jp nz,L15C2
ld a,ly      ; Wall above
cp 9
jr z,wallb
cp 8
jr z,wallb
ld a,hy
cp 8
jr z,walla

call rand
jp nz,ghdown

.walla     ; 1650
call rand
ret z

ld a,(pacy)
cp (ix + ghosty)
jr c,L1663
bit 7,(ix + ghostdy)
jp nz,ghdifnv
ret

.L1663
bit 7,(ix + ghostdy)
jp z,ghdifnv
ret

.wallb     ; 167A
call rand
and #07
jp z,ghuifnv
ld a,(pacy)
cp (ix + ghosty)
ret z
jr nc,L1694
bit 7,(ix + ghostdy)
jp nz,ghuifnv
ret

.L1694
bit 7,(ix + ghostdy)
jp z,ghuifnv
ret

.leveldone
ld a,2
call flushsound
ld a,(level)
inc a
cp 16
jr c,less16
ld a,16
.less16
ld (level),a
call eraseghfr
ld a,#ff
ld (ovlmask),a
ld de,(pacpos)
ld a,(pacbase)
ld b,a
ld a,(pacspr)
or b
ld b,a
call overlay
ld b,8
.loop8
push bc
ld a,1
ld bc,#1a1a
call scr_set_ink
call flyback9
ld a,1
ld bc,#0202
call scr_set_ink
call flyback9
pop bc
djnz loop8
ld a,(powertime)
sub 16
cp 100
jr nc,gt100
ld a,100
.gt100
ld (powertime),a
jp nextlevel

.ghlifnv
bit 7,(ix + ghostvuln)
ret nz
.ghleft
ld a,#ff
ld (ix + ghostv3),a
ld (ix + ghostdx),a
inc a
ld (ix + ghostdy),a
ld (ix + ghostspr),a
ld a,4
ld (ix + ghosteadd),a
ret

.ghrifnv
bit 7,(ix + ghostvuln)
ret nz
.ghright
ld a,1
ld (ix + ghostdx),a
ld (ix + ghostspr),a
dec a
ld (ix + ghostdy),a
dec a
ld (ix + ghostv3),a
ld (ix + ghosteadd),a
ret

.ghuifnv
bit 7,(ix + ghostvuln)
ret nz
.ghup
xor a
ld (ix + ghostdx),a
inc a
ld (ix + ghostdy),a
inc a
ld (ix + ghostspr),a
ld a,#fc
ld (ix + ghostv3),a
ld (ix + ghosteadd),a
ret

.ghdifnv
bit 7,(ix + ghostvuln)
ret nz
.ghdown
ld a,#ff
ld (ix + ghostdy),a
ld (ix + ghostv3),a
ld (ix + ghostspr),3
inc a
ld (ix + ghostdx),a
inc a
ld (ix + ghosteadd),a
ret

.checkdots
ld de,(pacpos)
inc d
dec e
dec e
call dexy2
ret c
ld bc,#2000
ld hl,dots + 63
.lpcdot
ld a,(hl)
dec hl
cp d
jr nz,nxcdot
ld a,(hl)
sub e
jr nz,nxcdot
ld (de),a
res 3,d
ld (de),a
set 3,d
inc hl
ld (hl),a
dec hl
inc c
.nxcdot
dec hl
djnz lpcdot
ld a,c
or a
ret z
ld hl,numdots
dec (hl)
ld bc,1
call addscorebc
ld a,#84
ld (schan),a
.vol8a equ $ + 1
ld a,8
ld (svol),a
ld hl,5
ld (sduration),hl
ld l,h
ld (senv),hl		; No envelope
ld hl,956
jp queuesoundhl

.placedots
ld hl,dots + 63
.dotloop
ld a,(hl)
dec hl
or a
jr z,nxdot
ld d,a
sub 8
ld b,a
ld e,(hl)
ld c,e
ld a,(de)
or a
jr z,drawdot
cp 4
jr nz,nxdot
ld a,(bc)
or a
jr z,drawdot
cp 4
jr nz,nxdot
inc hl
ld (hl),0
dec hl
.drawdot
ld a,4
ld (de),a
ld (bc),a
.nxdot
dec hl
ld a,l
cp dots - 1
jr nz,dotloop
ret

.inkswap
ld b,#f5
in a,(c)
ld hl,intno
ld bc,#7f03
out (c),c
rra
jr c,isffb
ld a,(hl)
inc a
ld (hl),a
cp 2
ret nz
ld b,100
djnz $
ld bc,#7f00 + INK_6
out (c),c
ret

.isffb
ld (hl),0
ld c,INK_18
out (c),c
ret

.setticker
ld de,tick
.settickerde
ld hl,ticker
ld bc,#c1ff
jp kl_new_fast_ticker

.dead
ld c,100
call pause
call kl_l_rom_enable
ld de,high8
ld hl,score + 2
ld b,3
.compsc
ld a,(de)
cp (hl)
jr c,enter
jp nz,highs
inc de
dec hl
djnz compsc
jp highs
.enter
ld hl,ticker
call kl_del_fast_ticker
ld de,inkswap
call settickerde
ld a,1
call setmode
ld a,1
ld bc,#0202
call scr_set_ink
ld a,2
ld bc,#1414
call scr_set_ink
ld a,3
ld bc,#1212
call scr_set_ink
ld de,#1c28
.clrtbox
push de
ld bc,#5c0f
call hline
pop de
inc e
ld a,e
cp #98
jr z,excbox
cp #38
jr nz,clrtbox
ld e,#90
jr clrtbox
.excbox
ld iy,#0fff
ld de,#224
ld hl,congrats
call printm1dh
ld de,#356
ld iy,#00ff
call printm1
ld de,#44e
call printm1
ld de,#632
ld iy,#0ff0
ld a,"_"
call m1ch
dec de
dec de
.waitclr
call km_read_char
jr c,waitclr
ld b,19
ld hl,buff
.keyloop
call km_wait_char
cp 127
jr z,del
cp 13
jr z,entered
inc b
dec b
jr z,keyloop
dec b
ld (hl),a
inc hl
ld ly,#ff
push bc
call m1ch
.showcurs
ld a,"_"
ld ly,#f0
call m1ch
dec de
dec de
pop bc
jr keyloop

.del
ld a,b
cp 19
jr z,keyloop
inc b
dec hl
push bc
ld a," "
call m1ch
dec de:dec de
dec de:dec de
jr showcurs

.entered
ld (hl),0
ld hl,ticker
call kl_del_fast_ticker
call setticker
ld ix,high7
ld b,7
ld a,(score + 2)
ld c,a
ld hl,(score)
ld de,-23
.checksc
ld a,(ix + 0)
cp c
jr c,still
jr nz,nothigher
ld a,(ix + 1)
cp h
jr c,still
jr nz,nothigher
ld a,(ix + 2)
cp l
jr nc,nothigher
.still
add ix,de
djnz checksc
.nothigher
push ix
pop bc
ld hl,high7
or a
sbc hl,bc
ld b,h
ld c,l
ld hl,high7 + 22
jr z,nomove
ld de,high8 + 22
lddr
.nomove
ld de,score + 2
inc hl
ld a,(de)
dec de
ld (hl),a
inc hl
ld a,(de)
dec de
ld (hl),a
inc hl
ld a,(de)
ld (hl),a
inc hl
ex de,hl
ld hl,buff
ld bc,20
ldir

.highs
ld a,1
call setmode
call kl_l_rom_enable
ld a,2
ld bc,#0606
call scr_set_ink
ld a,1
ld bc,#1a1a
call scr_set_ink
ld de,#22e
ld iy,#000f
ld hl,scorestext
call printm1dh
ld a,"1"
ld de,#306
ld hl,high1
.lpscores
push af
push hl
push de
ld ly,#f0
call m1ch
ld hx,4
.scdots
ld a,"."
call m1ch
dec hx
jr nz,scdots
ld ix,#032e
.scdigs
ld a,(hl)
rrca:rrca:rrca:rrca
call m1dig
ld a,(hl)
inc hl
call m1dig
dec hx
jr nz,scdigs
ld a,'0'
call m1ch
ld hx,3
.scdots2
ld a,"."
call m1ch
dec hx
jr nz,scdots2
call printm1
pop hl
ld de,160
add hl,de
ex de,hl
pop hl
ld bc,23
add hl,bc
pop af
inc a
cp "9"
jr nz,lpscores
ld de,#40a8
ld hl,presstext
call printm1
.waitspace
ld a,KEY_SPACE
call km_test_key
jr z,waitspace
jp newgame 

.deathsound
ld a,#81
ld (schan),a
.vol8b equ $ + 1
ld a,8
ld (svol),a
ld hl,0
ld (senv),hl		; No envelope
ld h,#80
ld (sduration),hl
ld b,8
.dsloop
push bc
;dec &60
ld a,(deathnote)
bit 0,b
jr nz,noincnote
inc a
inc a
.noincnote
dec a
bit 1,b
jr nz,nosubnote
sub 4
.nosubnote
ld (deathnote),a
add a
call bbcsound
ld c,1
call pause
pop bc
dec b
bit 7,b
jr z,dsloop
ret

.xora
xor a
ret

.wallcolx2
ld a,(ix + ghostdx)
ld b,a
add a
add b
jr wallcolx3

.wallcolx
ld a,(ix + ghostdx)
add a
.wallcolx3
add (ix + ghostx)
ld d,a
inc d:inc d
ld e,(ix + ghosty)

.wallcolh  ; Horizontal wall collision
dec e:dec e
call dexy2
jr c,xora
ld c,0
ld a,(de)     ; Get pixel colour of left pixel
rla:rl c
rla:rla:rl c
rla:rla:rl c
rla:rla:rl c
ld a,c
cp 8
ret z
dec de
ld c,0
ld a,(de)
rla:rla:rl c
rla:rla:rl c
rla:rla:rl c
rla:rla:rl c
ld a,c
ret

.wallcoly2
ld a,(ix + ghostdy)
ld b,a
add a
add b
jr wallcoly3

.wallcoly
ld a,(ix + ghostdy)
add a
.wallcoly3
add (ix + ghosty)
ld e,a
dec e:dec e
ld d,(ix + ghostx)

.wallcolv
inc d:inc d
push de
call dexy
ld a,(de)
pop de
ld c,0
rla:rl c
rla:rla:rl c
rla:rla:rl c
rla:rla:rl c
ld a,c
cp 8
ret z
call dexy2
ld a,(de)
ld c,0
rla:rl c
rla:rla:rl c
rla:rla:rl c
rla:rla:rl c
ld a,c
ret

.eraseghfr
ld a,#21
ld (ovlfg),a
xor a
ld (ovlmask),a
ld hl,ghostpos3 + ghosty
.eraghlp
push hl
ld e,(hl)
inc hl
ld a,(hl)
or a
jp p,notneg
xor a
.notneg
cp #4c
jr c,nogt4c
ld a,#4b
.nogt4c
ld d,a
ld b,#22
call overlay
pop hl
ld a,l
ld de,-ghostsize
add hl,de
cp ghostpos0 + ghosty
jr nz,eraghlp
ld de,#2711
ld b,#22
jp overlay

.tick
xor a
ld (ticker + 4),a
ld hl,(tickcount)
ld de,3333
or a
sbc hl,de
jr nc,setticks
ld de,(timercount)
add hl,de
ld a,(timertoggle)
cpl
ld (timertoggle),a
.setticks
ld (tickcount),hl
ret

.music
ld a,7
call flushsound
xor a
ld h,a
ld l,a
ld (senv),hl      ; Env and Ent (No envelope)
ld (sduration + 1),a
ld ix,tune0
.tunelp
push ix
ld b,(ix + 0)
.vol12a equ $ + 1
ld a,12        	;Amplitude
bit 0,b
jr z,use12
xor a
.use12
ld (svol),a
ld a,b
rra
and #01
inc a
ld d,a
add a
add a
add d
ld (sduration),a
ld a,#02
ld (schan),a
ld a,b
and #fc
push af
call bbcsound
ld a,#05
ld (schan),a
pop af
sub #30
call bbcsound
pop ix
inc ix
ld a,lx
cp tune0e
jr nz,tunelp
ld a,#ff
ld (firsttime),a
ret

.flushsound ; A = channel
or #80
ld l,a
xor a
ld d,a:ld e,a
ld b,a:ld c,a
inc c
ld h,a
xor a

.bbcsound1 ; A = note, BC = duration, DE = envelope, H = volume, L = channel
ld (sduration),bc
ld b,a
ld a,l
ld (schan),a
ld a,h
ld (svol),a
ld (senv),de
ld a,b

.bbcsound
ld l,a
ld h,notepitch / 256
ld l,(hl)
ld h,0
cp #30
rl h

.queuesoundhl
ld (stone),hl

.queuesound
ld hl,sblock
.quagain
call sound_queue
ret c
jr quagain

.powerpill
ld de,(pacpos)
ld hl,powermask
ld a,d
cp 40
ld a,e
jr nc,rightpp

cp 32
jr nc,lefttop

bit 1,(hl)
ret z
ld a,#fd
jr setpp

.lefttop
bit 7,(hl)
ret z
ld a,#7f
jr setpp

.rightpp
cp 32
jr nc,righttop

bit 3,(hl)
ret z
ld a,#f7
jr setpp

.righttop
bit 5,(hl)
ret z
ld a,#df

.setpp
and (hl)
ld (hl),a

ld hl,ghostpos3 + ghostvuln
ld de,-ghostsize
.vulnloop
ld a,(hl)
or a
jr nz,alrvuln
ld (hl),#80
.alrvuln
ld a,l
add hl,de
cp ghostpos0 + ghostvuln
jr nz,vulnloop
ld a,(powertime)
ld (powercount),a
ld a,#10
ld (ghostscore),a  ; This will rotate to give extra score for 4 ghosts in one pill
ld a,5
ld bc,#0202
call scr_set_ink
ld bc,5
call addscorebc
xor a
inc a
ret    ; NZ

.flyback9
ld bc,#f509
.waitstop
in a,(c)
rra
jr c,waitstop
.waitffb
in a,(c)
rra
jr nc,waitffb
dec c
jr nz,waitstop
ret

.pause10
ld c,9
.pause  ; For C + 1 1/100ths of a secondish
push bc
inc c
ld l,c
ld b,0
ld h,b
add hl,hl
add hl,bc
ld b,h
ld c,l
inc bc
.pauselp
call kl_time_please
ld a,l
ld hl,lasttime
cp (hl)
jr z,pauselp
ld (hl),a
dec bc
ld a,b
or c
jr nz,pauselp
pop bc
ret

.dohline
ld (hl),a:inc l
ld (hl),a:inc l
ld (hl),a:inc l
ld (hl),a:dec l:dec l:dec l
ld a,h
add 8
ld h,a
and #38
ret nz
ld a,l
add 80
ld l,a
ld a,h
adc #c0
ld h,a
cp 8
ret nz
ld h,#40
ret

.eraseeaten  ; HL points to Ghost X
push bc
ld d,(hl)
push hl
dec hl
ld e,(hl)
xor a
ld (ovlmask),a
ld a,#21
ld (ovlfg),a
ld b,#22
call overlay
ld a,#ff
ld (ovlmask),a
ld de,(pacpos)
ld b,#22
call overlay
pop hl
ld a,(hl)
call div3   ; In C and A
add a
add c       ; * 3
ld (hl),a
dec hl
ld a,(hl)
sub 5
call div3
add a
add c       ; * 3
add 5
ld (hl),a
ld a,#0f
ld (unk4a),a
push hl
pop ix
ld b,(ix + ghostv2)
jr floateyes

.vulnghost
ld b,(ix + ghostv2)
ld a,(ix + ghostx)
cp #4e
jr c,less4e
ld a,#4b
jr floateyes2  ; TODO - On real thing this does a BRK???

.less4e
call mod3
jr nz,notz
ld a,(ix + ghosty)
inc a
call mod3
jr nz,notz

.floateyes
ld a,(ix + ghostx)
.floateyes2
call div3
ld d,a
srl a
srl a
ld e,a
ld a,(ix + ghosty)
sub 5
call div3
add a
add a
add a
add e
sub c
ld e,a
cp #42
jr z,ghalive
ld a,d
and 3
xor 3
ld d,a
ld a,e
add ghdirmasks
ld l,a
ld a,ghdirmasks / 256
adc 0
ld h,a
ld a,(hl)
ld b,d
inc b
dec b
jr z,noshift
.shift
srl a
srl a
djnz shift
.noshift
and 3
ld (ix + ghostv2),a
ld b,a
add a
add eyemoves
ld l,a
ld a,eyemoves / 256
adc 0
ld h,a
ld a,(hl)
inc hl
ld (ix + ghostdx),a
ld a,(hl)
ld (ix + ghostdy),a
ld a,(unk4a)
cp #f
jr nz,notz
pop bc       ; ??? When does this get reached
ret

.notz
ld d,(ix + ghostx)
ld e,(ix + ghosty)
ld a,#ff
ld (ovlmask),a
ld a,b
add bases
ld l,a
ld a,bases / 256
adc 0
ld h,a
ld a,(hl)
ld (ovlfg),a
ld b,#22
jp drawit2

.ghalive
ld (ix + ghosteadd),#fc
ld (ix + ghostvuln),0
ld (ix + ghostdy),1
ld (ix + ghostspr),2
jp ghostcloop

.mod3
sub 3
jr nc,mod3
add 3
ret

.div3
ld c,#ff
.divlp
inc c
sub 3
jr nc,divlp
ld a,c
ret

.rand
ld a,r
rrca
rrca
neg
.seed equ $ + 1
xor 0
ld (seed),a
ret

.clrmem
xor a
.setmem
ld (hl),a
inc hl
djnz setmem
ret

.init
xor a
call setmode
ld bc,0
call scr_set_border
xor a
ld hl,inks
.inklp
ld c,(hl)
ld b,c
push af
push hl
call scr_set_ink
pop hl
inc hl
pop af
inc a
cp 16
jr nz,inklp
call mc_wait_flyback
halt
halt
call mc_wait_flyback
di
ret

.setmode
call scr_set_mode
xor a
call cls
ld hl,crtc
.crtcloop
ld b,#bc
ld a,(hl)
inc hl
or a
ret z
out (c),a
inc b
ld a,(hl)
inc hl
out (c),a
jr crtcloop

;call convert_sprites

.dexy
ld a,e
add a:add a
cpl
ld l,a
ld h,scrtab
ld a,(hl)
add d
ld e,a
inc h
ld d,(hl)
ret nc
inc d
ret

.dexy2    ; Convert co-ords in D, E to DE
ld a,80 - 1
cp d
ret c     ; Returns with carry if outside bounds
ld a,e
add a:add a
neg
inc a
ld l,a
ld h,scrtab
ld a,(hl)
add d
ld e,a
inc h
ld d,(hl)
ret nc
inc d
or a      ; Clear carry
ret

.overlay   ; Draw overlaid sprite B on ovlback at D = x, E = y
ld a,b
cp #16
ld a,d
jr z,is16
cp #4c
ret nc
.is16
cp #50
ret nc
call dexy2
ld a,b
add a
add sprites
ld l,a
ld a,sprites / 256
adc 0
ld h,a
ld c,(hl)
inc hl
ld b,(hl)      ; Base in BC
.ovlfg equ $ + 1
ld a,0
add a
add sprites
ld l,a
ld a,sprites / 256
adc 0
ld h,a
ld a,(hl)
inc hl
ld h,(hl)
ld l,a         ;Overlay in HL
ld a,(bc)      ;Height
inc bc
db #dd:ld l,a
ld a,(bc)
inc bc
db #fd:ld l,a
.ovly
db #fd:ld h,l
push de
.ovlx
ld a,(de)
cp 4
call z,checkdot
ld a,(bc)
inc bc
.ovlmask equ $ + 1
and #ff
or (hl)
inc hl
ld (de),a
inc de
db #fd:dec h
jr nz,ovlx
pop de
db #dd:dec l
ret z
ld a,d
add 8
ld d,a
and #38
jr nz,ovly
ld a,e
add 80
ld e,a
ld a,d
adc #c0
ld d,a
cp 8
jr nz,ovly
ld d,#40
jr ovly

.checkdot
push hl
ld hx,d
set 3,d
xor a
ld (de),a  ; Erase bottom part of dot - this probably happens anyway
ld hl,dots + 63
.moredots
ld a,(hl)
or a
jr nz,trydot
ld (hl),d
dec hl
ld (hl),e
ld d,hx
pop hl
ret
.trydot
dec hl
ld a,l
dec hl
cp dots
jr nz,moredots
ld d,hx
pop hl
ret

.initscreen
xor a
call cls
ld hl,scoretext
ld de,#d0
ld c,#3f
call print
ld hl,hlines
ld de,hline
ld bc,#4c0
call lines
ld de,vline
ld b,8
call lines
ld a,#c0
ld (#0d32),a:ld (#1532),a
ld (#0e22),a:ld (#1622),a
ld (#0e6e),a:ld (#166e),a
ld (#2cde),a:ld (#34de),a
ld (#0d7e),a:ld (#157e),a
ld (#0d7f),a:ld (#157f),a
ld (#0e6f),a:ld (#166f),a
ld (#2ebe),a:ld (#36be),a
ld (#689e),a:ld (#709e),a
ld (#1d2e),a:ld (#252e),a
ld (#1f0e),a:ld (#270e),a
ld (#58ee),a:ld (#60ee),a
ld (#3e22),a:ld (#0672),a
ld (#3d32),a:ld (#0582),a
ld (#3e6e),a:ld (#06be),a
ld (#3e6f),a:ld (#06bf),a
ld (#3d7e),a:ld (#05ce),a
ld (#3d7f),a:ld (#05cf),a
ld a,#80
ld (#2148),a
ld (#2948),a
ld (#3148),a
;ld (#1d2f),a
;ld (#36bf),a
ld a,#40
ld (#2149),a
ld (#2949),a
ld (#3149),a
;ld (#3672),a
;ld (#1ce2),a

ld ix,tilemap - 1
ld e,#3a
.tloopy
ld d,#03
.tloopx
inc ix
ld a,(ix + 0)
rra:rra:rra:rra
push de
call drawtilexy
pop de
ld a,d
cp #4b
jr z,exitx
inc d:inc d:inc d
ld a,(ix + 0)
push de
call drawtilexy
pop de
inc d:inc d:inc d
jr tloopx
.exitx
ld a,e
sub 3
ld e,a
cp 1
jr nz,tloopy
ld bc,0
jr addscorebc

.addscorebc
ld hl,score
ld a,(hl)
add c
daa
ld (hl),a
inc hl
ld a,(hl)
adc b
daa
ld (hl),a
inc hl
ld a,(hl)
adc 0
daa
ld (hl),a
ld e,#e4
ld bc,score2
ld ly,#0f
.scorelp
ld a,(bc)
and ly
ld d,a
ld a,(hl)
rra:rra:rra:rra
and #f
cp d
call nz,scorech
inc e:inc e:inc e:inc e
inc bc
ld a,(bc)
and ly
ld d,a
ld a,(hl)
and #f
cp d
call nz,scorech
inc e:inc e:inc e:inc e
inc bc
dec hl
ld a,l
cp score - 1
jr nz,scorelp
ret

.scorech
ld (bc),a
ld ly,#ff
push bc
push hl
push de
ld d,0
add a:add a:add a:add a
add a:ld l,a
ld a,char0 / 256
adc d
ld h,a
call drawchar
pop de
pop hl
pop bc
ret

.lines
ld (lroutine),de
.lineloop
push bc
ld d,(hl)
inc hl
ld e,(hl)
inc hl
ld b,(hl)
inc hl
push hl
.lroutine equ $ + 1
call hline
pop hl
pop bc
djnz lineloop
ret

.hlines
db 4,#12,#9c,4,#fe,#9c,5,#13,#9a,5,#fd,#9a

.vlines
db 4,#9f,#5f,4,#12,#61,#9f,#12,#61,#9f,#9f,#60
db 5,#9e,#5f,5,#13,#61,#9e,#13,#61,#9e,#9e,#5f

.inks
db 0, 2, 18, 2, 2, 2, 18, 20, 6, 0, 24, 26, 8, 8, 26, 18

.cls
ld c,0
.clsc
ld hl,scrtab * #100
.clline
ld e,(hl)
inc h
ld d,(hl)
dec h
ld b,80
.clrlp
ld (de),a
inc de
djnz clrlp
inc l
dec c
jr nz,clline
ret

.hline  ; D = x, E = y, B = width, C = ink
ld a,b
or a
ret z
srl d
push af
.nodecw
ld l,e
ld h,scrtab
ld a,(hl)
inc h
add d
ld h,(hl)
ld l,a
ld a,0
adc h
ld h,a
pop af
jr nc,nofpix
ld a,c
and #55
ld e,a
ld a,(hl)
and #aa
or e
ld (hl),a
inc hl
dec b
ret z
.nofpix
srl b
jr z,endpix
push af
.midpix
ld (hl),c
inc hl
djnz midpix
pop af
ret nc
.endpix
ld a,c
and #aa
ld e,a
ld a,(hl)
and #55
or e
ld (hl),a
ret

.vline ; D = x, E = y, B = height, C = ink
ld a,b
or a
ret z
ld l,e
ld a,#55
srl d
jr nc,leftpix
rra
.leftpix
ld e,a
rrca
and c
ld c,a
ld h,scrtab
ld a,(hl)
inc h
add d
ld h,(hl)
ld l,a
ld a,0
adc h
ld h,a
.nextpix
ld a,(hl)
and e
or c
ld (hl),a
dec b
ret z
ld a,h
add 8
ld h,a
and #38
jr nz,nextpix
ld a,l
add 80
ld l,a
ld a,h
adc #c0
ld h,a
cp 8
jr nz,nextpix
ld h,#40
jr nextpix

.chrowm1
ld b,a
and #f0
ld c,a
rrca:rrca:rrca:rrca
or c
and ly
xor hy
ld (de),a:inc e
ld a,b
and #0f
ld c,a
rlca:rlca:rlca:rlca
or c
and ly
xor hy
ld (de),a
dec e
ret

.m1dig
and #0f
jr nz,notm10
ld a,lx
jr m1ch
.notm10
ld lx,'0'
add #30

.m1ch
push de
push hl
ld l,a
ld h,7
add hl,hl:add hl,hl:add hl,hl
.dochm1
ld a,(hl):inc l
call chrowm1
ld a,d
add 8
ld d,a
and #38
jr nz,dochm1
.exitdh
pop hl
pop de
inc de
inc de
ret

.m1dh
push de
push hl
ld l,a
ld h,7
add hl,hl:add hl,hl:add hl,hl
.dodhm1
ld a,(hl)
call chrowm1
ld a,d
add 8
ld d,a
ld a,(hl):inc l
call chrowm1
ld a,l
and 7
jr z,exitdh
ld a,d
add 8
ld d,a
and #38
jr nz,dodhm1
ld a,e
add 80
ld e,a
ld a,d
adc #c0
ld d,a
cp 8
jr nz,dodhm1
ld d,#40
jr dodhm1

.printm1
ld a,(hl)
inc hl
or a
ret z
call m1ch
jr printm1

.printm1dh
ld a,(hl)
inc hl
or a
ret z
call m1dh
jr printm1dh

.chbyte
ld a,c
rl b
jr c,isleft
and #55
.isleft
rl b
jr c,isright
and #aa
.isright
ld (de),a
inc de
ret

.printchar
push hl
push de
ld l,a
ld h,7
add hl,hl:add hl,hl:add hl,hl
.linelp
push de
ld b,(hl)
inc hl
call chbyte
call chbyte
call chbyte
call chbyte
pop de
ld a,l
and 7
jr z,exitch
ld a,d
add 8
ld d,a
and #38
jr nz,linelp
ld a,e
add 80
ld e,a
ld a,d
adc #c0
ld d,a
cp 8
jr nz,linelp
ld d,#40
jr linelp
.exitch
pop de
pop hl
inc de:inc de:inc de:inc de
ret

.print  ; DE = screen address, HL = data, C = colour
call kl_l_rom_enable
ld a,(hl)
inc hl
or a
jp z,kl_l_rom_disable
call printchar
jr print

.checkpower
ld a,(powermask)
and c
jr z,drawtilexy
ld a,7

.drawtilexy ; Tile A at D = X, E = Y
and #f
ld b,a
call dexy
ld a,b

.drawtile ; Tile A at DE - 12 rows high (A is 0 - 15)
add a
add tiles
ld l,a
ld a,tiles / 256
adc 0
ld h,a
ld a,(hl)
inc hl
ld h,(hl)
ld l,a
ld bc,#0cff
.tileloop
ld a,d
ldi
ldi
ldi
dec e: dec e: dec e
dec b
ret z
add 8
ld d,a
and #38
jr nz,tileloop
ld a,e
add 80
ld e,a
ld a,d
adc #c0
ld d,a
cp 8
jr nz,tileloop
ld d,#40
jr tileloop

.drawchar ; Draw character at HL to DE
ld bc,32
.charloop
ld a,d
ldi:ldi:ldi:ldi
ret po
dec e:dec e:dec e: dec e
add 8
ld d,a
and #38
jr nz,charloop
ld a,e
add 80
ld e,a
ld a,d
adc #c0
ld d,a
cp 8
jr nz,charloop
ld d,#40
jr charloop

;.convert_sprites
;ld b,#28 - #23
;ld hl,sprite23
;ld de,#c000
;.convsprlp1
;push bc
;ld c,(hl)
;inc hl
;ld b,(hl)
;inc hl
;db #dd:;ld h,2
;db #dd:;ld l,0
;db #fd:;ld h,0
;.loopy
;push hl
;.loopx
;ld a,(hl)
;ld (de),a
;inc de
;ld a,l
;add 8
;ld l,a
;ld a,h
;adc 0
;ld h,a
;db #dd:;ld a,l
;cp b
;jr z,exitcx
;add 8
;db #dd:;ld l,a
;jr loopx
;.exitcx
;db #dd:;ld l,0
;db #fd:;inc h
;db #fd:;ld a,h
;and 7
;jr nz,dopop
;ld a,l
;sub 8
;ld l,a
;ld a,h
;sbc 0
;ld h,a
;pop af
;jr nopop
;.dopop
;pop hl
;.nopop
;inc hl
;db #dd:;inc h
;ld a,c
;dec c
;or a
;jr nz,loopy
;.adjx
;db #dd:;ld a,h
;and 7
;jr z,exitcy
;inc hl
;db #dd:;inc h
;jr adjx
;.exitcy
;pop bc
;djnz convsprlp1
;ret

.crtc
db 6,32,7,35,12,#0c,13,64,0

.scoretext
db "Score:",0

.readytext
db "READY!",0

.titletext
db "Acornsoft Pacman",0
db "KEYS:",0
db "Z - LEFT",0
db "X - RIGHT",0
db "' - UP",0
db "/ - DOWN",0
db "Copyright (C) Acornsoft 1982",0
db "PRESS ANY KEY TO START",0

.congrats
db "Congratulations!!",0
db "Your score is in the Top Eight.",0
db "Please enter your name:",0

.scorestext
db "Scores",0
.presstext
db "Press SPACE BAR to play again",0

.end1 equ $ and #ff
if end1
ds 256 - end1
endif

.notepitch ; Page aligned
db #F8, #F1, #EA, #E3, #DB, #D5, #CE, #C8, #C1, #BB, #B5, #AF, #A7, #A1, #9B, #95
db #90, #8A, #85, #7F, #79, #74, #6F, #6A, #64, #5F, #5A, #55, #50, #4B, #47, #42
db #3D, #39, #34, #30, #2B, #27, #23, #1F, #1A, #16, #12, #0E, #0B, #07, #04, #00  ; To here is +#100
db #FC, #F8, #F5, #F1, #ED, #EA, #E7, #E4, #E0, #DD, #DA, #D7, #D3, #D0, #CD, #CA
db #C8, #C5, #C2, #BF, #BC, #BA, #B7, #B5, #B2, #AF, #AD, #AA, #A8, #A5, #A3, #A1
db #9E, #9C, #9A, #98, #95, #93, #91, #8F, #8D, #8B, #89, #87, #85, #83, #82, #80
db #7E, #7C, #7A, #78, #76, #75, #73, #72, #70, #6E, #6D, #6B, #69, #68, #66, #65
db #64, #62, #61, #5F, #5E, #5D, #5B, #5A, #59, #57, #56, #55, #54, #52, #51, #50
db #4F, #4E, #4D, #4C, #4A, #49, #48, #47, #46, #45, #44, #43, #42, #41, #41, #40
db #3F, #3E, #3D, #3C, #3B, #3A, #39, #39, #38, #37, #36, #35, #34, #34, #33, #32
db #32, #31, #30, #2F, #2F, #2E, #2D, #2D, #2C, #2B, #2B, #2A, #2A, #29, #28, #28
db #27, #27, #26, #26, #25, #24, #24, #23, #23, #22, #22, #21, #21, #20, #20, #20
db #1F, #1F, #1E, #1E, #1D, #1D, #1C, #1C, #1C, #1B, #1B, #1A, #1A, #1A, #19, #19
db #19, #18, #18, #17, #17, #17, #16, #16, #16, #15, #15, #15, #15, #14, #14, #14
db #13, #13, #13, #13, #12, #12, #12, #11, #11, #11, #11, #10, #10, #10, #10, #10
db #0F, #0F, #0F, #0F, #0E, #0E, #0E, #0E, #0E, #0D, #0D, #0D, #0D, #0D, #0C, #0C

.char0   ; Page aligned
db #00,#3f,#3f,#00,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a
db #15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#00

.char1
db #00,#15,#2a,#00,#00,#3f,#2a,#00,#00,#15,#2a,#00,#00,#15,#2a,#00
db #00,#15,#2a,#00,#00,#15,#2a,#00,#00,#15,#2a,#00,#15,#3f,#3f,#2a

.char2
db #00,#3f,#3f,#00,#15,#2a,#15,#2a,#00,#00,#15,#2a,#00,#00,#3f,#00
db #00,#15,#2a,#00,#00,#3f,#00,#00,#15,#2a,#00,#00,#15,#3f,#3f,#2a

.char3
db #00,#3f,#3f,#00,#15,#2a,#15,#2a,#00,#00,#15,#2a,#00,#15,#3f,#00
db #00,#00,#15,#2a,#00,#00,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#00

.char4
db #00,#00,#3f,#00,#00,#15,#3f,#00,#00,#3f,#3f,#00,#15,#2a,#3f,#00
db #15,#3f,#3f,#2a,#00,#00,#3f,#00,#00,#00,#3f,#00,#00,#00,#3f,#00

.char5
db #15,#3f,#3f,#2a,#15,#2a,#00,#00,#15,#2a,#00,#00,#15,#3f,#3f,#00
db #00,#00,#15,#2a,#00,#00,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#00

.char6
db #00,#15,#3f,#00,#00,#3f,#00,#00,#15,#2a,#00,#00,#15,#3f,#3f,#00
db #15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#00

.char7
db #15,#3f,#3f,#2a,#15,#00,#15,#2a,#00,#00,#15,#2a,#00,#00,#3f,#00
db #00,#15,#2a,#00,#00,#3f,#00,#00,#00,#3f,#00,#00,#00,#3f,#00,#00

.char8
db #00,#3f,#3f,#00,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#00
db #15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#00

.char9
db #00,#3f,#3f,#00,#15,#2a,#15,#2a,#15,#2a,#15,#2a,#00,#3f,#3f,#2a
db #00,#00,#15,#2a,#00,#00,#15,#2a,#00,#00,#3f,#00,#00,#3f,#2a,#00

list
.tilemap
nolist
db #FF, #FF, #FF, #FF, #FF, #FF, #5F, #FF, #FF, #FF, #FF, #FF, #F0
db #F6, #AC, #F6, #AE, #AA, #8F, #1F, #2A, #AE, #AC, #F6, #AC, #F0
db #75, #05, #F5, #05, #FF, #FF, #FF, #FF, #F5, #05, #F5, #05, #70
db #F3, #A9, #F3, #A9, #F2, #AA, #EA, #A8, #F3, #A9, #F3, #A9, #F0
db #FF, #FF, #FF, #FF, #FF, #FF, #5F, #FF, #FF, #FF, #FF, #FF, #F0
db #F2, #A8, #F2, #AE, #AA, #80, #10, #2A, #AE, #A8, #F2, #A8, #F0
db #FF, #FF, #FF, #F5, #00, #00, #00, #00, #05, #FF, #FF, #FF, #F0
db #AA, #AA, #AC, #F5, #06, #A8, #02, #AC, #05, #F6, #AA, #AA, #A0
db #AA, #AA, #A9, #F1, #05, #00, #00, #05, #01, #F3, #AA, #AA, #A0
db #00, #00, #00, #F0, #05, #00, #00, #05, #00, #F0, #00, #00, #00
db #AA, #AA, #AC, #F4, #05, #00, #00, #05, #04, #F6, #AA, #AA, #A0
db #AA, #AA, #A9, #F1, #03, #AA, #EA, #A9, #01, #F3, #AA, #AA, #A0
db #FF, #FF, #FF, #FF, #FF, #FF, #5F, #FF, #FF, #FF, #FF, #FF, #F0
db #F2, #AC, #F2, #AA, #AA, #8F, #1F, #2A, #AA, #A8, #F6, #A8, #F0
db #7F, #F5, #FF, #FF, #FF, #FF, #0F, #FF, #FF, #FF, #F5, #FF, #70
db #A8, #F3, #A8, #F4, #F2, #AA, #EA, #A8, #F4, #F2, #A9, #F2, #A0
db #FF, #FF, #FF, #F5, #FF, #FF, #5F, #FF, #F5, #FF, #FF, #FF, #F0
db #F2, #AA, #AA, #AB, #AA, #8F, #1F, #2A, #AB, #AA, #AA, #A8, #F0
db #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #F0

list
.tile0
nolist
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.tile1
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40
db #00,#c0,#c0,#00,#40,#80,#00,#00,#00,#00,#00,#00

.tile2
db #00,#00,#00,#00,#00,#00,#00,#40,#c0,#00,#c0,#c0
db #00,#80,#00,#00,#80,#00,#00,#80,#00,#00,#80,#00
db #00,#c0,#c0,#00,#40,#c0,#00,#00,#00,#00,#00,#00

.tile3
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#00
db #00,#80,#00,#00,#80,#00,#00,#80,#00,#00,#80,#00
db #00,#c0,#c0,#00,#40,#c0,#00,#00,#00,#00,#00,#00

.tile4
db #00,#00,#00,#00,#00,#00,#00,#40,#80,#00,#c0,#c0
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40

.tile5
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40
db #00,#80,#40,#00,#80,#40,#00,#80,#40,#00,#80,#40

.tile6
db #00,#00,#00,#00,#00,#00,#00,#40,#c0,#00,#c0,#c0
db #00,#80,#00,#00,#80,#00,#00,#80,#00,#00,#80,#00
db #00,#80,#00,#00,#80,#40,#00,#80,#40,#00,#80,#40

.tile7
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#14,#00
db #00,#3c,#28,#00,#3c,#28,#14,#3c,#3c,#00,#3c,#28
db #00,#3c,#28,#00,#14,#00,#00,#00,#00,#00,#00,#00

.tile8
db #00,#00,#00,#00,#00,#00,#c0,#c0,#80,#c0,#c0,#c0
db #00,#00,#40,#00,#00,#40,#00,#00,#40,#00,#00,#40
db #c0,#c0,#c0,#c0,#c0,#80,#00,#00,#00,#00,#00,#00

.tile9
db #00,#80,#40,#00,#80,#40,#c0,#80,#40,#c0,#00,#40
db #00,#00,#40,#00,#00,#40,#00,#00,#40,#00,#00,#40
db #c0,#c0,#c0,#c0,#c0,#80,#00,#00,#00,#00,#00,#00

.tilea
db #00,#00,#00,#00,#00,#00,#c0,#c0,#c0,#c0,#c0,#c0
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #c0,#c0,#c0,#c0,#c0,#c0,#00,#00,#00,#00,#00,#00

.tileb
db #00,#80,#40,#00,#80,#40,#c0,#80,#40,#c0,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #c0,#c0,#c0,#c0,#c0,#c0,#00,#00,#00,#00,#00,#00

.tilec
db #00,#00,#00,#00,#00,#00,#c0,#c0,#80,#c0,#c0,#c0
db #00,#00,#40,#00,#00,#40,#00,#00,#40,#00,#00,#40
db #c0,#00,#40,#c0,#80,#40,#00,#80,#40,#00,#80,#40

.tiled
db #00,#80,#40,#00,#80,#40,#c0,#80,#40,#c0,#00,#40
db #00,#00,#40,#00,#00,#40,#00,#00,#40,#00,#00,#40
db #c0,#00,#40,#c0,#80,#40,#00,#80,#40,#00,#80,#40

.tilee
db #00,#00,#00,#00,#00,#00,#c0,#c0,#c0,#c0,#c0,#c0
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #c0,#00,#00,#c0,#80,#40,#00,#80,#40,#00,#80,#40

.tilef
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#04,#00,#00,#04,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.tiles
dw tile0, tile1, tile2, tile3, tile4, tile5, tile6, tile7
dw tile8, tile9, tilea, tileb, tilec, tiled, tilee, tilef

.spr0
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #ff,#ff,#ff,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff
db #00,#ff,#00,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#aa,#aa,#aa,#aa,#aa,#aa,#aa,#aa

.spr1
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #ff,#ff,#ff,#ff,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00
db #ff,#00,#ff,#00,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#55,#55,#55,#55,#55,#55,#55,#55

.spr2
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#aa,#aa,#aa,#aa,#aa,#aa,#aa,#aa

.spr3
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#aa,#55,#aa,#55,#aa,#55,#aa,#55
db #aa,#55,#aa,#55,#aa,#55,#aa,#55,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#55,#55,#55,#55,#55,#55,#55,#55

.spr4
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #ff,#ff,#ff,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff
db #00,#ff,#00,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#55,#55,#55,#55,#55,#55,#55,#55

.spr5
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #ff,#ff,#ff,#ff,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00,#ff,#00
db #ff,#00,#ff,#00,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#aa,#aa,#aa,#aa,#aa,#aa,#aa,#aa

.spr6
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55,#aa,#55
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#55,#55,#55,#55,#55,#55,#55,#55

.spr7
db 16,4
db #00,#00,#00,#00,#00,#55,#aa,#00,#00,#ff,#ff,#00,#55,#ff,#ff,#aa
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#aa,#55,#aa,#55,#aa,#55,#aa,#55
db #aa,#55,#aa,#55,#aa,#55,#aa,#55,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#aa,#aa,#aa,#aa,#aa,#aa,#aa,#aa

.spr8
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#3f,#00,#3f,#00,#35,#00,#35,#00,#35,#00,#35,#00
db #3f,#00,#3f,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.spr9
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#3f,#00,#3f,#00,#3a,#00,#3a,#00,#3a,#00,#3a
db #00,#3f,#00,#3f,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.spra
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #15,#20,#10,#2a,#15,#20,#10,#2a,#15,#2a,#15,#2a,#15,#2a,#15,#2a
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.sprb
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#15,#2a,#15,#2a,#15,#2a,#15,#2a
db #15,#20,#10,#2a,#15,#20,#10,#2a,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.sprc
db 16,4
db #00,#00,#00,#00,#00,#50,#a0,#00,#00,#f0,#f0,#00,#50,#f0,#f0,#a0
db #f0,#f0,#f0,#f0,#f0,#f2,#f1,#f0,#f0,#f2,#f1,#f0,#f0,#f0,#f0,#f0
db #f0,#f0,#f0,#f0,#f0,#f0,#f0,#f0,#f0,#f2,#f2,#f2,#f1,#f1,#f1,#f0
db #f0,#f0,#f0,#f0,#f0,#f0,#f0,#f0,#50,#50,#50,#50,#50,#50,#50,#50

.sprd
db 16,4
db #00,#00,#00,#00,#00,#50,#a0,#00,#00,#f0,#f0,#00,#50,#f0,#f0,#a0
db #f0,#f0,#f0,#f0,#f0,#f2,#f1,#f0,#f0,#f2,#f1,#f0,#f0,#f0,#f0,#f0
db #f0,#f0,#f0,#f0,#f0,#f0,#f0,#f0,#f0,#f2,#f2,#f2,#f1,#f1,#f1,#f0
db #f0,#f0,#f0,#f0,#f0,#f0,#f0,#f0,#a0,#a0,#a0,#a0,#a0,#a0,#a0,#a0

.spre
db 16,4
db #0c,#00,#55,#08,#55,#08,#0c,#00,#00,#55,#08,#00,#00,#06,#03,#00
db #01,#2b,#2b,#02,#03,#03,#03,#03,#03,#2b,#17,#17,#2b,#03,#03,#03
db #03,#2b,#2b,#2b,#01,#03,#03,#03,#15,#17,#03,#2a,#01,#03,#03,#02
db #00,#17,#17,#00,#00,#03,#03,#00,#00,#01,#2a,#00,#00,#01,#02,#00

.sprf
db 16,4
db #00,#00,#55,#08,#00,#00,#0c,#00,#00,#00,#08,#00,#00,#00,#08,#00
db #00,#55,#0c,#00,#00,#55,#55,#00,#00,#0c,#55,#00,#00,#08,#55,#00
db #00,#08,#03,#02,#01,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#2b
db #03,#2b,#03,#2b,#03,#2b,#01,#02,#01,#02,#00,#00,#00,#00,#00,#00

.spr10
db 16,4
db #00,#00,#00,#aa,#00,#00,#55,#ff,#00,#05,#ff,#ff,#00,#01,#00,#55
db #00,#01,#00,#00,#55,#03,#01,#02,#5f,#ff,#03,#03,#ab,#ab,#0e,#03
db #ff,#5f,#03,#03,#5f,#ab,#ab,#03,#ff,#5f,#57,#03,#ab,#ab,#ab,#03
db #5f,#ff,#57,#03,#55,#07,#ab,#02,#55,#ab,#03,#02,#00,#0b,#ab,#00

.spr11
db 16,4
db #55,#08,#00,#00,#00,#55,#00,#00,#00,#00,#08,#00,#01,#55,#0c,#02
db #03,#03,#09,#03,#17,#03,#03,#03,#17,#03,#03,#03,#17,#03,#03,#03
db #17,#03,#03,#03,#03,#2b,#03,#03,#03,#2b,#03,#03,#01,#2b,#03,#03
db #01,#17,#03,#02,#00,#17,#03,#02,#00,#03,#03,#00,#00,#01,#02,#00

.spr12
db 16,4
db #00,#ff,#aa,#ff,#00,#55,#ff,#aa,#00,#00,#55,#00,#00,#11,#76,#00
db #00,#b9,#b9,#22,#11,#33,#76,#22,#54,#76,#33,#22,#11,#33,#33,#a8
db #33,#33,#b9,#22,#b9,#b9,#33,#00,#33,#33,#76,#00,#76,#76,#22,#00
db #33,#33,#00,#00,#b9,#a8,#00,#00,#11,#00,#00,#00,#00,#00,#00,#00

.spr13
db 16,4
db #00,#55,#00,#00,#00,#ff,#aa,#00,#00,#ff,#aa,#00,#55,#ff,#ff,#00
db #55,#ff,#ff,#00,#55,#ff,#ff,#00,#ff,#ff,#ff,#aa,#ff,#ff,#ff,#aa
db #ff,#ff,#ff,#aa,#00,#00,#00,#00,#ff,#ff,#ff,#aa,#55,#ff,#ff,#00
db #55,#ff,#ff,#00,#02,#55,#00,#00,#01,#03,#02,#00,#00,#00,#03,#02

.spr14
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#00,#00
db #00,#0f,#0a,#00,#00,#0a,#0a,#00,#05,#05,#0f,#00,#05,#05,#0f,#00
db #05,#05,#2f,#00,#05,#05,#2f,#00,#05,#05,#2f,#00,#05,#05,#2f,#00
db #0a,#0f,#1f,#0a,#0f,#0f,#0f,#0a,#00,#05,#00,#00,#00,#00,#00,#00

.spr15
db 16,4
db #55,#08,#0c,#00,#00,#0c,#08,#00,#00,#10,#00,#00,#00,#30,#20,#00
db #10,#30,#30,#00,#10,#32,#30,#00,#30,#32,#30,#20,#30,#31,#30,#20
db #30,#30,#32,#20,#30,#30,#32,#20,#10,#30,#32,#00,#10,#30,#30,#00
db #00,#30,#20,#00,#00,#30,#20,#00,#00,#10,#00,#00,#00,#00,#00,#00

.spr16
db 16,1
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
;db #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF

.spr17
db 4,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
;db #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF, #FF

.spr18
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#0a,#00,#05,#0f,#0f,#00
db #0f,#0f,#0f,#00,#05,#0f,#0f,#0a,#00,#0f,#0f,#0a,#00,#05,#0f,#0a
db #00,#00,#0f,#0a,#00,#05,#0f,#0a,#00,#0f,#0f,#0a,#05,#0f,#0f,#0a
db #0f,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00,#00,#00,#00,#00

.spr19
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#05,#00,#05,#00,#05,#00,#05,#00
db #05,#00,#05,#00,#0f,#00,#05,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a
db #0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a
db #05,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00,#00,#00,#00,#00

.spr1a
db 16,4
db #00,#00,#00,#00,#00,#0f,#0a,#00,#05,#0f,#0f,#00,#05,#0f,#0f,#00
db #0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0a,#0f,#0a
db #0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#00,#05,#0a,#05,#00,#05,#00
db #05,#00,#05,#00,#05,#00,#05,#00,#00,#00,#00,#00,#00,#00,#00,#00

.spr1b
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#0f,#00,#00,#0f,#0f,#0a
db #00,#0f,#0f,#0f,#05,#0f,#0f,#0a,#05,#0f,#0f,#00,#05,#0f,#0a,#00
db #05,#0f,#00,#00,#05,#0f,#0a,#00,#05,#0f,#0f,#00,#05,#0f,#0f,#0a
db #00,#0f,#0f,#0f,#00,#0f,#0f,#0a,#00,#05,#0f,#00,#00,#00,#00,#00

.spr1c
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#0a,#00,#05,#0f,#0f,#00
db #05,#0f,#0f,#00,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#00,#0f,#0f,#0a
db #00,#00,#0f,#0a,#00,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a
db #05,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00,#00,#00,#00,#00

.spr1d
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#0a,#0a,#00,#05,#0a,#0f,#00
db #05,#0a,#0f,#00,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a
db #0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a
db #05,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00,#00,#00,#00,#00

.spr1e
db 16,4
db #00,#00,#00,#00,#00,#0f,#0a,#00,#05,#0f,#0f,#00,#05,#0f,#0f,#00
db #0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a,#0f,#0f,#0f,#0a
db #0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#05,#0a,#0f,#00
db #05,#0a,#0f,#00,#00,#0a,#0a,#00,#00,#00,#00,#00,#00,#00,#00,#00

.spr1f
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#0f,#00,#00,#0f,#0f,#0a
db #00,#0f,#0f,#0a,#05,#0f,#0f,#0f,#05,#0f,#0f,#0f,#05,#0f,#0f,#00
db #05,#0f,#00,#00,#05,#0f,#0f,#00,#05,#0f,#0f,#0f,#05,#0f,#0f,#0f
db #00,#0f,#0f,#0a,#00,#0f,#0f,#0a,#00,#05,#0f,#00,#00,#00,#00,#00

.spr20
db 1,1
db #00

.spr21
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.spr22
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

.spr23
db 16,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#00,#00,#00,#0a,#00,#00,#0a,#0a,#00,#00,#0a,#0f,#00,#05,#0a
db #0f,#00,#05,#0a,#0f,#00,#05,#0a,#0f,#0a,#0f,#0a,#0f,#0a,#0f,#0a
db #0f,#0f,#0f,#0a,#05,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00

.spr24
db 8,4
db #00,#00,#00,#00,#0a,#00,#00,#0a,#0a,#00,#00,#0a,#0f,#00,#05,#0a
db #0f,#0a,#0f,#0a,#05,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00

.spr25
db 8,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #0f,#0a,#0f,#0a,#05,#0f,#0f,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00

.spr26
db 8,4
db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
db #00,#0a,#0a,#00,#05,#0f,#0f,#00,#00,#0f,#0a,#00,#00,#05,#00,#00

.spr27
db 16,4
db #0a,#00,#0a,#05,#0a,#00,#0a,#05,#05,#00,#0a,#0a,#05,#05,#00,#0a
db #00,#0a,#05,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#0a,#05,#0f
db #0f,#0a,#05,#0f,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0a,#05,#00
db #05,#00,#0a,#0a,#05,#05,#00,#0a,#0a,#05,#00,#05,#0a,#05,#00,#05

.sprites
dw spr0, spr1, spr2, spr3, spr4, spr5, spr6, spr7
dw spr8+2, spr9+2, spra+2, sprb+2, sprc, sprd, spre, sprf
dw spr10, spr11, spr12, spr13, spr14, spr15, spr16, spr17
dw spr18, spr19, spr1a, spr1b, spr1c, spr1d, spr1e, spr1f
dw spr20, spr21+2, spr22, spr23, spr24, spr25, spr26, spr27

.fruits
db #0F, #0E, #10, #10, #11, #11, #12, #12
db #15, #15, #14, #14, #14, #13, #13, #13, #13

.eyemoves
db 0, 1, 1, 0, 0, -1, -1, 0

.ghdirmasks
db #05, #55, #55, #33, #FF, #FF, #C0
db #00, #00, #00, #00, #00, #00, #00
db #54, #54, #0F, #C5, #40, #FC, #F0
db #00, #00, #00, #00, #00, #00, #00
db #0F, #0D, #55, #33, #FF, #41, #40
db #00, #00, #00, #00, #00, #00, #00
db #55, #54, #4F, #C5, #4C, #FF, #F0
db #00, #00, #00, #00, #00, #00, #00
db #00, #00, #00, #20, #00, #00, #00
db #55, #55, #40, #20, #0F, #FF, #F0
db #00, #02, #00, #20, #02, #00, #00
db #00, #02, #00, #20, #02, #00, #00
db #55, #46, #15, #6F, #F2, #CF, #F0
db #A0, #00, #00, #88, #00, #00, #20
db #55, #55, #55, #8B, #FF, #FF, #F0
db #A0, #20, #20, #00, #20, #20, #20
db #A0, #20, #2F, #F5, #60, #20, #20
db #A0, #20, #00, #88, #00, #20, #20
db #A5, #65, #55, #8B, #FF, #EF, #E0

.bases
db #0a, #09, #0b, #08

.ghdirs
db #03, #03, #02, #03, #03, #03, #03, #00, #03
db #03, #03, #00, #00, #00, #03, #02, #00, #01

.fscores   ; Scores for fruit
dw #0030, #0010, #0050, #0070, #0100, #0500, #0300, #0200, #0500 ; Not sure if last used 

.tune0
db #62, #92, #7E, #72, #92, #7C, #7D, #72, #73, #71
db #66, #96, #82, #76, #96, #80, #81, #76, #77, #75
db #62, #92, #7E, #72, #92, #7C, #7D, #72, #73, #71
db #6C, #70, #74, #77, #78, #7C, #80, #83, #84, #88, #8C, #BF, #92
.tune0e

.score      ds 3
.score2     ds 6

.fruit      db 0
.palcount   db 0
.palblue    db 0
.fruitcount dw 0

.level      db 0
.numdots    db #ce
.powermask  db 0
.powercount db 0
.palwhite   db 26

.powertime  db #af
.altghspr   db 0
.ghostscore db 0
.unk4a      db 0
.ready      db 0

.lives      db 0

.ghostsize  equ 13

.ghosty     equ 0
.ghostx     equ 1
.ghostvuln  equ 2
.ghostdx    equ 3
.ghosteadd  equ 4
.ghostmask  equ 5
.ghostbase  equ 6
.ghostspr   equ 7
.ghostdy    equ 8
.ghostv0    equ 9   ; 51..54
.ghostv1    equ 10
.ghostv2    equ 11
.ghostv3    equ 12  ; 59..5C

.ghostvars  ds 4 * ghostsize
.pacpos     ds ghostsize
.pacy       equ pacpos
.pacx       equ pacpos + 1
.pacvuln    equ pacpos + ghostvuln
.pacdx      equ pacpos + ghostdx
.paceadd    equ pacpos + ghosteadd
.pacmask    equ pacpos + ghostmask
.pacbase    equ pacpos + ghostbase
.pacspr     equ pacpos + ghostspr
.pacdy      equ pacpos + ghostdy

.ghostpos0 equ ghostvars
.ghostpos1 equ ghostpos0 + ghostsize
.ghostpos2 equ ghostpos1 + ghostsize
.ghostpos3 equ ghostpos2 + ghostsize

.deathnote db 0
.firsttime db 0
.lasttime  db 0

.sblock
.schan
db 0        ; Channel
.senv
db 0        ; Env
.sent
db 0        ; Ent
.stone
dw 0        ; Tone period
.snoise
db 0        ; Noise period
.svol
db 0        ; Initial Amplitude
.sduration
dw 0        ; Duration

.ent1 db 3,18,10,1,18,3,1,84,-2,1
.ent2 db #82,16,-4,1,16,4,2
.ent3 db #82,16,-3,1,16,3,2
.ent4 db #82,16,-2,1,16,2,2
.ent5 db #82,16,-1,1,16,1,2
.env2 db 2,2,8,3,16,-1,6

.timertoggle db 0
.tickcount   dw 0
.timercount  dw 0

.dots
ds 64

.intno
db 0

.buff
ds 20

.high1
db #00,#01,#00:ds 20
.high2
db #00,#01,#00:ds 20
.high3
db #00,#01,#00:ds 20
.high4
db #00,#01,#00:ds 20
.high5
db #00,#01,#00:ds 20
.high6
db #00,#01,#00:ds 20
.high7
db #00,#01,#00:ds 20
.high8
db #00,#01,#00:ds 20

.ticker
ds 9

.scrtab equ #44
.scrend equ #46

list
.end2