; TILEMAPCONF PARA PHANTOMAS TALES #1: MARSPORT / CPC
; (C) 2009 THE MOJON TWINS

	XLIB TileMapConf
	
	XDEF tiles
	XDEF pantalla_juego
	XDEF tiles_tocados
	XDEF posiciones_pantalla
	XDEF posiciones_super_buffer
	
	XDEF posicion_inicial_area_visible
	XDEF posicion_inicial_superbuffer
	XDEF ancho_pantalla_bytes
	XDEF alto_pantalla_bytes
	XDEF ancho_pantalla_bytes_visible
	
	XDEF tile11
	XDEF _tile_0

	XDEF mascara1
	XDEF mascara2
	
	; Voy a definir como mscara de los sprites el color 2
	
	; 0: $00, $00
	; 1: $80, $40
	; 2: $04, $08
	; 3: $44, $88
	; 4: $10, $20
	; 5: $50, $A0
	; 6: $14, $28
	; 7: $54, $A8
	; 8: $01, $02
	; 9: $41, $82
	; 10: $05, $0A
	; 11: $45, $8A
	; 12: $11, $22
	
	;defc mascara1 = $05 ;
	;defc mascara2 = $0A ;
	defc mascara1 = $45;
	defc mascara2 = $8A;
	
; VALORES QUE DEFINEN EL BUFFER Y LA PANTALLA

	defc posicion_inicial_area_visible = $f0aa
	defc posicion_inicial_superbuffer = $100
	
	defc T_WIDTH = 	30 ;32 ;28 ;32 ;28 ;16			;max=40		;dimensiones de la pantalla en tiles
	defc T_HEIGHT = 20 ;16							;max=20
		
	defc ancho_pantalla_bytes = 2*T_WIDTH ; 2*T_WIDTH;		; El ancho de pantalla influye determinantemente en 
															; numerosas rutinas que hay que actualizar si se cambia
															; OJO con el modo
	defc alto_pantalla_bytes = 8*T_HEIGHT ;
	
	defc ancho_pantalla_bytes_visible = 2*T_WIDTH ;32  ; 64;		;dentro del area definida, cuanto se debe mostrar. 2*T_WIDTH

;El tamao del buffer es ancho_pantalla_bytes*alto_pantalla_bytes


.TileMapConf
;Con la definicin del mapeado hay que tener en cuenta que las coordenadas son:
;ANCHO=64 bytes (128 pixels en modo 0)
;ALTO=128 pixels

;el mximo que entra en el CPC es 20 lneas
;SI NO SE VAN A USAR TODAS LAS LINEAS, PARA AHORRA MEMORIA ES INTERESANTE COMENTARLAS

.posiciones_pantalla		;Posiciones en las que se dibujan los tiles
	defw posicion_inicial_area_visible+$50*0
	defw posicion_inicial_area_visible+$50*1  
	defw posicion_inicial_area_visible+$50*2
	defw posicion_inicial_area_visible+$50*3
	defw posicion_inicial_area_visible+$50*4
	defw posicion_inicial_area_visible+$50*5 
	defw posicion_inicial_area_visible+$50*6 
	defw posicion_inicial_area_visible+$50*7 
	defw posicion_inicial_area_visible+$50*8 
	defw posicion_inicial_area_visible+$50*9 
	defw posicion_inicial_area_visible+$50*10 
	defw posicion_inicial_area_visible+$50*11 
	defw posicion_inicial_area_visible+$50*12 
	defw posicion_inicial_area_visible+$50*13 
	defw posicion_inicial_area_visible+$50*14 
	defw posicion_inicial_area_visible+$50*15
	defw posicion_inicial_area_visible+$50*16
	defw posicion_inicial_area_visible+$50*17
	defw posicion_inicial_area_visible+$50*18
	defw posicion_inicial_area_visible+$50*19

.posiciones_super_buffer	;muestra el inicio de cada lnea (son 10 tiles de 8x16 de alto)

	;defw $1000, $1200, $1400, $1600, $1800, $1a00, $1c00, $1e00, $2000, $2200, $2400, $2600, $2800, $2a00, $2c00, $2f00
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*0
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*1
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*2
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*3
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*4
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*5
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*6
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*7
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*8
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*9
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*10
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*11
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*12
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*13
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*14
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*15
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*16
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*17
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*18
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*19
	
	;defw $1000, $1480, $1900, $1d80, $2200, $2680, $2b00, $2f80, $3400, $3880
	
;Rutinas para transferir bloques independientes a la pantalla

;Se busca el subbloque de 8x8 correspondiente a las coordenadas x,y
;el bloque se calcula dividiendo la coordenada x /8

.pantalla_actual 
	defw 0

.pantalla_juego  ;en tiles
	defs T_WIDTH*T_HEIGHT
	defb $FF	;Este byte es importante, marca el fin de la pantalla.

.tiles_tocados defs 150 ;150	;cuando un tile es tocado, se marca en esta tabla para luego restaurarlo. Es una tabla sin duplicados.

.tiles ;Son de 2x8 bytes
._tiles

._tile_0

._tile_0_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_1

._tile_1_DATA
defb $0, $0
defb $11, $EC
defb $11, $EC
defb $11, $EC
defb $33, $C8
defb $0, $0
defb $33, $C8
defb $0, $0
._tile_2

._tile_2_DATA
defb $0, $0
defb $76, $FE
defb $76, $FE
defb $76, $FE
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_3

._tile_3_DATA
defb $0, $0
defb $76, $FE
defb $77, $FE
defb $76, $FE
defb $FD, $EC
defb $FF, $EC
defb $FD, $EC
defb $0, $0
._tile_4

._tile_4_DATA
defb $0, $0
defb $11, $FE
defb $33, $D9
defb $77, $EC
defb $77, $80
defb $FF, $C8
defb $77, $B2
defb $33, $EC
._tile_5

._tile_5_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $64, $FE
defb $33, $C8
defb $77, $80
defb $FE, $64
defb $0, $0
._tile_6

._tile_6_DATA
defb $0, $0
defb $33, $C8
defb $76, $C8
defb $33, $C8
defb $FD, $C8
defb $FD, $80
defb $77, $C8
defb $0, $0
._tile_7

._tile_7_DATA
defb $0, $0
defb $77, $80
defb $77, $80
defb $77, $80
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_8

._tile_8_DATA
defb $0, $0
defb $33, $C8
defb $77, $E4
defb $77, $80
defb $FE, $0
defb $FE, $C8
defb $77, $80
defb $0, $0
._tile_9

._tile_9_DATA
defb $0, $0
defb $33, $C8
defb $75, $EC
defb $11, $EC
defb $33, $C8
defb $FB, $C8
defb $77, $80
defb $0, $0
._tile_10

._tile_10_DATA
defb $0, $0
defb $0, $0
defb $76, $76
defb $33, $EC
defb $33, $80
defb $77, $C8
defb $EC, $EC
defb $0, $0
._tile_11

._tile_11_DATA
defb $0, $0
defb $11, $EC
defb $11, $EC
defb $33, $FE
defb $77, $EC
defb $33, $C8
defb $33, $C8
defb $0, $0
._tile_12

._tile_12_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $77, $80
defb $77, $80
defb $0, $0
._tile_13

._tile_13_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $77, $FE
defb $FF, $EC
defb $0, $0
defb $0, $0
defb $0, $0
._tile_14

._tile_14_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $33, $C8
defb $33, $C8
defb $77, $80
._tile_15

._tile_15_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $FE
defb $33, $C8
defb $77, $80
defb $FE, $0
defb $0, $0
._tile_16

._tile_16_DATA
defb $0, $0
defb $33, $EC
defb $76, $FE
defb $76, $FE
defb $FD, $EC
defb $FD, $EC
defb $77, $C8
defb $0, $0
._tile_17

._tile_17_DATA
defb $0, $0
defb $33, $EC
defb $11, $EC
defb $11, $EC
defb $33, $C8
defb $33, $C8
defb $33, $C8
defb $0, $0
._tile_18

._tile_18_DATA
defb $0, $0
defb $33, $EC
defb $64, $FE
defb $0, $FE
defb $77, $C8
defb $FE, $0
defb $FF, $EC
defb $0, $0
._tile_19

._tile_19_DATA
defb $0, $0
defb $33, $EC
defb $64, $FE
defb $11, $FE
defb $11, $EC
defb $D9, $EC
defb $77, $C8
defb $0, $0
._tile_20

._tile_20_DATA
defb $0, $0
defb $11, $FE
defb $33, $FE
defb $76, $FE
defb $FF, $EC
defb $11, $EC
defb $11, $EC
defb $0, $0
._tile_21

._tile_21_DATA
defb $0, $0
defb $77, $FE
defb $77, $80
defb $77, $80
defb $FF, $EC
defb $11, $EC
defb $FF, $C8
defb $0, $0
._tile_22

._tile_22_DATA
defb $0, $0
defb $33, $EC
defb $77, $80
defb $77, $EC
defb $FE, $EC
defb $FE, $EC
defb $77, $C8
defb $0, $0
._tile_23

._tile_23_DATA
defb $0, $0
defb $77, $FE
defb $0, $FE
defb $0, $FE
defb $33, $C8
defb $33, $C8
defb $33, $C8
defb $0, $0
._tile_24

._tile_24_DATA
defb $0, $0
defb $33, $EC
defb $76, $FE
defb $76, $FE
defb $77, $C8
defb $FD, $EC
defb $77, $C8
defb $0, $0
._tile_25

._tile_25_DATA
defb $0, $0
defb $33, $EC
defb $76, $FE
defb $76, $FE
defb $77, $EC
defb $11, $EC
defb $77, $C8
defb $0, $0
._tile_26

._tile_26_DATA
defb $0, $0
defb $33, $C8
defb $33, $C8
defb $0, $0
defb $0, $0
defb $77, $80
defb $77, $80
defb $0, $0
._tile_27

._tile_27_DATA
defb $0, $0
defb $33, $C8
defb $33, $C8
defb $0, $0
defb $0, $0
defb $77, $80
defb $77, $80
defb $FE, $0
._tile_28

._tile_28_DATA
defb $0, $0
defb $11, $EC
defb $33, $C8
defb $77, $80
defb $77, $80
defb $33, $C8
defb $0, $0
defb $0, $0
._tile_29

._tile_29_DATA
defb $0, $0
defb $77, $FE
defb $77, $FE
defb $0, $0
defb $0, $0
defb $FF, $EC
defb $FF, $EC
defb $0, $0
._tile_30

._tile_30_DATA
defb $0, $0
defb $77, $80
defb $33, $C8
defb $11, $EC
defb $77, $80
defb $FE, $0
defb $0, $0
defb $0, $0
._tile_31

._tile_31_DATA
defb $0, $0
defb $33, $EC
defb $77, $EE
defb $75, $EE
defb $33, $C8
defb $77, $80
defb $0, $0
defb $77, $80
._tile_32

._tile_32_DATA
defb $0, $0
defb $33, $EC
defb $77, $FE
defb $64, $FE
defb $FB, $EC
defb $C8, $0
defb $77, $C8
defb $0, $0
._tile_33

._tile_33_DATA
defb $0, $0
defb $33, $EC
defb $77, $F6
defb $77, $F6
defb $FF, $EC
defb $FF, $EC
defb $FE, $EC
defb $0, $0
._tile_34

._tile_34_DATA
defb $0, $0
defb $77, $EC
defb $77, $F6
defb $77, $F6
defb $FF, $EC
defb $FE, $EC
defb $FF, $C8
defb $0, $0
._tile_35

._tile_35_DATA
defb $0, $0
defb $33, $EC
defb $77, $B2
defb $77, $80
defb $FE, $0
defb $FE, $64
defb $77, $C8
defb $0, $0
._tile_36

._tile_36_DATA
defb $0, $0
defb $77, $EC
defb $77, $F6
defb $77, $F6
defb $FE, $EC
defb $FE, $EC
defb $FF, $C8
defb $0, $0
._tile_37

._tile_37_DATA
defb $0, $0
defb $33, $EC
defb $77, $B2
defb $77, $C8
defb $FE, $0
defb $FE, $64
defb $77, $C8
defb $0, $0
._tile_38

._tile_38_DATA
defb $0, $0
defb $33, $FE
defb $33, $C8
defb $33, $EC
defb $77, $80
defb $77, $80
defb $77, $80
defb $0, $0
._tile_39

._tile_39_DATA
defb $0, $0
defb $33, $EC
defb $77, $B2
defb $77, $80
defb $FE, $EC
defb $FE, $64
defb $77, $C8
defb $0, $0
._tile_40

._tile_40_DATA
defb $0, $0
defb $77, $F6
defb $77, $F6
defb $77, $FE
defb $FE, $EC
defb $FE, $EC
defb $FE, $EC
defb $0, $0
._tile_41

._tile_41_DATA
defb $0, $0
defb $11, $EC
defb $11, $EC
defb $11, $EC
defb $33, $C8
defb $33, $C8
defb $33, $C8
defb $0, $0
._tile_42

._tile_42_DATA
defb $0, $0
defb $11, $EC
defb $11, $EC
defb $11, $EC
defb $33, $C8
defb $FB, $C8
defb $77, $80
defb $0, $0
._tile_43

._tile_43_DATA
defb $0, $0
defb $77, $B2
defb $77, $E4
defb $77, $C8
defb $FF, $80
defb $FE, $C8
defb $FE, $64
defb $0, $0
._tile_44

._tile_44_DATA
defb $0, $0
defb $77, $80
defb $77, $80
defb $77, $80
defb $FE, $0
defb $FE, $0
defb $FF, $C8
defb $0, $0
._tile_45

._tile_45_DATA
defb $0, $0
defb $33, $EC
defb $76, $FA
defb $76, $FA
defb $FD, $E4
defb $FD, $E4
defb $FD, $E4
defb $0, $0
._tile_46

._tile_46_DATA
defb $0, $0
defb $77, $F6
defb $77, $FE
defb $77, $FE
defb $FF, $EC
defb $FD, $EC
defb $FD, $EC
defb $0, $0
._tile_47

._tile_47_DATA
defb $0, $0
defb $33, $EC
defb $77, $F6
defb $77, $F6
defb $FE, $EC
defb $FE, $EC
defb $77, $C8
defb $0, $0
._tile_48

._tile_48_DATA
defb $0, $0
defb $77, $EC
defb $77, $F6
defb $77, $F6
defb $FF, $EC
defb $FF, $C8
defb $FE, $0
defb $0, $0
._tile_49

._tile_49_DATA
defb $0, $0
defb $33, $EC
defb $77, $F6
defb $77, $F6
defb $FE, $EC
defb $FE, $C8
defb $77, $EC
defb $0, $0
._tile_50

._tile_50_DATA
defb $0, $0
defb $77, $EC
defb $77, $F6
defb $77, $F6
defb $FF, $EC
defb $FF, $C8
defb $FE, $EC
defb $0, $0
._tile_51

._tile_51_DATA
defb $0, $0
defb $33, $EC
defb $77, $B2
defb $77, $EC
defb $77, $EC
defb $D9, $EC
defb $77, $C8
defb $0, $0
._tile_52

._tile_52_DATA
defb $0, $0
defb $77, $FE
defb $11, $EC
defb $11, $EC
defb $33, $C8
defb $33, $C8
defb $33, $C8
defb $0, $0
._tile_53

._tile_53_DATA
defb $0, $0
defb $77, $F6
defb $77, $F6
defb $77, $F6
defb $FE, $EC
defb $FE, $EC
defb $77, $C8
defb $0, $0
._tile_54

._tile_54_DATA
defb $0, $0
defb $77, $F6
defb $77, $F6
defb $77, $F6
defb $FE, $EC
defb $76, $C8
defb $77, $C8
defb $0, $0
._tile_55

._tile_55_DATA
defb $0, $0
defb $75, $F6
defb $75, $F6
defb $75, $F6
defb $FA, $EC
defb $FA, $EC
defb $77, $C8
defb $0, $0
._tile_56

._tile_56_DATA
defb $0, $0
defb $76, $EC
defb $76, $EC
defb $33, $C8
defb $77, $80
defb $FD, $C8
defb $FD, $C8
defb $0, $0
._tile_57

._tile_57_DATA
defb $0, $0
defb $76, $EC
defb $76, $EC
defb $77, $EC
defb $77, $80
defb $77, $80
defb $77, $80
defb $0, $0
._tile_58

._tile_58_DATA
defb $0, $0
defb $77, $FE
defb $0, $FE
defb $11, $EC
defb $77, $80
defb $FE, $0
defb $FF, $EC
defb $0, $0
._tile_59

._tile_59_DATA
defb $0, $0
defb $33, $C8
defb $77, $E4
defb $77, $80
defb $FE, $0
defb $FE, $C8
defb $77, $80
defb $0, $0
._tile_60

._tile_60_DATA
defb $0, $0
defb $77, $80
defb $33, $C8
defb $11, $EC
defb $11, $EC
defb $0, $0
defb $0, $0
defb $0, $0
._tile_61

._tile_61_DATA
defb $0, $0
defb $33, $C8
defb $75, $EC
defb $11, $EC
defb $33, $C8
defb $FB, $C8
defb $77, $80
defb $0, $0
._tile_62

._tile_62_DATA
defb $0, $0
defb $11, $80
defb $33, $C8
defb $76, $EC
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_63

._tile_63_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_64

._tile_64_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_65

._tile_65_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_66

._tile_66_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_67

._tile_67_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_68

._tile_68_DATA
defb $F0, $E0
defb $F, $5A
defb $F, $3C
defb $5A, $5A
defb $F0, $70
defb $2D, $87
defb $1E, $87
defb $A5, $A5
._tile_69

._tile_69_DATA
defb $F0, $E0
defb $1E, $5A
defb $F, $3C
defb $5A, $5A
defb $F0, $70
defb $2D, $87
defb $1E, $87
defb $A5, $A5
._tile_70

._tile_70_DATA
defb $F0, $E0
defb $F, $5A
defb $2D, $3C
defb $5A, $5A
defb $F0, $70
defb $2D, $A5
defb $1E, $87
defb $A5, $A5
._tile_71

._tile_71_DATA
defb $F0, $E0
defb $F, $5A
defb $87, $3C
defb $5A, $5A
defb $F0, $70
defb $2D, $87
defb $1E, $87
defb $A5, $A5
._tile_72

._tile_72_DATA
defb $F0, $E0
defb $F, $5A
defb $F, $3C
defb $5A, $58
defb $F0, $80
defb $2D, $0
defb $1E, $0
defb $A5, $80
._tile_73

._tile_73_DATA
defb $F0, $E0
defb $F, $5A
defb $A5, $3C
defb $5A, $5A
defb $B0, $F0
defb $0, $87
defb $0, $43
defb $0, $A5
._tile_74

._tile_74_DATA
defb $F0, $E0
defb $1E, $5A
defb $F, $3C
defb $5A, $5A
defb $F0, $70
defb $2D, $A5
defb $1E, $C3
defb $A5, $A5
._tile_75

._tile_75_DATA
defb $30, $E0
defb $52, $5A
defb $A5, $3C
defb $5A, $5A
defb $F0, $70
defb $2D, $87
defb $1E, $87
defb $A5, $A5
._tile_76

._tile_76_DATA
defb $0, $0
defb $0, $0
defb $A0, $A0
defb $0, $10
defb $0, $20
defb $0, $0
defb $0, $20
defb $0, $0
._tile_77

._tile_77_DATA
defb $0, $20
defb $0, $40
defb $A0, $A0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_78

._tile_78_DATA
defb $0, $20
defb $0, $40
defb $A0, $A0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_79

._tile_79_DATA
defb $0, $0
defb $0, $0
defb $A0, $A0
defb $0, $10
defb $0, $20
defb $0, $0
defb $0, $20
defb $0, $40
._tile_80

._tile_80_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $52, $0
defb $27, $0
defb $52, $0
defb $0, $10
._tile_81

._tile_81_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $3, $0
defb $43, $80
defb $3F, $C
defb $3F, $C
defb $43, $80
._tile_82

._tile_82_DATA
defb $20, $20
defb $50, $20
defb $10, $0
defb $10, $A0
defb $10, $0
defb $20, $20
defb $20, $70
defb $F0, $F0
._tile_83

._tile_83_DATA
defb $3, $2
defb $0, $0
defb $20, $20
defb $50, $20
defb $40, $0
defb $E0, $10
defb $F0, $B0
defb $F0, $F0
._tile_84

._tile_84_DATA
defb $FF, $FF
defb $7, $F
defb $F0, $F0
defb $0, $0
defb $5A, $5A
defb $0, $0
defb $30, $30
defb $B0, $92
._tile_85

._tile_85_DATA
defb $FF, $CE
defb $F, $1E
defb $F0, $E0
defb $0, $0
defb $5A, $5A
defb $0, $0
defb $30, $30
defb $B0, $92
._tile_86

._tile_86_DATA
defb $92, $92
defb $92, $92
defb $92, $92
defb $83, $83
defb $92, $92
defb $83, $83
defb $92, $92
defb $83, $83
._tile_87

._tile_87_DATA
defb $92, $92
defb $83, $83
defb $92, $1A
defb $83, $83
defb $1A, $1A
defb $83, $A1
defb $1A, $92
defb $B0, $B0
._tile_88

._tile_88_DATA
defb $AA, $44
defb $71, $F1
defb $F2, $F2
defb $F1, $F0
defb $F0, $F2
defb $F0, $F0
defb $58, $F0
defb $40, $F0
._tile_89

._tile_89_DATA
defb $44, $AA
defb $F2, $F5
defb $F4, $E0
defb $F2, $F4
defb $F0, $E0
defb $F0, $E0
defb $F0, $F0
defb $F0, $F0
._tile_90

._tile_90_DATA
defb $41, $E0
defb $50, $D0
defb $41, $80
defb $5, $80
defb $40, $48
defb $0, $20
defb $0, $40
defb $0, $0
._tile_91

._tile_91_DATA
defb $F0, $D0
defb $F0, $10
defb $78, $6
defb $68, $0
defb $4, $80
defb $12, $0
defb $0, $0
defb $0, $0
._tile_92

._tile_92_DATA
defb $0, $0
defb $0, $8
defb $1, $8
defb $3, $C
defb $0, $A
defb $0, $8
defb $1, $9
defb $10, $88
._tile_93

._tile_93_DATA
defb $0, $0
defb $0, $8
defb $0, $C
defb $8, $6
defb $8, $F
defb $C, $4
defb $E, $4
defb $8, $4C
._tile_94

._tile_94_DATA
defb $1, $0
defb $11, $80
defb $11, $98
defb $11, $11
defb $31, $0
defb $32, $0
defb $22, $0
defb $22, $0
._tile_95

._tile_95_DATA
defb $88, $26
defb $4C, $64
defb $88, $24
defb $88, $62
defb $C8, $66
defb $CC, $22
defb $88, $22
defb $88, $22
._tile_96

._tile_96_DATA
defb $0, $E0
defb $21, $FF
defb $53, $6F
defb $37, $9F
defb $B7, $FF
defb $F7, $FF
defb $B7, $F3
defb $F7, $F5
._tile_97

._tile_97_DATA
defb $0, $0
defb $61, $48
defb $BF, $AC
defb $FF, $CE
defb $EF, $FE
defb $FF, $DE
defb $F4, $FE
defb $F5, $D6
._tile_98

._tile_98_DATA
defb $B7, $F3
defb $F7, $55
defb $B7, $FF
defb $F7, $FF
defb $B7, $FF
defb $E7, $7F
defb $B7, $AF
defb $87, $1F
._tile_99

._tile_99_DATA
defb $F4, $DE
defb $55, $DE
defb $FF, $BE
defb $AF, $5E
defb $7F, $FE
defb $FF, $5E
defb $AF, $9E
defb $5F, $1E
._tile_100

._tile_100_DATA
defb $5A, $D2
defb $2D, $87
defb $16, $F
defb $43, $4B
defb $21, $F
defb $10, $1E
defb $40, $C0
defb $E0, $0
._tile_101

._tile_101_DATA
defb $F, $4A
defb $4B, $2C
defb $3C, $84
defb $48, $0
defb $90, $C0
defb $30, $68
defb $61, $B4
defb $D2, $1E
._tile_102

._tile_102_DATA
defb $B4, $E1
defb $5A, $4B
defb $87, $96
defb $61, $2C
defb $3, $C
defb $21, $58
defb $0, $30
defb $50, $61
._tile_103

._tile_103_DATA
defb $87, $2C
defb $48, $84
defb $0, $0
defb $70, $0
defb $D2, $E0
defb $A5, $B4
defb $4B, $F
defb $87, $E
._tile_104

._tile_104_DATA
defb $12, $D2
defb $61, $87
defb $70, $F
defb $21, $4B
defb $21, $F
defb $10, $1E
defb $40, $C0
defb $60, $0
._tile_105

._tile_105_DATA
defb $F, $4A
defb $4B, $2C
defb $3C, $84
defb $48, $0
defb $90, $80
defb $30, $C0
defb $61, $84
defb $C3, $48
._tile_106

._tile_106_DATA
defb $70, $10
defb $12, $F0
defb $21, $A5
defb $1, $4B
defb $10, $F
defb $0, $87
defb $0, $D2
defb $0, $60
._tile_107

._tile_107_DATA
defb $87, $84
defb $2D, $8
defb $2D, $8
defb $69, $80
defb $70, $0
defb $20, $0
defb $0, $0
defb $20, $0
._tile_108

._tile_108_DATA
defb $70, $F0
defb $77, $FF
defb $7, $F
defb $0, $0
defb $30, $70
defb $12, $25
defb $21, $0
defb $12, $0
._tile_109

._tile_109_DATA
defb $F0, $E0
defb $FF, $EE
defb $F, $E
defb $0, $0
defb $E0, $C0
defb $86, $84
defb $0, $48
defb $0, $84
._tile_110

._tile_110_DATA
defb $3, $0
defb $12, $0
defb $3, $0
defb $23, $0
defb $13, $0
defb $23, $0
defb $33, $0
defb $30, $0
._tile_111

._tile_111_DATA
defb $0, $C
defb $0, $C
defb $0, $C
defb $0, $C
defb $0, $4C
defb $0, $8C
defb $0, $CC
defb $0, $C0
._tile_112

._tile_112_DATA
defb $0, $0
defb $0, $43
defb $0, $0
defb $0, $1
defb $0, $1
defb $0, $12
defb $0, $F0
defb $10, $10
._tile_113

._tile_113_DATA
defb $0, $0
defb $F0, $0
defb $0, $0
defb $C0, $0
defb $C0, $0
defb $E0, $0
defb $F0, $80
defb $C0, $40
._tile_114

._tile_114_DATA
defb $20, $EE
defb $40, $AA
defb $3, $0
defb $6, $1C
defb $3, $6
defb $41, $8
defb $20, $F
defb $0, $0
._tile_115

._tile_115_DATA
defb $B3, $A8
defb $A2, $98
defb $80, $6
defb $C1, $B
defb $3, $6
defb $0, $1C
defb $F, $28
defb $0, $0
._tile_116

._tile_116_DATA
defb $A2, $44
defb $FA, $FE
defb $F5, $F4
defb $F0, $F2
defb $F5, $F0
defb $F0, $F9
defb $F4, $F0
defb $F0, $F2
._tile_117

._tile_117_DATA
defb $44, $AA
defb $F9, $F2
defb $F4, $F8
defb $F8, $F4
defb $F2, $F8
defb $F0, $F1
defb $F2, $F0
defb $F5, $F0
._tile_118

._tile_118_DATA
defb $F4, $F0
defb $F0, $70
defb $F0, $B0
defb $D0, $B0
defb $C0, $90
defb $C0, $10
defb $80, $80
defb $80, $10
._tile_119

._tile_119_DATA
defb $F0, $F1
defb $D0, $B0
defb $B0, $60
defb $B0, $60
defb $30, $60
defb $20, $60
defb $0, $60
defb $20, $20
._tile_120

._tile_120_DATA
defb $0, $0
defb $13, $4C
defb $43, $E
defb $25, $2C
defb $52, $68
defb $70, $C0
defb $30, $A0
defb $0, $72
._tile_121

._tile_121_DATA
defb $0, $0
defb $12, $4C
defb $7, $2E
defb $D2, $1F
defb $E1, $87
defb $70, $5A
defb $30, $A5
defb $10, $E0
._tile_122

._tile_122_DATA
defb $12, $5B
defb $61, $2F
defb $52, $1F
defb $61, $F
defb $70, $F
defb $61, $87
defb $30, $5A
defb $10, $E1
._tile_123

._tile_123_DATA
defb $80, $0
defb $F8, $6E
defb $6D, $1F
defb $ED, $1F
defb $7C, $5B
defb $5C, $A4
defb $8, $C0
defb $0, $0
._tile_124

._tile_124_DATA
defb $70, $F0
defb $87, $FF
defb $B5, $FF
defb $B7, $EC
defb $F7, $C8
defb $F7, $88
defb $F7, $88
defb $F7, $C8
._tile_125

._tile_125_DATA
defb $F0, $E0
defb $FF, $1E
defb $FF, $DA
defb $73, $DE
defb $31, $FE
defb $11, $FE
defb $11, $FE
defb $31, $FE
._tile_126

._tile_126_DATA
defb $F7, $EC
defb $F7, $EC
defb $F7, $CC
defb $F7, $C8
defb $B7, $88
defb $B5, $F8
defb $87, $FF
defb $70, $F0
._tile_127

._tile_127_DATA
defb $73, $FE
defb $73, $FE
defb $33, $FE
defb $31, $FE
defb $11, $DE
defb $F1, $DA
defb $FF, $1E
defb $F0, $E0
._tile_128

._tile_128_DATA
defb $10, $1E
defb $1, $B
defb $1, $F
defb $1, $C
defb $10, $F
defb $0, $87
defb $0, $43
defb $0, $21
._tile_129

._tile_129_DATA
defb $1E, $0
defb $B, $0
defb $F, $0
defb $7, $0
defb $1E, $0
defb $2C, $0
defb $48, $0
defb $80, $0
._tile_130

._tile_130_DATA
defb $0, $10
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
._tile_131

._tile_131_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_132

._tile_132_DATA
defb $0, $0
defb $0, $3
defb $0, $4
defb $0, $4
defb $0, $2
defb $0, $2
defb $0, $2
defb $0, $4
._tile_133

._tile_133_DATA
defb $0, $0
defb $C, $0
defb $2, $0
defb $2, $0
defb $4, $0
defb $4, $0
defb $4, $0
defb $2, $0
._tile_134

._tile_134_DATA
defb $0, $18
defb $1, $73
defb $2, $F7
defb $4, $FD
defb $4, $FF
defb $4, $F7
defb $2, $0
defb $1, $F
._tile_135

._tile_135_DATA
defb $81, $0
defb $EC, $8
defb $FA, $4
defb $FF, $2
defb $FF, $2
defb $F6, $2
defb $0, $4
defb $F, $8
._tile_136

._tile_136_DATA
defb $0, $0
defb $0, $0
defb $10, $FF
defb $31, $8
defb $13, $0
defb $13, $0
defb $31, $8
defb $10, $FF
._tile_137

._tile_137_DATA
defb $0, $0
defb $0, $0
defb $FF, $80
defb $1, $C8
defb $0, $8C
defb $0, $8C
defb $1, $C8
defb $FF, $80
._tile_138

._tile_138_DATA
defb $0, $10
defb $0, $1
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
defb $0, $11
._tile_139

._tile_139_DATA
defb $80, $0
defb $8, $0
defb $BB, $8C
defb $AE, $C8
defb $BA, $88
defb $BB, $88
defb $BE, $88
defb $AA, $88
._tile_140

._tile_140_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $50, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_141

._tile_141_DATA
defb $0, $0
defb $0, $0
defb $0, $40
defb $20, $A0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_142

._tile_142_DATA
defb $0, $0
defb $0, $0
defb $0, $40
defb $50, $A0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_143

._tile_143_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $10, $20
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_144

._tile_144_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_145

._tile_145_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_146

._tile_146_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_147

._tile_147_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_148

._tile_148_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_149

._tile_149_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_150

._tile_150_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_151

._tile_151_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_152

._tile_152_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_153

._tile_153_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_154

._tile_154_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_155

._tile_155_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_156

._tile_156_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_157

._tile_157_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_158

._tile_158_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_159

._tile_159_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
