
#include "cpcrslib.h"
#include "cpcwyzlib.h"
#include "sound.h"
//#include "stdio.h"
//#include "stdlib.h"
#include "map.h"
#include "sprites.h"

#pragma output STACKPTR=0xbf00

#define  DELTAx         8
#define  DELTAy        10

//Enemigos que se liberarï¿½n
#define oPhantomasa     0
#define pPhantomasaX    50
#define pPhantomasaY    176

#define oNanako         1
#define pNanakoX        54
#define pNanakoY        176


#define oTracy          2
#define pTracyX         58
#define pTracyY         176

#define oHorace         3
#define pHoraceX        62
#define pHoraceY        176

#define oHelmet         4
#define pHelmetX        66
#define pHelmetY        176





//Objetos que se recogen:
#define oBotas          1
#define oTrampa         4
#define oDesmaterializador 2
#define oEstrella       0
#define oDiskette       5
#define oBote           3
#define oLlave0         11
#define oLlave1         12
#define oLlave2         13
#define oLlave3         14
#define oLlave4         15
// objeto que da acceso al huevo de pascua
#define oHuevo       7

//Objetos fijos
#define oTerminal       6

//Tiles especiales
#define tBidonRojo      27
#define tBidonPintable  3
#define tPinchos        19



struct sprite {         // minimun sprite structure
              int sp0;                //2 bytes       01
              int sp1;                //2 bytes       23
              int coord0;             //2 bytes       45      current superbuffer address
              int coord1;             //2 bytes       67  old superbuffer address
              unsigned char cx, cy;   //2 bytes 89    current coordinates
              //unsigned char ox, oy; //2 bytes 1011  old coordinates
              unsigned char move, j0;         //      in this example, to know the movement direction of the sprite
              unsigned char jn;               //      in this example, to know the movement direction of the sprite
      };
      struct sprite sprite00,sprite01,sprite02;





extern unsigned char tintas[];  //inks
extern unsigned char juego_completo;
extern unsigned char mapa_actual[];
extern unsigned int pos_mapa_actual;
extern char num_mapa;
extern unsigned int map_number;
extern unsigned char pantallas[];
extern unsigned char valor;
extern unsigned char L1489[];
extern unsigned char listaObjetosPantalla[];
extern unsigned char listaObjetos[];
extern unsigned char listaPersonajes[];
extern unsigned char estrellas;
extern unsigned char trampas;
extern unsigned char trampas_disponibles;
extern unsigned char bidones;
extern unsigned char pos_disquete[];    //para indicar los datos del disquete
extern unsigned char pos_botas[];
extern unsigned char pos_desmaterializador[];
extern unsigned char pos_bote[];
extern unsigned char tipo_enemigo;
extern unsigned char buffer[];
extern unsigned char valorn[];
extern unsigned char vida;
extern unsigned char karakasas;
extern unsigned char llaves[];
extern unsigned char llavesUsadas[];
extern unsigned char contador;
extern unsigned char posKarakasas[];
extern unsigned char posFantasmas[];
extern unsigned char muerto;
extern unsigned char liberados;
extern unsigned char fantasmas_atrapados;
extern unsigned char pantalla_menu[];
extern unsigned char pantalla_marco[];
extern unsigned char pantalla_huevo[];
extern unsigned char pantalla_esp[];
extern unsigned char tintas_hw[];
//extern unsigned char tintas_hw_negro[];
extern unsigned int gsstile;
extern unsigned int gttile;
extern unsigned char gntile;
extern unsigned char mHuevo;
extern unsigned int posi;
#asm
._gntile
defb 0
._contador
defb 0
._posi
defb 0,0
._gsstile
defb 0,0
._gttile
defb 0,0
._fantasmas_atrapados
defb 0
._juego_completo
defb 0
._liberados
defb 0
._muerto 
defb 0
._posKarakasas

defs 10;      //x,y,status
._posFantasmas  //status
defb 1,1,1,1,1,1,1,1,1,1
._llaves
defs 5
._llavesUsadas
defs 5
._karakasas
defb 0
._vida
defb 0
._valorn
defb 0,0,0
._tipo_enemigo
defb 0
._bidones
defb 0
._trampas
defb 0
._trampas_disponibles
defb 0
._estrellas
defb 0
._mHuevo
defb 0
._listaObjetosPantalla
defs 9*3        //nr, no, x,y,status,t1,t2,t3,t4
defs 9*9
._buffer
defs 64
._listaObjetos
      ._pos_disquete
      defb 47,0,oDiskette,52,112,1        //screen, nr, no, x,y,status
      ._pos_bote
      defb 10,1,oBote,48,80,1
      ._pos_desmaterializador
      defb 27,2,oDesmaterializador,48,32,1
       ._pos_botas
      defb 45,3,oBotas,20,112,1  
      defb 40,4,oTerminal,8,48,1
   
      defb 89,5,oEstrella,24,112,1       
      defb 80,6,oEstrella,8,32,1
      defb 81,7,oEstrella,24,32,1
      defb 82,8,oEstrella,28,32,1
      defb 83,9,oEstrella,28,32,1
      defb 84,10,oEstrella,28,32,1
      defb 85,11,oEstrella,32,32,1
      defb 86,12,oEstrella,32,48,1
      defb 87,13,oEstrella,28,48,1
      defb 88,14,oEstrella,8,16,1
                      

      
      defb 50,15,oTrampa,8,96,1      
      defb 40,16,oTrampa,52,128,1
      defb 41,17,oTrampa,48,96,1 
      defb 42,18,oTrampa,24,64,1
      defb 43,19,oTrampa,24,64,1 
      
      defb 16,20,oHuevo,32,82,1

      /*defb 25,21,oTrampa,24,64,1 
      defb 26,22,oTrampa,24,64,1
      defb 27,23,oTrampa,24,64,1 
      defb 28,24,oTrampa,24,64,1
      defb 29,25,oTrampa,24,64,1 */
                                         
._listaPersonajes
defb 39,56,64
defb 49,56,64
defb 59,56,64
defb 69,56,64
defb 79,56,64
      
defs 6*40
._valor
defb 0
._pantallas
defs 110
._num_mapa
defb 0
._map_number
defw 0
._pos_mapa_actual
defw 0
._mapa_actual
defs 8*5*4*4






._tintas  //firmware inks
//defb 14,13,1,6,26,24,15,8,10,22,0,3,18,4,11,25
defb 3,1,10,19,6,12,21,4,13,22,0,15,24,17,14,26
._tintas_hw
defb 28,4,6,2,12,30,26,24,0,25,20,14,10,15,31,11,20
//._tintas_hw_negro
//defb 20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20

._pantalla_menu
BINARY "mar.pu"
._pantalla_marco
BINARY "mm2.pu"
._pantalla_huevo
BINARY "huevo.pu"
._pantalla_esp
BINARY "esp.pu"
#endasm





void interrupciones(void) {


      #asm
      di
      ld hl,($0039)
      ld (_int_original),HL   //guardo el salto original


      ld HL,_interrupcion
      ld ($0039),HL
      ei
      jp term
._int_original  defw 0

._interrupcion
      DI
      push ix
      push iy
      ex af,af
      EXX
      //LD BC,$F5E0
      LD B,$F5
      IN A,(C)
      AND 1
      JR NZ,L14D3
._L1489
      LD A,$0000
      INC A
      LD (_L1489+1),A
      CP 24 //6		
      JR NZ,L14D4
.L14D3
      xor a
      LD (_L1489+1),A
.L14D4
      exx
      EX AF,AF
      pop iy
      pop ix
      EI
      RET
.term
      #endasm
}


void sincroniza(){
      #asm
      ._bucle_sincro
      LD A,(_L1489+1)
      cp 5
      jp nz, _bucle_sincro

      #endasm
}

void set_colours() { //hardware calls, ints must been changed
   unsigned char x;
      for (x=0;x<17;x++)
      	cpc_SetColour(x,tintas_hw[x]);
     //cpc_SetInk(x,tintas[x]);
     // cpc_SetBorder(0);
}

void pause(void) {
      #asm
      ld b,7
      .pause_loop
      halt
      djnz pause_loop
      #endasm
}

void pause2(void) {
      #asm
      ld b,5
      .pause_loop2
      halt
      djnz pause_loop2
      #endasm
}

void numero(unsigned char a){
      unsigned char b;
      b=a/10;
      valorn[0]=b+48;
      valorn[1]=a-b*10+48;
      valorn[2]=0;

/*      if (a<10){
              valorn[0]=48;
              valorn[1]=a+48;
              valorn[2]=0;
      } else {
              valorn[0]=49;
              a=a-10;
              valorn[1]=a+48;
              valorn[2]=0;
      }       */
}


void update_tile(unsigned char stile, unsigned char tx,unsigned char ty) {
      unsigned int sstile, i,j, ntile,  ttile, t0x, t0y;

      t0x=tx*4;
      t0y=ty*4;
      tx=t0x*2;
      ty=t0y*8;
      ntile=0; //16*stile;
      sstile=stile*16;
      for (j=0;j<4;j++){
              for (i=0;i<4;i++){
                      ttile=tileset[sstile+ntile];

                      mapa_actual[t0x+i+((t0y+j)<<5)]=ttile;
                      cpc_PutTile2x8(tiles+(ttile<<4),(tx+i+i+DELTAx),(DELTAy+ty+(j<<3)));
                      ntile++;
              }
      }


}
/*
void update_tile2(unsigned char stile,unsigned char tx,unsigned char ty) {
      unsigned int i,j, ntile,  ttile, t0x, t0y;

      t0x=tx<<2;
      t0y=ty<<2;
      tx=t0x<<1;
      ty=t0y<<3;
      ntile=0; //16*stile;
      stile=stile<<4;
      for (j=0;j<4;j++){
              for (i=0;i<4;i++){
                      ttile=tileset[stile+ntile];

                      //valor=ttile;
                      mapa_actual[t0x+i+((t0y+j)<<5)]=ttile;
                      #asm
                      ld a,(_valor)
                      ld hl,(_pos_mapa_actual)
                      ld de,_mapa_actual
                      add hl,de
                      ld (hl),a
                      #endasm 
                      //mitile=ttile<<4;
                      cpc_PutTile2x8(tiles+(ttile<<4),(tx+i+i+DELTAx),(DELTAy+ty+(j<<3)));
                      ntile++;
              }
      }


}


void set_map() {
      unsigned char tx1,ty1;
      //unsigned int map_number;
      //pos_mapa_actual=0;
      //read the tile map to uncompress it
      //map_number=40*num_mapa;
      for (tx1=0;tx1<8;tx1++){
              for (ty1=0;ty1<5;ty1++){
                      update_tile(mapset[map_number+tx1+(ty1<<3)],tx1,ty1);
                      //send stile to
                      //update map tile
              }
      }
}

unsigned char ReadTile(unsigned char tx, unsigned char ty) {
      return mapa_actual[tx+ty*32];
} */
/*
void preparaBuffer(void){
	#asm
	ld bc,5120
	ld hl,$100
	ld de,$101
	ld (hl),$f
	ldir
	#endasm
	
} */
/*
void set_map_old() {
      unsigned char tx1,ty1,tx,ty;
      unsigned int sstile, i,j,  ttile, t0x, t0y;
	  unsigned char stile, ntile;
	  
	                for (i=0;i<17;i++)
      			cpc_SetColour(i,tintas_hw_negro[i]);     
      			
	  cpc_PutSp(0x0100,80,64,cpc_GetScrAddress(8,10));
	  cpc_PutSp(0x0100,80,64,cpc_GetScrAddress(8,90));
      //unsigned int map_number;
      //pos_mapa_actual=0;
      //read the tile map to uncompress it
      //map_number=40*num_mapa;
      //for (i=0;i<640;i++)
      //	mapa_actual[i]=0;
      #asm
      ld hl,_mapa_actual
      ld de,_mapa_actual+1
      ld bc,640
      ld (hl),0
      ldir
      #endasm	
      contador=0;
     
      for (ty1=0;ty1<20;ty1=ty1+4){
      	for (tx1=0;tx1<32;tx1=tx1+4){
      	        
      	         ntile=0; //16*stile;
                      sstile=(mapset[map_number+contador]<<4);
                      if (sstile!=0){
					      t0x=tx1 ;//<<2; //*4;
					      t0y=ty1; //<<2; //*4;
					      tx=t0x<<1;//*2;
					      ty=t0y<<3; //8;
					     
					      //sstile=stile<<4 ;//16;
					      
					      for (j=0;j<4;j++){
					              for (i=0;i<4;i++){
					                      ttile=tileset[sstile+ntile];
					                      if (ttile!=0){
					                      	mapa_actual[t0x+i+((t0y+j)<<5)]=ttile;
					                      	cpc_PutTile2x8(tiles+(ttile<<4),(tx+i+i+DELTAx),(DELTAy+ty+(j<<3)));
				                      	}
					                      ntile++;
					              }
	      				  }
      				  } else {ntile=ntile+16;}
      
                       contador++;     
              }
      }
      	                for (i=0;i<17;i++)
      			cpc_SetColour(i,tintas_hw[i]);     
}

*/

void set_map() {
      unsigned char tx1,ty1,tx,ty;
      unsigned int  i,j,   t0x, t0y;
	  unsigned char stile;
	  
	           //for (i=0;i<17;i++)
      		//	cpc_SetColour(i,tintas_hw_negro[i]);     
      			
	 // cpc_PutSp(0x0100,80,64,cpc_GetScrAddress(8,10));
	 // cpc_PutSp(0x0100,80,64,cpc_GetScrAddress(8,90));
      //unsigned int map_number;
      //pos_mapa_actual=0;
      //read the tile map to uncompress it
      //map_number=40*num_mapa;
      //for (i=0;i<640;i++)
      //	mapa_actual[i]=0;
      #asm
      ld hl,_mapa_actual
      ld de,_mapa_actual+1
      ld bc,640
      ld (hl),0
      ldir
      #endasm	
      
      contador=0;		//vble global para accederla por asm
      for (ty1=0;ty1<20;ty1=ty1+4){
      	for (tx1=0;tx1<32;tx1=tx1+4){
      	        
      	         gntile=0; //16*stile;
      	         #asm
      	         
      	         ld hl,(_map_number)
      	         ld a,(_contador)
      	         ld e,a
      	         ld d,0
      	         add hl,de
      	         ld de,_mapset
      	         add hl,de
      	         ld l,(hl)
      	         ld h,0
      	         add hl,hl
      	         add hl,hl
      	         add hl,hl
      	         add hl,hl
      	         ld (_gsstile),hl
      	         ld hl,_contador
      	         inc (HL)
      	         #endasm
                     // gsstile=(mapset[map_number+contador]<<4);
                      if (gsstile!=0){
					      t0x=tx1 ;//<<2; //*4;
					      t0y=ty1; //<<2; //*4;
					      tx=t0x<<1;//*2;
					      ty=t0y<<3; //8;
					     
					      //sstile=stile<<4 ;//16;
					      
					      for (j=0;j<4;j++){
					              for (i=0;i<4;i++){
					                      gttile=tileset[gsstile+gntile];
					                  /*    #asm
					                      ld hl,(_gsstile)
					                      ld a,(_gntile)
					                      ld e,a
					                      ld d,0
					                      add hl,de
					                      
					                      ld de,_tileset
					                      add hl,de
					                      
					                      ld a,(hl)
					                      ld (_gttile+1),a
					                      inc hl
					                      ld a,(hl)
					                      ld (_gttile),a					                      
					                      #endasm */
					                      
					                      //if (gttile!=0){
					                      	mapa_actual[t0x+i+((t0y+j)<<5)]=gttile;
					                      	//cpc_PutTile2x8(tiles+(gttile<<4),(tx+i+i+DELTAx),(DELTAy+ty+(j<<3)));
				                      	//}
					                      gntile++;
					              }
	      				  }
      				  } else {gntile=gntile+16;}
      
                      // contador++;     
              }
      }
    //  for (i=0;i<17;i++)
     // 	cpc_SetColour(i,tintas_hw[i]);   
     
  
    gsstile=0;
    	contador=0;
 // for (ty1=0;ty1<160;ty1=ty1+8){
	     #asm
	    ld c,20
	    .buc1
	    push bc
	    #endasm  
	    
	    posi=cpc_GetScrAddress(DELTAx,contador+DELTAy);
	   // contador=contador+8;
      	//for (tx1=0;tx1<64;tx1=tx1+2){   
	      	//gttile  =mapa_actual[gsstile];
	      	#asm
	      	
	      	ld a,(_contador)
	      	add 8
	      	ld (_contador),a
	      	ld c,32
	      	.buc2
	      	push bc
	      	
	      	ld de,_mapa_actual
	      	ld hl,(_gsstile)
	      	add hl,de
	      	ld de,_gttile
	      	ld a,(hl)
	      	ld (de),a
	     // 	or a
	     // 	jp z,cont_k
	
	ld de,_tiles
	ld a,(_gttile)
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,de
	ld de,(_posi)
	ex de,hl
		
		defb $fD
   		LD H,8		//;ALTO, SE PUEDE TRABAJAR CON HX DIRECTAMENTE
		ld b,7
		
	.loop_alto_tile_2x8w
	.loop_ancho_tile_2x8w		
		ld A,(DE)
		ld (hl),a
		inc de
		inc hl
		
		ld A,(DE)
		ld (hl),a
		inc de


	   defb $fD
	   dec H
	   jp z, cont_k  //ret z
	   
.suma_siguiente_linea0_tile_2x8w		
		LD C,$ff			//;&07f6 			;salto linea menos ancho
		ADD HL,BC
		jp nc,loop_alto_tile_2x8w //;sig_linea_2zz		//;si no desborda va a la siguiente linea
		ld bc,$c050
		
		add HL,BC
		ld b,7			//;slo se dara una de cada 8 veces en un sprite
		jp loop_alto_tile_2x8w	
     			
       			
       			

       			.cont_k
       			ld hl,(_posi)
       			inc hl
       			inc hl
       			ld (_posi),hl
       			ld hl,(_gsstile)
       			inc hl
       			ld (_gsstile),hl       		
       			
       			pop bc
       			dec c
       			jp nz,buc2	
       			#endasm
       		//posi=posi+2;
       		//gsstile++;
   		//}
	     #asm
	    pop bc
	    dec c
	    jp nz, buc1
	    
    
	    #endasm  
 //   }
}

/*

void set_map_old1() {
      unsigned char tx1,ty1,tx,ty;
      unsigned int  i,j,   t0x, t0y;
	  unsigned char stile;
	  
	           //for (i=0;i<17;i++)
      		//	cpc_SetColour(i,tintas_hw_negro[i]);     
      			
	  cpc_PutSp(0x0100,80,64,cpc_GetScrAddress(8,10));
	  cpc_PutSp(0x0100,80,64,cpc_GetScrAddress(8,90));
      //unsigned int map_number;
      //pos_mapa_actual=0;
      //read the tile map to uncompress it
      //map_number=40*num_mapa;
      //for (i=0;i<640;i++)
      //	mapa_actual[i]=0;
      #asm
      ld hl,_mapa_actual
      ld de,_mapa_actual+1
      ld bc,640
      ld (hl),0
      ldir
      #endasm	
      
      contador=0;		//vble global para accederla por asm
      for (ty1=0;ty1<20;ty1=ty1+4){
      	for (tx1=0;tx1<32;tx1=tx1+4){
      	        
      	         gntile=0; //16*stile;
      	         #asm
      	         
      	         ld hl,(_map_number)
      	         ld a,(_contador)
      	         ld e,a
      	         ld d,0
      	         add hl,de
      	         ld de,_mapset
      	         add hl,de
      	         ld l,(hl)
      	         ld h,0
      	         add hl,hl
      	         add hl,hl
      	         add hl,hl
      	         add hl,hl
      	         ld (_gsstile),hl
      	         
      	         #endasm
                     // gsstile=(mapset[map_number+contador]<<4);
                      if (gsstile!=0){
					      t0x=tx1 ;//<<2; //*4;
					      t0y=ty1; //<<2; //*4;
					      tx=t0x<<1;//*2;
					      ty=t0y<<3; //8;
					     
					      //sstile=stile<<4 ;//16;
					      
					      for (j=0;j<4;j++){
					              for (i=0;i<4;i++){
					                      gttile=tileset[gsstile+gntile];

					                      
					                      if (gttile!=0){
					                      	mapa_actual[t0x+i+((t0y+j)<<5)]=gttile;
					                      	cpc_PutTile2x8(tiles+(gttile<<4),(tx+i+i+DELTAx),(DELTAy+ty+(j<<3)));
				                      	}
				                      	#asm
				                      	ld hl,_gntile
				                      	inc (HL)
					                      #endasm //gntile++;
					              }
	      				  }
      				  } else {
	      				  #asm
	      				  ld a,(_gntile)
	      				  add 16
	      				  ld (_gntile),a
	      				  #endasm
	      				  //gntile=gntile+16;
	      				  }
      
                       contador++;     
              }
      }
    //  for (i=0;i<17;i++)
     // 	cpc_SetColour(i,tintas_hw[i]);     
}

*/

unsigned char miraVertical(unsigned char tx, unsigned char ty) {
//tx, ty reciben coordenadas a mirar
      unsigned int z0,z1;
      unsigned int t0=((ty>>3)<<5);
      z0=((tx+3)>>3)+((ty>>5)<<3);
      z1=(tx>>3)+((ty>>5)<<3);
      //unsigned int map_act;
      //map_act=num_mapa*40;
      //if(mapa_actual[tx/2+t0]==4 || mapa_actual[(tx+1)/2+t0]==4 || mapa_actual[(tx+3)/2+t0]==4) {
	      

	  	
      if(mapset[map_number+z0]==tPinchos || mapset[map_number+z1]==tPinchos) {
              collide();
              sprite00.cy=sprite00.cy-4;

              return 1;
      }


      if(pos_bote[5]==0){
              if(mapset[map_number+z0]==tBidonPintable){
                      mapset[map_number+z0]=tBidonRojo ;
                      bidones++;
                      //Se debujan los tiles nuevos
                      cpc_WyzStartEffect(2,8);
                      update_tile(tBidonRojo ,(tx+3)>>3,ty>>5);
                       if (bidones==15) darLlave(oHorace);
                      return 1;
              }else {
                      if (mapset[map_number+z1]==tBidonPintable) {
                              //nuevo color
                              mapset[map_number+z1]=tBidonRojo ;
                              bidones++;
                              //Se debujan los tiles nuevos
                              cpc_WyzStartEffect(2,8);
                              update_tile(tBidonRojo ,tx>>3,ty>>5);
                              if (bidones==15) darLlave(oHorace);
                              return 1;
                      }
              }
      }



/*      if((pos_bote[5]==0) && ((mapset[map_number+((tx+3)>>3)+((ty>>5)<<3)]==5) || (mapset[map_number+(tx>>3)+((ty>>5)<<3)]==5))) {
              //nuevo color
              mapset[map_number+(tx>>3)+((ty>>5)<<3)]=6;
              bidones++;
              //Se debujan los tiles nuevos
              update_tile(6,tx>>3,ty>>5);
              return 1;
      } */

      return (mapa_actual[(tx>>1)+t0] || mapa_actual[((tx+1)>>1)+t0] || mapa_actual[((tx+3)>>1)+t0]);
      //return mapa_actual[tx/2+t0] ;
}


unsigned char miraVerticalEnemigo(unsigned char tx, unsigned char ty) {
//tx, ty reciben coordenadas a mirar
      unsigned int t0=((ty>>3)<<5);
      
      return (mapa_actual[(tx>>1)+t0] || mapa_actual[((tx+1)>>1)+t0] || mapa_actual[((tx+3)>>1)+t0]);
}

unsigned char miraHorizontal(unsigned char tx, unsigned char ty) {
//tx, ty reciben coordenadas a mirar
      unsigned int t0=(tx>>1);
      unsigned int z0;
      z0=((tx+1)>>3)+((ty>>5)<<3); //solo se mira por la derecha
      /*if(mapset[num_mapa*40+(tx>>3)+((ty>>5)<<3)]==4){
	
      //if(mapa_actual[t0+32*(ty/8)]==4 || mapa_actual[t0+32*((ty+7)/8)]==4 || mapa_actual[t0+32*((ty+15)/8)]==4){
              collide();
              return 1;
      }*/
      // Miro a la derecha del sprite 1 para saber si hay que abrir la puerta
      if(mapset[map_number+z0]==26){
      //if(mapa_actual[t0+((ty>>3)<<5)]==26 || mapa_actual[t0+(((ty+7)>>3)<<5)]==26 || mapa_actual[t0+(((ty+15)>>3)<<5)]==26){
	      switch (num_mapa){
		      case 39:
		      		if(llaves[0]==1) {
			      		abrirPuerta(0);
		      			/*llaves[0]=0;	//reset key
		      			mapset[39*40+20]=0;//set tile 0
		      			abrirPuerta(1);
		      			update_tile(0,4,2);	//draw tile 0
		      			vida=vida+10; */
	      			}
		      		break;
		      case 49:
		      		if(llaves[1]==1) {
						abrirPuerta(1);	      			
					}	      
		      		break;
		      case 59:
		      		if(llaves[2]==1) {
		      			abrirPuerta(2);
	      			}	      
		      		break;
		      case 69:
		      		if(llaves[3]==1) {
		      			abrirPuerta(3);
	      			}	      
		      		break;
		      case 79:
		      		if(llaves[4]==1) {
		      			abrirPuerta(4);
	      			}	      
		      		break;	      
	      }
  		}
      return (mapa_actual[t0+((ty>>3)<<5)] || mapa_actual[t0+(((ty+7)>>3)<<5)] || mapa_actual[t0+(((ty+15)>>3)<<5)]);
}

unsigned char miraHorizontalEnemigo(unsigned char tx, unsigned char ty) {
//tx, ty reciben coordenadas a mirar
      unsigned int t0=(tx>>1);
      /*if(mapset[num_mapa*40+(tx>>3)+((ty>>5)<<3)]==4){

      //if(mapa_actual[t0+32*(ty/8)]==4 || mapa_actual[t0+32*((ty+7)/8)]==4 || mapa_actual[t0+32*((ty+15)/8)]==4){
              collide();
              return 1;
      }*/
      return (mapa_actual[t0+((ty>>3)<<5)] || mapa_actual[t0+(((ty+7)>>3)<<5)] || mapa_actual[t0+(((ty+15)>>3)<<5)]);
}

void mueveSpriteA(void){

      if ((sprite01.j0&2)==0){
              if(sprite01.cx<60 && (miraHorizontalEnemigo(sprite01.cx+4, sprite01.cy)==0) ) {
                      sprite01.cx++;
              } else {
                      sprite01.j0=sprite01.j0|2;
                      sprite01.cx--;
              }
      } else {
              if(sprite01.cx>1 && (miraHorizontalEnemigo(sprite01.cx-1, sprite01.cy)==0) ) {
                      sprite01.cx--;
              } else {
                      sprite01.j0=sprite01.j0&253;
                      sprite01.cx++;
              }
      }

      if ((sprite01.j0&1)==0){
              if(sprite01.cy<153 && (miraVerticalEnemigo(sprite01.cx, sprite01.cy+17)==0) ) {
                      sprite01.cy=sprite01.cy+4;
              } else {
                      sprite01.j0=sprite01.j0|1;
                      sprite01.cy=sprite01.cy-4;
              }
      } else {
              if(sprite01.cy>1 && (miraVerticalEnemigo(sprite01.cx, sprite01.cy-1)==0) ) {
                      sprite01.cy=sprite01.cy-4;
              } else {
                      sprite01.j0=sprite01.j0&254;
                      sprite01.cy=sprite01.cy+4;
              }
      }

}


void mueveSpriteB(void){        //Karakasa
      unsigned char a;
//en caso de colisiï¿½n o fin de pasos, se calcula nueva direcciï¿½n y nuevo nï¿½mero de pasos a dar.

//primero, mira si hay suelo bajo sus pies
	if((miraVerticalEnemigo(sprite02.cx, sprite02.cy+24)==0) && sprite02.cy<136){
		sprite02.cy=sprite02.cy+4;
	}else {
	
	
	
	//pasos en jn
	      sprite02.jn--;  //Es importante iniciar jn=1 al principio de cada pantalla
	
	
	
	      if(sprite02.jn==0){     //Pasos finalizados. Se busca nueva direcciï¿½n y nï¿½mero pasos
	
	              sprite02.jn=cpc_Random()&31+1;   //nuevo nï¿½mero de pasos
	
	              sprite02.j0=(cpc_Random())&3; //nueva direcciï¿½n x
	
	              if (sprite02.j0==3){
	                      sprite02.jn=sprite02.jn+2;
	                      (sprite02.jn>>1)
	              }
	
	      }
	
	      switch (sprite02.j0){
	      case 0:
	              if(sprite02.cx<60 && (miraHorizontalEnemigo(sprite02.cx+4, sprite02.cy)==0) ) {
	                      sprite02.cx++;
	              } else {
	                      sprite02.jn=1;  //Si hay colisiï¿½n, nueva direcciï¿½n
	              }
	              break;
	      case 1:
	              if(sprite02.cx>1 && (miraHorizontalEnemigo(sprite02.cx-1, sprite02.cy)==0) ) {
	                      sprite02.cx--;
	              } else {
	                      sprite02.jn=1;  //Si hay colisiï¿½n, nueva direcciï¿½n
	              }
	              break;
	      default:        //karakasa se queda parado
	              break;
	      }
	}
}

void localizarObjeto(void){
      unsigned char i,j;
      unsigned int pos_objeto;
      j=0;
      for(i=0;i<36;i++) {	
              listaObjetosPantalla[i]=255;
      } //Reset all the Screen Objects
      for(i=0;i<21;i++){
              if(listaObjetos[i*6]==num_mapa && listaObjetos[i*6+5]==1){
                      listaObjetosPantalla[j*9]= listaObjetos[i*6+1]; //nr
                      listaObjetosPantalla[j*9+1]= listaObjetos[i*6+2]; //no
                      listaObjetosPantalla[j*9+2]= listaObjetos[i*6+3]; //x
                      listaObjetosPantalla[j*9+3]= listaObjetos[i*6+4]; //y
                      listaObjetosPantalla[j*9+4]=1; //status
                      //se mira los tiles correspondientes y se guardan en 5,6
                      listaObjetosPantalla[j*9+5]=mapa_actual[listaObjetosPantalla[j*9+2]/2+32*(listaObjetosPantalla[j*9+3]/8)];
                      listaObjetosPantalla[j*9+6]=mapa_actual[listaObjetosPantalla[j*9+2]/2+32*(listaObjetosPantalla[j*9+3]/8)+1];
                      listaObjetosPantalla[j*9+7]=mapa_actual[(listaObjetosPantalla[j*9+2]+1)/2+32*(listaObjetosPantalla[j*9+3]/8)];
                      listaObjetosPantalla[j*9+8]=mapa_actual[(listaObjetosPantalla[j*9+2]+1)/2+32*(listaObjetosPantalla[j*9+3]/8)+1];
                      j++;
              }
      }
      //Muestra los objetos en pantalla
      for(i=0;i<36;i=i+9){
              if(listaObjetosPantalla[i]==255) break;
              cpc_PutTile4x16(objetos+listaObjetosPantalla[i+1]*64,listaObjetosPantalla[i+2]+DELTAx,DELTAy+listaObjetosPantalla[i+3]);

      }
}


void localizarPersonaje(void){
      unsigned char i;

      for(i=0;i<5;i++) {
	      
              if(listaPersonajes[i*3]==num_mapa){
	              cpc_PutTile4x16(personajes+i*64,listaPersonajes[i*3+1]+DELTAx,DELTAy+listaPersonajes[i*3+2]);
	              break;
              }
          }
	              
      
}


unsigned char checkObject(unsigned char x, unsigned char y){
//  if ((sprite00.cx > x+3) || (x > sprite00.cx+3) || (sprite00.cy > y+15) || (y > sprite00.cy+15))
	if ((sprite00.cx > x+2) || (x > sprite00.cx+3) || (sprite00.cy > y+4) || (y > sprite00.cy+15))
      return 0;
  else
      return 1;
}

void checkKarakasa(void){
      if (pos_botas[5]==0){
              //if (((sprite00.cy+16)==sprite01.cy) && !((sprite00.cx > sprite01.cx+3) || (sprite01.cx > sprite00.cx+3))){
              if ((((sprite00.cy+16)==sprite02.cy) || ((sprite00.cy+17)==sprite02.cy)) && !((sprite00.cx > sprite02.cx+3) || (sprite02.cx > sprite00.cx+3))) {
              //Elimino el karakasa
              		  cpc_WyzStartEffect(2,1);
                      karakasas++;
                      cpc_PutSpriteXOR(sprite02.sp1,sprite02.coord1);
                      sprite02.move=0;
                      posKarakasas[num_mapa]=0;    //para que no vuelva a salir al volver a esta pantalla
                      if(karakasas==10) darLlave(oNanako);
              }
      }
}

void collide(void) {
      //cpc_SetBorder(1);
      cpc_WyzStartEffect(2,4);
      vida--;
      numero(vida);
      cpc_PrintGphStrXY(valorn,16,1);
      pause();
      
      if (vida==0) muerto=1;
      //cpc_SetBorder(0);
}

void restaurarMarcadores(void){
	unsigned char i;
	
	  numero(vida);
      cpc_PrintGphStrXY(valorn,16,1);
      numero(trampas);
      coloresLetras1();
      cpc_PrintGphStrXY(valorn+1,26,184);
      numero(estrellas);
      cpc_PrintGphStrXY(valorn,14,184);      
      coloresLetras2();      
      if(pos_disquete[5]!=1){
	      hacerTransparente(3);
	      cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(32,176));
      }
      if(pos_desmaterializador[5]==0){
	      hacerTransparente(2);
	      cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(36,176));
      }
      if(pos_bote[5]==0){
	      hacerTransparente(4);
	      cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(40,176));
      }
      if(pos_botas[5]==0){
	      hacerTransparente(1);
	      cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(44,176));
      }               
      for (i=0;i<5;i++){
	      if (llaves[i]==1)
	      	darLlave2(i);
	      if (llavesUsadas[i]==1)
	      	soltarLlave(i);
      	
      	
  	 }
         
}


void buscarEnemigo(void){
	if (num_mapa!=19){ //En la primera pantalla no hay enemigos
       if (num_mapa<10) {
               tipo_enemigo=1; //karakasa
               ubicarKarakasa();       //ubica karakasa
               tipo_enemigo=0; //normal
               ubicarSpriteA();
       } else {
               if (num_mapa>92 && num_mapa<98) { //5 fantasmas
                       tipo_enemigo=2; //fanstama
               } else {
                       tipo_enemigo=0; //normal
               }
      //if(num_mapa==10) tipo_enemigo=2;

       ubicarSpriteA();
       }
   } else sprite01.move=0;
}

void ubicarSpriteA(void){
      unsigned char tx, ty, a, b;
      //unsigned int map_number;
      if (((tipo_enemigo==2) && (posFantasmas[99-num_mapa]==1)) || tipo_enemigo==0) {
               //map_number=40*num_mapa;
               b=1;
               while (b){
                       tx=cpc_Random()&7;
                       a=1;
                       while (a){
                               ty=cpc_Random()&7;
                               if (ty<5) a=0;
                       }
                       //if (mapset[map_number+(tx>>3)+(ty>>5)*8]==0) b=1;
                       if (mapset[map_number+tx+(ty<<3)]==0) b=0;
               }

               //ubicacin aleatoria en un supertile 0 para que se pueda mover
               if(tipo_enemigo==0){
	               sprite01.sp1=sMalo1+((cpc_Random()&1)*66);
	               sprite01.sp0=sprite01.sp1;
               } else {
	               sprite01.sp1=sFantasma;
	               sprite01.sp0=sFantasma;
               }
               
               sprite01.cx=(tx<<3)+2;
               sprite01.cy=(ty<<5)+16;
               sprite01.j0=0;
               sprite01.coord0=cpc_GetScrAddress(sprite01.cx+DELTAx,sprite01.cy+DELTAy);
               sprite01.coord1=sprite01.coord0;
               sprite01.move=1;
       }
       else sprite01.move=0;
}

void ubicarKarakasa(void){      //ubica el karakasa común
 	unsigned char tx, ty, a, b;
             b=1;
             ty=0;
               while (b){
                       tx=cpc_Random()&7;
               //        a=1;
              //         while (a){
              //                 ty=cpc_Random()&7;
              //                 if (ty<5) a=0;
               //        }
                       //if (mapset[map_number+(tx>>3)+(ty>>5)*8]==0) b=1;
                       if (mapset[map_number+tx]==0) b=0;
               }
      //En cada pantalla de la fila superior, se tiene las coordenadas de su caracasa correspondiente (mientras exista)
      if(posKarakasas[num_mapa]==1){
               sprite02.sp1=sKarakasa;
               sprite02.sp0=sKarakasa;
               sprite02.cx=(tx<<3)+2;
               sprite02.cy=ty+4;
               sprite02.j0=1;
               sprite02.coord0=cpc_GetScrAddress(sprite02.cx+DELTAx,sprite02.cy+DELTAy);
               sprite02.coord1=sprite02.coord0;
               sprite02.move=1;
      } else sprite02.move=0;
}

void secuenciaCaptura(void){
      unsigned char i,j,capturado,k;
      unsigned int z;
      //se muestra la jaula sobre el sprite yse hace mover al fantasma hasta la jaula
      capturado=0;
      k=0;
      i=sprite00.cx;
      j=(sprite00.cy-16);
      z=cpc_GetScrAddress(i+DELTAx,j+DELTAy);
      cpc_GetSp(buffer,16,4,z);

      cpc_PutTile4x16(trampa,i+DELTAx,j+DELTAy);
      //secuencia
      while(!capturado){
              if ((sprite01.cy)<j)
                      sprite01.cy++;
              else
                      sprite01.cy--;
              if (sprite01.cx<i)
                              sprite01.cx++;
              else
                      sprite01.cx--;
              //if ((sprite01.cx==i) && (sprite01.cy==j))
              //      capturado=1;
              sincroniza();
              cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord1);
              sprite01.coord0=cpc_GetScrAddress(sprite01.cx+DELTAx,sprite01.cy+DELTAy);
              cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
              sprite01.coord1=sprite01.coord0;
              k++;
              if(k==64)
                      capturado=1;
      }
      //Quita el fantasma
      cpc_WyzStartEffect(2,6);
      cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
      sprite01.coord1=sprite01.coord0;
      sprite01.move=0;
      //Quita jaula
      cpc_PutTile4x16(buffer,i+DELTAx,j+DELTAy);
      trampas--;
      numero(trampas);
      coloresLetras1();
      cpc_PrintGphStrXY(valorn+1,26,184);
      coloresLetras2();

}


void capturarFantasma(){
      if (pos_desmaterializador[5]==0 && sprite01.move==1 && tipo_enemigo==2 && sprite00.cy>16) { //tengo el desmaterializador
              if (trampas!=0 && trampas_disponibles!=0){
	              	  cpc_WyzStartEffect(2,5);
                      //capturo el fantasma
                      fantasmas_atrapados++;
                      trampas_disponibles--;
                      secuenciaCaptura();
                      posFantasmas[99-num_mapa]=0;
                      if((fantasmas_atrapados==5)) darLlave( oTracy );
              }
      }
}

void quitarObjetoPantalla(unsigned char i){
      unsigned char j;
	  cpc_WyzStartEffect(2,3);
      //conviene quitar los sprites antes de meter el nuevo tile y luego volverlos a poner

      cpc_PutSpriteXOR(sprite00.sp1,sprite00.coord1);


      //sprite00.coord1=sprite00.coord0;
      if (sprite01.move==1)
              cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
      if (sprite02.move==1)
              cpc_PutSpriteXOR(sprite02.sp0,sprite02.coord0);

      cpc_PutTile2x8(tiles+16*listaObjetosPantalla[9*i+5],listaObjetosPantalla[i*9+2]+DELTAx,DELTAy+listaObjetosPantalla[i*9+3]);
      cpc_PutTile2x8(tiles+16*listaObjetosPantalla[9*i+6],listaObjetosPantalla[i*9+2]+DELTAx,8+DELTAy+listaObjetosPantalla[i*9+3]);
      cpc_PutTile2x8(tiles+16*listaObjetosPantalla[9*i+7],listaObjetosPantalla[i*9+2]+DELTAx+2,DELTAy+listaObjetosPantalla[i*9+3]);
      cpc_PutTile2x8(tiles+16*listaObjetosPantalla[9*i+8],listaObjetosPantalla[i*9+2]+DELTAx+2,8+DELTAy+listaObjetosPantalla[i*9+3]);

      cpc_PutSpriteXOR(sprite00.sp1,sprite00.coord1);
      if (sprite01.move==1)
              cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
      if (sprite02.move==1)
              cpc_PutSpriteXOR(sprite02.sp0,sprite02.coord0);

      for(j=0;j<21;j++){
              if(listaObjetos[6*j+1]==listaObjetosPantalla[9*i]) {
                      listaObjetos[6*j+5]=0;
                      break;
              }
      }

      listaObjetosPantalla[9*i+4]=0;
}


void abrirPuerta(unsigned char i){
	cpc_WyzStartEffect(2,7);
	llaves[i]=0;	//reset key
	llavesUsadas[i]=1;	//reset key
	mapset[(39+10*i)*40+20]=0;//set tile 0
	update_tile(0,4,2);	//draw tile 0
	vida=vida+10;
	if (vida>99) vida=99;
	numero(vida);
	cpc_PrintGphStrXY(valorn,16,1);	
	soltarLlave(i);
	liberados++;
	if(liberados==5) juego_completo=1;
}

void finJuego(){
	
	num_mapa=100;
	map_number=num_mapa*40;
	set_map();
	
	//put Sprites:
	cpc_PutTile4x16(sTracy,32+DELTAx,112+DELTAy);
	cpc_PutTile4x16(sHelmet,38+DELTAx,112+DELTAy);
	
	
	cpc_PutTile4x16(sPhantomasa,44+DELTAx,112+DELTAy);
	cpc_PutTile4x16(sHorace,50+DELTAx,112+DELTAy);
	cpc_PutTile4x16(sNanako,56+DELTAx,112+DELTAy);

	cpc_PutSpriteXOR(sprite3,cpc_GetScrAddress(12+DELTAx,112+DELTAy));	
	coloresLetras3();
	cpc_PrintGphStrXY("YOU;MADE;IT>>",25,50);
	cpc_PrintGphStrXY("YOU;RESCUED;YOUR;FRIENDS",14,66);
	cpc_PrintGphStrXY("WELL;DONE>",28,82);
	//sprite00.move=255;
	sprite01.move=0;
	sprite02.move=0;
	esperaTecla(); //while(!cpc_AnyKeyPressed()){}
	

}

void darLlave2(unsigned char i){
	unsigned int zx,zy;
	llaves[i]=1;    //llave recogida
	switch (i){
               case oTracy:
                       zx=pTracyX;
                       zy=pTracyY;
                       //t=sTracy;
                       hacerTransparente(5);
                       break;
               case oPhantomasa:
                       zx=pPhantomasaX;
                       zy=pPhantomasaY;
                       hacerTransparente(6);
                       //t=sPhantomasa;
                       break;
               case oHorace:
                       zx=pHoraceX;
                       zy=pHoraceY;
                       hacerTransparente(7);
                       //t=sHorace;
                       break;
               case oHelmet:
                       zx=pHelmetX;
                       zy=pHelmetY;
                       hacerTransparente(8);
                       //t=sHelmet;
                       break;
               case oNanako:
                       zx=pNanakoX;
                       zy=pNanakoY;
                       hacerTransparente(9);
                       //t=sNanako;
                       break;
       }
       //t=sLlaves+64*i;
       cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(zx,zy));
}
void darLlave(unsigned char j) {       
       //dibuja la llave correspondiente en la pantalla
       
       cpc_WyzStartEffect(2,2);
       darLlave2(j);
       //cpc_PutTile4x16(t,zx,zy);

}

void soltarLlave(unsigned char i) {
       unsigned int zx,zy;
       //dibuja la llave correspondiente en la pantalla
       
       switch (i){
               case oTracy:
                       zx=pTracyX;
                       zy=pTracyY;
                       
                       //t=sTracy;
                       break;
               case oPhantomasa:
                       zx=pPhantomasaX;
                       zy=pPhantomasaY;
                    
                       //t=sPhantomasa;
                       break;
               case oHorace:
                       zx=pHoraceX;
                       zy=pHoraceY;
                     
                       //t=sHorace;
                       break;
               case oHelmet:
                       zx=pHelmetX;
                       zy=pHelmetY;
                       
                       //t=sHelmet;
                       break;
               case oNanako:
                       zx=pNanakoX;
                       zy=pNanakoY;
                       //t=sNanako;
                       
                       break;
       }
       //t=sLlaves+64*i;
       hacerTransparente(10);
       cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(zx,zy));
      // cpc_PutTile4x16(llavet0,zx,zy);

}

void hacerTransparente(unsigned char z){
	unsigned char a,b,i;
	
	for (i=0;i<64;i++){
		switch (z) {
			case 1:
				a=sprite12[i];
				break;
			case 2:
				a=sprite13[i];
				break;
			case 3:
				a=sprite16[i];
				break;
			case 4:
				a=sprite14[i];
				break;
			case 5:
				a=sL1[i];
				break;
			case 6:
				a=sL2[i];
				break;
			case 7:
				a=sL3[i];
				break;
			case 8:
				a=sL4[i];
				break;
			case 9:
				a=sL5[i];
				break;
			case 10:
				a=llavet0[i];
				break;																				
		}												
		
		b=a;
		if ((a&0xaa)==0x0a){ //primer byte es transparente
			b=(b&0x55);
		}
		if ((a&0x55)==0x05){ //segundo byte es transparente
			b=(b&0xaa);
		}	
		buffer[i]=b;	
	}
}


void rellenaPantalla(void){
	          #asm
              ld hl,$c000
              ld de,$c001
              ld bc,16383
              ld (hl),$0f
              ldir
              #endasm
          }
void coloresLetras1(void){
	cpc_SetInkGphStr(0,42);    
	cpc_SetInkGphStr(1,170); 
	cpc_SetInkGphStr(2,170); 
	cpc_SetInkGphStr(3,170);      
} 

void coloresLetras2(void){
	cpc_SetInkGphStr(0,170);    
	cpc_SetInkGphStr(1,10); 
	cpc_SetInkGphStr(2,10); 
	cpc_SetInkGphStr(3,10);    
} 

void coloresLetras3(void){
	   
	coloresLetras1();  
	cpc_SetInkGphStr(0,10); 
	 
} 

         
void accionObjeto(unsigned char i) {
	// Cambio los colores de las letras, por si se escribe
         
	  coloresLetras1();
      switch (listaObjetosPantalla[9*i+1]) {
              case oBotas : //botas
                              //Elimino objeto de la pantalla
                              
                              quitarObjetoPantalla(i);
                              //Dibujo objeto fuera pantalla
                              hacerTransparente(1);
                              //cpc_PutTile4x16(objetos+listaObjetosPantalla[i*9+1]*64,44,176);
                              cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(44,176));
                              break;
              case oTrampa : //trampa
                              //Elimino objeto de la pantalla
                              quitarObjetoPantalla(i);
                              //inc numero
                              trampas_disponibles++;
                              trampas++;
                              //cpc_PrintGphStrXY("T",16,180);
                              numero(trampas);
                              cpc_PrintGphStrXY(valorn+1,26,184);
    
                              break;
              case oDesmaterializador : //desmaterializador
                              //Elimino objeto de la pantalla
                              quitarObjetoPantalla(i);
                              //Dibujo objeto fuera pantalla
                              hacerTransparente(2);
							//	cpc_PutTile4x16(buffer,36,176);
                               cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(36,176));
                              break;
              case oEstrella : //estrella
                              //Elimino objeto de la pantalla
                              quitarObjetoPantalla(i);
                              //inc numero estrellas
                              estrellas++;
                              //cpc_PrintGphStrXY("E",20,180);
                              numero(estrellas);

                              cpc_PrintGphStrXY(valorn,14,184);
                              if(estrellas==10)
                                       darLlave(oPhantomasa);

                              break;
              case oDiskette : //diskete
                              //Elimino objeto de la pantalla
                              quitarObjetoPantalla(i);
                              //Dibujo objeto fuera pantalla
                              hacerTransparente(3);
                              //cpc_PutTile4x16(objetos+listaObjetosPantalla[i*9+1]*64,32,176);
                              cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(32,176));
                              break;
              case oBote : //bote
                              //Elimino objeto de la pantalla
                              quitarObjetoPantalla(i);
                              //Dibujo objeto fuera pantalla
                              hacerTransparente(4);
                              //cpc_PutTile4x16(objetos+listaObjetosPantalla[i*9+1]*64,40,176);
                              cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(40,176));
                              break;
              case oTerminal : //terminal
                              //Si se tiene el disquete hace su funciï¿½n
                              
                              if (pos_disquete[5]==0) {
	                              cpc_WyzStartEffect(2,3);
	                              darLlave(oHelmet);
	                              pos_disquete[5]=2;	// solo se mete el disco una vez.
                              }
                              break;
              case oHuevo : //huevo pascua
              				//  if (mHuevo)
							//  	mostrarHuevo();
							if (mHuevo==1)
							  	mHuevo=3;
                            break;                              

      }

//restauro los colores de las letras
      coloresLetras2();

}

void spritesXOR() {
	unsigned int i,j;
	unsigned char a;
	for (j=0;j<9;j++){
		for (i=0;i<64;i++){
			a=sprite0[j*66+i+2]^0xf;
			sprite0[j*66+i+2]=a;
		}
	}
	for (i=0;i<96;i++){
		a=sKarakasa[i+2]^0xf;
		sKarakasa[i+2]=a;
	}
	
	
	
	//pongo los bidones pintables en el mapa
	mapset[20*40+26]=tBidonPintable;
	mapset[20*40+29]=tBidonPintable;
	mapset[21*40+11]=tBidonPintable;
	mapset[21*40+13]=tBidonPintable;
	mapset[21*40+26]=tBidonPintable;
	mapset[21*40+28]=tBidonPintable;
	mapset[21*40+30]=tBidonPintable;
	mapset[22*40+12]=tBidonPintable;
	mapset[22*40+26]=tBidonPintable;
	mapset[22*40+29]=tBidonPintable;
	mapset[23*40+10]=tBidonPintable;
	mapset[23*40+13]=tBidonPintable;
	mapset[23*40+26]=tBidonPintable;
	mapset[23*40+28]=tBidonPintable;
	mapset[23*40+30]=tBidonPintable;
/*	#asm
	di
	ld hl,_sprite0+2
	ld d,5
	
	.buc_2
	//push bc
	
	ld bc,64
	.buc_1
	ld a,$f
	xor (hl)
	ld (hl),a
	inc hl
	djnz buc_1


		
	dec d
	jp nz, buc_2
	//pop bc
	//djnz buc_2
	ei
	#endasm	  */
}

void ralentiza(void){
	unsigned char i;
	for (i=0;i<2;i++)
		pause();
	
}

void esperaTecla(void){

	while(!cpc_AnyKeyPressed()){}	
}

void mostrarHuevo(void){
	//La pantalla es en modo 1
	tintasNegro();
	cpc_SetMode(1);	
	cpc_Uncrunch(pantalla_huevo,0xc000);
//	set_colours();
	cpc_SetColour(0,13);
	cpc_SetColour(1,20);
	cpc_SetColour(2,3);
	cpc_SetColour(3,11);

	esperaTecla();
	
	//Restaurando la situacin
	tintasNegro();
	cpc_SetMode(0);
	cpc_Uncrunch(pantalla_marco,0xc000);	
	restaurarMarcadores();
	set_colours();
}

void tintasNegro(void){
	unsigned char i;
	for (i=0;i<17;i++)
		cpc_SetColour(i,20); 
}

void setTintas3 (unsigned char t){
	 cpc_SetInkGphStr(1,t);		//0 rojo oscuro (marron)
     cpc_SetInkGphStr(2,t);
     cpc_SetInkGphStr(3,t);
}

redefine_tecla(unsigned char tecla, unsigned char texto[]){
	unsigned char t;
	cpc_PrintGphStrXY(texto,10,190);
	cpc_RedefineKey(tecla); 
	cpc_WyzStartEffect(2,1);
	for (t=0;t<10;t++)
		ralentiza();
	cpc_PrintGphStrXY(";;;;;;;;;",10,190);		
}
main(){


      unsigned char bucle_menu, fin_juego, fin_pantalla, i,j, teclas;
      unsigned int a;
	  interrupciones();

      
      cpc_SetMode(0);
      tintasNegro();
	  rellenaPantalla();
	  cpc_AssignKey(4,0x4604);	// Tecla R para redefinir
	  cpc_AssignKey(5,0x4710);	// Tecla S para redefinir
	  //if (primera_ejecucion) {
	              //cpc_SetColour(1,19);
	              //primera_ejecucion=0;
	              //cpc_PutSp(esp_logo,39,25,0xc1aa);
	              
	              cpc_Uncrunch(pantalla_esp,0xc000);
	              set_colours();
	              esperaTecla();
	              //cpc_SetColour(1,4);
	              rellenaPantalla();
	              cpc_PrintGphStrXY("DEDICATED;TO;THE;LIVING",7*2+1,40);
	              cpc_PrintGphStrXY("MEMORY;;OF;;BENWAY;;SR<",7*2+1,48);
	              esperaTecla();
	              
      //        }
                       	 
	  //primera_ejecucion=1;
      
      cpc_WyzInitPlayer(TABLA_SONIDOS, TABLA_PAUTAS, TABLA_EFECTOS, TABLA_SONG);		//establece los datos que se usarn
      	//comienza la msica y los efectos
	//preparaBuffer();
	spritesXOR();
      while(1) {
      //MENU
      		  
              
			 cpc_WyzSetTempo(6);
             // for (i=0;i<17;i++)
             // 	cpc_SetColour(i,20); 
              tintasNegro();
      			//cpc_SetColour(i,tintas_hw_negro[i]); 	
			  cpc_SetInkGphStr(0,10); 
			  cpc_Uncrunch(pantalla_menu,0xc000);
			  cpc_WyzLoadSong(0);	//selecciona la cancin
			  cpc_WyzSetPlayerOn();	
			  setTintas3(170);
              //cpc_SetInkGphStr(1,170);		//0 rojo oscuro (marron)
              //cpc_SetInkGphStr(2,170);
              //cpc_SetInkGphStr(3,170);
              cpc_PrintGphStrXY("COMPUTER;EMUZONE",3*2+1,30);
              cpc_PrintGphStrXY("GAMES;STUDIO",5*2+1,38);
              setTintas3(2);
              //cpc_SetInkGphStr(1,2);
              //cpc_SetInkGphStr(2,2);
              //cpc_SetInkGphStr(3,2);                  
              cpc_PrintGphStrXY("PRESENTS",7*2+1,46);
              setTintas3(40);
              //cpc_SetInkGphStr(1,40);
              //cpc_SetInkGphStr(2,40);
              //cpc_SetInkGphStr(3,40);              
              cpc_PrintGphStrXY("MARIANO",8*2,68);
              cpc_PrintGphStrXY("THE;DRAGON",6*2+1,76);
              cpc_PrintGphStrXY("IN",10*2+1,84);
              cpc_PrintGphStrXY("CAPERS;IN;CITYLAND",2*2+1,92);
              setTintas3(42);
              //cpc_SetInkGphStr(1,42);
              //cpc_SetInkGphStr(2,42);
              //cpc_SetInkGphStr(3,42);          //2 blanco  
              cpc_PrintGphStrXY("MARIANO;CREATED;BY",2*2+1,106);
              cpc_PrintGphStrXY("KENDROOCK",7*2,114);
              setTintas3(34);
              //cpc_SetInkGphStr(1,34);		//8 azul
              //cpc_SetInkGphStr(2,34);
              //cpc_SetInkGphStr(3,34);             
              cpc_PrintGphStrXY("CODE:ARTABURU<ESP;SOFT",1,130);
              cpc_PrintGphStrXY("GFX:NA;THAN",6*2,138);
              cpc_PrintGphStrXY("DADMAN",10*2,146);         
              cpc_PrintGphStrXY("MUSIC:EIGHTBITER",4*2-1,154);       
              cpc_PrintGphStrXY("SFX:WYZ",8*2,162);      
              setTintas3(160);
              //cpc_SetInkGphStr(1,160);
              //cpc_SetInkGphStr(2,160);
              //cpc_SetInkGphStr(3,160);		//10 negro
              
              cpc_PrintGphStrXY("R:REDEFINE;S:START",2*2+1,174);
              set_colours();
              
              bucle_menu=1;
              while(bucle_menu){
	              
	              if (cpc_TestKey(4)==1) { //Tecla R
		              //Redefinir teclado
		              cpc_AssignKey(0,0x0000);
		              cpc_AssignKey(1,0x0000);
		              cpc_AssignKey(2,0x0000);
		              cpc_AssignKey(3,0x0000);
		              redefine_tecla(2,"SALTO");
		              redefine_tecla(3,"TRAMPA");
		              redefine_tecla(1,"IZQUIERDA");
		              redefine_tecla(0,"DERECHA");

		      /*        cpc_PrintGphStrXY("TRAMPA",10,190);
		              cpc_RedefineKey(1); 
		              cpc_WyzStartEffect(2,1);
		              ralentiza();
		              cpc_PrintGphStrXY("IZQUIERDA",10,190);
		              cpc_RedefineKey(2); 
		              cpc_WyzStartEffect(2,1);
		              ralentiza();
		              cpc_PrintGphStrXY("DERECHA;;",10,190);
		              cpc_RedefineKey(3); 
		              cpc_WyzStartEffect(2,1); */
		              	              
		              
	              }
	              if (cpc_TestKey(5)==1)
	              		bucle_menu=0;
              		
          	  }
                            

              
              
              
              cpc_WyzSetPlayerOff();
              cpc_WyzConfigurePlayer(8); 
              cpc_WyzSetPlayerOn();
              
              cpc_WyzStartEffect(2,2);	

              
  
              //for (i=0;i<17;i++)
      		  //	cpc_SetColour(i,20);           
      		  tintasNegro();	   
              cpc_Uncrunch(pantalla_marco,0xc000);
              set_colours();
        /*      cpc_SetInkGphStr(0,42);    
              cpc_SetInkGphStr(1,170); 
              cpc_SetInkGphStr(2,170); 
              cpc_SetInkGphStr(3,170);   */   

                     /*         hacerTransparente(1);
                          
                              cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(44,176));

                              hacerTransparente(2);
						
                               cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(36,176));

                              hacerTransparente(3);
                        
                              cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(32,176));

                              hacerTransparente(4);
                         
                              cpc_PutSpTr(buffer,16,4,cpc_GetScrAddress(40,176)); 
                              darLlave(0);
                              darLlave(1);
                              darLlave(2);
                              darLlave(3);
                              darLlave(4);
                              soltarLlave(0);
                              soltarLlave(2);
                              soltarLlave(1);
                              soltarLlave(3);
                              soltarLlave(4);

while(1){} */
              // All the sprite values are initilized
              sprite00.sp1=sprite3;
              sprite00.sp0=sprite3;
              //sprite00.ox=50;
              //sprite00.oy=40;
              sprite00.cx=30;
              sprite00.cy=40;
              sprite00.j0=0;
              sprite00.move=1;
              sprite00.coord0=cpc_GetScrAddress(sprite00.cx+DELTAx,sprite00.cy+DELTAy);
              sprite00.coord1=sprite00.coord0;

              /*restaurar karakasas y fantasmas*/
              for (a=0;a<10;a++){
                       posKarakasas[a]=1;
                       posFantasmas[a]=1;
              }


              /*restaurar objetos */
              for (a=0;a<21;a++)
                      listaObjetos[a*6+5]=1;
                      
              for (a=0;a<5;a++){        //restaura llaves
                      llaves[a]=0;
                      llavesUsadas[a]=0;
                  }

              for (a=0;a<4000;a++)  //restaurar bidones amarillos
                      if(mapset[a]==tBidonRojo)
                              mapset[a]=tBidonPintable; 
                              
			  fantasmas_atrapados=0;
              juego_completo=0;
			  liberados=0;
			  muerto=0;
              fin_juego=0;
              vida=80;
              karakasas=0;
              bidones=0;
              trampas=0;
              trampas_disponibles=0;
              estrellas=0;
              num_mapa=19 ; //45; //19;     //start screen
              
              map_number=40*num_mapa;
              
  
              
              coloresLetras1();         
              numero(estrellas);
              cpc_PrintGphStrXY(valorn,14,184);

              numero(trampas);
              
              cpc_PrintGphStrXY(valorn+1,26,184);    
      /*        cpc_SetInkGphStr(0,170);    
              cpc_SetInkGphStr(1,10); 
              cpc_SetInkGphStr(2,10); 
              cpc_SetInkGphStr(3,10); */
              coloresLetras2();
              numero(vida);
    		  cpc_PrintGphStrXY(valorn,16,1);
    		  
    		                            
              
              
              mapset[39*40+20]=26;
              mapset[49*40+20]=26;
              mapset[59*40+20]=26;
              mapset[69*40+20]=26;
              mapset[79*40+20]=26;
              //darLlave2(0);
              //darLlave(1);
              //darLlave2(2);
              //darLlave(3);
              //darLlave2(4); 
              
              //mostrarHuevo();
             // pos_disquete[5]=0;
              
			cpc_WyzSetTempo(7);				 
              mHuevo=1;
              while (!fin_juego){     //
              		  if (num_mapa==15)
              		  	mHuevo=1;		//cada vez q entra en la pantalla 15 se habilita
              		  				//el huevo de pascua
                      fin_pantalla=0;
                      set_map();
                      localizarObjeto();
					  localizarPersonaje();
                      buscarEnemigo();
                      //sprite01.move=1;
                      sprite01.jn=1;
                      //while(1) {}
                      //sprite00.j0=0;
                      cpc_PutSpriteXOR(sprite00.sp0,sprite00.coord0);
                      if(sprite01.move==1)
                               cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
                      if(sprite02.move==1)
                               cpc_PutSpriteXOR(sprite02.sp0,sprite02.coord0);                               
                      while(fin_pantalla==0){
                              //Default number keys for moving one of the sprites:
                              // 0: cursor right
                              // 1: cursor left
                              // 2: cursor up
                              // 3: cursor down
							  //Pausing the game a little bit
                              pause2();

                              teclas=0;
                              //if(sprite00.j0==2) {//keyboard detection
                              teclas=cpc_TestKey(0) + (cpc_TestKey(1)<<1) + (cpc_TestKey(2)<<2) + (cpc_TestKey(3)<<3);
                              //}
							  sprite00.sp1=sprite00.sp0;

                              //if falling detect the ground for sprite00
                              if (sprite00.j0!=1) {
                                      //if ((ReadTile(sprite00.cx/2,(sprite00.cy+17)/8))==0) {
                                      if ((miraVertical(sprite00.cx,sprite00.cy+16))==0) {
                                              //cpc_SpUpdY(sprite00,2);
                                              cpc_WyzStartEffect(1,0);
                                              sprite00.cy=sprite00.cy+4;
                                              sprite00.coord1=sprite00.coord0;
                                              sprite00.j0=0;
                                              if(sprite02.move==1)
                                                      checkKarakasa();
                                      } else  {
	                                      sprite00.j0=2;
	                                      if(sprite00.move==2) {
		                                      sprite00.sp0=sprite0+((sprite00.cx&1)*(66));
	                                      } else {
		                                      sprite00.sp0=sprite3+((sprite00.cx&1)*(66));
	                                      }
                                      }

                              }
                              if (sprite00.j0==1){
                                      sprite00.jn++;
                                      if (sprite00.jn==14) sprite00.j0=0;
                                      if (!(num_mapa<10 && (sprite00.cy-4)==0)) {
			                              if (((miraVertical(sprite00.cx,sprite00.cy-4))==0)) {
	                                              sprite00.cy=sprite00.cy-4;
	                                              cpc_WyzStartEffect(1,0);
	                                              sprite00.coord1=sprite00.coord0;
	
	                                      }
                                      }
                              }

                              if ((teclas&1)==1)  {
                                      if ((miraHorizontal(sprite00.cx+4,sprite00.cy))==0){
	                                      	  cpc_WyzStartEffect(1,0);
                                              sprite00.cx++;
                                          }
                                              sprite00.move=1;
                                              
                                              //if (sprite00.jn==2)
                                              //sprite00.sp1=sprite00.sp0;
                                              if(sprite00.j0==2) 
                                              	sprite00.sp0=sprite3+((sprite00.cx&1)*66);
                                              else 
                                              	sprite00.sp0=sprite5;
											                                                                                            
                              } else {
	                              if ((teclas&2)==2)  {
	                                      if ((miraHorizontal(sprite00.cx-1,sprite00.cy))==0){
		                                      	  cpc_WyzStartEffect(1,0);
	                                              sprite00.cx--;
                                              }
	                                              sprite00.move=2;
	                                              
	                                              //sprite00.sp1=sprite00.sp0;
	                                              //sprite00.sp0=sprite0;
	                                              if(sprite00.j0==2) 
	                                              	sprite00.sp0=sprite0+((sprite00.cx&1)*(66));
	                                              else 
	                                              	sprite00.sp0=sprite2;
	                              }
                              }

                              if ((sprite00.j0==2) && (teclas&4)==4)  { //jump
                                      sprite00.j0=1;
                                      sprite00.jn=0;
                                      //cpc_WyzStartEffect(1);
                                      if(sprite00.move==2) {
                                      	sprite00.sp0=sprite2;
                                  	} else {
	                                  	sprite00.sp0=sprite5;
                                  	}
                              }


                              //Interacciï¿½n con objetos
                              for (i=0;i<4;i++){
                                      j=9*i;
                                      if(listaObjetosPantalla[j]==255)
                                              break;
                                      else {
                                              if(listaObjetosPantalla[j+4]!=0 && checkObject(listaObjetosPantalla[j+2]+1,listaObjetosPantalla[j+3]+8)) {
                                                      accionObjeto(i);
                                              }
                                      }
                              }

                              
                              sprite00.coord0=cpc_GetScrAddress(sprite00.cx+DELTAx,sprite00.cy+DELTAy);
                              
                              sincroniza();
                              //main Sprite allways drawn
                              cpc_PutSpriteXOR(sprite00.sp1,sprite00.coord1);
                              cpc_PutSpriteXOR(sprite00.sp0,sprite00.coord0);
                              


                              if ((teclas&8)==8) {
                                      capturarFantasma();
                              }

                              //Enemy sprite, can be desapeared
                              if (sprite01.move==1){
                                      //if (tipo_enemigo==1) mueveSpriteB();
                                        //else mueveSpriteA();
                                        mueveSpriteA();
                                      cpc_PutSpriteXOR(sprite01.sp1,sprite01.coord1);
                                      sprite01.coord0=cpc_GetScrAddress(sprite01.cx+DELTAx,sprite01.cy+DELTAy);
                                      cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
                                      sprite01.coord1=sprite01.coord0;

                                      if (cpc_CollSp(sprite00,sprite01)) {
                                              collide();  //test if there is collision between sprite00 and sprite01
                                              //if not karakasa:
                                              //if(tipo_enemigo!=1) {   //el karakasa solo desaparece al pisarlo
                                                      cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
                                                      sprite01.move=0;

                                              //}
                                      }
                              }	
                              if (sprite02.move==1){
                                      //if (tipo_enemigo==1) mueveSpriteB();
                                        //else mueveSpriteA();
                                        mueveSpriteB();
                                      cpc_PutSpriteXOR(sprite02.sp1,sprite02.coord1);
                                      sprite02.coord0=cpc_GetScrAddress(sprite02.cx+DELTAx,sprite02.cy+DELTAy);
                                      cpc_PutSpriteXOR(sprite02.sp0,sprite02.coord0);
                                      sprite02.coord1=sprite02.coord0;

                                      if (cpc_CollSp(sprite00,sprite02)) {
                                              collide();  //test if there is collision between sprite00 and sprite01
                                      }
                              }
                              				
                              sprite00.coord1=sprite00.coord0;
                              	//finJuego();
                              //mira si hay que cambiar de pantalla
                              if (sprite00.cy==0 && sprite00.j0==1) fin_pantalla=1;
                                      else if (sprite00.cy>=144 && (sprite00.j0==0 || sprite00.j0==2)) {fin_pantalla=2;}
     
                              if (sprite00.cx==0) fin_pantalla=3;
                                      else if (sprite00.cx==60) {fin_pantalla=4; }
                              
                              if(muerto) {
	                              	  coloresLetras3();
                                      cpc_PrintGphStrXY("GAME;OVER",30,60);
                                      fin_pantalla=5; //game over
                              } 
                              if(juego_completo==1) {
	                              finJuego();
                              	  fin_pantalla=5;
                          	  }
                          	  if (mHuevo==3) {
					  			  fin_pantalla=6;
					  			  mHuevo=0;
				  	  		  }
                              
                      }

							
                      if(juego_completo!=1){
	                      //al terminar la pantalla, borra los sprites que haya
	                     // if (sprite00.move!=255)
	                      	cpc_PutSpriteXOR(sprite00.sp0,sprite00.coord0);
	                      if (sprite01.move==1)
	                              cpc_PutSpriteXOR(sprite01.sp0,sprite01.coord0);
	                      if (sprite02.move==1)
	                              cpc_PutSpriteXOR(sprite02.sp0,sprite02.coord0);
                         }
                      //if(num_mapa==10)
                      //      cpc_PrintGphStr("1",0xc000);
                      sprite01.move=0;
                      sprite02.move=0;
                      switch (fin_pantalla) {
                              case 1:         //arriba
                                      sprite00.cy=144
                                      num_mapa=num_mapa-10;
                                      //cpc_PrintGphStr("1",0xc000);
                                      break;
                              case 2:         //abajo
                                      sprite00.cy=0
                                      num_mapa=num_mapa+10;
                                      //cpc_PrintGphStr("2",0xc004);
                                      break;
                              case 3:         //izquierda
                                      sprite00.cx=59
                                      num_mapa=num_mapa-1;
                                      //cpc_PrintGphStr("3",0xc008);
                                      break;
                              case 4:         //derecha
                                      sprite00.cx=1
                                      num_mapa=num_mapa+1;
                                      //cpc_PrintGphStr("4",0xc00c);
                                      break;
                              case 5:
                                      fin_juego=1;
                                      for(i=0;i<200;i++)
                                              pause();
                                      break;
                              case 6:
									  mostrarHuevo();
                                      break;                                      
                      }

                      map_number=40*num_mapa;


                      sprite00.coord1=sprite00.coord0=cpc_GetScrAddress(sprite00.cx+DELTAx,sprite00.cy+DELTAy);

                      //while(1){}
              }
			cpc_WyzSetPlayerOff();
      }       //end menu
}


