/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#include <cpcrslib.h>
#include <cpcwyzlib.h>
#include "keyboard/keyboardtable.h"
#include "sprites/sprite.h"
#include "sprites/entidad.h"
#include "mapas/mapas.h"
#include "mapas/niveles.h"
#include "musica/music.h"
#include "jugar.h"
#include <stdlib.h>
#include <stdio.h>

//PAGES
#define P_0		0
#define P_1		1
#define P_2		2
#define P_3		3

void InitTeclasBasicas(void) 
{
	unsigned char i = 0;
	extern int vectorDeTeclas[];

	// Creating an array using ASM generates smaller code than using C
	__asm
		//ret						// Ensure we do not execute data as code
		jp end_data
		  _vectorDeTeclas:
			.dw KEY_CURSOR_UP 		// 0: ARRIBA
			.dw KEY_CURSOR_DOWN 	// 1: ABAJO
			.dw KEY_CURSOR_LEFT		// 2: IZQUIERDA
			.dw KEY_CURSOR_RIGHT	// 3: DERECHA
			.dw KEY_SPACE			// 4: ATAQUE MELE
			.dw KEY_E				// 5: ATAQUE DISTANCIA
			.dw KEY_DEL				// 6: PAUSA
			.dw KEY_ESC				// 7: SALIR
			.dw KEY_1				// 8: JUGAR MENU
			.dw KEY_2				// 9: CONTROLES MENU
			.dw KEY_3				// 10: SALIR MENU
			.dw KEY_S				// 11:Sonido On/Off
			.dw KEY_N
			.dw KEY_B
			
			.dw KEY_NONE
	    end_data:
	__endasm;	
	
	do { 
		cpc_AssignKey(i, vectorDeTeclas[i]);
		++i;
	} while (vectorDeTeclas[i] != KEY_NONE);
}


// Bucle principal del juego
unsigned char jugar() {

return jugarExterno();	

}

unsigned char go() {
	unsigned long int i = 0;
	cpc_ClrScr();
	
	cpc_PutSp(game, 20, 20, 0xC29F);	
	cpc_PutSp(over, 20, 20, 0xC3DF);	

	play(CANCION_GO);

	for(i = 0 ; i < 150000 ; i++);
	
	return E_MENU;
}

unsigned char logo() {
	int i = 0 , cont = 0;
	tEntidad orco;
	tEntidad cuchillo;
	tEntidad jugador;
	cpc_ClrScr();
	
	cpc_PutSp(fracture, 20, 40, 0xC294);
	cpc_PutSp(games, 20, 25, 0xCB8B);
	cpc_PutSp(presents, 8, 18, 0xCC7F);	
	
	IniciarEntidad(&orco,ORCO,19*4,8*16,3);
	IniciarEntidad(&cuchillo,ENT_CUCHILLO,19*4,8*16,1);
	IniciarEntidad(&jugador,PJ,19*4,8*16,1);
	
	orco.recorrido[0].x = 5;
	orco.recorrido[0].y = 8;
	cuchillo.recorrido[0].x = 5;
	cuchillo.recorrido[0].y = 8;
	jugador.recorrido[0].x = 9;
	jugador.recorrido[0].y = 8;
	
	orco.numRutas++;
	cuchillo.numRutas++;
	jugador.numRutas++;
	orco.aux1 = 1;
	cuchillo.aux1 = 0;
	PintarEntidad(&orco);
	
	play(CANCION_INICIO);
	
	do{
		if(i > (250-orco.aux2) ){
			if(cont > 5 && orco.aux1){
				IrA(&orco);
				PintarEntidad(&orco);
			}
			
			if(cuchillo.aux1){
				IrA(&cuchillo);
				PintarEntidad(&cuchillo);
			}
			
			if(jugador.aux1){
				if(jugador.aux2){
					if(probabilidad(20)){
						jugador.direccion = (jugador.direccion+1)%4;
						jugador.cambio = 1;
					}
				}
				else{
					if(IrA(&jugador)){
						jugador.aux2 = 1;
						jugador.direccion = 0;
						cont = 999;
					}
				}
					
				PintarEntidad(&jugador);
			}
			cont++;
			i = 0;
		}
		
		if(cont == 30){
			cuchillo.aux1 = 1;
			playEffect(2,1);
		}
		
		if(cont == 35){
			jugador.aux1 = 1;
			orco.aux2 = 100;
		}
		
		if(orco.aux1 && cont > 40 && orco.nueva.x+3 == cuchillo.nueva.x){
			orco.aux1 = 0;
			orco.aux2 = 0;
			cuchillo.aux1 = 0;
			PintarTrozoManchado(&orco);
			PintarTrozoManchado(&cuchillo);
			playEffect(2,0);
		}
		
		i++;
		
		if(cont == 1025)
			return E_MENU;
			
	}while(1);
	
	return E_MENU;
}

unsigned char menu(unsigned char *estadoAnterior) {
	unsigned char estado=E_MENU;
	*estadoAnterior = E_MENU;
	cpc_ClrScr();
	
	play(CANCION_MENU);
	cpc_PutSp(orcs, 20, 23, 0xC1FC);
	cpc_PutSp(dungeon, 20, 35, 0xC2E6);

	//if(Sonido)
		
	CambiarColoresTexto(0,170,170,170);
	cpc_PrintGphStrXY("1;JUEGA",31,105);
	cpc_PrintGphStrXY("2;CONTROLES",31,125); 	
	cpc_PrintGphStrXY("3;SALIR",31,145); 
	
	do {
		cpc_ScanKeyboard();
		if 		(cpc_TestKeyF(KEYID_MENU_1)) estado=E_INTRO;
		else if (cpc_TestKeyF(KEYID_MENU_2)) estado=E_CONTROLES;
		else if (cpc_TestKeyF(KEYID_MENU_3)) estado=E_SALIR;

	} while (estado == E_MENU);
	
	return estado;
}

unsigned char controles(unsigned char estadoAnterior) {
	cpc_ClrScr();
	playEffect(2,0);
	CambiarColoresTexto(0,170,170,170);
	cpc_PrintGphStrXY("E;;;;;;;;;;;LANZAR;ARMA;ARROJADIZA",6,30);  
	cpc_PrintGphStrXY("ESPACIO;;;;;ATAQUE;CUERPO;A;CUERPO",6,50); 
	cpc_PrintGphStrXY("ARRIBA;;;;;;;;;;DESPLAZARSE;ARRIBA",6,70);
	cpc_PrintGphStrXY("ABAJO;;;;;;;;;;;;DESPLAZARSE;ABAJO",6,90);
	cpc_PrintGphStrXY("IZQUIERDA;;;;DESPLAZARSE;IZQUIERDA",6,110);
	cpc_PrintGphStrXY("DERECHA;;;;;;;;DESPLAZARSE;DERECHA",6,130);
	cpc_PrintGphStrXY("ESCAPE;;;;;;;;;;;;;;;;;;;;;;;SALIR",6,150);
	CambiarColoresTexto(0,42,42,42);
	cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;CONTINUAR;",4,180);
	
	while(!cpc_AnyKeyPressed());
	playEffect(2,0);
	
	if( estadoAnterior == E_INTRO)
		return E_JUGAR;
	else
		return E_MENU;
		
}

unsigned char intro(unsigned char page, unsigned char *leido,unsigned char *estadoAnterior ) {

	unsigned char estado=E_INTRO;
	*estadoAnterior = E_INTRO;
	cpc_ClrScr();
	playEffect(2,0);
	CambiarColoresTexto(0,170,170,170);
	if(!*leido)
	{
		switch(page)
		{
		
			case P_0:
				cpc_PrintGphStrXY("CUENTA;LA;LEYENDA;QUE;EN;LO;MAS;",8,40);  
				cpc_PrintGphStrXY("PROFUNDO;DEL;TERRITORIO;ORCO;SE;",8,60); 
				cpc_PrintGphStrXY("ENCONDE;LA;MAZMORRA;QUE;ALBERGA;",8,80);
				cpc_PrintGphStrXY("EL;ORBE;SAGRADO;CAPAZ;DE;CONFERIR;",8,100);
				cpc_PrintGphStrXY("A;SU;PORTADOR;EL;PODER;DEL;TIEMPO;",8,120);
				CambiarColoresTexto(0,42,42,42);
				cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;CONTINUAR;",4,160);
			break;
		
			case P_1:
				cpc_PrintGphStrXY("SOLAMENTE;ALGUIEN;TAN;LOCO;COMO;",8,40);  
				cpc_PrintGphStrXY("GRAHIM;SE;AVENTURARIA;EN;UN;LUGAR;",8,60); 
				cpc_PrintGphStrXY("ASI;PUES;EL;ORBE;SE;ENCUENTRA;",8,80);
				cpc_PrintGphStrXY("CUSTODIADO;POR;LA;GUARDIA;ORCA;",8,100);
				cpc_PrintGphStrXY("Y;TODO;TIPO;DE;RETOS;IMPOSIBLES;",8,120);
				CambiarColoresTexto(0,42,42,42);
				cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;CONTINUAR;",4,160);
			break;
		
			case P_2:
				cpc_PrintGphStrXY("LAS;MALAS;LENGUAS;CUENTAN;QUE;",8,40);  
				cpc_PrintGphStrXY("QUIEN;ENTRA;NUNCA;CONSIGUE;SALIR;",8,60); 
				cpc_PrintGphStrXY("LABERINTOS;Y;PORTALES;TEMPORALES;",8,80);
				cpc_PrintGphStrXY("QUE;TE;HARAN;VOLVER;AL;PRINCIPIO;",8,100);
				cpc_PrintGphStrXY("ATREVETE;A;JUGAR;Y;ADENTRATE;",8,120);
				CambiarColoresTexto(0,42,42,42);
				cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;CONTINUAR;",4,160);
				estado=E_CONTROLES;
				*leido = 1;
			break;
		
		
		}
		
		while(!cpc_AnyKeyPressed());
	}else
		estado = E_JUGAR;
			
	return estado;
}

unsigned char final() {

	unsigned int i=0;
	cpc_ClrScr();
	
	CambiarColoresTexto(0,170,170,170);
	cpc_PrintGphStrXY("FELICIDADES;HAS;CONSEGUIDO;EL;",12,60);
	cpc_PrintGphStrXY("PODER;DE;DOMINAR;EL;TIEMPO;",12,80);
	CambiarColoresTexto(0,42,42,42);
	cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;CONTINUAR;",4,130);
	
	while(!cpc_AnyKeyPressed());
	while(cpc_AnyKeyPressed());
	playEffect(2,0);
	cpc_ClrScr();
	
	CambiarColoresTexto(0,170,170,170);
	cpc_PrintGphStrXY("CREDITOS",30,40);
	
	cpc_PrintGphStrXY("JOSE;MANUEL;SERRANO;",20,70);
	cpc_PrintGphStrXY("JUAN;POMARES;",20,90);
	cpc_PrintGphStrXY("JUAN;ENRIQUE;ALCARAZ",20,110);
	cpc_PrintGphStrXY("TOMAS;POVEDA",20,130);
	cpc_PrintGphStrXY("EVARIST;PEREZ",20,150);
	
	while(!cpc_AnyKeyPressed());
	while(cpc_AnyKeyPressed());
	playEffect(2,0);
	return E_MENU;
}


int main() {  

	unsigned char estado=E_LOGO;
	unsigned char page=P_0;
	unsigned char leido = 0;
	unsigned char estadoAnterior = E_LOGO;
	
	// cambiamos colores
	setColors(colores);
	//despues modo
	cpc_SetModo(0);
	
	//deshabilitamos firmware para tener mas recursos y inicializamos las teclas
	cpc_DisableFirmware();
	InitTeclasBasicas();

	// Controlar estados del juego
	while (estado != E_SALIR) {
		
		switch(estado){
			case E_LOGO: estado = logo();
			break;
			
			case E_MENU: estado = menu(&estadoAnterior);
			break;
			
			case E_INTRO: estado = intro(page,&leido,&estadoAnterior);
					
				switch(page)
				{
				
					case P_0:
						page=P_1;
					break;
				
					case P_1:
						page=P_2;
					break;
				
					case P_2:
						page=P_3;
					break;
				}
			break;
			
			case E_JUGAR: estado = jugar();
			break;
			
			case E_GO: estado = go();
			break;
			
			case E_CONTROLES: estado = controles(estadoAnterior);
			break;
			
			case E_FINAL: estado = final();
			break;
		}
		
	}

	// Restauramos firmware
	cpc_EnableFirmware();

	return 0;
}