/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#include <cpcwyzlib.h>
#include "music.h"

unsigned char playing = 0;

void play(unsigned char song) 
{
	if(playing)
		pause();
		
	cpc_WyzInitPlayer(SONGS[song].sound_table, SONGS[song].rule_table, SONGS[song].effect_table, SONGS[song].song_table);
	cpc_WyzLoadSong(0);
	cpc_WyzSetPlayerOn();
	
	playing = 1;
}

void playEffect(unsigned char channel, unsigned char effect)
{
	if(playing)
		cpc_WyzStartEffect(channel,effect); 
}

void pause() 
{
	if(playing)
		cpc_WyzSetPlayerOff();
		
	playing = 0;
}

void resume() 
{
	if(!playing)
		cpc_WyzSetPlayerOn();
		
	playing = 1;
}

