/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#include <cpcrslib.h>
#include "entidad.h"
#include "sprite.h"
#include "../musica/music.h"

tEntidad* jugador;
TNivel* niv;
tEntidad FLECHAS[MAX_NUM_FLECHAS];

unsigned char mapactual[ANCHO_MAPAS][ALTO_MAPAS];
unsigned char matrizRecorrido[ANCHO_MAPAS][ALTO_MAPAS];
unsigned char numFlechas = 0 ;
unsigned char alarma = 0;
unsigned char intentos_calcular_ruta=0;
tPosicionTile tposaux;

void PutSpriteMode0(unsigned char *pSprite, unsigned char nX, unsigned char nY, unsigned char nWidth, unsigned char nHeight)
{
	cpc_PutSp(pSprite, nHeight, nWidth, cpc_GetScrAddress(nX, nY)+80);
}

void PintarTrozoManchado(tEntidad *ent)
{
	PutSpriteMode0((unsigned char*)tilesMapa, ent->ant.x, ent->ant.y, ent->width, ent->height);
	ent->ant.x=ent->nueva.x; 
	ent->ant.y=ent->nueva.y;
}

void PintarEntidad(tEntidad *ent)
{
	if(ent->cambio)
	{
		PintarTrozoManchado(ent);
		ent->cambio=0;
	}
	
	PutSpriteMode0(ent->sprite+ent->direccion*ent->tamcelda, ent->nueva.x, ent->nueva.y, ent->width, ent->height);		
}

void CopiarEntidad(tEntidad *a, tEntidad *b)
{
	unsigned char aux;

	a->nueva.x=b->nueva.x;
	a->nueva.y=b->nueva.y;

	a->inicial.x=b->inicial.x;
	a->inicial.y=b->inicial.y;

	a->ant.x=b->ant.x;
	a->ant.y=b->ant.y;

	a->direccion=b->direccion;
	a->tipo=b->tipo;
	a->width=b->width;
	a->height=b->height;//Tamao del sprite 
	a->tamcelda=b->tamcelda;

	a->aux1=b->aux1;
	a->aux2=b->aux2;
	a->contRutas=b->contRutas;
	a->numRutas=b->numRutas;
	for(aux=0; aux<b->contRutas; aux++)
	{
		a->recorrido[aux].x=b->recorrido[aux].x;
		a->recorrido[aux].y=b->recorrido[aux].y;
	}

	a->probAscendente=b->probAscendente;
	a->estado=b->estado;
	a->alertado=b->alertado;
	a->gradoPatrulla=b->gradoPatrulla;
	a->rangoEscucha = b->rangoEscucha;
	a->contFlechas = b->contFlechas;

	a->velx=b->velx;
	a->vely=b->vely;
	a->cambio=b->cambio;
	a->sprite=b->sprite;
}

void IniciarEntidad(tEntidad *ent, unsigned char tipo, unsigned char x, unsigned char y, unsigned char direccion)
{
	/**************************************************
	Se pasa x y absolutas, no la posicion en el mapa
	************************************************/

  ent->cambio=1;//Para que la pinte la primera vez
  ent->inicial.x=x; ent->inicial.y=y;  
  ent->ant.x=x; ent->ant.y=y;
  ent->nueva.x=x; ent->nueva.y=y;
  ent->direccion=direccion;
  ent->tipo=tipo;
  
  // inicializacion de variables IA
  ent->aux1 = 0;
  ent->aux2 = 0;
  ent->contRutas = 0;
  ent->numRutas=0;
  ent->estado = ORCO_PATRULLA;
  ent->probAscendente = 0;
  ent->alertado=0;
  ent->gradoPatrulla = 5;
  ent->rangoEscucha = 3;
  ent->contFlechas = 0;
  
  
  switch(tipo)
  {
	case PJ:
		ent->width=4; ent->height=16;
		ent->velx=2;  ent->vely=4;
		ent->sprite=(unsigned char*)&heroe;
		break;
	case INSECTO:
		ent->width=4; ent->height=8;
		ent->velx=2;  ent->vely=4;
		ent->estado = BICHO_MOVERSE;
		ent->aux2 = (ent->direccion+1)%4;
		ent->sprite=(unsigned char*)&insecto;
		break;
	case ORCO:
		ent->width=4; ent->height=16;
		ent->velx=1;  ent->vely=2;
		ent->sprite=(unsigned char*)&orco;
		break;
	case ORCOA:
		ent->width=4; ent->height=16;
		ent->velx=1;  ent->vely=2;
		ent->gradoPatrulla = 2;
		ent->sprite=(unsigned char*)&orcoArquero;
		break;
	case ORCOJEFE:
		ent->width=4; ent->height=16;
		ent->velx=2;  ent->vely=4;
		ent->alertado = 1;
		ent->rangoEscucha = 5;
		ent->sprite=(unsigned char*)&orcoJefe;
		break;
		
	  /*************************************/
	 /*Aadir sprites de cuchillo y flecha*/
	/*************************************/
	case ENT_CUCHILLO:
		if(direccion == 0 || direccion == 2){
			ent->width=2;
			ent->height=8;
			ent->nueva.x=x+1;
			if(direccion == 0)
				ent->nueva.y=y-8;
			else
				ent->nueva.y=y+16;
		}
		else{
			ent->width=4;// Conversion del 8 a 4 dado que cada 1 cuenta por 2 pixels en horizontal
			ent->height=4;// Conversion del 2 a 4 dado que cada 1 cuenta por 2 pixels en horizontal
			ent->nueva.y=y+6;
			
			if(direccion == 1)
				ent->nueva.x=x-3;
			else
				ent->nueva.x=x+3;
		}
		ent->velx=2;
		ent->vely=4;
		
		ent->ant.x=ent->nueva.x; ent->ant.y=ent->nueva.y;
		ent->sprite=(unsigned char*)&cuchillo;
		break;
	case ENT_FLECHA:
		if(direccion == 0 || direccion == 2){
			ent->width=2;
			ent->height=8;
			ent->nueva.x=x+1;
			if(direccion == 0)
				ent->nueva.y=y-8;
			else
				ent->nueva.y=y+16;
		}
		else{
			ent->width=4;// Conversion del 8 a 4 dado que cada 1 cuenta por 2 pixels en horizontal
			ent->height=4;// Conversion del 2 a 4 dado que cada 1 cuenta por 2 pixels en horizontal
			ent->nueva.y=y+6;
			
			if(direccion == 1)
				ent->nueva.x=x-3;
			else
				ent->nueva.x=x+3;
		}
		ent->velx=2;
		ent->vely=4;
		
		ent->ant.x=ent->nueva.x; ent->ant.y=ent->nueva.y;
		ent->sprite=(unsigned char*)&flecha;
		break;

	case ENT_MELE:
		if(direccion == 0 || direccion == 2){
			ent->width=2;
			ent->height=8;
			if(direccion == 0)
			{
				ent->nueva.y=y-8;
				ent->nueva.x=x+2;
			}
			else
				ent->nueva.y=y+16;
		}
		else{
			ent->width=4;
			ent->height=4;
			ent->nueva.y = y+4;
			if(direccion == 1)
				ent->nueva.x=x-3;
			else
				ent->nueva.x=x+3;
		}
		ent->velx=1;
		ent->vely=2;
		ent->ant.x=ent->nueva.x; ent->ant.y=ent->nueva.y;
		ent->sprite=(unsigned char*)&cuchillo;
		break;
	}
	
	ent->tamcelda=ent->width*ent->height;
}

unsigned char EsColisionable(unsigned char x, unsigned char y, unsigned char tipoEnt)
{
	unsigned char tipo = mapactual[x][y];
	if(tipoEnt == PJ)
		return tipo==1;
	else
		return (tipo==1 || tipo==3);//Muros o puertas o portales
}

unsigned char EsColisionableTipo(unsigned char x, unsigned char y)
{
	unsigned char tipo = niv->mapa[ANCHO_MAPAS*y + x];
	if(tipo == 12)
	{
		 niv->posSalidas[0].posX=x;
		 niv->posSalidas[0].posY=y;
		 niv->posSalidas[0].dirPuerta=4;
		 niv->posSalidas[0].nivelAlQueLleva=50;
	}
	return colisionTiles[tipo];
}

unsigned char EsColision(unsigned char x, unsigned char y, unsigned char tipoEnt)
{
	return EsColisionable( x>>2, y>>4,tipoEnt);
}

unsigned char SePuedeMover(tEntidad *ent)
{
	unsigned char celdax, celday;
	
	celdax=ent->nueva.x>>2; // 2^2=4 es el ancho de los tiles, es el que se necesita
	celday=ent->nueva.y>>4; // 2^4=16 es el alto de los tiles, es el que se necesita
	if(!EsColisionable(celdax,celday,ent->tipo))
	{			
		if(celdax!=(ent->nueva.x+ent->width-1)>>2)
		{
			if(celday!=(ent->nueva.y+ent->height-1)>>4)
			{ 
				if(EsColisionable(celdax,celday+1,ent->tipo) || EsColisionable(celdax+1,celday+1,ent->tipo) || EsColisionable(celdax+1,celday,ent->tipo))
					return 0;
			}else
				if(EsColisionable(celdax+1,celday,ent->tipo))
					return 0;
		}else
			if(celday!=(ent->nueva.y+ent->height-1)>>4)
				if(EsColisionable(celdax,celday+1,ent->tipo))
					return 0;
	}else
		return 0;
	return 1;
}

unsigned char PuedeMoverse(unsigned char *posx ,unsigned char *posy , unsigned char dir , unsigned char *dirActual)
{
	switch(dir)
	{
		case 0: *posy=*posy-1;
			break;
		case 1: *posx=*posx-1;
			break;
		case 2: *posy=*posy+1;
			break;
		case 3: *posx=*posx+1;
			break;
		default:
			return 0;
			break;			
	}
	
	if(matrizRecorrido[*posx][*posy] != 0)
	{
		switch(dir)
		{
			case 0: *posy=*posy+1;
				break;
			case 1: *posx=*posx+1;
				break;
			case 2: *posy=*posy-1;
				break;
			case 3: *posx=*posx-1;
				break;
		}
		return 0;
	}
	*dirActual = dir;
	return 1;
}

unsigned char MoverEntidad(tEntidad *ent, unsigned char dir)
{
	switch(dir)
	{
		case 0://Arriba
			ent->nueva.y-=ent->vely;
		break;
		
		case 1://Izquierda
			ent->nueva.x-=ent->velx;
		break;
		
		case 2://Abajo
			ent->nueva.y+=ent->vely;
		break; 
		
		case 3://derecha
			ent->nueva.x+=ent->velx;
		break;
		
	}

	if(!SePuedeMover(ent))
	{
		ent->nueva.y=ent->ant.y;
		ent->nueva.x=ent->ant.x;
		if(dir!=ent->direccion)
		{
			//ent->cambio=1;
			ent->direccion=dir;
			return 0;
		}
		else
			ent->cambio=0;
	}else
	{
		ent->direccion=dir;
		ent->cambio=1;
	}
	return ent->cambio;
}

unsigned char ComprobarPuertas(tEntidad *ent , unsigned char pospuertax , unsigned char pospuertay, unsigned char dirPuerta)
{
	unsigned char pospixelpuertaX = pospuertax<<2;
	unsigned char pospixelpuertaY = pospuertay<<4;
	
	switch(dirPuerta)
	{	
		case 0: 
			if( (ent->nueva.x >= pospixelpuertaX && ent->nueva.x <= (pospixelpuertaX+8) )
					&& ent->nueva.y < pospixelpuertaY+14)
						return 1;
				break;
		case 1: 
			if( (ent->nueva.y >= pospixelpuertaY && ent->nueva.y <= (pospixelpuertaY+16) )
					&& ent->nueva.x < pospixelpuertaX+3)
						return 1;
				break;
		case 2: 
			if( (ent->nueva.x >= pospixelpuertaX && ent->nueva.x <= (pospixelpuertaX+8) )
					&& ent->nueva.y > pospixelpuertaY)
						return 1;
				break;
		case 3: if( (ent->nueva.y >= pospixelpuertaY && ent->nueva.y <= (pospixelpuertaY+16) )
					&& ent->nueva.x > pospixelpuertaX-3)
						return 1;
				break;	
		
		case 4:/*Orbe final*/
		   if(((ent->nueva.x+ent->width-1) < pospixelpuertaX) || (ent->nueva.x>(pospixelpuertaX+3)))
				return 0;
		   else if(((ent->nueva.y+ent->height-1) < pospixelpuertaY+8) || (ent->nueva.y>(pospixelpuertaY+15)))
				return 0;
		   return 1;
	}
		
	return 0;
	
}

unsigned char avance(tEntidad* ent)
{
	// Si da + se mueve hacia izquierda,si da- se mueve hacia derecha, si da= se mueve verticalmente
	//int difx = ent->nueva.x - (ent->recorrido[ent->contRutas].x<<2);
	//int dify = ent->nueva.y - (ent->recorrido[ent->contRutas].y<<4);
	int difx = (ent->nueva.x>>2) - ent->recorrido[ent->contRutas].x;
	int dify = (ent->nueva.y>>4) - ent->recorrido[ent->contRutas].y;
	
	
	if(difx == 0 && dify == 0)
		return 1;
	
	return 0;
}

unsigned int abs(int n){ return (n < 0) ? -n : n;}
unsigned char probabilidad(unsigned char probable)
{
	unsigned char numero=cpc_Random()%100;
	if(numero<(probable))
		return 1;
	else
		return 0;
}

void MoverEntidadIA(tEntidad *ent)
{
	if(ent->contFlechas > 0)
	{	
		if(ent->contFlechas > 10)
			ent->contFlechas = 0;
		else
			ent->contFlechas++;
	}
	
	switch(ent->estado)
	{		
		case ORCO_MIRANDO: 
			//cpc_PrintGphStrXY("MIRANDO;;;",4,8);
			Mirando(ent);
			break;
		
		case ORCO_PATRULLA: 
			//cpc_PrintGphStrXY("PATRULLA;;",4,8);
			Patrullar(ent);
			break;
			
		case ORCO_DAR_ALARMA: 
			//cpc_PrintGphStrXY("DAR;ALARMA",4,8);
			ActivarAlarma(ent);
			break;
			
		case ORCO_ALERTADO: 
			//cpc_PrintGphStrXY("ALERTADO;;",4,8);
			Alertado(ent);
			break;
		case ORCO_ATACAR:
			//cpc_PrintGphStrXY("ATACAR;;;;",4,8);
			AtacarOrco(ent);
			break;
			
		case ORCO_ALERTA:
			//cpc_PrintGphStrXY("ALERTA;;;;",4,8);
			Alerta(ent);
			break;
			
		case BICHO_MOVERSE: MoverBicho(ent);
			break;
		
		case BICHO_ATACAR: BichoAtaca(ent);
			break;
			
		default:
			break;			
	}
}

unsigned char ColisionEntidades(tEntidad *eA, tEntidad *eB) 
{	
	if(((eA->nueva.x+eA->width-1) < eB->nueva.x) || (eA->nueva.x>(eB->nueva.x+eB->width-1)))
		return 0;
	else if(((eA->nueva.y+eA->height-1) < eB->nueva.y) || (eA->nueva.y>(eB->nueva.y+eB->height-1)))
		return 0;

    return 1;
}

unsigned char CalcularMele(unsigned char dirPj)
{	
	if(dirPj==0)
		return 1;
	else if(dirPj==2)
			return 3;
		else
			return 2;
}

void RellenarMapaNumero(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char num)
{
	unsigned char celdax=x>>2;//4=2^2
	unsigned char celday=y>>4;//16=2^4
		
	mapactual[celdax][celday]=num;
		
	if(celdax!=(x+width-1)>>2)//Esta en medio de dos
	{
		mapactual[celdax+1][celday]=num;
		
		if(celday!=(y+height-1)>>4)//Esta en medio de dos
		{
			mapactual[celdax][celday+1]=num;
			mapactual[celdax+1][celday+1]=num;
		}
	}else if(celday!=(y+height-1)>>4)//Esta en medio de dos
			mapactual[celdax][celday+1]=num;

}

void RellenarMapaColisiones()
{
	unsigned char i=0, j=0;
	
	for(i=0; i<ANCHO_MAPAS; i++)
		for(j=0; j<ALTO_MAPAS; j++)
			mapactual[i][j]=EsColisionableTipo(i, j);
}

// Devuelve si se ha escuchado o no al pj
unsigned char escuchar(tEntidad *enemigo, unsigned char lado, unsigned char absol)
{
	unsigned char difx = 0 , dify = 0 ,difTotal = 0;
	
	difx = abs((jugador->nueva.x>>2) - (enemigo->nueva.x>>2));
	dify = abs((jugador->nueva.y>>4 )- (enemigo->nueva.y>>4));
	difTotal = difx+dify;
	
	if(difTotal <= lado)
		if(absol)
			return 1;
		else
			return probabilidad( (100/lado)*(lado-difTotal+1) );
			
	return 0;	
}

unsigned char ver(unsigned char x, unsigned char y, unsigned char dir)
{
	int i = 0;
	switch(dir)
	{
		case 0://Arriba
			for(i=y-1; i>=0; i--){
				if(mapactual[x][i] == 1)
					return 0;
				if(mapactual[x][i] == 6)
					return 1;
			}
			break;
		case 1://Izquierda			
			for(i=x-1; i>=0; i--){
				if(mapactual[i][y] == 1)
					return 0;
				if(mapactual[i][y]==6)
					return 1;
			}
			break;
		case 2://Abajo
			for(i=y+1; i<ALTO_MAPAS; i++){
				if(mapactual[x][i] == 1)
					return 0;
				if(mapactual[x][i]==6)
					return 1;
			}
			break;
		case 3://Derecha
			for(i=x+1; i<ANCHO_MAPAS; i++){
				if(mapactual[i][y] == 1)
					return 0;
				if(mapactual[i][y]==6)
					return 1;
			}
			break;
	}
	return 0;
}

unsigned char lanzarFlecha(tEntidad* ent)
{
	if(numFlechas < MAX_NUM_FLECHAS && ent->contFlechas == 0 )
	{
		IniciarEntidad(&FLECHAS[numFlechas], ENT_FLECHA, ent->nueva.x,ent->nueva.y,ent->direccion);
		if(MoverEntidad(&FLECHAS[numFlechas], FLECHAS[numFlechas].direccion))
		{
			ent->contFlechas++;
			numFlechas++;
			playEffect(2,1);
		}
	}
	return 0;
}

unsigned char IrA(tEntidad *ent)
{
	// Suponemos que uno de los dos valores es igual al otro y que no hay colisones dado
	//  que esa funcion se delega al metodo qque crea las rutas.
	if(ent->contRutas < ent->numRutas)
	{
		tposaux.x= ent->recorrido[ent->contRutas].x;
		tposaux.y= ent->recorrido[ent->contRutas].y;
			
		if(ent->nueva.x == (tposaux.x<<2))
		{
			if(ent->nueva.y < (tposaux.y<<4))
			{
				ent->direccion = 2;
				ent->nueva.y+=ent->vely;
			}else
			{
				if(ent->nueva.y > (tposaux.y<<4))
				{
				ent->direccion = 0;
				ent->nueva.y-=ent->vely;
				}else
				{
					ent->cambio=1;
					return 1;
				}
			}

			if( (ent->direccion == 0 || ent->direccion == 2) && (ent->nueva.y == (tposaux.y<<4)) /* && (ent->nueva.y+ent->height-1)==(pos->y<<4)*/ )
			{
				ent->cambio=1;
				return 1;
			}
		}else
		{
			if(ent->nueva.x < (tposaux.x<<2))
			{
				ent->direccion = 3;
				ent->nueva.x+=ent->velx;
			}else
			{
				ent->direccion = 1;
				ent->nueva.x-=ent->velx;
			}

			if( (ent->direccion == 1 || ent->direccion == 3) && (ent->nueva.x == (tposaux.x<<2)) )
			{			
				ent->cambio=1;
				return 1;
			}
		}   
		ent->cambio=1;
	}else
	{
		ent->numRutas = 0 ;
		ent->contRutas = 0;
	}
	return 0;
}

unsigned char DondeMirarTile(unsigned char tilex, unsigned char tiley)
{
	unsigned char dirs[4] = {0,0,0,0};
	unsigned char aux;

	do
	{
		do
		{
			aux = cpc_Random()%4;
			if(dirs[aux] != 1)
				break;
		}while(1);
		
		switch(aux)
		{
			case 0: if(!EsColisionable(tilex , tiley-1 , 1)) return aux;	break;	
			
			case 1: if(!EsColisionable(tilex-1 , tiley , 1)) return aux;	break;	
			
			case 2: if(!EsColisionable(tilex , tiley+1 , 1)) return aux;	break;
			
			case 3: if(!EsColisionable(tilex+1 , tiley , 1)) return aux;	break;
		}
		dirs[aux] = 1;
	}while(1);
	
	return aux;
}

// devuelve una direccion aleatoria en base a las direcciones en las que se pueden ver (no mira hacia paredes)
unsigned char DondeMirar(tEntidad *ent)
{
	return DondeMirarTile(ent->nueva.x >> 2,ent->nueva.y >> 4);
}

unsigned char mirar(tEntidad *ent)
{
	unsigned char x=ent->nueva.x>>2;
	unsigned char y=ent->nueva.y>>4;
	
	if(ent->tipo==ORCOJEFE)
		return ( ver(x, y, 0) || ver(x, y, 1) || ver(x, y, 2) || ver(x, y, 3) );
	else
		return ver(x, y, ent->direccion);
}

void CrearTPosAleatoria(unsigned char actx, unsigned char acty, unsigned char desviacion)
{
	int posX = 0 , posY = 0;
	
	do
	{
		posX = actx + cpc_Random()%desviacion - cpc_Random()%desviacion;
		posY = acty + cpc_Random()%desviacion - cpc_Random()%desviacion;
		if(posX < 0 || posX >= ANCHO_MAPAS)
			posX = actx;
		if(posY < 0 || posY >= ALTO_MAPAS)
			posY = acty;
		if(!EsColisionable(posX,posY,1) && (posX != actx || posY != acty))
			break;
	}while(1);
	 
	tposaux.x = posX;
	tposaux.y = posY;
}

void CalcularRutaRecta(tEntidad *ent , tPosicionTile *tpos)
{
	int dirx = (ent->nueva.x >> 2) - tpos->x;
	int diry = (ent->nueva.y >> 4) - tpos->y;
	ent->contRutas = 0;
	ent->numRutas = 0;
	
	if(dirx!=0)// Movemos en X
	{
		if(tpos->y!=((ent->nueva.y+ent->height-1) >> 4))
		{
			ent->numRutas++;
			ent->recorrido[0].x = ent->nueva.x >> 2;
			ent->recorrido[0].y = ent->nueva.y >> 4;
		}			
	}else// Movemos en y
	{
		if( tpos->x!=((ent->nueva.x+ent->width-1) >> 2) )
		{
			ent->numRutas++;
			ent->recorrido[0].x = ent->nueva.x >> 2;
			ent->recorrido[0].y = ent->nueva.y >> 4;
		}		
	}

	ent->recorrido[ent->numRutas].x = tpos->x;
	ent->recorrido[ent->numRutas].y = tpos->y;
	ent->numRutas++;
}

void CalcularRuta(tEntidad *ent , tPosicionTile *tpos)
{
 // Inicializacion
	unsigned char posx = (ent->nueva.x) >> 2;
	unsigned char posy = (ent->nueva.y) >> 4;
	unsigned char dirPrefx, dirPrefy, cont=0;
	unsigned char i , j ,dirActual = ent->direccion;
	unsigned char dirpref;
	int difx = 0 , dify = 0;
	intentos_calcular_ruta++;
	
	//cpc_PrintGphStrXY("F",tpos->x*4,tpos->y*16+8);
	
 // inicializacion matriz.
	for(i = 0 ; i < ANCHO_MAPAS ; i++)
		for(j = 0 ; j < ALTO_MAPAS ; j++)
			if(mapactual[i][j] == 1 || mapactual[i][j] == 3)
				matrizRecorrido[i][j] = 1;
			else
				matrizRecorrido[i][j] = 0;

	ent->contRutas = 0;	
	if(posx!=((ent->nueva.x+ent->width-1) >> 2) || posy!=((ent->nueva.y+ent->height-1) >> 2))			
	{
		ent->recorrido[0].x = posx;		
		ent->recorrido[0].y = posy;
		matrizRecorrido[posx][posy]=1;
		
		ent->numRutas = 1;
	}else
		ent->numRutas = 0;
	

	do{
		difx = posx - tpos->x;
		dify = posy - tpos->y;
		
		if(difx > 0)
			dirPrefx = 1;
		else
			if(difx<0)
				dirPrefx = 3;
			else
				dirPrefx=1+2*probabilidad(50);
				
		if(dify > 0)
			dirPrefy = 0;
		else
			if(dify<0)
				dirPrefy = 2;
			else
				dirPrefy=2*probabilidad(50);
			
		//Comprobaciones
		if(difx!=0)
			dirpref=probabilidad(100*(difx+dify)/(difx));
		else
			dirpref=0;
		// Comprobacion de si puede moverse en x y es una direccion preferente
		if((dirpref && !PuedeMoverse(&posx,&posy,dirPrefx,&dirActual)) || (!dirpref && !PuedeMoverse(&posx,&posy,dirPrefy,&dirActual))  ){
			// Comprobacion de si puede moverse en Y y es una direccion preferente
			if((dirpref && !PuedeMoverse(&posx,&posy,dirPrefy,&dirActual)) ||  (!dirpref && !PuedeMoverse(&posx,&posy,dirPrefx,&dirActual))){
				
				if(dirPrefx == dirActual || dirPrefy == dirActual)
				{
					if( probabilidad(60) ){
							if( !PuedeMoverse(&posx,&posy,(dirPrefx+2)%4,&dirActual) )
								if(!PuedeMoverse(&posx,&posy,(dirPrefy+2)%4,&dirActual) )
								{
									break;
								}
						}
						else{
							if(!PuedeMoverse(&posx,&posy,(dirPrefy+2)%4,&dirActual) )
								if( !PuedeMoverse(&posx,&posy,(dirPrefx+2)%4,&dirActual) )
								{
									break;
								}
						}
				}else{
					if( !PuedeMoverse(&posx,&posy,dirActual,&dirActual) )
						if( !PuedeMoverse(&posx,&posy,(6-(dirActual+dirPrefx+dirPrefy)),&dirActual) )
						{
							break;
						}
				}
			}
		}
		
		ent->recorrido[ent->numRutas].x = posx;
		ent->recorrido[ent->numRutas].y = posy;
		ent->numRutas++;
		
		matrizRecorrido[posx][posy]=1;
	
		
		if(posx==tpos->x && posy==tpos->y)
			break;
		else
			if(ent->numRutas==PUNTOS_MAX_RUTA)
			{	
				if(intentos_calcular_ruta < 2)
				{
					CalcularRuta(ent, tpos);
					break;
				}
				else
				{
					if(intentos_calcular_ruta < 5){
						CrearTPosAleatoria(ent->nueva.x>>2, ent->nueva.y>>4, 5);
						tpos->x = tposaux.x;
						tpos->y = tposaux.y;
						CalcularRuta(ent, tpos);
						break;
					}
					else
						break;
				}
			}
			
	}while(1);
	intentos_calcular_ruta=0;
	//cpc_PrintGphStrXY("I",posx*4,posy*16+8);
}

// Metodos estados IA
void Alertado(tEntidad *ent)
{			
	ent->alertado=1;
	if(ent->tipo!=ORCOA)
	{
		ent->velx*=2;
		ent->vely*=2;
		tposaux.x = ent->inicial.x>>2;
		tposaux.y = ent->inicial.y>>4;
		ent->gradoPatrulla *= 2;			 
		CalcularRuta(ent,&tposaux);
		if( IrA(ent) )
			ent->contRutas = (ent->contRutas+1);
		
	}else
	{	
		if(niv->numSalidas)
		{
			unsigned char salida_proteger=cpc_Random()%niv->numSalidas;
			CrearTPosAleatoria(niv->posSalidas[salida_proteger].posX, niv->posSalidas[salida_proteger].posY, 3);
			ent->inicial.x=tposaux.x<<2;
			ent->inicial.y=tposaux.y<<4;
			
			ent->gradoPatrulla=2;		
			CalcularRuta(ent,&tposaux);
			if( IrA(ent) )
				ent->contRutas = (ent->contRutas+1);
		}		
	}
	ent->estado = ORCO_PATRULLA;	
}

void Mirando(tEntidad *ent)
{
	if( !alarma || ent->alertado )
	{
		if(!mirar(ent))
		{
			if(!escuchar(ent, ent->rangoEscucha, 0))
			{
				if( probabilidad(30) ){
					ent->direccion = DondeMirar(ent);
					ent->cambio = 1;
				}	
				else
					if(probabilidad(ent->probAscendente)){
						ent->probAscendente = 1;
						ent->estado = ORCO_PATRULLA;
					}
				
				ent->probAscendente += 2;
			}
			// Si te escucha se pone en estado alerta
			else {
				if(alarma)
					ent->estado = ORCO_ATACAR;
				else
					ent->estado = ORCO_ALERTA;
			}
		}
		// Si te ve, si hay alarma la dara y si no ira a por ti
		else
		{
			if(ent->tipo == ORCOJEFE && !alarma){
				alarma =1;
				if(niv->hayAlarma)
					PutSpriteMode0((unsigned char*)tilesMapa+(4*16*11), niv->alarma.posX<<2,niv->alarma.posY<<4, 4, 16);
				playEffect(2,4);
			}
		
			if(niv->hayAlarma && !alarma)
			{
				tposaux.x = niv->alarma.posX;
				tposaux.y = niv->alarma.posY;
				switch(niv->alarma.dirAlarma){
					case 0:
						tposaux.y++;
						break;
					case 1:
						tposaux.x++;
						break;
					case 2:
						tposaux.y--;
						break;
					case 3:
						tposaux.x--;
						break;
				}
				CalcularRuta(ent,&tposaux);
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
				
				ent->estado = ORCO_DAR_ALARMA;
			}else
			{
				tposaux.x = jugador->nueva.x >> 2;
				tposaux.y = jugador->nueva.y >> 4;
				
				CalcularRutaRecta(ent,&tposaux);
				
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
					
				ent->estado = ORCO_ATACAR;
			}			
		}	
	}
	// Si hay alarma, cancela y vuelve a patrulla donde se le mejoraran los stats y hara lo pertinente.
	else
		ent->estado = ORCO_PATRULLA;	
}

void Patrullar(tEntidad *ent)
{
	if( !alarma || ent->alertado  )
	{
		if(!mirar(ent) )
		{
			if(!escuchar(ent, ent->rangoEscucha, 0))
			{
				if(probabilidad(1))
				{
					ent->direccion = DondeMirar(ent);
					ent->probAscendente = 1;
					ent->estado = ORCO_MIRANDO;
				}else
				{
					if( ent->numRutas==0 || IrA(ent) )
					{
						if(ent->numRutas==ent->contRutas)
						{
							 if(ent->inicial.x==ent->nueva.x && ent->inicial.y==ent->nueva.y)
							 {
								  CrearTPosAleatoria(ent->nueva.x>>2, ent->nueva.y>>4, ent->gradoPatrulla);								  
								  CalcularRuta(ent,&tposaux);
								  if( IrA(ent) )
									ent->contRutas = (ent->contRutas+1);
									
								  ent->estado = ORCO_MIRANDO;
								  //Esta en la primera casilla
							 }else
							 {
								tposaux.x = ent->inicial.x>>2;
								tposaux.y = ent->inicial.y>>4;
								
								CalcularRuta(ent,&tposaux);
								if( IrA(ent) )
									ent->contRutas = (ent->contRutas+1);
									
								ent->estado = ORCO_MIRANDO;
							 }
							 ent->contRutas=0;
						}else
							ent->contRutas++;
					}								
				}						
			}else
			{ //Si lo escucha y hay alarma enchufada, ataca, si no, va donde ha escuchado algo
				if(alarma)
					ent->estado = ORCO_ATACAR;
				else
					ent->estado = ORCO_ALERTA;
			}		
		// Si lo ve, si hay alarma se va a la alarma si no se ataca
		}else
		{
			if(ent->tipo == ORCOJEFE && !alarma)
			{
				alarma =1;
				if(niv->hayAlarma)
					PutSpriteMode0((unsigned char*)tilesMapa+(4*16*11), niv->alarma.posX<<2,niv->alarma.posY<<4, 4, 16);
				playEffect(2,4);
			}	

			if(niv->hayAlarma && !alarma)
			{
				tposaux.x = niv->alarma.posX;
				tposaux.y = niv->alarma.posY;
				switch(niv->alarma.dirAlarma)
				{
					case 0:
						tposaux.y++;
						break;
					case 1:
						tposaux.x++;
						break;
					case 2:
						tposaux.y--;
						break;
					case 3:
						tposaux.x--;
						break;
				}
				CalcularRuta(ent,&tposaux);
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
					
				ent->estado = ORCO_DAR_ALARMA;
			}else
			{
				tposaux.x = jugador->nueva.x >> 2;
				tposaux.y = jugador->nueva.y >> 4;
				
				CalcularRutaRecta(ent,&tposaux);
				
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
					
				ent->estado = ORCO_ATACAR;
			}
		}
	// Si hay alarma se marca como alertado y se pasa al estadoque se le cambia los stats
	// o en el caso de los arquros, se les dice de ir a las puertas.
	}else
	{	
		//Si hay avance cambiamos, si no seguimos moviendo		
		if(avance(ent)){
			ent->alertado=1;					
			ent->estado = ORCO_ALERTADO;
		}
		IrA(ent);

	}

}

void Alerta(tEntidad *ent)
{
	if( !alarma && !ent->alertado)
	{
		if( !mirar(ent) ){
			// si no se escucha tiene que ir al ultimo punto procesado
			if(!escuchar(ent, ent->rangoEscucha, 0))
			{
				if(IrA(ent))
					ent->contRutas = (ent->contRutas+1);
				if(ent->numRutas == 0){
					CrearTPosAleatoria(ent->nueva.x>>2, ent->nueva.y>>4, 3);								  
					CalcularRuta(ent,&tposaux);
					ent->estado = ORCO_MIRANDO;
				}
			}
			//Si te escucha se recalcula la ruta y se mueve
			else{
				if(IrA(ent))
					ent->contRutas = (ent->contRutas+1);
				if(ent->numRutas == 0){
					tposaux.x = jugador->nueva.x>>2;
					tposaux.y =	jugador->nueva.y>>4;								  
					CalcularRuta(ent,&tposaux);
				}
			}
		}
		// Si lo ve, si hay alarma se va a la alarma si no se ataca
		else{
			if(ent->tipo == ORCOJEFE && !alarma){
				alarma =1;
				if(niv->hayAlarma)
					PutSpriteMode0((unsigned char*)tilesMapa+(4*16*11), niv->alarma.posX<<2,niv->alarma.posY<<4, 4, 16);
				playEffect(2,4);				
			}
		
			if(niv->hayAlarma && !alarma)
			{
				tposaux.x = niv->alarma.posX;
				tposaux.y = niv->alarma.posY;
				switch(niv->alarma.dirAlarma){
					case 0:
						tposaux.y++;
						break;
					case 1:
						tposaux.x++;
						break;
					case 2:
						tposaux.y--;
						break;
					case 3:
						tposaux.x--;
						break;
				}
				CalcularRuta(ent,&tposaux);
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
				ent->estado = ORCO_DAR_ALARMA;
			}else
			{
				tposaux.x = jugador->nueva.x >> 2;
				tposaux.y = jugador->nueva.y >> 4;
				
				CalcularRutaRecta(ent,&tposaux);
				
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
					
				ent->estado = ORCO_ATACAR;
			}
		}
	}
	// Si hay alarma, cancela y vueve a patrulla donde se le mejoraran los stats y hara lo pertinente.
	else
		ent->estado = ORCO_PATRULLA;
}

void ActivarAlarma(tEntidad *ent)
{
	if(!alarma)
	{
		if( ent->numRutas==0 || IrA(ent) )
		{
			if(ent->numRutas==ent->contRutas)
			{
				alarma = 1;
				PutSpriteMode0((unsigned char*)tilesMapa+(4*16*11), niv->alarma.posX<<2,niv->alarma.posY<<4, 4, 16);
				playEffect(2,6);
				ent->estado = ORCO_ALERTADO;
			}else
				ent->contRutas++;
		}
	}else
	{
		if(avance(ent)){
			ent->alertado=1;					
			ent->estado = ORCO_ALERTADO;
		}	
		IrA(ent);
	}
}

void AtacarOrco(tEntidad *ent)
{	
	if( !mirar(ent) )
	{
		
		if(ent->numRutas == 0){
			if(escuchar(ent, ent->rangoEscucha, 1)){
				tposaux.x = jugador->nueva.x >> 2;
				tposaux.y = jugador->nueva.y >> 4;
				CalcularRuta(ent,&tposaux);
			}
			else{
				CrearTPosAleatoria(ent->nueva.x>>2, ent->nueva.y>>4, 2);								  
				CalcularRuta(ent,&tposaux);
				ent->estado = ORCO_MIRANDO;
			}
		}	
		
		if( IrA(ent) )
			ent->contRutas = (ent->contRutas+1);
			
	}
	// si el orco ve al pj, se renueva la ruta
	else{
		if(ent->tipo == ORCOA){
			lanzarFlecha(ent);
			ent->estado = ORCO_MIRANDO;
		}
		else{
		
			unsigned char enemX = ent->nueva.x>>2;
			unsigned char enemY = ent->nueva.y>>4;
			
			if(ent->tipo == ORCOJEFE)
				if(ver(enemX,enemY,1))
					ent->direccion = 1;
				else if(ver(enemX,enemY,3))
					ent->direccion = 3;
				else if(ver(enemX,enemY,0))
					ent->direccion = 0;
				else
					ent->direccion = 2;
					
			
			tposaux.x = jugador->nueva.x>>2;
			tposaux.y = jugador->nueva.y>>4;
			
			switch(ent->direccion){
				case 0:
				case 2:
					if( (tposaux.x - enemX) < 0  ){
						tposaux.x++;
					}
					break;
					
				case 1:
				case 3:
					if( (tposaux.y - enemY) < 0  ){
						tposaux.y++;
					}	
				
					break;
			}			
				CalcularRutaRecta(ent,&tposaux);
				
				if( IrA(ent) )
					ent->contRutas = (ent->contRutas+1);
		}
	}	
}

//BICHOS
void MoverBicho(tEntidad *ent)
{
	if( !escuchar(ent, ent->rangoEscucha, 0) )
	{
		if( probabilidad(50) )
		{
			unsigned char aux = ent->direccion;
			
			if(!MoverEntidad(ent,ent->aux2))
				ent->direccion = (ent->aux2+2)%4;
			
			ent->aux2 = aux; //swap entre la direccion anterior y la actual
		}
		else
		{
			if(!MoverEntidad(ent,ent->direccion))
				ent->direccion = (ent->direccion+2)%4;
		}
	}else
	{
		ent->contRutas = 0;
		ent->estado = BICHO_ATACAR;
	}
}

void BichoAtaca(tEntidad *ent)
{
	if( escuchar(ent, ent->rangoEscucha, 1))
	{	
		// si es la primera vez que entro, calculo ruta
		if( ent->numRutas == 0 )
		{
			tposaux.x = jugador->nueva.x>>2;
			tposaux.y = jugador->nueva.y>>4;
	
			CalcularRuta(ent,&tposaux);
		}
		// si no pasa nada sigo mi camino
		if( IrA(ent) )
			ent->contRutas = (ent->contRutas+1);
	}else
	{
		if(ent->contRutas<ent->numRutas)
		{
			if(IrA(ent))
				ent->contRutas++;
		}else
		{
			ent->direccion = DondeMirar(ent);
			ent->estado = BICHO_MOVERSE;
			ent->aux1=0;
		}
	}
}
