/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#ifndef _ENTIDAD_H_
#define _ENTIDAD_H_

#include "../mapas/niveles.h"
#include "../mapas/mapas.h"
// Variables globales
#define PUNTOS_MAX_RUTA	75

// Tipos de entidades
#define PJ			0

#define ORCO		2
#define ORCOA		3
#define ORCOJEFE	4

#define INSECTO		5

#define ENT_CUCHILLO	10
#define ENT_FLECHA		11
#define ENT_MELE		12


// Estados de las entidades
#define RANDOM				18
#define ORCO_MIRANDO		19
#define ORCO_PATRULLA		20
#define ORCO_ALERTA			21
#define ORCO_DAR_ALARMA		22
#define ORCO_ATACAR			23
#define ORCO_ALERTADO		24
#define MUERTO				25


#define BICHO_MOVERSE	50
#define BICHO_ATACAR	51


extern unsigned char mapactual[ANCHO_MAPAS][ALTO_MAPAS];
extern unsigned char alarma;


extern unsigned char numFlechas;

typedef struct
{
	int x, y;
}tPosicion;

typedef struct{
	unsigned char x, y;
}tPosicionTile;

typedef struct
{
  tPosicion ant, nueva, inicial;
  unsigned char direccion;
  /*
   * Direccion donde apunta
   * 0 Arriba
   * 1 Izquierda
   * 2 Abajo
   * 3 Derecha
   */
  unsigned char tipo;
  unsigned char width, height;//Tamao del sprite 
  unsigned char tamcelda;
  
  // variables para IA
  unsigned char aux1; 
  unsigned char aux2;
  unsigned char contRutas;
  unsigned char numRutas;// Numero de puntos de ruta actuales en pathfinding
  tPosicionTile recorrido[PUNTOS_MAX_RUTA];
  unsigned char probAscendente; // variable usada para almacenar probabilidades ascendentes
  unsigned char estado;
  unsigned char alertado;
  unsigned char gradoPatrulla;
  unsigned char rangoEscucha;
  unsigned char contFlechas;
  
  unsigned char velx, vely;//Velocidad de desplazamiento
  unsigned char cambio;//Indica si se debe repintar o no
  unsigned char *sprite;
} tEntidad;

// Puntero a jugador, fijo

extern tEntidad *jugador;
extern TNivel *niv;
extern tEntidad FLECHAS[MAX_NUM_FLECHAS];

void CopiarEntidad(tEntidad *a, tEntidad *b);
void PutSpriteMode0(unsigned char *pSprite, unsigned char nX, unsigned char nY, unsigned char nWidth, unsigned char nHeight);
void PintarTrozoManchado(tEntidad *ent);
void PintarEntidad(tEntidad *ent);
void IniciarEntidad(tEntidad *ent, unsigned char tipo, unsigned char x, unsigned char y, unsigned char direccion);
void MoverEntidadIA(tEntidad *ent);

unsigned char probabilidad(unsigned char probable);
unsigned char SePuedeMover(tEntidad *ent);
unsigned char PuedeMoverse(unsigned char *posx ,unsigned char *posy , unsigned char dir , unsigned char *dirActual);
unsigned char MoverEntidad(tEntidad *ent, unsigned char dir);
unsigned char ComprobarPuertas(tEntidad *ent , unsigned char pospuertax , unsigned char pospuertay, unsigned char dirPuerta);
unsigned char ColisionEntidades(tEntidad *entidad1, tEntidad *entidad2);
unsigned char CalcularMele(unsigned char dirPj);

// Metodos Auxiliares IA
unsigned char Mirar(tEntidad *ent, tEntidad *pj, tEntidad *cuchillo);
unsigned char ver(unsigned char x, unsigned char y, unsigned char dir);
unsigned char DondeMirar(tEntidad *ent);
void CalcularRuta(tEntidad *ent , tPosicionTile *tpos);
unsigned char escuchar(tEntidad *enemigo, unsigned char lado, unsigned char);
unsigned char IrA(tEntidad *ent);


void Alertado(tEntidad *ent);
void Mirando(tEntidad *ent);
void Patrullar(tEntidad *ent);
void Alerta(tEntidad *ent);
void ActivarAlarma(tEntidad *ent);
void AtacarOrco(tEntidad *ent);


//BICHOS
// El bicho debe moverse solo en dos direcciones hasta que choque, por lo que cambiara una o las dos direcciones
void MoverBicho(tEntidad *ent);
void BichoAtaca(tEntidad *ent);

void RellenarMapaNumero(unsigned char x, unsigned char y, unsigned char w, unsigned char h, unsigned char num);
void RellenarMapaColisiones();
#endif