; --------------------------------------------------------------------------- 
; Pac-Man Fruit routines (c) SyX 2011
; --------------------------------------------------------------------------- 

; --------------------------------------------------------------------------- 
; Restore the screen covered by the fruit sprite (16 x 16 sprites / 64 bytes)
; --------------------------------------------------------------------------- 
restore_fruit
    ; Only restore background once
    LD   HL,restore_fruit
    LD   (HL),$C9

    LD   HL,$0000
    
    ; 4º Scanline
    LD   ($7C5E),HL
    LD   ($7C60),HL

    ; 5º Scanline
    LD   ($449E),HL
    LD   ($44A0),HL

    ; 6º Scanline
    LD   ($4C9E),HL
    LD   ($4CA0),HL

    ; 7º Scanline
    LD   ($549E),HL
    LD   ($54A0),HL

    ; 8º Scanline
    LD   ($5C9E),HL
    LD   ($5CA0),HL

    ; 9º Scanline
    LD   ($649E),HL
    LD   ($64A0),HL

    ; 10º Scanline
    LD   ($6C9E),HL
    LD   ($6CA0),HL

    ; 11º Scanline
    LD   ($749E),HL
    LD   ($74A0),HL

    ; 12º Scanline
    LD   ($7C9E),HL
    LD   ($7CA0),HL

    ; 13º Scanline
    LD   ($44DE),HL
    LD   ($44E0),HL

    ; 14º Scanline
    LD   ($4CDE),HL
    LD   ($4CE0),HL

    CPL
    SUB  FRUIT06_HEIGHT
    RET  Z                  ; Not in fruit 6
    ; 3º Scanline
    LD   ($745E),HL
    LD   ($7460),HL

    DEC  A
    RET  Z                  ; Not in fruits 0, 1, 2 and 4 (only 3, 5 and 7)
    ; 15º Scanline
    LD   ($54DE),HL
    LD   ($54E0),HL

    DEC  A
    RET  Z                  ; Not in fruits 3 and 7 (only in 5)
    ; 2º Scanline
    LD   ($6C5E),HL
    LD   ($6C60),HL

    RET

; --------------------------------------------------------------------------- 
; Save the background cover by the fruit sprite (16 x 16 sprites / 64 bytes)
; Tiles 0 - 7
; --------------------------------------------------------------------------- 
save_fruit_spr_00
save_fruit_spr_01
save_fruit_spr_02
save_fruit_spr_04
    LD   A,FRUIT00_HEIGHT   ; Same sprite height (12)
    JR   save_fruit

save_fruit_spr_03
save_fruit_spr_07
    LD   A,FRUIT03_HEIGHT   ; Same sprite height (13)
    JR   save_fruit

save_fruit_spr_05
    LD   A,FRUIT05_HEIGHT   ; Sprite Height (14)
    JR   save_fruit

save_fruit_spr_06
    LD   A,FRUIT06_HEIGHT   ; Sprite Height (11)
    JR   save_fruit


save_fruit
    LD   (DE),A             ; Save address low
    INC  E
    INC  E
    CPL                     ; Complement Height (Mark as a 4 bytes width sprite)
    LD   (DE),A             ; Save Height (Mark bit for Fruit %F------- | F = fruit)
    
    RET

; --------------------------------------------------------------------------- 
; Draw a fruit sprite (16 x 16 sprites / 64 bytes) / Tiles 0 - 7
; --------------------------------------------------------------------------- 
; Height 11 scanlines / CY + 3
print_fruit_spr_06
    LD   HL,SPR_FRUIT_06
    LD   (sm_old_stack_print_fruit + 1),SP
    LD   SP,HL
    JR   print_fruit_spr1_cy3

; Height 12 scanlines / CY + 2
print_fruit_spr_00
    LD   HL,SPR_FRUIT_00
    JR   pre_print_fruit_spr1

print_fruit_spr_01
    LD   HL,SPR_FRUIT_01
    JR   pre_print_fruit_spr1

print_fruit_spr_02
    LD   HL,SPR_FRUIT_02
pre_print_fruit_spr1
    LD   (sm_old_stack_print_fruit + 1),SP
    LD   SP,HL
    JR   print_fruit_spr1

; Height 13 scanlines / CY + 2
print_fruit_spr_03
    LD   HL,SPR_FRUIT_03
    JR   pre_print_fruit_spr2_cy2

print_fruit_spr_07
    LD   HL,SPR_FRUIT_07
pre_print_fruit_spr2_cy2
    LD   (sm_old_stack_print_fruit + 1),SP
    LD   SP,HL
    JR   print_fruit_spr2_cy2

; Height 14 scanlines / CY + 1
print_fruit_spr_05
    LD   HL,SPR_FRUIT_05
    LD   (sm_old_stack_print_fruit + 1),SP
    LD   SP,HL

print_fruit_spr2
    ; 2º Scanline
    POP  HL
    LD   ($6C5E),HL
    POP  HL
    LD   ($6C60),HL

print_fruit_spr2_cy2
    ; 15º Scanline
    POP  HL
    LD   ($54DE),HL
    POP  HL
    LD   ($54E0),HL
    JR   print_fruit_spr1

; Height 12 scanlines / CY + 2
print_fruit_spr_04
    LD   HL,SPR_FRUIT_04
    LD   (sm_old_stack_print_fruit + 1),SP
    LD   SP,HL

print_fruit_spr1
    ; 3º Scanline
    POP  HL
    LD   ($745E),HL
    POP  HL
    LD   ($7460),HL

print_fruit_spr1_cy3
    ; 4º Scanline
    POP  HL
    LD   ($7C5E),HL
    POP  HL
    LD   ($7C60),HL

    ; 5º Scanline
    POP  HL
    LD   ($449E),HL
    POP  HL
    LD   ($44A0),HL

    ; 6º Scanline
    POP  HL
    LD   ($4C9E),HL
    POP  HL
    LD   ($4CA0),HL

    ; 7º Scanline
    POP  HL
    LD   ($549E),HL
    POP  HL
    LD   ($54A0),HL

    ; 8º Scanline
    POP  HL
    LD   ($5C9E),HL
    POP  HL
    LD   ($5CA0),HL

    ; 9º Scanline
    POP  HL
    LD   ($649E),HL
    POP  HL
    LD   ($64A0),HL

    ; 10º Scanline
    POP  HL
    LD   ($6C9E),HL
    POP  HL
    LD   ($6CA0),HL

    ; 11º Scanline
    POP  HL
    LD   ($749E),HL
    POP  HL
    LD   ($74A0),HL

    ; 12º Scanline
    POP  HL
    LD   ($7C9E),HL
    POP  HL
    LD   ($7CA0),HL

    ; 13º Scanline
    POP  HL
    LD   ($44DE),HL
    POP  HL
    LD   ($44E0),HL

    ; 14º Scanline
    POP  HL
    LD   ($4CDE),HL
    POP  HL
    LD   ($4CE0),HL

sm_old_stack_print_fruit
    LD   SP,$0000

    RET

; --------------------------------------------------------------------------- 
