; --------------------------------------------------------------------------- 
; Pac-Man CPC Sprite Code (c) SyX 2011
; --------------------------------------------------------------------------- 

; ---------------------------------------------------------------------------
; Tables for print Pac-Man sprites
; Pac-Man
table_print_h9
    DEFW print_scanlines_8_1_pac
    DEFW print_scanlines_7_2_pac
    DEFW print_scanlines_6_3_pac
    DEFW print_scanlines_5_4_pac
    DEFW print_scanlines_4_5_pac
    DEFW print_scanlines_3_6_pac
    DEFW print_scanlines_2_7_pac
    DEFW print_scanlines_1_8_pac

; Pac-Man
table_print_h12
    DEFW print_scanlines_8_4_pac
    DEFW print_scanlines_7_5_pac
    DEFW print_scanlines_6_6_pac
    DEFW print_scanlines_5_7_pac
    DEFW print_scanlines_4_8_pac
    DEFW print_scanlines_3_8_1_pac
    DEFW print_scanlines_2_8_2_pac
    DEFW print_scanlines_1_8_3_pac

; Pac-Man
table_print_h13
    DEFW print_scanlines_8_5_pac
    DEFW print_scanlines_7_6_pac
    DEFW print_scanlines_6_7_pac
    DEFW print_scanlines_5_8_pac
    DEFW print_scanlines_4_8_1_pac
    DEFW print_scanlines_3_8_2_pac
    DEFW print_scanlines_2_8_3_pac
    DEFW print_scanlines_1_8_4_pac

; Ghost and Eaten Ghost in Intermission (<- Restore BG / Fill 0)
table_print_h14
    DEFW print_scanlines_8_6_ghost
    DEFW print_scanlines_7_7_ghost
    DEFW print_scanlines_6_8_ghost
    DEFW print_scanlines_5_8_1_ghost
    DEFW print_scanlines_4_8_2_ghost
    DEFW print_scanlines_3_8_3_ghost
    DEFW print_scanlines_2_8_4_ghost
    DEFW print_scanlines_1_8_5_ghost

; ---------------------------------------------------------------------------
; Routines for printing sprites in screen 
; (5 bytes x 16 pixels)
;
; Entry:
;   HL: Sprite Address
;   DE: Screen Address
; ---------------------------------------------------------------------------
; 1_x
print_scanlines_1_8_pac
    CALL print_1_scanline_pac_plus
    JP   print_8_scanlines_pac

; 1_8_x
print_scanlines_1_8_3_pac
    CALL print_1_scanline_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_3_scanlines_pac

print_scanlines_1_8_4_pac
    CALL print_1_scanline_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_4_scanlines_pac

print_scanlines_1_8_5_ghost
    CALL print_1_scanline_ghost_plus
    CALL print_8_scanlines_ghost_plus
    JP   print_5_scanlines_ghost

; ---------------------------------------------------------------------------
; 2_x
print_scanlines_2_7_pac
    CALL print_2_scanlines_pac_plus
    JP   print_7_scanlines_pac

; 2_8_x
print_scanlines_2_8_2_pac
    CALL print_2_scanlines_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_2_scanlines_pac

print_scanlines_2_8_3_pac
    CALL print_2_scanlines_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_3_scanlines_pac

print_scanlines_2_8_4_ghost
    CALL print_2_scanlines_ghost_plus
    CALL print_8_scanlines_ghost_plus
    JP   print_4_scanlines_ghost

; ---------------------------------------------------------------------------
; 3_x
print_scanlines_3_6_pac
    CALL print_3_scanlines_pac_plus
    JP   print_6_scanlines_pac

; 3_8_x
print_scanlines_3_8_1_pac
    CALL print_3_scanlines_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_1_scanline_pac

print_scanlines_3_8_2_pac
    CALL print_3_scanlines_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_2_scanlines_pac

print_scanlines_3_8_3_ghost
    CALL print_3_scanlines_ghost_plus
    CALL print_8_scanlines_ghost_plus
    JP   print_3_scanlines_ghost

; ---------------------------------------------------------------------------
; 4_x
print_scanlines_4_5_pac
    CALL print_4_scanlines_pac_plus
    JP   print_5_scanlines_pac

print_scanlines_4_8_pac
    CALL print_4_scanlines_pac_plus
    JP   print_8_scanlines_pac

; 4_8_x
print_scanlines_4_8_1_pac
    CALL print_4_scanlines_pac_plus
    CALL print_8_scanlines_pac_plus
    JP   print_1_scanline_pac

print_scanlines_4_8_2_ghost
    CALL print_4_scanlines_ghost_plus
    CALL print_8_scanlines_ghost_plus
    JP   print_2_scanlines_ghost

; ---------------------------------------------------------------------------
; 5_x
print_scanlines_5_4_pac
    CALL print_5_scanlines_pac_plus
    JP   print_4_scanlines_pac

print_scanlines_5_7_pac
    CALL print_5_scanlines_pac_plus
    JP   print_7_scanlines_pac

print_scanlines_5_8_pac
    CALL print_5_scanlines_pac_plus
    JP   print_8_scanlines_pac

; 5_8_x
print_scanlines_5_8_1_ghost
    CALL print_5_scanlines_ghost_plus
    CALL print_8_scanlines_ghost_plus
    JP   print_1_scanline_ghost

; ---------------------------------------------------------------------------
; 6_x
print_scanlines_6_3_pac
    CALL print_6_scanlines_pac_plus
    JP   print_3_scanlines_pac

print_scanlines_6_6_pac
    CALL print_6_scanlines_pac_plus
    JP   print_6_scanlines_pac

print_scanlines_6_7_pac
    CALL print_6_scanlines_pac_plus
    JP   print_7_scanlines_pac

print_scanlines_6_8_ghost
    CALL print_6_scanlines_ghost_plus
    JP   print_8_scanlines_ghost

; ---------------------------------------------------------------------------
; 7_x
print_scanlines_7_2_pac
    CALL print_7_scanlines_pac_plus
    JP   print_2_scanlines_pac

print_scanlines_7_5_pac
    CALL print_7_scanlines_pac_plus
    JP   print_5_scanlines_pac

print_scanlines_7_6_pac
    CALL print_7_scanlines_pac_plus
    JP   print_6_scanlines_pac

print_scanlines_7_7_ghost
    CALL print_7_scanlines_ghost_plus
    JP   print_7_scanlines_ghost

; ---------------------------------------------------------------------------
; 8_x
print_scanlines_8_1_pac
    CALL print_8_scanlines_pac_plus
    JP   print_1_scanline_pac

print_scanlines_8_4_pac
    CALL print_8_scanlines_pac_plus
    JP   print_4_scanlines_pac

print_scanlines_8_5_pac
    CALL print_8_scanlines_pac_plus
    JP   print_5_scanlines_pac

print_scanlines_8_6_ghost
    CALL print_8_scanlines_ghost_plus
    JP   print_6_scanlines_ghost

; ---------------------------------------------------------------------------
; Print sprite routine unroll
; ---------------------------------------------------------------------------
print_8_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN
    
print_7_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_6_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_5_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_4_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_3_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_2_scanlines_pac
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_1_scanline_pac
    PRINT_PACMAN_SCANLINE

    RET

print_8_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN
    
print_7_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_6_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_5_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_4_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_3_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_2_scanlines_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_SCAN_PACMAN

print_1_scanline_pac_plus
    PRINT_PACMAN_SCANLINE
    NEXT_CHAR_PACMAN

    RET

; ---------------------------------------------------------------------------
print_scanlines_bigpac
    CALL print_3_scanlines_plus_w9
    CALL print_8_scanlines_plus_w9
    CALL print_5_scanlines_w9

    ; Invert print
    DEC  L              ; Not need DEC HL
    LD   A,D
    ADD  8
    LD   D,A
    DEC  E
    CALL print_3_scanlines_plus_w9_inv
    CALL print_8_scanlines_plus_w9_inv
    JP   print_5_scanlines_w9_inv

print_8_scanlines_plus_w9
    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

print_3_scanlines_plus_w9
    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_CHAR_BIGPAC

    RET

print_5_scanlines_w9
    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC
    NEXT_SCAN_BIGPAC

    PRINT_SCAN_BIGPAC

    RET

print_8_scanlines_plus_w9_inv
    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

print_3_scanlines_plus_w9_inv
    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_CHAR_BIGPAC_INV

    RET

print_5_scanlines_w9_inv
    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV
    NEXT_SCAN_BIGPAC_INV

    PRINT_SCAN_BIGPAC_INV

    RET

; ---------------------------------------------------------------------------
