; --------------------------------------------------------------------------- 
; Pac-Man CPC Sprite Code (c) SyX 2011
; --------------------------------------------------------------------------- 

; ---------------------------------------------------------------------------
; Tables for restoring backgrounds covered by sprites

; Intermission Ghost (Restore BG / Fill 0) | Width 5 bytes
table_restore_h3
    DEFW restore_3_scanlines
    DEFW restore_3_scanlines
    DEFW restore_3_scanlines
    DEFW restore_3_scanlines
    DEFW restore_3_scanlines
    DEFW restore_3_scanlines
    DEFW restore_scanlines_2_1
    DEFW restore_scanlines_1_2

; Intermission Ghost (Restore BG / Fill 0) | Width 5 bytes
table_restore_h4
    DEFW restore_4_scanlines
    DEFW restore_4_scanlines
    DEFW restore_4_scanlines
    DEFW restore_4_scanlines
    DEFW restore_4_scanlines
    DEFW restore_scanlines_3_1
    DEFW restore_scanlines_2_2
    DEFW restore_scanlines_1_3

; Eyes and Pac-Death * | Width 5 bytes
table_restore_h5
    DEFW restore_5_scanlines
    DEFW restore_5_scanlines
    DEFW restore_5_scanlines
    DEFW restore_5_scanlines
    DEFW restore_scanlines_4_1
    DEFW restore_scanlines_3_2
    DEFW restore_scanlines_2_3
    DEFW restore_scanlines_1_4

; Pac-Death * | Width 5 bytes
table_restore_h6
    DEFW restore_6_scanlines
    DEFW restore_6_scanlines
    DEFW restore_6_scanlines
    DEFW restore_scanlines_5_1
    DEFW restore_scanlines_4_2
    DEFW restore_scanlines_3_3
    DEFW restore_scanlines_2_4
    DEFW restore_scanlines_1_5

; Scores and Pac-Death * | Width 5 bytes
table_restore_h7
    DEFW restore_7_scanlines
    DEFW restore_7_scanlines
    DEFW restore_scanlines_6_1
    DEFW restore_scanlines_5_2
    DEFW restore_scanlines_4_3
    DEFW restore_scanlines_3_4
    DEFW restore_scanlines_2_5
    DEFW restore_scanlines_1_6

; Pac-Death * | Width 5 bytes
table_restore_h8
    DEFW restore_8_scanlines
    DEFW restore_scanlines_7_1
    DEFW restore_scanlines_6_2
    DEFW restore_scanlines_5_3
    DEFW restore_scanlines_4_4
    DEFW restore_scanlines_3_5
    DEFW restore_scanlines_2_6
    DEFW restore_scanlines_1_7

; Pac-Man | Width 4 bytes
table_restore_h9
    DEFW restore_scanlines_8_1_w4
    DEFW restore_scanlines_7_2_w4
    DEFW restore_scanlines_6_3_w4
    DEFW restore_scanlines_5_4_w4
    DEFW restore_scanlines_4_5_w4
    DEFW restore_scanlines_3_6_w4
    DEFW restore_scanlines_2_7_w4
    DEFW restore_scanlines_1_8_w4

; Pac-Death * (9 + 1 and 10) | Width 5 bytes
table_restore_h10
    DEFW restore_scanlines_8_2
    DEFW restore_scanlines_7_3
    DEFW restore_scanlines_6_4
    DEFW restore_scanlines_5_5
    DEFW restore_scanlines_4_6
    DEFW restore_scanlines_3_7
    DEFW restore_scanlines_2_8
    DEFW restore_scanlines_1_8_1
 
; Intermission Ghost (Restore BG / Fill 0) | Width 5 bytes
table_restore_h11
    DEFW restore_scanlines_8_3
    DEFW restore_scanlines_7_4
    DEFW restore_scanlines_6_5
    DEFW restore_scanlines_5_6
    DEFW restore_scanlines_4_7
    DEFW restore_scanlines_3_8
    DEFW restore_scanlines_2_8_1
    DEFW restore_scanlines_1_8_2

; Pac-Man | Width 4 bytes
table_restore_h12
    DEFW restore_scanlines_8_4_w4
    DEFW restore_scanlines_7_5_w4
    DEFW restore_scanlines_6_6_w4
    DEFW restore_scanlines_5_7_w4
    DEFW restore_scanlines_4_8_w4
    DEFW restore_scanlines_3_8_1_w4
    DEFW restore_scanlines_2_8_2_w4
    DEFW restore_scanlines_1_8_3_w4

; Pac-Man | Width 4 bytes
table_restore_h13
    DEFW restore_scanlines_8_5_w4
    DEFW restore_scanlines_7_6_w4
    DEFW restore_scanlines_6_7_w4
    DEFW restore_scanlines_5_8_w4
    DEFW restore_scanlines_4_8_1_w4
    DEFW restore_scanlines_3_8_2_w4
    DEFW restore_scanlines_2_8_3_w4
    DEFW restore_scanlines_1_8_4_w4

; Ghost and Eaten Ghost in Intermission (<- Restore BG / Fill 0) | Width 4 bytes
table_restore_h14
    DEFW restore_scanlines_8_6_w4
    DEFW restore_scanlines_7_7_w4
    DEFW restore_scanlines_6_8_w4
    DEFW restore_scanlines_5_8_1_w4
    DEFW restore_scanlines_4_8_2_w4
    DEFW restore_scanlines_3_8_3_w4
    DEFW restore_scanlines_2_8_4_w4
    DEFW restore_scanlines_1_8_5_w4

; Big Pac-Man (Restore BG / Fill 0) | Width 5 bytes
table_restore_h16
    DEFW restore_scanlines_bigpac       ; 3_8_5

; ---------------------------------------------------------------------------
; Routines for restoring background covered by sprites 
; (5 bytes x 16 pixels)
;
; Entry:
;   HL: Saved Background Address
;   DE: Screen Address
; ---------------------------------------------------------------------------
; 1_x
restore_scanlines_1_2
    CALL restore_1_scanline_plus
    JP   restore_2_scanlines

restore_scanlines_1_3
    CALL restore_1_scanline_plus
    JP   restore_3_scanlines

restore_scanlines_1_4
    CALL restore_1_scanline_plus
    JP   restore_4_scanlines

restore_scanlines_1_5
    CALL restore_1_scanline_plus
    JP   restore_5_scanlines

restore_scanlines_1_6
    CALL restore_1_scanline_plus
    JP   restore_6_scanlines

restore_scanlines_1_7
    CALL restore_1_scanline_plus
    JP   restore_7_scanlines

restore_scanlines_1_8_w4
    CALL restore_1_scanline_plus_w4
    JP   restore_8_scanlines_w4

; 1_8_x
restore_scanlines_1_8_1
    CALL restore_1_scanline_plus
    CALL restore_8_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_1_8_2
    CALL restore_1_scanline_plus
    CALL restore_8_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_1_8_3_w4
    CALL restore_1_scanline_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_3_scanlines_w4

restore_scanlines_1_8_4_w4
    CALL restore_1_scanline_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_4_scanlines_w4

restore_scanlines_1_8_5_w4
    CALL restore_1_scanline_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_5_scanlines_w4

; ---------------------------------------------------------------------------
; 2_x
restore_scanlines_2_1
    CALL restore_2_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_2_2
    CALL restore_2_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_2_3
    CALL restore_2_scanlines_plus
    JP   restore_3_scanlines

restore_scanlines_2_4
    CALL restore_2_scanlines_plus
    JP   restore_4_scanlines

restore_scanlines_2_5
    CALL restore_2_scanlines_plus
    JP   restore_5_scanlines

restore_scanlines_2_6
    CALL restore_2_scanlines_plus
    JP   restore_6_scanlines

restore_scanlines_2_7_w4
    CALL restore_2_scanlines_plus_w4
    JP   restore_7_scanlines_w4

restore_scanlines_2_8
    CALL restore_2_scanlines_plus
    JP   restore_8_scanlines

; 2_8_x
restore_scanlines_2_8_1
    CALL restore_2_scanlines_plus
    CALL restore_8_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_2_8_2_w4
    CALL restore_2_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_2_scanlines_w4

restore_scanlines_2_8_3_w4
    CALL restore_2_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_3_scanlines_w4

    ; For intermission ghosts
restore_scanlines_2_8_4
    CALL restore_2_scanlines_plus
    CALL restore_8_scanlines_plus
    JP   restore_4_scanlines
    JR   restore_scanlines_2_8_4

restore_scanlines_2_8_4_w4
    CALL restore_2_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_4_scanlines_w4

; ---------------------------------------------------------------------------
; 3_x
restore_scanlines_3_1
    CALL restore_3_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_3_2
    CALL restore_3_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_3_3
    CALL restore_3_scanlines_plus
    JP   restore_3_scanlines

restore_scanlines_3_4
    CALL restore_3_scanlines_plus
    JP   restore_4_scanlines

restore_scanlines_3_5
    CALL restore_3_scanlines_plus
    JP   restore_5_scanlines

restore_scanlines_3_6_w4
    CALL restore_3_scanlines_plus_w4
    JP   restore_6_scanlines_w4

restore_scanlines_3_7
    CALL restore_3_scanlines_plus
    JP   restore_7_scanlines

restore_scanlines_3_8
    CALL restore_3_scanlines_plus
    JP   restore_8_scanlines

; 3_8_x
restore_scanlines_3_8_1_w4
    CALL restore_3_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_1_scanline_w4

restore_scanlines_3_8_2_w4
    CALL restore_3_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_2_scanlines_w4

restore_scanlines_3_8_3_w4
    CALL restore_3_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_3_scanlines_w4


restore_scanlines_bigpac
    EX   DE,HL                          ; HL = Screen Address
    XOR  A                              ; Byte to fill the VRAM
    LD   BC,$D040
    CALL restore_bigpac_half
    SET  3,H
    JP   restore_bigpac_half

restore_bigpac_half
    ; *** First Char ***
    ; 6 Scanline
    RESTORE_BIGPAC_RIGHT
    SET  4,H
    
    ; 8 Scanline
    RESTORE_BIGPAC_LEFT
    RES  3,H

    ; 7 Scanline
    RESTORE_BIGPAC_RIGHT
    ADD  HL,BC                          ; NEXT_CHAR

    ; *** Second Char ***
    ; 1 Scanline
    RESTORE_BIGPAC_LEFT
    SET  3,H

    ; 2 Scanline
    RESTORE_BIGPAC_RIGHT
    SET  4,H
    
    ; 4 Scanline
    RESTORE_BIGPAC_LEFT
    RES  3,H

    ; 3 Scanline
    RESTORE_BIGPAC_RIGHT
    SET  5,H

    ; 7 Scanline
    RESTORE_BIGPAC_LEFT
    RES  4,H

    ; 5 Scanline
    RESTORE_BIGPAC_RIGHT
    SET  3,H

    ; 6 Scanline
    RESTORE_BIGPAC_LEFT
    SET  4,H

    ; 8 Scanline
    RESTORE_BIGPAC_RIGHT
    ADD  HL,BC

    ; *** Third Char ***
    ; 2 Scanline
    RESTORE_BIGPAC_LEFT
    SET  4,H
    
    ; 4 Scanline
    RESTORE_BIGPAC_RIGHT
    RES  3,H

    ; 3 Scanline
    RESTORE_BIGPAC_LEFT
    RES  4,H

    ; 1 Scanline
    RESTORE_BIGPAC_RIGHT
    SET  5,H

    ; 5 Scanline
    RESTORE_BIGPAC_LEFT

    RET

; ---------------------------------------------------------------------------
; 4_x
restore_scanlines_4_1
    CALL restore_4_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_4_2
    CALL restore_4_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_4_3
    CALL restore_4_scanlines_plus
    JP   restore_3_scanlines

restore_scanlines_4_4
    CALL restore_4_scanlines_plus
    JP   restore_4_scanlines

restore_scanlines_4_5_w4
    CALL restore_4_scanlines_plus_w4
    JP   restore_5_scanlines_w4

restore_scanlines_4_6
    CALL restore_4_scanlines_plus
    JP   restore_6_scanlines

restore_scanlines_4_7
    CALL restore_4_scanlines_plus
    JP   restore_7_scanlines

restore_scanlines_4_8_w4
    CALL restore_4_scanlines_plus_w4
    JP   restore_8_scanlines_w4

; 4_8_x
restore_scanlines_4_8_1_w4
    CALL restore_4_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_1_scanline_w4

restore_scanlines_4_8_2_w4
    CALL restore_4_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_2_scanlines_w4

; ---------------------------------------------------------------------------
; 5_x
restore_scanlines_5_1
    CALL restore_5_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_5_2
    CALL restore_5_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_5_3
    CALL restore_5_scanlines_plus
    JP   restore_3_scanlines

restore_scanlines_5_4_w4
    CALL restore_5_scanlines_plus_w4
    JP   restore_4_scanlines_w4

restore_scanlines_5_5
    CALL restore_5_scanlines_plus
    JP   restore_5_scanlines

restore_scanlines_5_6
    CALL restore_5_scanlines_plus
    JP   restore_6_scanlines

restore_scanlines_5_7_w4
    CALL restore_5_scanlines_plus_w4
    JP   restore_7_scanlines_w4

restore_scanlines_5_8_w4
    CALL restore_5_scanlines_plus_w4
    JP   restore_8_scanlines_w4

; 5_8_x
restore_scanlines_5_8_1_w4
    CALL restore_5_scanlines_plus_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_1_scanline_w4

; ---------------------------------------------------------------------------
; 6_x
restore_scanlines_6_1
    CALL restore_6_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_6_2
    CALL restore_6_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_6_3_w4
    CALL restore_6_scanlines_plus_w4
    JP   restore_3_scanlines_w4

restore_scanlines_6_4
    CALL restore_6_scanlines_plus
    JP   restore_4_scanlines

restore_scanlines_6_5
    CALL restore_6_scanlines_plus
    JP   restore_5_scanlines

restore_scanlines_6_6_w4
    CALL restore_6_scanlines_plus_w4
    JP   restore_6_scanlines_w4

restore_scanlines_6_7_w4
    CALL restore_6_scanlines_plus_w4
    JP   restore_7_scanlines_w4

restore_scanlines_6_8_w4
    CALL restore_6_scanlines_plus_w4
    JP   restore_8_scanlines_w4

; ---------------------------------------------------------------------------
; 7_x
restore_scanlines_7_1
    CALL restore_7_scanlines_plus
    JP   restore_1_scanline

restore_scanlines_7_2_w4
    CALL restore_7_scanlines_plus_w4
    JP   restore_2_scanlines_w4

restore_scanlines_7_3
    CALL restore_7_scanlines_plus
    JP   restore_3_scanlines

restore_scanlines_7_4
    CALL restore_7_scanlines_plus
    JP   restore_4_scanlines

restore_scanlines_7_5_w4
    CALL restore_7_scanlines_plus_w4
    JP   restore_5_scanlines_w4

restore_scanlines_7_6_w4
    CALL restore_7_scanlines_plus_w4
    JP   restore_6_scanlines_w4

restore_scanlines_7_7_w4
    CALL restore_7_scanlines_plus_w4
    JP   restore_7_scanlines_w4

; ---------------------------------------------------------------------------
; 8_x
restore_scanlines_8_1_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_1_scanline_w4

restore_scanlines_8_2
    CALL restore_8_scanlines_plus
    JP   restore_2_scanlines

restore_scanlines_8_3
    CALL restore_8_scanlines_plus
    JP   restore_3_scanlines

restore_scanlines_8_4_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_4_scanlines_w4

restore_scanlines_8_5_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_5_scanlines_w4

restore_scanlines_8_6_w4
    CALL restore_8_scanlines_plus_w4
    JP   restore_6_scanlines_w4

; ---------------------------------------------------------------------------
; Restore background routine desenrollada
; ---------------------------------------------------------------------------
restore_8_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5
    
restore_7_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_6_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_5_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_4_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_3_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_2_scanlines
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_1_scanline
    RESTORE_BG_SCANLINE 5

    RET

restore_8_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5
    
restore_7_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_6_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_5_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_4_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_3_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_2_scanlines_plus
    RESTORE_BG_SCANLINE 5
    NEXT_SCAN_RESTORE 5

restore_1_scanline_plus
    RESTORE_BG_SCANLINE 5
    NEXT_CHAR_RESTORE 5

    RET

; ---------------------------------------------------------------------------
restore_8_scanlines_w4
print_8_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4
    
restore_7_scanlines_w4
print_7_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_6_scanlines_w4
print_6_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_5_scanlines_w4
print_5_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_4_scanlines_w4
print_4_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_3_scanlines_w4
print_3_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_2_scanlines_w4
print_2_scanlines_ghost
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_1_scanline_w4
print_1_scanline_ghost
    RESTORE_BG_SCANLINE 4

    RET

restore_8_scanlines_plus_w4
print_8_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4
    
restore_7_scanlines_plus_w4
print_7_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_6_scanlines_plus_w4
print_6_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_5_scanlines_plus_w4
print_5_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_4_scanlines_plus_w4
print_4_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_3_scanlines_plus_w4
print_3_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_2_scanlines_plus_w4
print_2_scanlines_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_SCAN_RESTORE 4

restore_1_scanline_plus_w4
print_1_scanline_ghost_plus
    RESTORE_BG_SCANLINE 4
    NEXT_CHAR_RESTORE 4

    RET

; ---------------------------------------------------------------------------
