; --------------------------------------------------------------------------- 
; Pac-Man CPC Sprite Code (c) SyX 2011
; --------------------------------------------------------------------------- 

; --------------------------------------------------------------------------- 
; Tables for save background in the sprite buffers (only used by sprites 
; height 5, 6, 7, 8, 10, 12, 13 and 14)
; Eyes | Width 5 bytes
table_save_backgrounds_h5
    DEFW save_5_scanlines
    DEFW save_5_scanlines
    DEFW save_5_scanlines
    DEFW save_5_scanlines
    DEFW save_scanlines_4_1             ; *
    DEFW save_scanlines_3_2             ; *
    DEFW save_scanlines_2_3             ; *
    DEFW save_scanlines_1_4             ; *

; Pac-Death | Width 5 bytes
table_save_backgrounds_h6
    DEFW save_6_scanlines
    DEFW save_6_scanlines
    DEFW save_6_scanlines
    DEFW save_scanlines_5_1             ; *
    DEFW save_scanlines_4_2             ; *
    DEFW save_scanlines_3_3             ; *
    DEFW save_scanlines_2_4             ; *
    DEFW save_scanlines_1_5             ; *

; Score and Pac-Death | Width 5 bytes
table_save_backgrounds_h7
    DEFW save_7_scanlines
    DEFW save_7_scanlines
    DEFW save_scanlines_6_1             ; *
    DEFW save_scanlines_5_2             ; *
    DEFW save_scanlines_4_3             ; *
    DEFW save_scanlines_3_4             ; *
    DEFW save_scanlines_2_5             ; *
    DEFW save_scanlines_1_6             ; *

; Pac-Death | Width 5 bytes
table_save_backgrounds_h8
    DEFW save_8_scanlines
    DEFW save_scanlines_7_1             ; *
    DEFW save_scanlines_6_2             ; *
    DEFW save_scanlines_5_3             ; *
    DEFW save_scanlines_4_4             ; *
    DEFW save_scanlines_3_5             ; *
    DEFW save_scanlines_2_6             ; *
    DEFW save_scanlines_1_7             ; *
    
; Pac-Man | Width 4 bytes
table_save_backgrounds_h9
    DEFW save_scanlines_8_1_w4          ; *
    DEFW save_scanlines_7_2_w4          ; *
    DEFW save_scanlines_6_3_w4          ; *
    DEFW save_scanlines_5_4_w4          ; *
    DEFW save_scanlines_4_5_w4          ; *
    DEFW save_scanlines_3_6_w4          ; *
    DEFW save_scanlines_2_7_w4          ; *
    DEFW save_scanlines_1_8_w4          ; *

; Pac-Death | Width 5 bytes
table_save_backgrounds_h10
    DEFW save_scanlines_8_2             ; *
    DEFW save_scanlines_7_3             ; *
    DEFW save_scanlines_6_4             ; *
    DEFW save_scanlines_5_5             ; *
    DEFW save_scanlines_4_6             ; *
    DEFW save_scanlines_3_7             ; *
    DEFW save_scanlines_2_8             ; *
    DEFW save_scanlines_1_8_1           ; *

; Pac-Man | Width 4 bytes
table_save_backgrounds_h12
    DEFW save_scanlines_8_4_w4          ; *
    DEFW save_scanlines_7_5_w4          ; *
    DEFW save_scanlines_6_6_w4          ; *
    DEFW save_scanlines_5_7_w4          ; *
    DEFW save_scanlines_4_8_w4          ; *
    DEFW save_scanlines_3_8_1_w4        ; *
    DEFW save_scanlines_2_8_2_w4        ; *
    DEFW save_scanlines_1_8_3_w4        ; *

; Pac-Man | Width 4 bytes
table_save_backgrounds_h13
    DEFW save_scanlines_8_5_w4          ; *
    DEFW save_scanlines_7_6_w4          ; *
    DEFW save_scanlines_6_7_w4          ; *
    DEFW save_scanlines_5_8_w4          ; *
    DEFW save_scanlines_4_8_1_w4        ; *
    DEFW save_scanlines_3_8_2_w4        ; *
    DEFW save_scanlines_2_8_3_w4        ; *
    DEFW save_scanlines_1_8_4_w4        ; *

; Ghost | Width 4 bytes
table_save_backgrounds_h14
    DEFW save_scanlines_8_6_w4          ; *
    DEFW save_scanlines_7_7_w4          ; *
    DEFW save_scanlines_6_8_w4          ; *
    DEFW save_scanlines_5_8_1_w4        ; *
    DEFW save_scanlines_4_8_2_w4        ; *
    DEFW save_scanlines_3_8_3_w4        ; *
    DEFW save_scanlines_2_8_4_w4        ; *
    DEFW save_scanlines_1_8_5_w4        ; *

; ---------------------------------------------------------------------------
; Routines for saving background covered by sprites 
;
; Entry:
;   HL: Screen Address
;   DE: Save Background Address
; ---------------------------------------------------------------------------
; 1_x
save_scanlines_1_4
    CALL save_1_scanline_plus
    JP   save_4_scanlines

save_scanlines_1_5
    CALL save_1_scanline_plus
    JP   save_5_scanlines

save_scanlines_1_6
    CALL save_1_scanline_plus
    JP   save_6_scanlines

save_scanlines_1_7
    CALL save_1_scanline_plus
    JP   save_7_scanlines

save_scanlines_1_8_w4
    CALL save_1_scanline_plus_w4
    JP   save_8_scanlines_w4

; 1_8_x
save_scanlines_1_8_1
    CALL save_1_scanline_plus
    CALL save_8_scanlines_plus
    JP   save_1_scanline

save_scanlines_1_8_3_w4
    CALL save_1_scanline_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_3_scanlines_w4

save_scanlines_1_8_4_w4
    CALL save_1_scanline_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_4_scanlines_w4

save_scanlines_1_8_5_w4
    CALL save_1_scanline_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_5_scanlines_w4

; ---------------------------------------------------------------------------
; 2_x
save_scanlines_2_3
    CALL save_2_scanlines_plus
    JP   save_3_scanlines

save_scanlines_2_4
    CALL save_2_scanlines_plus
    JP   save_4_scanlines

save_scanlines_2_5
    CALL save_2_scanlines_plus
    JP   save_5_scanlines

save_scanlines_2_6
    CALL save_2_scanlines_plus
    JP   save_6_scanlines

save_scanlines_2_7_w4
    CALL save_2_scanlines_plus_w4
    JP   save_7_scanlines_w4

save_scanlines_2_8
    CALL save_2_scanlines_plus
    JP   save_8_scanlines

; 2_8_x
save_scanlines_2_8_2_w4
    CALL save_2_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_2_scanlines_w4

save_scanlines_2_8_3_w4
    CALL save_2_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_3_scanlines_w4

save_scanlines_2_8_4_w4
    CALL save_2_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_4_scanlines_w4

; ---------------------------------------------------------------------------
; 3_x
save_scanlines_3_2
    CALL save_3_scanlines_plus
    JP   save_2_scanlines

save_scanlines_3_3
    CALL save_3_scanlines_plus
    JP   save_3_scanlines

save_scanlines_3_4
    CALL save_3_scanlines_plus
    JP   save_4_scanlines

save_scanlines_3_5
    CALL save_3_scanlines_plus
    JP   save_5_scanlines

save_scanlines_3_6_w4
    CALL save_3_scanlines_plus_w4
    JP   save_6_scanlines_w4

save_scanlines_3_7
    CALL save_3_scanlines_plus
    JP   save_7_scanlines

; 3_8_x
save_scanlines_3_8_1_w4
    CALL save_3_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_1_scanline_w4

save_scanlines_3_8_2_w4
    CALL save_3_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_2_scanlines_w4

save_scanlines_3_8_3_w4
    CALL save_3_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_3_scanlines_w4

; ---------------------------------------------------------------------------
; 4_x
save_scanlines_4_1
    CALL save_4_scanlines_plus
    JP   save_1_scanline

save_scanlines_4_2
    CALL save_4_scanlines_plus
    JP   save_2_scanlines

save_scanlines_4_3
    CALL save_4_scanlines_plus
    JP   save_3_scanlines

save_scanlines_4_4
    CALL save_4_scanlines_plus
    JP   save_4_scanlines

save_scanlines_4_5_w4
    CALL save_4_scanlines_plus_w4
    JP   save_5_scanlines_w4

save_scanlines_4_6
    CALL save_4_scanlines_plus
    JP   save_6_scanlines

save_scanlines_4_8_w4
    CALL save_4_scanlines_plus_w4
    JP   save_8_scanlines_w4

; 4_8_x
save_scanlines_4_8_1_w4
    CALL save_4_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_1_scanline_w4

save_scanlines_4_8_2_w4
    CALL save_4_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_2_scanlines_w4

; ---------------------------------------------------------------------------
; 5_x
save_scanlines_5_1
    CALL save_5_scanlines_plus
    JP   save_1_scanline

save_scanlines_5_2
    CALL save_5_scanlines_plus
    JP   save_2_scanlines

save_scanlines_5_3
    CALL save_5_scanlines_plus
    JP   save_3_scanlines

save_scanlines_5_4_w4
    CALL save_5_scanlines_plus_w4
    JP   save_4_scanlines_w4

save_scanlines_5_5
    CALL save_5_scanlines_plus
    JP   save_5_scanlines

save_scanlines_5_7_w4
    CALL save_5_scanlines_plus_w4
    JP   save_7_scanlines_w4

save_scanlines_5_8_w4
    CALL save_5_scanlines_plus_w4
    JP   save_8_scanlines_w4

; 5_8_x
save_scanlines_5_8_1_w4
    CALL save_5_scanlines_plus_w4
    CALL save_8_scanlines_plus_w4
    JP   save_1_scanline_w4

; ---------------------------------------------------------------------------
; 6_x
save_scanlines_6_1
    CALL save_6_scanlines_plus
    JP   save_1_scanline

save_scanlines_6_2
    CALL save_6_scanlines_plus
    JP   save_2_scanlines

save_scanlines_6_3_w4
    CALL save_6_scanlines_plus_w4
    JP   save_3_scanlines_w4

save_scanlines_6_4
    CALL save_6_scanlines_plus
    JP   save_4_scanlines

save_scanlines_6_6_w4
    CALL save_6_scanlines_plus_w4
    JP   save_6_scanlines_w4

save_scanlines_6_7_w4
    CALL save_6_scanlines_plus_w4
    JP   save_7_scanlines_w4

save_scanlines_6_8_w4
    CALL save_6_scanlines_plus_w4
    JP   save_8_scanlines_w4

; ---------------------------------------------------------------------------
; 7_x
save_scanlines_7_1
    CALL save_7_scanlines_plus
    JP   save_1_scanline

save_scanlines_7_2_w4
    CALL save_7_scanlines_plus_w4
    JP   save_2_scanlines_w4

save_scanlines_7_3
    CALL save_7_scanlines_plus
    JP   save_3_scanlines

save_scanlines_7_5_w4
    CALL save_7_scanlines_plus_w4
    JP   save_5_scanlines_w4

save_scanlines_7_6_w4
    CALL save_7_scanlines_plus_w4
    JP   save_6_scanlines_w4

save_scanlines_7_7_w4
    CALL save_7_scanlines_plus_w4
    JP   save_7_scanlines_w4

; ---------------------------------------------------------------------------
; 8_x
save_scanlines_8_1_w4
    CALL save_8_scanlines_plus_w4
    JP   save_1_scanline_w4

save_scanlines_8_2
    CALL save_8_scanlines_plus
    JP   save_2_scanlines

save_scanlines_8_4_w4
    CALL save_8_scanlines_plus_w4
    JP   save_4_scanlines_w4

save_scanlines_8_5_w4
    CALL save_8_scanlines_plus_w4
    JP   save_5_scanlines_w4

save_scanlines_8_6_w4
    CALL save_8_scanlines_plus_w4
    JP   save_6_scanlines_w4

; ---------------------------------------------------------------------------
; Save background for normal sprite
; ---------------------------------------------------------------------------
save_8_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_7_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_6_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_5_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_4_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_3_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_2_scanlines
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_1_scanline
    SAVE_BG_SCANLINE 5

    RET

save_8_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_7_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_6_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_5_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_4_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_3_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_2_scanlines_plus
    SAVE_BG_SCANLINE 5
    NEXT_SCAN_SAVE 5

save_1_scanline_plus
    SAVE_BG_SCANLINE 5
    NEXT_CHAR_SAVE 5

    RET

; ---------------------------------------------------------------------------
; Save background for Pac-Man & Ghost sprite
; ---------------------------------------------------------------------------
save_8_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_7_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_6_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_5_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_4_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_3_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_2_scanlines_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_1_scanline_w4
    SAVE_BG_SCANLINE 4

    RET

save_8_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_7_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_6_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_5_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_4_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_3_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_2_scanlines_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_SCAN_SAVE 4

save_1_scanline_plus_w4
    SAVE_BG_SCANLINE 4
    NEXT_CHAR_SAVE 4

    RET

; --------------------------------------------------------------------------- 
