; --------------------------------------------------------------------------- 
; Pac-Man CPC Sprite Code - Print Sprites (c) SyX 2012
; --------------------------------------------------------------------------- 

; --------------------------------------------------------------------------- 
; Draw the currently visible sprites, in the correct order for overlaps
; Note: sprite order changes depending on mode, so not always as listed!
; --------------------------------------------------------------------------- 
do_sprites
    SET_VRAM_PAGE           ; Put the VRAM page in $4000 (BC, IXH)
    BIT  1,C
    JR   NZ,.print_second_buffer

.print_first_buffer
    LD   DE,(SPRITE6_ATRB)
    LD   HL,SPRITE6_SAVE1
    CALL draw_sprite        ; Fruit

    LD   DE,(SPRITE5_ATRB)
    LD   HL,SPRITE5_SAVE1
    CALL draw_sprite        ; Pacman

    LD   DE,(SPRITE4_ATRB)
    LD   HL,SPRITE4_SAVE1
    CALL draw_sprite        ; Orange ghost

    LD   DE,(SPRITE3_ATRB)
    LD   HL,SPRITE3_SAVE1
    CALL draw_sprite        ; Cyan ghost

    LD   DE,(SPRITE2_ATRB)
    LD   HL,SPRITE2_SAVE1
    CALL draw_sprite        ; Pink ghost

    LD   DE,(SPRITE1_ATRB)
    LD   HL,SPRITE1_SAVE1
    CALL draw_sprite        ; Red ghost

    JR   .end_do_print

.print_second_buffer    
    LD   DE,(SPRITE6_ATRB)
    LD   HL,SPRITE6_SAVE2
    CALL draw_sprite        ; Fruit

    LD   DE,(SPRITE5_ATRB)
    LD   HL,SPRITE5_SAVE2
    CALL draw_sprite        ; Pacman

    LD   DE,(SPRITE4_ATRB)
    LD   HL,SPRITE4_SAVE2
    CALL draw_sprite        ; Orange ghost

    LD   DE,(SPRITE3_ATRB)
    LD   HL,SPRITE3_SAVE2
    CALL draw_sprite        ; Cyan ghost

    LD   DE,(SPRITE2_ATRB)
    LD   HL,SPRITE2_SAVE2
    CALL draw_sprite        ; Pink ghost

    LD   DE,(SPRITE1_ATRB)
    LD   HL,SPRITE1_SAVE2
    CALL draw_sprite        ; Red ghost

.end_do_print
    SET_PAGE RUN_CODE

    RET

; --------------------------------------------------------------------------- 
; Draw a mask sprite
; Entry:
;     HL : Address of the buffer used for saving the background
;     D : Palette
;     E : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
; --------------------------------------------------------------------------- 
draw_sprite
    LD   A,(HL)
    AND  A
    RET  Z                  ; No background saved, no need of drawing sprite

    LD   A,D
    AND  A
    RET  Z                  ; Sprite palette all black

    ; Map an arcade sprite number to our sprite
    LD   A,E
    AND  %11111100
    RRCA                    ; Sprite pattern number * 2

    ; Skip print fruit
sm_skip_fruit
    CP   16
    RET  C
    
    LD   B,>arcade2cpc_print_sprites
    ADD  A,<arcade2cpc_print_sprites
    JR   NC,.espero_no_estar_en_mitad_pagina_01    ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina_01
    LD   C,A
    LD   A,(BC)
    LD   IYL,A
    INC  BC                                     ; *** REVISAR *** INC C
    LD   A,(BC)
    LD   IYH,A

    JP   (IY)               ; Jump to the print routine
    
; ---------------------------------------------------------------------------
; Conversion table from Arcade sprite numbers to CPC (for printing sprites)
; ---------------------------------------------------------------------------
arcade2cpc_print_sprites
    ; Fruits
    DEFW print_fruit_spr_00,print_fruit_spr_01,print_fruit_spr_02,print_fruit_spr_03
    DEFW print_fruit_spr_04,print_fruit_spr_05,print_fruit_spr_06,print_fruit_spr_07
    
    ; Intermission Ghost
    DEFW print_ighost_spr_08,print_ighost_spr_09,print_ighost_spr_10,print_ighost_spr_11
    DEFW print_ighost_spr_12,print_ighost_spr_13,print_blank_spr,print_blank_spr

    ; Big Pac-Man
    DEFW print_blank_spr,print_bigpac_spr_01,print_blank_spr,print_blank_spr    ; 0, 1*, 4, 5
    DEFW print_blank_spr,print_bigpac_spr_02,print_blank_spr,print_blank_spr    ; 0, 2*, 4, 6
    DEFW print_blank_spr,print_bigpac_spr_03,print_blank_spr,print_blank_spr    ; 0, 3*, 4, 7

    ; Scare Ghost
    DEFW print_sghost_spr_28,print_sghost_spr_29,print_blank_spr,print_blank_spr
    
    ; Ghost
    DEFW print_ghost_spr_32,print_ghost_spr_33,print_ghost_spr_34,print_ghost_spr_35
    DEFW print_ghost_spr_36,print_ghost_spr_37,print_ghost_spr_38,print_ghost_spr_39

    ; Score
    DEFW print_score_spr_40,print_score_spr_41,print_score_spr_42,print_score_spr_43
    
    ; Pac-Man
    DEFW print_pacman_spr_44,print_pacman_spr_45,print_pacman_spr_46,print_pacman_spr_47
    
    ; Pac-Man Ball, Explosion (blank) and Ghost bitten
    DEFW print_pacman_spr_48,print_blank_spr,print_eghost_spr_50,print_eghost_spr_51
    
    ; Pac-Man Death
    DEFW print_pacdeath_spr_52,print_pacdeath_spr_53,print_pacdeath_spr_54,print_pacdeath_spr_55
    DEFW print_pacdeath_spr_56,print_pacdeath_spr_57,print_pacdeath_spr_58,print_pacdeath_spr_59
    DEFW print_pacdeath_spr_60,print_pacdeath_spr_61,print_pacdeath_spr_62,print_blank_spr

; --------------------------------------------------------------------------- 
; Entry:
;     HL : Address of the buffer used for saving the background
;     D  : Palette
;     E  : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
; Exit:
;     HL : Address of the buffer used for saving the background
;     DE : Sprite frame address
; --------------------------------------------------------------------------- 

; Tiles  14, 15, 30, 31, 63
print_blank_spr
    RET

; Tiles 28 - 29
print_sghost_spr_28
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    BIT  1,D                        ; Check colour
    JR   NZ,.scare_ghost_02
    LD   DE,SPR_SGHOST_BLUE_28      ; Blue Scared
    JP   continue_print_sprite
.scare_ghost_02
    LD   DE,SPR_SGHOST_YELLOW_28    ; Yellow Scared
    JP   continue_print_sprite

print_sghost_spr_29
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    BIT  1,D                        ; Check colour
    JR   NZ,.scare_ghost_02
    LD   DE,SPR_SGHOST_BLUE_29      ; Blue Scared
    JP   continue_print_sprite
.scare_ghost_02
    LD   DE,SPR_SGHOST_YELLOW_29    ; Yellow Scared
    JP   continue_print_sprite

; Tiles 32 - 39
print_ghost_spr_32
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_RIGHT
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_32
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_32
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_32
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_32
    JP   continue_print_sprite

print_ghost_spr_33
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_RIGHT
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_33
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_33
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_33
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_33
    JP   continue_print_sprite

print_ghost_spr_34
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_DOWN
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_34
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_34
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_34
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_34
    JP   continue_print_sprite

print_ghost_spr_35
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_DOWN
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_35
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_35
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_35
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_35
    JP   continue_print_sprite

print_ghost_spr_36
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_LEFT
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_36
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_36
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_36
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_36
    JP   continue_print_sprite

print_ghost_spr_37
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_LEFT
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_37
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_37
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_37
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_37
    JP   continue_print_sprite

print_ghost_spr_38
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_UP
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_38
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_38
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_38
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_38
    JP   continue_print_sprite

print_ghost_spr_39
    LD   BC,SPR_GHOST_WIDTH * GHOST_HEIGHT
    DEC  D
    JR   Z,.red_ghost
    SRL  D
    DEC  D
    JR   Z,.pink_ghost
    DEC  D
    JR   Z,.cyan_ghost
    DEC  D
    JR   Z,.orange_ghost
.eyes_only    
    LD   DE,SPR_EYES_UP
    JP   continue_print_sprite_make_shift

.red_ghost    
    LD   DE,SPR_GHOST_RED_39
    JP   continue_print_sprite

.pink_ghost    
    LD   DE,SPR_GHOST_PINK_39
    JP   continue_print_sprite

.cyan_ghost    
    LD   DE,SPR_GHOST_CYAN_39
    JP   continue_print_sprite

.orange_ghost    
    LD   DE,SPR_GHOST_ORANGE_39
    JP   continue_print_sprite
    
; Tiles 44 - 48
print_pacman_spr_44
    LD   BC,SPR_PAC_WIDTH * PACMAN44_HEIGHT
    BIT  1,E
    JR   NZ,.pacman_left
    LD   DE,SPR_PACMAN_RIGHT_44
    JP   continue_print_sprite
.pacman_left
    LD   DE,SPR_PACMAN_LEFT_44
    JP   continue_print_sprite

print_pacman_spr_45
    LD   BC,SPR_PAC_WIDTH * PACMAN45_HEIGHT
    BIT  0,E
    JR   NZ,.pacman_up
    LD   DE,SPR_PACMAN_DOWN_45
    JP   continue_print_sprite
.pacman_up
    LD   DE,SPR_PACMAN_UP_45
    JP   continue_print_sprite

print_pacman_spr_46
    LD   BC,SPR_PAC_WIDTH * PACMAN46_HEIGHT
    BIT  1,E
    JR   NZ,.pacman_left
    LD   DE,SPR_PACMAN_RIGHT_46
    JP   continue_print_sprite
.pacman_left
    LD   DE,SPR_PACMAN_LEFT_46
    JP   continue_print_sprite

print_pacman_spr_47
    LD   BC,SPR_PAC_WIDTH * PACMAN47_HEIGHT
    BIT  0,E
    JR   NZ,.pacman_up
    LD   DE,SPR_PACMAN_DOWN_47
    JP   continue_print_sprite
.pacman_up
    LD   DE,SPR_PACMAN_UP_47
    JP   continue_print_sprite

print_pacman_spr_48
    LD   DE,SPR_PACMAN_48
    LD   BC,SPR_PAC_WIDTH * PAC_BALL_HEIGHT
    JP   continue_print_sprite

; Tile 49 (Not used)
;print_explosion_spr
;    RET

; --------------------------------------------------------------------------- 
; Tiles  8 - 13 | 50 - 51 Intermission Ghosts
; Tiles 40 - 43 Scores
; Tiles 52 - 62 Pac-Man Death Sprites
;
; Entry:
;     D  : Palette
;     E  : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
;     HL : Address of the buffer used for saving the background
; Exit:
;     DE : Address of the Sprite + Mask frame
;     HL : Address of the buffer used for saving the background
; --------------------------------------------------------------------------- 
; Intermission Ghosts
print_ighost_spr_08
    LD   DE,SPR_IGHOST_08
    JR   continue_print_sprite_make_shift

print_ighost_spr_09
    LD   DE,SPR_IGHOST_09
    JR   continue_print_sprite_make_shift

print_ighost_spr_10
    LD   DE,SPR_IGHOST_10
    JR   continue_print_sprite_make_shift_pink

print_ighost_spr_11
    LD   DE,SPR_IGHOST_11
    JR   continue_print_sprite_make_shift_pink

print_ighost_spr_12
    LD   DE,SPR_IGHOST_12
    JR   continue_print_sprite_make_shift

print_ighost_spr_13
    LD   DE,SPR_IGHOST_13
    JR   continue_print_sprite_make_shift

print_eghost_spr_50
    LD   DE,SPR_EGHOST_50
    JR   continue_print_sprite_make_shift_pink

print_eghost_spr_51
    LD   DE,SPR_EGHOST_51
    JR   continue_print_sprite_make_shift_pink

; Scores
print_score_spr_40
    LD   DE,SPR_SCORE_40
    JR   continue_print_sprite_make_shift

print_score_spr_41
    LD   DE,SPR_SCORE_41
    JR   continue_print_sprite_make_shift

print_score_spr_42
    LD   DE,SPR_SCORE_42
    JR   continue_print_sprite_make_shift

print_score_spr_43
    LD   DE,SPR_SCORE_43
    JR   continue_print_sprite_make_shift

; Pac-Man Death Sprites
print_pacdeath_spr_52
    LD   DE,SPR_PACDEATH_52
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_53
    LD   DE,SPR_PACDEATH_53
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_54
    LD   DE,SPR_PACDEATH_54
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_55
    LD   DE,SPR_PACDEATH_55
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_56
    LD   DE,SPR_PACDEATH_56
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_57
    LD   DE,SPR_PACDEATH_57
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_58
    LD   DE,SPR_PACDEATH_58
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_59
    LD   DE,SPR_PACDEATH_59
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_60
    LD   DE,SPR_PACDEATH_60
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_61
    LD   DE,SPR_PACDEATH_61
    JR   continue_print_sprite_make_shift

print_pacdeath_spr_62
    LD   DE,SPR_PACDEATH_62
    JR   continue_print_sprite_make_shift

; --------------------------------------------------------------------------- 
; Entry:
;     DE : Sprite frame address
;     HL : Address of the buffer used for saving the background
; Exit:
;     DE : Screen Address
;     HL : Address of the Sprite + Mask frame
; --------------------------------------------------------------------------- 
continue_print_sprite_make_shift_pink
    LD   A,INK + ROSA
    LD   (flash_maze.sm_flash_blue + 1),A
continue_print_sprite_make_shift
    ; Get the screen address where print the sprite
    LD   C,(HL)
    INC  L
    LD   B,(HL)             ; BC = Screen Address

    ; Get the Sprite Height
    INC  L
    LD   L,(HL)
    LD   A,L
    RRCA
    RRCA
    AND  %00001111
    LD   IXL,A              ; Sprite Height
    LD   A,L
    LD   L,C
    LD   H,B
    EX   DE,HL              ; DE = Screen Address | HL = Address of the Sprite + Mask frame
    
    ; Get the Preshift frame
    AND  %00000011
    JR   Z,print_sprite_shift_0
    DEC  A
    JR   Z,print_sprite_shift_1
    DEC  A
    JP   Z,print_sprite_shift_2
    JP   print_sprite_shift_3

; --------------------------------------------------------------------------- 
; Entry:
;     DE : Screen Address
;     HL : Address of the Sprite + Mask frame
;    IXL : Sprite Height
; --------------------------------------------------------------------------- 
; **** ....
print_sprite_shift_0
    LD   (.sm_old_sp + 1),SP
    LD   SP,HL
    EX   DE,HL              ; HL = Screen Address

.loop_print_shift_0
    ; 1º, 2º y 3º Bytes
    REPT 3
        POP  DE
        LD   A,(HL)
        AND  D
        OR   E
        LD   (HL),A
        INC  L
    ENDR
    
    ; 4º Byte
    POP  DE
    LD   A,(HL)
    AND  D
    OR   E
    LD   (HL),A
    
    LD   BC,$0800 - 3
    ADD  HL,BC
    BIT  7,H
    JR   Z,.next_sprite_scan
    LD   BC,$C040
    ADD  HL,BC
.next_sprite_scan
    DEC  IXL
    JR   NZ,.loop_print_shift_0
.sm_old_sp
    LD   SP,$0000
    RET

; .*** *...
print_sprite_shift_1
    LD   (.sm_old_sp + 1),SP
    LD   SP,HL
    EX   DE,HL              ; HL = Screen Address

.loop_print_shift_1
    ; 1º Byte
    ; Máscara
    POP  DE
    LD   A,D
    AND  %11101110
    RRCA
    OR   %10001000
    LD   C,A
    LD   A,(HL)
    AND  C
    LD   C,A
    
    ; Sprite
    LD   A,E            
    AND  %11101110      
    RRCA                
    OR   C              
    LD   (HL),A         
    INC  L              

    ; 2º, 3º y 4º Bytes
    REPT 3
        ; Sprite anterior
        LD   A,E        
        AND  %00010001  
        RLCA
        RLCA
        RLCA            
        LD   IYL,A      
        ; Máscara anterior
        LD   A,D        
        AND  %00010001  
        RLCA
        RLCA
        RLCA            
        LD   C,A        
        ; Máscara
        POP  DE         
        LD   A,D        
        AND  %11101110  
        RRCA            
        OR   C          
        LD   C,A        
        LD   A,(HL)     
        AND  C          
        LD   C,A        
        ; Sprite
        LD   A,E        
        AND  %11101110  
        RRCA            
        OR   IYL        
        OR   C          
        LD   (HL),A     
        INC  L          
    ENDR

    ; 5º Byte
    ; Máscara anterior
    LD   A,D            
    AND  %00010001      
    RLCA
    RLCA
    RLCA                
    OR   %01110111      
    LD   C,A            
    LD   A,(HL)         
    AND  C              
    LD   C,A            
    ; Sprite
    LD   A,E            
    AND  %00010001      
    RLCA
    RLCA
    RLCA                
    OR   C              
    LD   (HL),A         

    LD   BC,$0800 - 4
    ADD  HL,BC
    BIT  7,H
    JR   Z,.next_sprite_scan
    LD   BC,$C040
    ADD  HL,BC
.next_sprite_scan
    DEC  IXL
    JP   NZ,.loop_print_shift_1
.sm_old_sp
    LD   SP,$0000
    RET

; ..** **..
print_sprite_shift_2
    LD   (.sm_old_sp + 1),SP
    LD   SP,HL
    EX   DE,HL              ; HL = Screen Address

.loop_print_shift_2
    ; 1º Byte
    ; Máscara
    POP  DE             
    LD   A,D            
    AND  %11001100      
    RRCA
    RRCA                
    OR   %11001100      
    LD   C,A            
    LD   A,(HL)         
    AND  C              
    LD   C,A            
    
    ; Sprite
    LD   A,E            
    AND  %11001100      
    RRCA
    RRCA                
    OR   C              
    LD   (HL),A         
    INC  L              

    ; 2º, 3º y 4º Bytes
    REPT 3
        ; Sprite anterior
        LD   A,E        
        AND  %00110011  
        RLCA
        RLCA            
        LD   IYL,A      
        ; Máscara anterior
        LD   A,D        
        AND  %00110011  
        RLCA
        RLCA            
        LD   C,A        
        ; Máscara
        POP  DE         
        LD   A,D        
        AND  %11001100  
        RRCA
        RRCA            
        OR   C          
        LD   C,A        
        LD   A,(HL)     
        AND  C          
        LD   C,A        
        ; Sprite
        LD   A,E        
        AND  %11001100  
        RRCA
        RRCA            
        OR   IYL        
        OR   C          
        LD   (HL),A     
        INC  L          
    ENDR

    ; 5º Byte
    ; Máscara anterior
    LD   A,D            
    AND  %00110011      
    RLCA
    RLCA                
    OR   %00110011      
    LD   C,A            
    LD   A,(HL)         
    AND  C              
    LD   C,A            
    ; Sprite
    LD   A,E            
    AND  %00110011      
    RLCA
    RLCA                
    OR   C              
    LD   (HL),A         

    LD   BC,$0800 - 4
    ADD  HL,BC
    BIT  7,H
    JR   Z,.next_sprite_scan
    LD   BC,$C040
    ADD  HL,BC
.next_sprite_scan
    DEC  IXL
    JP   NZ,.loop_print_shift_2
.sm_old_sp
    LD   SP,$0000
    RET

; ...* ***.
print_sprite_shift_3
    LD   (.sm_old_sp + 1),SP
    LD   SP,HL
    EX   DE,HL              ; HL = Screen Address

.loop_print_shift_3
    ; 1º Byte
    ; Máscara
    POP  DE             
    LD   A,D            
    AND  %10001000      
    RRCA
    RRCA
    RRCA                
    OR   %11101110      
    LD   C,A            
    LD   A,(HL)         
    AND  C              
    LD   C,A            
    
    ; Sprite
    LD   A,E            
    AND  %10001000      
    RRCA
    RRCA
    RRCA                
    OR   C              
    LD   (HL),A         
    INC  L              

    ; 2º, 3º y 4º Bytes
    REPT 3
        ; Sprite anterior
        LD   A,E        
        AND  %01110111  
        RLCA            
        LD   IYL,A      
        ; Máscara anterior
        LD   A,D        
        AND  %01110111  
        RLCA            
        LD   C,A        
        ; Máscara
        POP  DE        
        LD   A,D        
        AND  %10001000  
        RRCA
        RRCA
        RRCA            
        OR   C          
        LD   C,A        
        LD   A,(HL)     
        AND  C          
        LD   C,A        
        ; Sprite
        LD   A,E        
        AND  %10001000  
        RRCA
        RRCA
        RRCA            
        OR   IYL        
        OR   C          
        LD   (HL),A     
        INC  L          
    ENDR

    ; 5º Byte
    ; Máscara anterior
    LD   A,D            
    AND  %01110111      
    RLCA                
    OR   %00010001      
    LD   C,A            
    LD   A,(HL)         
    AND  C              
    LD   C,A            
    ; Sprite
    LD   A,E            
    AND  %01110111      
    RLCA                
    OR   C              
    LD   (HL),A         

    LD   BC,$0800 - 4
    ADD  HL,BC
    BIT  7,H
    JR   Z,.next_sprite_scan
    LD   BC,$C040
    ADD  HL,BC
.next_sprite_scan
    DEC  IXL
    JP   NZ,.loop_print_shift_3
.sm_old_sp
    LD   SP,$0000
    RET

; --------------------------------------------------------------------------- 
; Tiles 16 - 27 Big Pac-Man
;
; Entry:
;     D  : Palette
;     E  : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
;     HL : Address of the buffer used for saving the background
; Exit:
;     BC : Sprite frame size in bytes
;     DE : Address of the Sprite + Mask frame
;     HL : Address of the buffer used for saving the background
; --------------------------------------------------------------------------- 
; Big Pac
print_bigpac_spr_01
    LD   DE,SPR_BIGPAC_SPR_01
    LD   BC,SPR_BIGPAC_WIDTH * BIGPAC_HEIGHT
    JR   continue_print_sprite_bigpac

print_bigpac_spr_02
    LD   DE,SPR_BIGPAC_SPR_02
    LD   BC,SPR_BIGPAC_WIDTH * BIGPAC_HEIGHT
    JR   continue_print_sprite_bigpac

print_bigpac_spr_03
    LD   DE,SPR_BIGPAC_SPR_03
    LD   BC,SPR_BIGPAC_WIDTH * BIGPAC_HEIGHT
    JR   continue_print_sprite_bigpac

; --------------------------------------------------------------------------- 
; Entry:
;     BC : Sprite frame size in bytes
;     DE : Sprite frame address
;     HL : Address of the buffer used for saving the background
; --------------------------------------------------------------------------- 
continue_print_sprite_bigpac
    INC  L
    INC  L
    LD   A,(HL)
    EX   AF,AF'
    DEC  L
    LD   A,(HL)
    DEC  L
    LD   L,(HL)
    LD   H,A            ; Get the screen address where print the sprite
    EX   AF,AF'
    AND  %00000011      ; Get the Preshift frame
    EX   DE,HL          ; HL = Sprite / DE = Screen Address
    JP   Z,print_scanlines_bigpac
.loop_next_frame
    ADD  HL,BC
    DEC  A
    JR   NZ,.loop_next_frame
 
    ; Print Big Pac-Man
    JP   print_scanlines_bigpac

; --------------------------------------------------------------------------- 
; Entry:
;     BC : Sprite frame size in bytes
;     DE : Sprite frame address
;     HL : Address of the buffer used for saving the background
; --------------------------------------------------------------------------- 
continue_print_sprite
    ; Get the screen address where print the sprite
    PUSH HL
    INC  L
    INC  L
    LD   A,(HL)
    AND  %00000011  ; Get the Preshift frame
    JP   Z,.got_frame_sprite
    EX   DE,HL
.loop_next_frame
    ADD  HL,BC
    DEC  A
    JR   NZ,.loop_next_frame
    EX   DE,HL
.got_frame_sprite    
    ; HL : Address of the buffer used for saving the background + 2
    ; DE : Sprite frame address
    LD   A,(HL)
    ; %0fhhhhxx (f = Fast Mode | h = Sprite Height | x = Preshift Frame 0 - 3)
    BIT  6,A
    JR   NZ,.not_need_mask
.apply_mask
    ; Select the mask routine from the sprite
.not_need_mask
    AND  %00111100
    RRCA            ; A = Sprite Height * 2
    LD   B,>(table_print_routines - 18)
    ADD  A,<(table_print_routines - 18)
    JR   NC,.espero_no_estar_en_mitad_pagina_01 ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina_01
    LD   C,A
    LD   A,(BC)
    LD   (sm_table_print_low + 1),A
    INC  BC
    LD   A,(BC)
    LD   (sm_table_print_high + 1),A
    
    ; Get the screen address where print the sprite
    POP  HL
    LD   A,(HL)
    INC  L
    LD   H,(HL)
    LD   L,A
    
    EX   DE,HL              ; HL = Sprite / DE = Screen Address
 
    ; Get the 2KB block
    LD   A,D                ; Get the 2 KB block where the sprite need to be restore
    AND  %00111000
    RRCA
    RRCA

    ; We use the same table to restore background and print sprites
sm_table_print_high
    LD   B,>table_print_routines ;table_restore_and_print_h3
sm_table_print_low
    ADD  A,<table_print_routines ;table_restore_and_print_h3
    JR   NC,.espero_no_estar_en_mitad_pagina_02 ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina_02
    LD   C,A
    LD   A,(BC)
    LD   IYL,A
    INC  BC                                     ; *** REVISAR *** INC C
    LD   A,(BC)
    LD   IYH,A

    JP   (IY)               ; Jump to the print routine

table_print_routines
    DEFW table_print_h9
    DEFW $0000
    DEFW $0000
    DEFW table_print_h12
    DEFW table_print_h13
    DEFW table_print_h14

; --------------------------------------------------------------------------- 
    include 'cpc_print_scanlines.s'

; --------------------------------------------------------------------------- 
