; --------------------------------------------------------------------------- 
; Pac-Man CPC Sprite Code - Restore Backgrounds (c) SyX 2012
; --------------------------------------------------------------------------- 

; --------------------------------------------------------------------------- 
; Remove the previous sprites by restoring the image that was underneath them
; --------------------------------------------------------------------------- 
do_restore
    SET_VRAM_PAGE           ; Put the VRAM page in $4000 (BC, IXH)

    BIT  1,C
    JR   NZ,.restore_second_buffer
.restore_first_buffer    
    LD   HL,SPRITE1_SAVE1
    CALL restore_sprite
    
    LD   HL,SPRITE2_SAVE1
    CALL restore_sprite
    
    LD   HL,SPRITE3_SAVE1
    CALL restore_sprite
    
    LD   HL,SPRITE4_SAVE1
    CALL restore_sprite
    
    LD   HL,SPRITE5_SAVE1
    CALL restore_sprite
    
    LD   HL,SPRITE6_SAVE1
    CALL restore_sprite
    
    JR   .end_do_restore

.restore_second_buffer    
    LD   HL,SPRITE1_SAVE2
    CALL restore_sprite
    
    LD   HL,SPRITE2_SAVE2
    CALL restore_sprite
    
    LD   HL,SPRITE3_SAVE2
    CALL restore_sprite
    
    LD   HL,SPRITE4_SAVE2
    CALL restore_sprite
    
    LD   HL,SPRITE5_SAVE2
    CALL restore_sprite
    
    LD   HL,SPRITE6_SAVE2
    CALL restore_sprite

.end_do_restore
    SET_PAGE RUN_CODE

    RET

; --------------------------------------------------------------------------- 
; Restore a single sprite-sized block, if data was saved
; Entry:
;     HL : Address of the buffer used for saving the background
; ---------------------------------------------------------------------------  
restore_sprite
    LD   A,(HL)
    AND  A
    RET  Z                  ; No data saved

    LD   (HL),0             ; Flag 'no restore data'

    LD   E,A                ; Restore address low
    INC  L
    LD   D,(HL)             ; Restore address high
    INC  L

    LD   A,(HL)             ; Restore sprite height
    INC  L

    ; %Ffhhhh-- (F = fruit | f = Fast Mode | h = Sprite Height)
    ; %Ffhhhh-m (F = fruit | f = Fast Mode | h = Sprite Height | m = Masked Sprite)

    ; Test if this sprite is used by the fruits
    OR   A
    JP   M,restore_fruit

    LD   IXL,A              ; Save for testing Fast Mode

    ; Update the pointer to the table to restore routines
    AND  %00111100
    RRCA                    ; A = Sprite Height * 2
    LD   B,>table_restore_routines ;(table_restore_routines - 6)
    ADD  A,<table_restore_routines ;(table_restore_routines - 6)
    JR   NC,.espero_no_estar_en_mitad_pagina_01 ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina_01
    LD   C,A
    LD   A,(BC)
    LD   (sm_table_restore_low + 1),A
    INC  BC
    LD   A,(BC)
    LD   (sm_table_restore_high + 1),A
    
    ; Get the 2 KB block where the sprite need to be restore
    LD   A,D
    AND  %00111000
    RRCA
    RRCA

    ; We use the same table to restore background and print sprites
sm_table_restore_high
    LD   B,>table_restore_routines ;table_restore_and_print_h3 ;table_fill_zeros_h3
sm_table_restore_low
    ADD  A,<table_restore_routines ;table_restore_and_print_h3 ;table_fill_zeros_h3
    JR   NC,.espero_no_estar_en_mitad_pagina_02 ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina_02
    LD   C,A
    LD   A,(BC)
    LD   IYL,A
    INC  BC                 ; *** REVISAR *** INC C
    LD   A,(BC)
    LD   IYH,A
    LD   A,IXL
    BIT  6,A
    JR   Z,.jump_routine
;;;    XOR  A               ; A was used as 0 byte to plot
    ; %Ffhhhh-- (F = fruit | f = Fast Mode | h = Sprite Height)
    ; Caso especial, comprobar la Coordenada Y 
    LD   HL,ZERO_ZONE       ; Set the background buffer to an arcade blank rom zone
    AND  %00111100
    CP   %00111000
    JR   NZ,.jump_routine
    DEC  IY
    DEC  IY                 ; Update jump
.jump_routine
    JP   (IY)               ; Jump to the print routine
    
table_restore_routines
    DEFW table_restore_h16 - 10         ; Big-Pac
    DEFW $0000
    DEFW $0000
    DEFW table_restore_h3               ; IGhost
    DEFW table_restore_h4               ; IGhost
    DEFW table_restore_h5               ; Ghost Eyes, Pac-Death
    DEFW table_restore_h6               ; Pac-Death
    DEFW table_restore_h7               ; Ghost Eyes, Score, Pac-Death
    DEFW table_restore_h8               ; Pac-Death
    DEFW table_restore_h9               ; Pac-Man
    DEFW table_restore_h10              ; Pac-Death, Pac-Death + 1
    DEFW table_restore_h11              ; IGhost
    DEFW table_restore_h12              ; Pac-Man
    DEFW table_restore_h13              ; Pac-Man
    DEFW table_restore_h14              ; Ghost, EGhost

; --------------------------------------------------------------------------- 
    include 'cpc_restore_scanlines.s'

; --------------------------------------------------------------------------- 
