; --------------------------------------------------------------------------- 
; Pac-Man Macros (c) SyX 2011
; --------------------------------------------------------------------------- 

; ---------------------------------------------------------------------------
; Pac-Gums
 MACRO DRAW_PILL_COMPILED
    LD   HL,$0C03
    LD   (\1 + $0800 * 0),HL
    LD   (\1 + $0800 * 7),HL
    LD   HL,$0E07
    LD   (\1 + $0800 * 1),HL
    LD   (\1 + $0800 * 6),HL
    LD   HL,$0F0F
    LD   (\1 + $0800 * 2),HL
    LD   (\1 + $0800 * 3),HL
    LD   (\1 + $0800 * 4),HL
    LD   (\1 + $0800 * 5),HL
 ENDM
 
 MACRO CLEAR_PILL_COMPILED
    LD   HL,$0000
    LD   (\1 + $0800 * 0),HL
    LD   (\1 + $0800 * 1),HL
    LD   (\1 + $0800 * 2),HL
    LD   (\1 + $0800 * 3),HL
    LD   (\1 + $0800 * 4),HL
    LD   (\1 + $0800 * 5),HL
    LD   (\1 + $0800 * 6),HL
    LD   (\1 + $0800 * 7),HL
 ENDM

; ---------------------------------------------------------------------------
; Macros for restoring background

; Get the address of the next char for restoring background
 MACRO NEXT_CHAR_RESTORE
    EX   DE,HL                          ; (1)
    LD   BC,$C840 - \1                  ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Get the address of the next char for restoring background
 MACRO NEXT_SCAN_RESTORE
    EX   DE,HL                          ; (1)
    LD   BC,$0800 - \1                  ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Print background scanline
 MACRO RESTORE_BG_SCANLINE
    REPT \1
        LDI
    ENDR
 ENDM

; ---------------------------------------------------------------------------
; Macros for saving background

; Get the address of the next char for save background
 MACRO NEXT_CHAR_SAVE
    LD   BC,$C840 - \1                  ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
 ENDM

; Get the address of the next scanline for save background
 MACRO NEXT_SCAN_SAVE
    LD   BC,$0800 - \1                  ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
 ENDM

; Save background scanline
 MACRO SAVE_BG_SCANLINE
    REPT \1
        LDI
    ENDR
 ENDM

; ---------------------------------------------------------------------------
; Macros for print Pac-Man sprite

; Get the address of the next char for print sprite/restore background
 MACRO NEXT_CHAR_PACMAN
    EX   DE,HL                          ; (1)
    LD   BC,$C840 - 3                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Get the address of the next scanline for print sprite/restore background
 MACRO NEXT_SCAN_PACMAN
    EX   DE,HL                          ; (1)
    LD   BC,$0800 - 3                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Print Pac-Man sprite scanline
 MACRO PRINT_PACMAN_SCANLINE
    LD   A,(DE)                         ; Obtenemos el byte de la pantalla
    AND  (HL)                           ; Lo enmascaramos
    INC  HL
    OR   (HL)                           ; Aplicamos el byte del sprite
    LD   (DE),A                         ; Lo pintamos
    INC  HL
    INC  E
    LDI
    LDI
    LD   A,(DE)                         ; Obtenemos el byte de la pantalla
    AND  (HL)                           ; Lo enmascaramos
    INC  HL
    OR   (HL)                           ; Aplicamos el byte del sprite
    LD   (DE),A                         ; Lo pintamos
    INC  HL
 ENDM

;--;

; Get the address of the next char for print sprite/restore background
 MACRO NEXT_CHAR_LPACMAN
    EX   DE,HL                          ; (1)
    LD   BC,$C840 - 4                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Get the address of the next scanline for print sprite/restore background
 MACRO NEXT_SCAN_LPACMAN
    EX   DE,HL                          ; (1)
    LD   BC,$0800 - 4                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

 ; Print Pac-Man sprite scanline (1 Mask + 3 GFXs)
 MACRO PRINT_LPACMAN_SCANLINE
    LD   A,(DE)                         ; Obtenemos el byte de la pantalla
    AND  (HL)                           ; Lo enmascaramos
    INC  HL
    OR   (HL)                           ; Aplicamos el byte del sprite
    LD   (DE),A                         ; Lo pintamos
    INC  HL
    INC  E
    LDI
    LDI
    INC  HL ; Sobra
    LDI
 ENDM

;--;

; Get the address of the next char for print sprite/restore background
 MACRO NEXT_CHAR_RPACMAN
    EX   DE,HL                          ; (1)
    LD   BC,$C840 - 3                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Get the address of the next scanline for print sprite/restore background
 MACRO NEXT_SCAN_RPACMAN
    EX   DE,HL                          ; (1)
    LD   BC,$0800 - 3                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM
 
 ; Print Pac-Man sprite scanline (3 GFXs + 1 Mask)
 MACRO PRINT_RPACMAN_SCANLINE
    INC  HL ;Sobra
    LDI
    LDI
    LDI
    LD   A,(DE)                         ; Obtenemos el byte de la pantalla
    AND  (HL)                           ; Lo enmascaramos
    INC  HL
    OR   (HL)                           ; Aplicamos el byte del sprite
    LD   (DE),A                         ; Lo pintamos
    INC  HL
 ENDM

; ---------------------------------------------------------------------------
; Macros to Restore background covered by Big Pac-Man
; ---------------------------------------------------------------------------
 MACRO RESTORE_BIGPAC_RIGHT
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
    INC  L
    LD   (HL),A
 ENDM

 MACRO RESTORE_BIGPAC_LEFT
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
    DEC  L
    LD   (HL),A
 ENDM

; ---------------------------------------------------------------------------
; Macros to print Big Pac-Man
; ---------------------------------------------------------------------------
; Print Normal
 MACRO PRINT_SCAN_BIGPAC
    REPT 9
        LDI
    ENDR
 ENDM

; Get the address of the next char
 MACRO NEXT_CHAR_BIGPAC
    EX   DE,HL                          ; (1)
    LD   BC,$C840 - 9                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Get the address of the next scanline
 MACRO NEXT_SCAN_BIGPAC
    EX   DE,HL                          ; (1)
    LD   BC,$0800 - 9                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Print Inverted
 MACRO PRINT_SCAN_BIGPAC_INV
    REPT 9
        LDD
    ENDR
 ENDM

; Get the address of the next char (INV)
 MACRO NEXT_CHAR_BIGPAC_INV
    EX   DE,HL                          ; (1)
    LD   BC,$C840 + 9                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; Get the address of the next scanline (INV)
 MACRO NEXT_SCAN_BIGPAC_INV
    EX   DE,HL                          ; (1)
    LD   BC,$0800 + 9                   ; (3) Correction factor to next char
    ADD  HL,BC                          ; (3)
    EX   DE,HL                          ; (1)
 ENDM

; ---------------------------------------------------------------------------
; Macros RAM paging

; ---------------------------------------------------------------------------
; Put the VRAM page in $4000
 MACRO SET_VRAM_PAGE
    LD   B,>GATE_ARRAY
    LD   C,IXH
    OUT  (C),C
 ENDM

; ---------------------------------------------------------------------------
; SET_FAST_PAGE: Activa la pgina de RAM extendida indicada, presupone que 
; B = >GATE_ARRAY
; Corrompe: BC
; ---------------------------------------------------------------------------
 MACRO SET_PAGE_FAST
    LD   C,\1
    OUT  (C),C
 ENDM

; ---------------------------------------------------------------------------
; Put the VRAM page in $4000, presupone B = >GATE_ARRAY
 MACRO SET_VRAM_PAGE_FAST
    LD   C,IXH
    OUT  (C),C
 ENDM
 
; ---------------------------------------------------------------------------
