; ---------------------------------------------------------------------------
; Pac-Man emulator launcher (in the top of the stack)
; ---------------------------------------------------------------------------

    include 'constantes.i'
    include 'hardware.i'
    include 'macros.i'

    ORG  CPC_STACK - 80

; ---------------------------------------------------------------------------
patch_arcade_ints
    PUSH HL
    ; Patch Pac-Man code
    LD   HL,$D604                       ; SUB   4
    LD   ($3181),HL
    LD   HL,$47ED                       ; LD   I,A
    LD   ($3183),HL

    ; Set the game interrupt handler from $30B0 -> $008D,
    ; changed to $008E to save a PUSH AF
    LD   HL,$008E                       ; $008D
    LD   (SM_INT_HANDLER),HL
    POP  HL
    JP   $3181

    ; Launch Pac-Man!!!
launch_pacman
    ; Clear VRAM buffers
    SET_PAGE $C0
    LD   HL,$4000
    LD   DE,$4001
    LD   BC,$3FFF
    LD   (HL),0
    LDIR
    LD   HL,$4000
    LD   DE,$C000
    LD   BC,$4000
    LDIR

    ; Set game palette
    LD   HL,end_pacman_palette - 1
    LD   A,end_pacman_palette - pacman_palette - 1
    LD   B,>GATE_ARRAY
.loop_set_pacman_palette
    OUT  (C),A
    INC  B
    OUTD
    DEC  A
    JP   P,.loop_set_pacman_palette

    ; Enable bank config for running the emulator
    SET_PAGE RUN_CODE

    ; Execute emulator
    JP   $0000

; ---------------------------------------------------------------------------
pacman_palette
    DEFB INK + NEGRO,INK + AZUL_BRILLANTE, INK + AMARILLO_BRILLANTE,INK + ROJO_BRILLANTE
end_pacman_palette

; ---------------------------------------------------------------------------
    END
