; ---------------------------------------------------------------------------
; Pac-Man emulator launcher (in the top of the stack)
; ---------------------------------------------------------------------------

    include 'constantes.i'
    include 'hardware.i'
    include 'macros.i'

    ORG  CPC_STACK - 80

; ---------------------------------------------------------------------------
patch_arcade_ints
    PUSH HL
    ; Patch Pac-Man code
    LD   HL,$D604                       ; SUB   4
    LD   ($3181),HL
    LD   HL,$47ED                       ; LD   I,A
    LD   ($3183),HL

    ; Set the game interrupt handler ($30B0 -> $008D),
    ; changed to $008E to save a PUSH AF
    LD   HL,$008E                       ; $008D
    LD   (SM_INT_HANDLER),HL
    POP  HL
    JP   $3181

    ; Relaunch Pac-Man!!!
relaunch_pacman
    ; Clear VRAM buffer in $4000
    SET_PAGE $C1
    LD   HL,$4000
    LD   DE,$4001
    LD   BC,$3FFF
    LD   (HL),0
    LDIR

    ; Clear buffers used for saving background (sprites)
    LD   HL,SPRITE1_SAVE1 ;- $8000
    LD   DE,SPRITE1_SAVE1 + 1 ;- $8000 + 1
    LD   BC,SPRITE6_SAVE2 + 5 * 14 + 3 - SPRITE1_SAVE1 - 1
    LD   (HL),0
    LDIR

    ; Enable bank config for running the emulator
    SET_PAGE RUN_CODE

    ; Update the DIP setting in $5080
sm_dip_value
    LD   A,0
    LD   (DIP_5080),A

    ; Execute emulator
    JP   $0000

; ---------------------------------------------------------------------------
    END
