// pm1.c

// Platformer Medley, 1 Carga
// ===========================

// Versin para Amstrad CPC en C. La idea es portarlo luego a ZX Spectrum 128K
// Todo el core del juego ir en un archivo core.h que ser empleado por
// pm1.c y pm2.c, para no replicar cdigo. El archivo con los sprites,
// sprites.h, ser empleado tambin por ambas versiones. Lo nico que cambiar
// son los enlaces al archivo de mapas y un par de cosas ms, como el control 
// de clave de acceso y el final.

// Empezamos.

// Mi cuarto juego para CPC.

#include <cpcrslib.h>				// Biblioteca de juego por Artaburu.
#include <cpcwyzlib.h>				// Replayer AY por WYZ, adaptado por Artaburu.
#include "sound1.h"					// Configuracin del replayer AY + msicas.

// Aqu definimos las cosas propias de la carga 1:

// Dimensiones y datos del mapa:

#define MAPDATA_WIDTH					5
#define MAPDATA_HEIGHT					8
#define MAPDATA_ENDSCR					35
#define MAPDATA_INITSCR					0
#define MAPDATA_OPERATION				<=
#define MAPDATA_XVALUE					8
#define MAPDATA_XSTART					16
#define MAPDATA_YSTART					16
#define MAPDATA_LASTROW_FIRSTSCRINDEX	35

// Comportamiento de los tiles
// 0 transpasable
// 1 transpasable y mata
// 2 plataforma
// 3 obstculo

unsigned char tile_c [] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	2, 0, 0, 3, 3, 3, 1, 3, 3, 3, 3, 2, 2, 2, 0, 0,
	0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
};

// Datos especficos de la primera carga:

extern unsigned char map_data [];	// TODO: Mover esto a map1.h cuando acabes.
extern unsigned char s_marco [];	
#include "map1.h"					// Mapa de la primera carga
#include "sprites1.h"				// Spriteset
#include "letreros.h"				// Letreros (game over y "Platformer Medley")
#include "enem1.h"					// Datos de los enemigos

// Cadenas especficas

extern unsigned char cad_title_1 [];
extern unsigned char cad_title_2 [];
extern unsigned char cad_title_3 [];

extern unsigned char cad_keys_1 [];
extern unsigned char cad_keys_2 [];
extern unsigned char cad_keys_3 [];
extern unsigned char cad_keys_4 [];
extern unsigned char cad_keys_5 [];
unsigned char *cad_keys [] = {
	cad_keys_1, cad_keys_2, cad_keys_3, cad_keys_4, cad_keys_5
};

extern unsigned char cad_greeting_1 [];
extern unsigned char cad_greeting_2 [];
extern unsigned char cad_pass_1 [];

#asm
	._cad_greeting_1
		defm "XXXXXXXX"
		defb 0
	._cad_greeting_2
		defm "XXXXXXXX"
		defb 0

	._cad_title_1
		defm "FIRST;BLOCK"
		defb 0
	._cad_title_2
		defm "A;GAME;BY;THE;MOJON;TWINS"
		defb 0
	._cad_title_3
		defm "PRESS;ANY;KEY;TO;PLAY"
		defb 0
		
	._cad_keys_1
		defm "L;ARROW:WALK;LEFT"
		defb 0
	._cad_keys_2
		defm "R;ARROW:WALK;RIGHT"
		defb 0
	._cad_keys_3
		defm ";;SPACE:JUMP"
		defb 0
	._cad_keys_4
		defm ";;;;ESC:QUIT"
		defb 0
	._cad_keys_5
		defm ";;;;;;M:T<MUSIC"
		defb 0
	
	._cad_pass_1
		defm "PASSWORD"
		defb 0
#endasm

// Prototipos

void final (void);
void titulo (void);
void special_features_show_screen (unsigned char);
void special_features_ingame (unsigned char);

// Funciones y datos compartidos del juego

#include "core.h"					

// Funciones y datos especficos de esta carga

void final (void) {
	cpc_UnExo ((unsigned int *) (song_1), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (1);
	cpc_WyzSetPlayerOn ();
	
	clear_playground ();
	set_text_inks (2, 0, 162, 168);
	cpc_PrintGphStrXY ((unsigned int *) (cad_pass_1), (unsigned char *) (36), (unsigned char *) (84));
	set_text_inks (162, 0, 170, 34);
	cpc_PrintGphStrXY ((unsigned int *) (cad_greeting_1), (unsigned char *) (36), (unsigned char *) (100));
	
	wait_for_key ();	
	cpc_WyzSetPlayerOff ();
}

void titulo (void) {
	unsigned char i;
	
	clear_playground ();
	
	cpc_UnExo ((unsigned int *) (song_1), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (1);
	cpc_WyzSetPlayerOn ();
	
	cpc_PutSpTr ( (unsigned int *) (g_letreros [1]), (unsigned char *) (16), (unsigned char *) (16), (unsigned int *) (0xc166));
	
	set_text_inks (2, 0, 162, 168);
	cpc_PrintGphStrXY ((unsigned int *) (cad_title_1), (unsigned char *) (33), (unsigned char *) (50));
	set_text_inks (160, 0, 170, 32);
	for (i = 0; i < 5; i ++)
		cpc_PrintGphStrXY ((unsigned int *) (cad_keys [i]), (unsigned char *) (26), (unsigned char *) (84 + (i << 3)));
	set_text_inks (162, 0, 170, 34);
	cpc_PrintGphStrXY ((unsigned int *) (cad_title_2), (unsigned char *) (20), (unsigned char *) (150));
	cpc_PrintGphStrXY ((unsigned int *) (cad_title_3), (unsigned char *) (24), (unsigned char *) (168));

	wait_for_key ();	
	cpc_WyzSetPlayerOff ();
}

void special_features_show_screen (unsigned char pant) {
	// Nada en la primera carga.	
}

void special_features_ingame (unsigned char pant) {
	// Nada en la primera carga.	
}

// Main

void main (void) {
	main_game ();
}

#asm
	._s_marco
		BINARY "s_marco_1.bin"
#endasm
