/*
This file is part of VoidHawk.

VoidHawk is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

VoidHawk is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with VoidHawk.  If not, see <http://www.gnu.org/licenses/>.
*/
void SetColours()
{
    unsigned char i;
    for (i = 0; i < 16; i++)
        cpc_SetInk(i, paleta[i]);
}

unsigned char GetMode0PixelColorByte(unsigned char nColor, unsigned char nPixel)
{
    unsigned char nByte = 0;

    if(nPixel == 0)
    {
        nByte &= 85;

        if(nColor & 1)
            nByte |= 128;

        if(nColor & 2)
            nByte |= 8;

        if(nColor & 4)
            nByte |= 32;

        if(nColor & 8)
            nByte |= 2;
    }
    else
    {
        nByte &= 170;

        if(nColor & 1)
            nByte |= 64;

        if(nColor & 2)
            nByte |= 4;

        if(nColor & 4)
            nByte |= 16;

        if(nColor & 8)
            nByte |= 1;
    }

    return nByte;
}

unsigned char *GetLineAddress(unsigned char nLine)
{
    return (unsigned char *)0xC000 + ((nLine / 8) * 80) + ((nLine % 8) * 2048);
}
