; Macros for handling left/right edge horizontal displacements properly
macro incc
ld a,c
inc c
or %11000000
inc a
jp nz,@noborder
ld a,c
sub &40
ld c,a
move4linesUp_phase1
@noborder
endm

macro decc
ld a,c
dec c
and %00111111
jp nz,@noborder
ld a,c
add &40
ld c,a
move4linesDown_phase1
@noborder
endm

macro inc2c
ld a,c
add &c2
ld c,a
move4linesUp_phase1
endm

macro dec2c
ld a,c
add &3e
ld c,a
move4linesDown_phase1
endm

; Macros performing vertical screen displacements 
macro moveLineUp_phase1
ld a,b
sub &8           ; Decrements one line
ld b,a
bit 6,b
jr z, @end

ld a,c
add &c0
ld c,a
ld a,b
adc &3f
ld b,a

set 3,b          ; Fixes jump over top screen edge

@end
endm

macro moveLineDown_phase1
ld a,b
add &8           ; Increments one line
ld b,a
bit 6,b
jr z,@end      

ld a,c
add &40
ld c,a
ld a,b
adc &c0
ld b,a

res 3,b          ; Fixes jump over bottom screen edge

@end
endm

macro move2linesDown_phase1
ld a,b
add &10          ; Increments two lines
ld b,a
bit 6,b
jr z,@end      

ld a,c
add &40
ld c,a

ld a,b
adc &c0
xor b
and %11000111
xor b
ld b,a

@end
endm

macro move4linesDown_phase1
ld a,b
add &20          ; Increments two lines
ld b,a
bit 6,b
jr z,@end      

ld a,c
add &40
ld c,a

ld a,b
adc &c0
xor b
and %11000111
xor b
ld b,a

@end
endm

macro move4LinesUp_phase1
ld a,b
sub &20           ; Decrements one line
ld b,a
bit 6,b
jr z,@end

ld a,c
add &c0
ld c,a

ld a,b
adc &3f
xor b
and %11000111
xor b
ld b,a

@end
endm
