; Here we have a set of routines for updating the neighbour counts of the 
; active cell's neighbours according to each particular transition during 
; the Phase 1 of the algorithm.

; The label of each section represents the transtion in the form 
; .te(oldstate)(currentstate)

; Some transitions are degenerate, meaning that they have the same effect on
; its neighbours, and some other aren't even present as they don't represent
; any change at all, like tn0000 or tn0101 for instance. 

; The following figure can help to understand what this code does, each pair 
; of letters represent information that is encoded togheter within the same 
; cell data byte. 

;NL BB RN    
;NL XX RN
;NL BB RN

; where

;   XX - Represent the cell pair whose transition is being evaluated
;   N  - Represent the partial neighbour counts that are not affected
;        in any case by this transition (they are not neighbours of any of 
;        the evaluated cells)
;   L  - Represent the partial neighbour counts that must be updated if the
;        left cell of the pair changes its state.
;   R  - Represent the partial neighbour counts that must be updated if the
;        right cell of the pair changes its state.
;   B  - Represent the partial neighbour counts that must be updated if any
;        of the evauated cells change its state, unless both change in 
;        opposite senses, ie. tn1001, tn0110

; INPUT
; DE - Address of the cell pair whose neigbours are to be updated

; Only the first transition block is commented

.te0001      
.te1011      ; These are degenerate transitions, so they share code


; The rest of the section is straightforward, just iterate through the 
; neighbour cell pairs and update its neighbour counts according to what 
; has been depicted in the previous figure.
; The neigbours are scanned in an order that minimizes the number of vertical 
; jumps (which are expensive). 

ld hl,&2420  ; DE is used as a temporary storage to speed up a little bit some
             ; additions/substractions
incc        

ld a,(bc)
add l
ld (bc),a

moveLineup_phase1

ld a,(bc)
add l
ld (bc),a

decc

ld a,(bc)
add h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
add h
ld (bc),a

incc

ld a,(bc)
add l
ld (bc),a

jp neighupdtd	; We are done with this one, jump back to Phase1.asm

; And so on...

.te0010
.te0111


ld hl,&2404

decc

ld a,(bc)
add l
ld (bc),a

moveLineup_phase1

ld a,(bc)
add l
ld (bc),a

incc

ld a,(bc)
add h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
add h
ld (bc),a

decc

ld a,(bc)
add l
ld (bc),a

jp neighupdtd

.te0011


ld hl,&2004

incc

ld a,(bc)
add h
ld (bc),a

dec2c

ld a,(bc)
add l
ld (bc),a

moveLineup_phase1

ld a,(bc)
add l
ld (bc),a

incc

ld a,(bc)
add &48
ld (bc),a

incc

ld a,(bc)
add h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
add h
ld (bc),a

decc

ld a,(bc)
add &48
ld (bc),a

decc

ld a,(bc)
add l
ld (bc),a

jp neighupdtd

.te0100
.te1110


ld hl,&2420

incc

ld a,(bc)
sub l
ld (bc),a

moveLineup_phase1

ld a,(bc)
sub l
ld (bc),a

decc

ld a,(bc)
sub h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
sub h
ld (bc),a

incc

ld a,(bc)
sub l
ld (bc),a

jp neighupdtd

.te1000
.te1101


ld hl,&2404

decc

ld a,(bc)
sub l
ld (bc),a

moveLineup_phase1

ld a,(bc)
sub l
ld (bc),a

incc

ld a,(bc)
sub h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
sub h
ld (bc),a

decc

ld a,(bc)
sub l
ld (bc),a

jp neighupdtd

.te1100


ld hl,&2004

incc

ld a,(bc)
sub h
ld (bc),a

dec2c

ld a,(bc)
sub l
ld (bc),a

moveLineup_phase1

ld a,(bc)
sub l
ld (bc),a

incc

ld a,(bc)
sub &48
ld (bc),a

incc

ld a,(bc)
sub h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
sub h
ld (bc),a

decc

ld a,(bc)
sub &48
ld (bc),a

decc

ld a,(bc)
sub l
ld (bc),a

jp neighupdtd

.te0110


ld hl,&2004

incc

ld a,(bc)
sub h
ld (bc),a

dec2c

ld a,(bc)
add l
ld (bc),a

moveLineup_phase1

ld a,(bc)
add l
ld (bc),a

inc2c

ld a,(bc)
sub h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
sub h
ld (bc),a

dec2c

ld a,(bc)
add l
ld (bc),a

jp neighupdtd

.te1001


ld hl,&2004

incc

ld a,(bc)
add h
ld (bc),a

dec2c

ld a,(bc)
sub l
ld (bc),a

moveLineup_phase1

ld a,(bc)
sub l
ld (bc),a

inc2c

ld a,(bc)
add h
ld (bc),a

move2linesDown_phase1

ld a,(bc)
add h
ld (bc),a

dec2c

ld a,(bc)
sub l
ld (bc),a

jp neighupdtd
