; Lookup table generator

; USES
; H - Lookup table base address
; L - (NlNlNl) (NrNrNr) L R
; D - Calculate new state
; C - Temporary storage

ld hl,LOOKUPTABLE

.lookuptableloop

ld d,0

; Determine right bit state

ld a,l
and %00011100
rrca
ld c,a		; c = 0000 (NrNrNr)0

ld a,l
and %00000010	; a = 0000 00L0
add c
rrca
ld c,a		; c = 0000 0(NrNrNr + L)

ld a,l
and %00000001	; a = 0000 000R

or c		; 23/3 Rule simplification, if the new state is alive 
cp 3		; the result of the OR operation will be 3
jr nz,cont1	; otherwise the new state is dead
set 0,d		; d = 000 000 0 newR
.cont1

; Determine left bit state

ld a,l
and %11100000
rlca
rlca
rlca
ld c,a		; c = 0000 0(NlNlNl)

ld a,l
and %00000001	; a = 0000 000R
add c
ld c,a		; c = 0000 0(NlNlNl + R)

ld a,l
and %00000010
rrca		; a = 0000 000L

or c		; 23/3 Rule simplification, if the new state is alive 
cp 3		; the result of the OR operation will be 3
jr nz,cont2	; otherwise the new state is dead
set 1,d		; d = 000 000 newL newR
.cont2

ld a,l
and %00000011
rlca
rlca            ; a = 00 00 oldL oldR 00
or d            ; a = 00 00 oldL oldR newL newR
ld (hl),a       ; Write the result to lookup table

inc l           ; Proceed until we are done
jr nz,lookuptableloop
