	nolist


; 	Arkos Tracker - Player Test

;	If the SoundEffects is set to 1, you can press F1 and F3 to trigger sound effects, F2 to stop the one triggered with F1.

Player_Address		equ #7000
Music_Address		equ #4000
Music_SFX_Address	equ #4000

SoundEffects equ 0		;If to 1, set it also PLY_UseSoundEffects to 1 in the player.


	org #8000
	run $

	di
	ld hl,#c9fb
	ld (#38),hl

	ld de,Music_Address
	call Player_Address


	if SoundEffects
	ld de,Music_SFX_Address
	call PLY_SFX_Init
	endif

MainLoop

Sync	ld b,#f5
	in a,(c)
	rra
	jr nc,Sync + 2

	ei
	nop
	halt
	halt

	ld bc,#7f10
	out (c),c
	ld a,#4b
	out (c),a

	call Player_Address + 3
	ld bc,#7f44
	out (c),c
	halt
	di	

	ld bc,#7f54
	out (c),c

	if SoundEffects

	ld a,1+64
	call Keyboard
	cp %11011111
	jr z,KeyF1

	cp %10111111
	jr z,KeyF2

	ld a,0+64
	call Keyboard
	cp %11011111
	jr z,KeyF3

	endif

	jr MainLoop


	if SoundEffects
;Plays a Sound Effects along with the music.
;A = No Channel (0,1,2)
;L = SFX Number (>0)
;H = Volume (0...F)
;E = Note (0...143)
;D = Speed (0 = As original, 1...255 = new Speed (1 is fastest))
;BC = Pitch.
KeyF1
	ld a,1
	ld l,13
	ld h,15
	ld e,36
	ld d,20
	ld bc,0
	call PLY_SFX_Play
	jr MainLoop

KeyF2
	ld e,1
	call PLY_SFX_Stop
	jr MainLoop

KeyF3
	ld a,2
	ld l,3
	ld h,15
	ld e,60
	ld d,0
	ld bc,-40
	call PLY_SFX_Play
	jr MainLoop

Keyboard
	LD BC,#F782
	OUT (C),C
	LD BC,#F40E
	OUT (C),C
	LD BC,#F6C0
	OUT (C),C
	DEFB #ed,#71
	LD BC,#F792
	OUT (C),C
	DEC B
	OUT (C),A
	LD B,#F4
	IN A,(C)
	LD BC,#F782
	OUT (C),C
	DEC B
	DEFB #ed,#71
	RET




	endif


	org Player_Address
	read "ArkosTrackerPlayer_CPC_MSX.asm"





	org Music_Address
	incbin "molusk.bin"


	
	list
;*** End of Music
	nolist