#include <sbaudefs.h>

/* EXTENDED (SDS-310F) Mode user functions  */

unsigned int sba_acq_qual     (unsigned int mode,
                               unsigned long start,
                               unsigned long count);

unsigned int sba_clear        (void);
unsigned int sba_config_mode  (unsigned int mode);
unsigned int sba_data_file    (char *file);
unsigned int sba_delta_time   (unsigned int mode,
                               unsigned int line1,
                               unsigned int line2,
                               unsigned long *time);

unsigned int sba_display_data (unsigned int start,
										 unsigned int count,
                               unsigned int mode,
                               unsigned int time);

unsigned int sba_interactive_display (unsigned int start,
                               unsigned int mode,
                               unsigned int time);

unsigned int sba_event_filter (unsigned int width, 
                               unsigned int mode);

unsigned int sba_status       (unsigned int *status);
unsigned int sba_id_qual      (unsigned int mode,
                               unsigned char iid,
                               unsigned char tid,
                               unsigned int storage,
                               unsigned int trigger);

unsigned int sba_log_length   (unsigned int mode,
                               unsigned int *lines);

unsigned int sba_resolution   (unsigned int res);
unsigned int sba_run          (void);
unsigned int sba_scsi_bus     (unsigned int line,
                               unsigned long *control,
                               unsigned long *data);

unsigned int sba_state_data   (unsigned int start,
                               unsigned int state,
                               unsigned int count,
                               unsigned int offset,
                               unsigned int *data);

unsigned int sba_state_line   (unsigned int start,
                               unsigned int dirc,
                               unsigned int state,
                               unsigned int count,
                               unsigned int *line);

unsigned int sba_timing_line  (unsigned int start,
                               unsigned int dirc,
                               char *control,
                               char *data,
                               unsigned int trigger,
                               unsigned int count,
                               unsigned int *line);

unsigned int sba_trigger      (unsigned int mode,
                               char *control,
                               char *data,
                               char *external,
                               unsigned int count,
                               unsigned int position);

unsigned int sba_xlate        (unsigned int mode,
                               unsigned int line,
                               unsigned int *new);


/* END Prototypes for Logic (SCSI BUS) Analyzer User Functions  */
                     
