#include <stdio.h>
#include <string.h>
#include <stdlib.h>

union _vid {
	char name[8];
	unsigned short sname[4];
};
union _tid {
	char name[16];
	unsigned short sname[8];
};

struct dir0 {
  unsigned short dfirstblk;
  unsigned short dflastblk;
  unsigned short dfkind;
  union _vid dvid;
  unsigned short deovblk;
  unsigned short dnumfiles;
  unsigned short dloadtime;
  unsigned short dlastboot;
  unsigned short padding;
};
struct dirn {
  unsigned short dfirstblk;
  unsigned short dflastblk;
  unsigned short dfkind;
  union _tid dtid;
  unsigned short dlastbyte;
  unsigned short daccess;
};
#if 0
unsigned short swap(unsigned short x) {
  union u {
    unsigned short x;
    unsigned char c[2];
  } u;
  unsigned char s;
  u.x = x;
  s = u.c[0];
  u.c[0] = u.c[1];
  u.c[1] = s;
  return u.x;
}
#else
#define swap(x) (x)
#endif

/* format information:
 * single sided disks have track 0 formatted as SD  26 * 128 byte sectors
 * track 1-77 as DD 26 * 256 byte sectors, grouped as 512 byte virtual sectors
 * 
 * double sided disks have track 0, side 0 formatted as SD 26 * 128 byte
 * track0 side 1 as DD 26 * 256
 * track 1-154 as 26 * 256 byte sectors, grouped as 512 byte virtual sectors
 *
 * the directory starts at track 1, logical sector 2 (i.e. at sector 4 on track 1)
 */
int main(int argc, char* argv[])
{
  char name[17];
  char cbuf[512];
  char buf[512*30];
  FILE* in,*out;
  int i,n,k;
  int b,e,l;
  struct dir0* dir0;
  struct dirn* dirn;
  char *fname;
  int dsformat = 0;
  long blkoffset, pos;

  if (argc == 2) {
    /* single sided */
    fname = argv[1];
  } else if (argc == 3 && !strcmp(argv[1],"-d")) {
    /* double sided */
    dsformat = 1;
    fname = argv[2];
  } else {
    fprintf(stderr,"Usage: %s [-d] diskimage.bin\n",argv[0]);
    exit (1);
  }

  if ((in=fopen(fname,"rb"))==NULL) {
    fprintf(stderr,"Can't read %s\n",fname);
    exit(2);
  }
  
  printf("Extract boot record\n");
  fread(buf,26,128,in);
  out = fopen("bootrec.bin","wb");
  fwrite(buf,26,128,out);
  fclose(out);
  blkoffset = 26 * 128l;
 
  if (dsformat) {
    /* skip over 26 * 256 byte on side 1 */
    fread(buf,26,256,in);
    blkoffset += 26*256l;
  }

  /* skip over 2* 512 byte ucsd boot sectors (maybe unused) */
  fread(buf,2,512,in);

  /* read directory records */
  fread(buf,4,512,in);
  dir0 = (struct dir0*)buf;
  dirn = (struct dirn*)(buf+26);
  printf("Directory:\n");
  printf("  firstblock=%d\n",swap(dir0->dfirstblk));
  printf("  lastblock=%d\n",swap(dir0->dflastblk));
  for (i=0; i<4; i++) dir0->dvid.sname[i] = swap(dir0->dvid.sname[i]);
  printf("  volumeid=");
  for (i=1; i<=dir0->dvid.name[0]; i++) printf("%c",dir0->dvid.name[i]);
  putchar('\n');
  printf("  lastblock=%d\n",swap(dir0->deovblk));
  printf("  numfiles=%d\n",swap(dir0->dnumfiles));

  for (n=0; n<swap(dir0->dnumfiles); n++) {
    if (dirn[n].dfkind) {
      printf("\nFile=");
	  for (i=0; i<8; i++) dirn[n].dtid.sname[i] = swap(dirn[n].dtid.sname[i]);
	  for (i=1; i<=dirn[n].dtid.name[0]; i++) printf("%c",dirn[n].dtid.name[i]);
      putchar('\n');
      b = swap(dirn[n].dfirstblk);
      e = swap(dirn[n].dflastblk);
      l = swap(dirn[n].dlastbyte);
      printf("  firstblock=%d\n",b);
      printf("  lastblock=%d\n",e);
      printf("  filetype=0x%04x\n",swap(dirn[n].dfkind));
      printf("  lastbyte=%d\n",l);
      memset(name,0,17);
      strncpy(name,&dirn[n].dtid.name[1],dirn[n].dtid.name[0]);
	  for (i=0; i<dirn[n].dtid.name[0]; i++)
		if (name[i]=='/') name[i]='_';
      out = fopen(name,"wb");
#define BLKSIZE 512

      fseek(in,blkoffset+(b*BLKSIZE),0);
	  printf("b=%d seek to %x\n",b,blkoffset+(b*BLKSIZE));
      for (k=0; k<(e-b)-1; k++) {
		fread(cbuf,1,BLKSIZE,in);
		for (i=0; i<BLKSIZE; i+=2) {
//			char ss = cbuf[i];
//			cbuf[i] = cbuf[i+1];
//			cbuf[i+1] = ss;
		}
		fwrite(cbuf,1,BLKSIZE,out);
      }
	  fread(cbuf,1,l,in);
	  for (i=0; i<BLKSIZE; i+=2) {
//			char ss = cbuf[i];
//			cbuf[i] = cbuf[i+1];
//			cbuf[i+1] = ss;
	  }
	  fwrite(cbuf,1,l,out);
      fclose(out);
    }	
  }
}
