0010 Rem - IREBLD.bb
:!IREBLD - rebuild an existing index based on the current loading
:
:# D E S C R I P T I O N
:IREBLD uses the IBUILD utility to rebuild an index into a temporary index
:using a KFIND/KNEXT loop on the existing index and BLOCK WRITEs to the
:temporary index. The temporary index is then transferred back into the
:original index using a READ/WRITE loop. The desired blocking factor, 1% - 99%
:inclusive, can be specified by the user since IBUILD is used. If IREBLD is
:invoked via a RUN command or by typing only the program name as a CLI command
:the operation will be interactive. A status report on the selected index file
:will be displayed and the user will be prompted as to whether or not the file
:needs to be rebuilt. If the answer is yes, then the blocking factor is also
:requested and the index file is rebuilt. If IREBLD is invoked from the CLI
:with a series of arguments, or is SWAPped to with a series of arguments in
:common (in GETCM.SL format), then the operation is automatic and requires no
:further user input. This allows the program to be STARTed as either the first
:or last operation of the day to avoid index overflow problems. If this method
:is used, then the calling sequence below lists the order of the required
:arguments, none of which are optional, although the group may be repeated to
:process more than one index file with a single run of the program. In the CLI
:mode, several global switches are supported, as described below. For example,
:a list of the files processed and the action performed for each can be output
:to either the terminal or the default Qfile. Normal operation is to continue
:processing if certain non-fatal errors occur (eg. FILE NOT FOUND, a non-index
:file being encountered or and error from IBUILD). This can be switched to
:abort the program run if any error occurs by specifying the /A switch. To
:control program activity on the index being rebuilt, block 0 of the index file
:is LOCKed prior to processing and UNLOCKed upon completion. This method is
:used because the index is a logical file and, therefore, cannot be OPENed
:exclusively. This results in less than perfect synchronization since it is
:still possible for other activity to occur on the index. Specifically, a KNEXT
:loop in progress at the time IREBLD is invoked will not use block 0 and will
:result in an error when the temporary index is transferred back to the
:original index. Also, any index activity for which the no-lock flag has been
:set, either in the descriptor string or in the LOPEN, will not be stopped by
:the LOCK. Additionally, the impact on the system should IREBLD begin a rebuild
:while other jobs are accessing (KFINDing, etc.) the index is that the other
:jobs will hang waiting on the completion of the LOCK which is implicit in the
:KFIND, etc. Once IREBLD finishes, the outstanding LOCK requests will be
:satisfied and the jobs resumed. Therefore, is is recommended that IREBLD be
:the only job in the system accessing an index file while it is running. If an
:index is determined to be empty (zero keys on the lowest level) the index will
:be initialized as specified in block zero. This can be avoided by answering
:no to the query in interactive mode and by using the /N switch in
:CLI mode. Note, however, that there is generally no reason to avoid the
:initialization as this maximizes the amount of available space in the index.
:
:> C A L L I N G    S E Q U E N C E
:       following is the command syntax for operation from the CLI:
:!IREBLD{<switches>} <index-filename> <block-0-limit> <lowest-level-limit>
:                    <rebuild-blocking-factor>
:
:                <switches> is a list of zero or more of the following:
:
:                     /A to abort the program if any error occurs (standard
:                           operation is to continue with the next file if
:                           a non-fatal error occurs)
:                     /L output a list of file processed to the current
:                           default Qfile
:                     /N to prevent initialization of empty indexes (standard
:                           operation on an empty index is equivalent to an
:                           LFU/LINIT to restore all available space)
:                     /V to output a list of files processed to the terminal
:
:          <index-filename> is the name of a logical file name of a DB format
:                              logical file of type I
:           <block-0-limit> is the maximum acceptable percent loading from the
:                              statistics reported on block 0
:      <lowest-level-limit> is the minimum acceptable percent loading from the
:                              statistics reported on the lowest level
: <rebuild-blocking-factor> is the blocking factor to be used if the index is
:                              rebuilt
:
:The operation is as follows: the percent loading of both level 0 and the
:lowest level of the index are determined and compared with the limits supplied
:as arguments. If the percent loading from block 0 is greater than the supplied
:<block-0-limit> value (whole percentage only used, no decimal parts) AND the
:percent loading from the lowest level is less than the supplied <lowest-level-
:limit> then the index is rebuilt using the supplied <rebuild-blocking-factor>.
:
:@ F I L E S    U S E D
:The index file must be a logical file of type I and is LOPENed by IREBLD, a
:temporary index is used for rebuilding. The format for the filename of this
:temporary file is INDEX$$<processor-#><job-#>.TM, which makes the name unique
:for all jobs on the system, allowing multiple rebuilds to run simultaneously,
:although this is not encouraged.
:
::
0100 REM IREBLD - REBUILD INDEX INTO INDEX BASED ON LOADING   06/17/80   WEB
0110 DIM LFTABL$[26],B$[512],X$[132],F$[20],T9$[512],LFILE$[10],TYP$[1]
0120 READ E,R1,F%,P,GS,NF,OUTCH
0130 DATA 0,0,1,0,-1,0,16
0140 CLOSE 
0150 GOSUB 7550  :  \ INITCM
0160 GOSUB 7500  :  \ GETCM 
0165 STMA 6,1
0170 IF S=-1 THEN GOTO 0280
0175 STMA 14,X$,0
0180 IF X$<>"IREBLD" THEN GOTO 0280
0190 LET GS=S
0200 IF AND(GS,SHFT(1,20))=0 THEN GOTO 0280
0210 LET OUTCH=15
0220 LET GS=OR(GS,SHFT(1,10))
0230 STMA 9,3,X$
0240 OPEN FILE[OUTCH,2],X$
0250 PRINT FILE[OUTCH],"INDEX FILE CHECK/REBUILD           REV 1.00"
0260 PRINT FILE[OUTCH],USING "'00/00/00',T0,L7_0,F8.0,27X,'00:00:00',T0,L7_0,F8.0",SYS(28),SYS(27)
0270 PRINT FILE[OUTCH],
0280 IF GS=-1 THEN PRINT FILE[OUTCH],"INDEX FILE CHECK/REBUILD   REV 1.00"
0290 ON ERR THEN GOTO 9000
0300 ON IKEY THEN GOTO 9100
0310 IF GS=-1 THEN PRINT FILE[OUTCH],
0320 LET LFTABL$=FILL$(0)
0330 IF GPOS(0)<>-1 THEN CLOSE FILE[0]
0340 UNLOCK 
0350 GOSUB 5000  :  GET FILENAME
0360 IF LEN(X$)=0 THEN GOTO 0580
0370 IF X$="END" THEN GOTO 0580
0380 LET NF=NF+1
0390 GOSUB 7800  :  \ FINDFILE
0400 IF E=0 THEN GOTO 0510
0410 IF E<>-10 THEN STMA 19,E
0420 IF GS<>-1 THEN GOTO 0450
0430 PRINT FILE[OUTCH],"***   FILE NOT FOUND   ***"
0440 GOTO 0310
0450 IF AND(GS,SHFT(1,31)) THEN STMA 19,E
0460 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],", NOT FOUND"
0470 GOSUB 7500  :  \ GETCM 
0480 GOSUB 7500  :  \ GETCM 
0490 GOSUB 7500  :  \ GETCM 
0500 GOTO 0310
0510 IF TYP$="I" THEN GOTO 0630
0520 IF GS=-1 THEN GOTO 0560
0530 IF AND(GS,SHFT(1,31)) THEN STMA 19,89
0540 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],"NOT AN INDEX"
0550 GOTO 0470
0560 PRINT FILE[OUTCH],"LOGICAL FILE IS NOT AN INDEX"
0570 GOTO 0310
0580 CLOSE 
0590 LET F$="INDEX$$",SYS(25),SYS(9)/10,MOD(SYS(9),10),".TM"
0600 DELETE E,F$
0610 STMA 2,1,0
0620 END 
0630 LET E=30
0640 LOCK 1,1,0,E
0650 IF E=-1 THEN GOTO 0720
0660 IF GS=-1 THEN GOTO 0700
0670 IF AND(GS,SHFT(1,31)) THEN STMA 19,57
0680 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],", LOCKED"
0690 GOTO 0470
0700 PRINT FILE[OUTCH],"INDEX FILE IS LOCKED - TRY AGAIN LATER"
0710 GOTO 0310
0720 UNPACK "CL@21L",LFTABL$,C%,POSN,LREC
0730 LET BLK=POSN/512
0740 BLOCK READ FILE[C%,BLK],B$[1,512]
0750 UNPACK "CCCCCCC",B$,ELEN%,KPB%,LSTBLK%,NXTBLK%,L0BLK%,BLKFAC%,FLGS%
0760 LET BLKFAC%=(BLKFAC%*100+50)/KPB%
0770 LET PCNT0=((NXTBLK%-1)*10000/LSTBLK%+5)/10
0780 LET X$=PCNT0/10,".",MOD(PCNT0,10),"%"
0790 IF GS=-1 THEN PRINT FILE[OUTCH],"BLOCK 0 PERCENT LOADING  :  ";X$
0800 LET BLK=L0BLK%
0810 LET EMPTY=0
0820 LET FIRST=0
0830 LET TBLK=0
0840 LET TENTRY=0
0850 LET SBLK=POSN/512
0860 LET BLK=BLK+SBLK
0870 BLOCK READ FILE[C%,BLK],B$[1,512]
0880 LET X$="JJ@",ELEN%+1,"L"
0890 UNPACK X$,B$,NENTRY%,NXT%,BLK
0900 IF NXT%<0 THEN GOTO 1020
0910 IF NXT% THEN GOTO 0930
0920 GOTO 0860
0930 LET TENTRY=TENTRY+NENTRY%
0940 LET TBLK=TBLK+1
0950 LET BLK=NXT%+SBLK
0960 IF FIRST=0 THEN IF NENTRY%=0 THEN LET EMPTY=EMPTY+1
0970 IF NENTRY% THEN LET FIRST=1
0980 BLOCK READ FILE[C%,BLK],B$[1,512]
0990 UNPACK "JJ",B$,NENTRY%,NXT%
1000 IF NXT%>0 THEN GOTO 0930
1010 IF NXT%<>-1 THEN STMA 19,67
1020 LET TENTRY=TENTRY+NENTRY%-1
1030 LET TBLK=TBLK+1
1040 IF GS=-1 THEN PRINT FILE[OUTCH],"TOTAL NUMBER OF KEYS     : ";TENTRY
1050 IF GS=-1 THEN PRINT FILE[OUTCH],"TOTAL NUMBER OF BLOCKS   : ";TBLK
1060 LET MENTRY=(KPB%-1)*TBLK
1070 LET PCNT1=(TENTRY*10000/MENTRY+5)/10
1080 IF GS=-1 THEN PRINT FILE[OUTCH],"MAXIMUM NUMBER OF KEYS   : ";MENTRY
1090 LET X$=PCNT1/10,".",MOD(PCNT1,10),"%"
1100 IF GS=-1 THEN PRINT FILE[OUTCH],"PERCENT IN USE           :  ";X$
1110 IF GS=-1 THEN PRINT FILE[OUTCH],"EMPTY INITIAL SECTORS    : ";EMPTY
1120 GOSUB 5200  :  REBUILD ???
1130 IF X$<>"Y" THEN GOTO 1450
1140 LET F$="INDEX$$",SYS(25),SYS(9)/10,MOD(SYS(9),10),".TM"
1150 DELETE E,F$
1160 IF GPOS(1)<>-1 THEN CLOSE FILE[1]
1170 OPEN FILE[1,0],F$
1180 GOSUB 5500  :  GET BLOCKING FACTOR
1190 LET BLKFAC%=X
1200 LET KPB1%=MAX(2,(508/ELEN%*BLKFAC%+50)/100)
1210 PACK 1220,B$,0,POSN,LREC,512,1,0,LREC,512,KPB1%,FLGS%,0,ELEN%-4,-2
1220 RFORM  Z512LLLLLLLLJJJJJ
1230 BLOCK WRITE B$
1240 STMA 2,1,139
1250 STMA 2,2,0
1260 SWAP "IBUILD"
1270 STMA 1,1,E
1275 STMA 1,2,L
1280 IF E=0 THEN GOTO 1330
1290 IF GS<>-1 THEN IF AND(GS,SHFT(1,31)) THEN STMA 19,E
1300 IF GS<>-1 THEN IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],", IBUILD ERROR NO.";E
1310 IF GS=-1 THEN PRINT FILE[OUTCH],"***   ERROR #";E;"FROM IBUILD - SEE IBUILD DOCUMENTATION FOR MESSAGE(S)   ***";@(-25)
1320 GOTO 0310
1330 POSITION FILE[1,6]
1340 READ FILE[1],LST%
1350 POSITION FILE[0,POSN]
1360 POSITION FILE[1,0]
1370 STMA 6,5
1380 FOR R1=0 TO LST%-1
1390   READ FILE[1],B$[1,512]
1400   WRITE FILE[0],B$[1,512]
1410 NEXT R1
1420 STMA 7,5
1430 DELETE E,F$
1440 IF GS<>-1 THEN IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],", DONE"
1450 IF GS=-1 THEN PRINT FILE[OUTCH],
1460 GOTO 0310
5000 REM GET FILENAME
5005 IF GS<>-1 THEN GOTO 5020
5010 INPUT "INDEX FILE NAME [END]    :  ",X$
5015 RETURN 
5020 GOSUB 7500  :  \ GETCM 
5025 IF S=-1 THEN GOTO 5040
5030 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],"FILENAME = ";X$;
5035 RETURN 
5040 LET X$=""
5045 IF NF THEN RETURN 
5050 LET GS=-1
5055 GOTO 5010
5200 REM REBUILD ???
5203 TRACE ON
5205 IF TENTRY=0 THEN GOTO 5305
5210 IF GS<>-1 THEN GOTO 5235
5215 INPUT "REBUILD INDEX (Y,N) [N]  :  ",@(-10,1),X$
5220 IF LEN(X$)=0 THEN LET X$="N"
5223 TRACE OFF
5225 IF X$<>"Y" THEN IF X$<>"N" THEN GOTO 5215
5230 RETURN 
5235 GOSUB 7500  :  \ GETCM 
5240 GOSUB 7600  :  \ VAL WITH XCALL
5245 IF Y% THEN STMA 19,46
5250 LET LIM0=X
5255 GOSUB 7500  :  \ GETCM 
5260 GOSUB 7600  :  \ VAL WITH XCALL
5265 IF Y% THEN STMA 19,46
5270 LET LIM1=X
5275 LET X$="N"
5280 IF PCNT0/10>LIM0 THEN IF PCNT1/10<LIM1 THEN LET X$="Y"
5285 IF X$="Y" THEN RETURN 
5290 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],", NOT REBUILT"
5295 GOSUB 7500  :  \ GETCM 
5300 RETURN 
5305 IF GS<>-1 THEN GOTO 5335
5310 PRINT FILE[OUTCH],"***   INDEX IS EMPTY   ***";@(-25)
5315 INPUT USING "","INITIALIZE INDEX [Y]     : ",X$
5320 IF LEN(X$)=0 THEN LET X$="Y"
5325 IF X$="N" THEN RETURN 
5330 GOTO 5355
5335 LET X$=", EMPTY INDEX"
5340 IF AND(GS,SHFT(1,18))=0 THEN LET X$[0]=" - INITIALIZING"
5345 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],X$
5350 IF AND(GS,SHFT(1,18)) THEN GOTO 5410
5355 LET LSTBLK%=LREC
5360 LET NXTBLK%=2
5365 LET L0BLK%=1
5370 LET BLKFAC%=KPB%*BLKFAC%/100
5375 STMA 6,5
5380 POSITION FILE[0,POSN]
5385 WRITE FILE[0],ELEN%,KPB%,LSTBLK%,NXTBLK%,L0BLK%,BLKFAC%,FLGS%
5390 POSITION FILE[0,POSN+512]
5395 LET B$[1,512]=CHR$(1,2),FILL$(-1)
5400 WRITE FILE[0],B$
5405 STMA 7,5
5410 LET X$="N"
5415 IF GS=-1 THEN RETURN 
5420 GOSUB 7500  :  \ GETCM 
5425 GOSUB 7500  :  \ GETCM 
5430 GOSUB 7500  :  \ GETCM 
5435 RETURN 
5500 REM GET BLOCKING FACTOR
5505 IF GS<>-1 THEN GOTO 5545
5510 LET X$="BLOCKING FACTOR [",BLKFAC%,"]     :  "
5515 PRINT FILE[OUTCH],X$;
5520 INPUT "",X
5525 IF X=0 THEN LET X=BLKFAC%
5530 IF X>0 THEN IF X<100 THEN RETURN 
5535 PRINT FILE[OUTCH],"ILLEGAL BLOCKING FACTOR"
5540 GOTO 5510
5545 GOSUB 7500  :  \ GETCM 
5550 GOSUB 7600  :  \ VAL WITH XCALL
5555 IF Y% THEN STMA 19,46
5560 IF X=0 THEN LET X=BLKFAC%
5565 IF X<1 THEN STMA 19,150
5570 IF X>99 THEN STMA 19,150
5575 IF AND(GS,SHFT(1,10)) THEN PRINT FILE[OUTCH],", BLOCKING FACTOR =";X;
5580 RETURN 
%INCLUDE "/bb/syslib/GETCM.SL"
%INCLUDE "/bb/syslib/VAL.SL"
7800 REM \ LFINDFILE
7805 LET E=0
7810 LET LFTABL$[(F%-1)*26+1,F%*26]=FILL$(0)
7815 LOPEN E,FILE[F%,B$],X$
7817 IF E=-10 THEN RETURN 
7820 IF E THEN GOTO 7835
7825 UNPACK "CL+2A10CLA",LFTABL$[(F%-1)*26+1],CHAN,POSN,LFILE$,RLEN,LREC,TYP$
7830 RETURN 
7835 INPUT "BYTE OFFSET: ",POSN
7840 INPUT "RECORD LENGTH (BYTES): ",RLEN
7845 INPUT "LAST RECORD NUMBER: ",LREC
7850 FOR I=0 TO 15
7855   IF GPOS(I)=-1 THEN GOTO 7870
7860 NEXT I
7865 STMA 19,24
7870 LET CHAN=I
7875 LET LFILE$=X$
7880 INPUT USING "","FILE TYPE: ",@(-10,1),TYP$
7885 OPEN FILE[CHAN,6],X$
7890 LOPEN E,FILE[F%,CHAN],X$,TYP$,RLEN,LREC,POSN
7895 RETURN 
9000 REM ERROR HANDLER
9005 IF GS=-1 THEN GOTO 9030
9010 STMA 2,1,SYS(7)
9015 STMA 2,2,SYS(20)
9020 PRINT FILE[OUTCH],
9025 GOTO 9045
9030 LET X$="ERROR - ",ERM$(SYS(7))
9035 PRINT 
9040 PRINT X$
9045 LET F$="INDEX$$",SYS(25),SYS(9)/10,MOD(SYS(9),10),".TM"
9050 DELETE E,F$
9055 NEW 
9100 REM IKEY HANDLER
9105 IF GS<>-1 THEN GOTO 9045
9110 LET X$="  INT"
9115 PRINT X$
9120 STMA 8,0
9125 STMA 7,5
9130 GOTO 0300
