0010 Rem - XBUILD.bb  
: !P_XBUILD
:
: BUILDS AN INDEX FILE GIVEN A DATA FILE USING KADDS
:
: ARGUEMENTS PASSED IN COMMON
:   LOC  LEN  USE
:    1    4   CHANNEL # OF INPUT FILE 
:    5    4   BYTE OFFSET TO REC # 0 OF INPUT FILE
:    9    4   LAST-RECORD-NUMBER IN INPUT FILE 
:   13    4   # OF BYTES PER RECORD IN INPUT FILE
:   17    4   CHANNEL # OF INDEX FILE 
:   21    4   BYTE OFFSET TO REC # 0 OF INDEX FILE
:   25    4   LAST-RECORD-NUMBER IN INDEX FILE 
:   29    4   # OF BYTES PER RECORD IN INDEX FILE 
:   33    2   # PER BLOCK (BLOCKING FACTOR)
:   35    2   FLAG TO DISALLOW DUPLICATE KEYS   
:   37    2   FLAG TO CHECK FOR DELETED RECORDS
:   39    2   TOTAL KEY FIELD LENGTH (BYTES)
:   41    2   # OF KEY FIELDS 
:   43+  2*2  STARTING & ENDING BYTE # (RELATIVE TO 1) OF KEY
:             FIELDS IN ORDER OF SIGNIFIGANCE
:
: RETURNED
:   STMA 2,1,(ERROR CODE)
:   STMA 2,2,(LINE # IN ERROR)
:
: DATA FILE: KEY EXTRACTED FROM DATA RECORD COMPOSED OF THE FIELDS 
:   SPECIFIED, UP TO THE TOTAL KEY FIELD LENGTH. PADDING OF ODD SIZED
:   KEYS WITH NULLS IS AUTOMATIC.
:   DATA RECORDS 1 TO MAX#-1 ARE PROCESSED.
:
0050 REM XBUILD - REV 2.00 (09/26/77)
0100 ON ERR THEN GOTO 5030           :Return error traps to c calling program
0110 LET ERCODE%=0                  :Init error code
0200 DIM BUF$[544],LFTABL$[52]
0210 LET LFTABL$=FILL$(0)
0230 BLOCK READ BUF$                :Read arguments from common
0260 UNPACK "LLLLLL",BUF$,INPCHN%,INPDSP%,INPMAX%,INPSIZ%,NDXCHN%,NDXDSP% :Channel # of input file
0290 UNPACK "@25LLJJJJJ",BUF$,NDXMAX%,NDXSIZ%,KPBLOC%,DUPKEY%,CKSTAT%,KEYLEN%,NKFLDS% :Displacement to input file
0520 DIM KDEF%[NKFLDS%*2,0]        :Allocate key definition array
0522 FOR I%=43 TO 41+4*NKFLDS% STEP 2   :Extract field locations
0524   LET KDEF%[(I%-43)/2]=ASC(BUF$[I%,I%+1])
0526 NEXT I%
0528 LET NKFLDS%=NKFLDS%-1         :Change 1:n to 0:n-1
0530 DIM KDEF%[NKFLDS%,1]          :ReDIM for easier access
0535 DIM REC$[INPSIZ%]             :Allocate input record
0650 IF MOD(NDXDSP%,512) THEN GOTO 5008       :Required to be on block boundary
0680 LET KEYSIZ%=KEYLEN%+4+AND(KEYLEN%,1)     :Key entry size must be even
0710 LET KPBLOK%=508/KEYSIZ%        :Max number of keys per block
0740 LET LSTBLK%=NDXMAX%            :Keep last block #
0770 LET NXTBLK%=2                  :Beginning block #
0800 LET NXTL0%=1                   :Next level 0 block
0830 LET BLKFAC%=KPBLOC%            :Keep blocking factor
0860 IF NDXSIZ%<>512 THEN GOTO 5007      :Index block size must be 512
0890 IF KPBLOC%>=KPBLOK% THEN GOTO 5009   :Illegal blocking factor
0920 DIM KEY$[KEYLEN%]
0950 LET BUF$=FILL$(0)           :Initialize buffer
:
:   Init index file
0980 POSITION FILE[NDXCHN%,NDXDSP%]
1010 WRITE FILE[NDXCHN%],KEYSIZ%,KPBLOK%,NDXMAX%,NXTBLK%,NXTL0%,BLKFAC%,DUPKEY%,BUF$[1,498]
1040 LET BUF$="<0><1>",FILL$(-1,510)
1070 WRITE FILE[NDXCHN%],BUF$
1100 LOPEN FILE[1,NDXCHN%,3],"","I",512,NDXMAX%,NDXDSP%
:
:   Data file procedure
3000 POSITION FILE[INPCHN%,INPDSP%+INPSIZ%] :Position to beginning of file 
3005 FOR ITMP=1 TO INPMAX%-1         :Process data file between limits
3010   LET RECNO=ITMP               :Current record #
3020   POSITION FILE[INPCHN%,RECNO*INPSIZ%+INPDSP%]
3040   READ FILE[INPCHN%],REC$       :Read record
3050   IF EOF(INPCHN%) THEN GOTO 3130     :File shorter than specified
3060   IF CKSTAT% THEN IF REC$[1,2]="<0><0>" THEN GOTO 3120    :Skip deleted records
3064   LET KEY$=""                 :Clear key
3066   FOR I%=0 TO NKFLDS%         :Compose key
3068     LET KEY$[0]=REC$[KDEF%[I%,0],KDEF%[I%,1]]
3070   NEXT I%
3100   KADD 1,BUF$,KEY$,RECNO      :Add index entry 
3120 NEXT ITMP
3130 GOTO 5060
5000 DATA 68,150,148,45,149,151,85,146
5003 READ ERCODE%        : 146 - Duplicate entry
5004 READ ERCODE%        : 077 - Invalid record pointer
5005 READ ERCODE%        : 151 - Key size found > specified
5006 READ ERCODE%        : 149 - Input record out of sequence
5007 READ ERCODE%        : 045 - Illegal index record size(<>512)
5008 READ ERCODE%        : 148 - Illegal index file displacement
5009 READ ERCODE%        : 150 - Illegal blocking factor
5010 READ ERCODE%        : 068 - Index space exhausted
5015 LET X%=0                      :Clear line #, not a BASIC error
5020 GOTO 5050
5030 LET ERCODE%=SYS(7)            :BASIC error code
5040 LET X%=SYS(20)         :Line # in error
5050 STMA 2,2,X%
5060 STMA 2,1,ERCODE%
5080 END
