/*
	Optable.h - Use to list p-codes.
*/

#include	"/bb/include/opcodes.h"

static	struct optab {
   char *opname;
   int  opval;
} optab[] = {

	/* 0 byte iops */
	"%nops",	0,
	"NOP",		NOP,
	"STMTX",	STMTX,
	"LD0J",		LD0J,
	"LD0L",		LD0L,
	"LD0X",		LD0X,
	"LD1J",		LD1J,
	"LD1L",		LD1L,
	"LD1X",		LD1X,
	"ANDJ",		ANDJ,
	"ANDL",		ANDL,
	"ORJ",		ORJ,
	"ORL",		ORL,
	"XORJ",		XORJ,
	"XORL",		XORL,
	"NOTJ",		NOTJ,
	"NOTL",		NOTL,
	"LTZJ",		LTZJ,
	"LEZJ",		LEZJ,
	"EQZJ",		EQZJ,
	"NEZJ",		NEZJ,
	"GEZJ",		GEZJ,
	"GTZJ",		GTZJ,
	"ASCL",		ASCL,
	"INTX",		INTX,
	"LENJ",		LENJ,
	"SYSL",		SYSL,
	"SHFX",		SHFX,
	"SQRJ",		SQRJ,
	"SQRL",		SQRL,
	"SQRX",		SQRX,
	"RNDJ",		RNDJ,
	"RNDL",		RNDL,
	"RNDX",		RNDX,
	"VALJ",		VALJ,
	"VALL",		VALL,
	"VALX",		VALX,
	"EXPJ",		EXPJ,
	"EXPL",		EXPL,
	"EXPX",		EXPX,
	"ABSJ",		ABSJ,
	"ABSL",		ABSL,
	"ABSX",		ABSX,
	"MAXJ",		MAXJ,
	"MAXL",		MAXL,
	"MAXX",		MAXX,
	"MINJ",		MINJ,
	"MINL",		MINL,
	"MINX",		MINX,
	"MODJ",		MODJ,
	"MODL",		MODL,
	"MODX",		MODX,
	"SGNJ",		SGNJ,
	"SGNL",		SGNL,
	"SGNX",		SGNX,
	"SHFJ",		SHFJ,
	"SHFL",		SHFL,
	"NEGL",		NEGL,
	"NEGX",		NEGX,
	"CMPJ",		CMPJ,
	"CMPL",		CMPL,
	"CMPX",		CMPX,
	"ADDJ",		ADDJ,
	"ADDL",		ADDL,
	"ADDX",		ADDX,
	"SUBJ",		SUBJ,
	"SUBL",		SUBL,
	"SUBX",		SUBX,
	"MULJ",		MULJ,
	"MULL",		MULL,
	"MULX",		MULX,
	"DIVJ",		DIVJ,
	"DIVL",		DIVL,
	"DIVX",		DIVX,
	"NEGJ",		NEGJ,
	"LDIL",		LDIL,
	"LDIX",		LDIX,
	"LDIDJ",	LDIDJ,
	"LDIDL",	LDIDL,
	"LDIDX",	LDIDX,
	"STIJ",		STIJ,
	"STIL",		STIL,
	"STIX",		STIX,
	"STIDJ",	STIDJ,
	"STIDL",	STIDL,
	"STIDX",	STIDX,
	"LDIJ",		LDIJ,
	"FXJL",		FXJL,
	"FXJX",		FXJX,
	"FXLJ",		FXLJ,
	"FXLX",		FXLX,
	"FXXJ",		FXXJ,
	"FXXL",		FXXL,
	"CVLJ",		CVLJ,
	"CVXJ",		CVXJ,
	"CVXL",		CVXL,
	"RETFN",	RETFN,
	"DPRL",		DPRL,
	"RETSUB",	RETSUB,
	"MOVS",		MOVS,
	"UPCL",		UPCL,
	"CMPA",		CMPA,
	"INA",		INA,
	"INJ",		INJ,
	"INL",		INL,
	"INX",		INX,
	"RDA",		RDA,
	"RDJ",		RDJ,
	"RDL",		RDL,
	"RDX",		RDX,
	"RDLJ",		RDLJ,
	"WRA",		WRA,
	"WRJ",		WRJ,
	"WRL",		WRL,
	"WRX",		WRX,
	"WRLJ",		WRLJ,
	"PAKA",		PAKA,
	"PAKJ",		PAKJ,
	"PAKL",		PAKL,
	"PAKX",		PAKX,
	"PAKD",		PAKD,
	"UPKA",		UPKA,
	"UPKJ",		UPKJ,
	"UPKL",		UPKL,
	"UPKX",		UPKX,
	"UPKD",		UPKD,
	"PRA",		PRA,
	"PRJ",		PRJ,
	"PRL",		PRL,
	"PRX",		PRX,
	"PRUA",		PRUA,
	"PRUJ",		PRUJ,
	"PRUL",		PRUL,
	"PRUX",		PRUX,
	"PAKSET",	PAKSET,
	"PAKEND",	PAKEND,
	"UPKSET",	UPKSET,
	"PRSET",	PRSET,
	"PRCOM",	PRCOM,
	"PRTAB",	PRTAB,
	"PRCTL",	PRCTL,
	"PRCR",		PRCR,
	"PREND",	PREND,
	"PRUSET",	PRUSET,
	"PRUEND",	PRUEND,
	"INSET",	INSET,
	"INUSET",	INUSET,
	"INPRM",	INPRM,
	"INCTL",	INCTL,
	"INCR",		INCR,
	"INEND",	INEND,
	"TISET",	TISET,
	"TIUSET",	TIUSET,
	"RDSET",	RDSET,
	"RDEND",	RDEND,
	"WRSET",	WRSET,
	"WREND",	WREND,
	"STMA1",	STMA1,
	"STMA2",	STMA2,
	"STMA3",	STMA3,
	"STMA4",	STMA4,
	"STMA5",	STMA5,
	"STMA6",	STMA6,
	"STMA7",	STMA7,
	"STMA8",	STMA8,
	"STMA9",	STMA9,
	"STMA10",	STMA10,
	"STMA11",	STMA11,
	"STMA12",	STMA12,
	"STMA13",	STMA13,
	"STMA14",	STMA14,
	"STMA15",	STMA15,
	"STMA19",	STMA19,
	"STMA20",	STMA20,
	"STMA21",	STMA21,
	"STMB0",	STMB0,
	"STMB1",	STMB1,
	"STMB2",	STMB2,
	"STMB3",	STMB3,
	"STMB4",	STMB4,
	"STMB5",	STMB5,
	"STMB10",	STMB10,
	"STMB11",	STMB11,
	"STMB21",	STMB21,
	"STMB22",	STMB22,
	"STMB24",	STMB24,
	"STMC0",	STMC0,
	"STMC1",	STMC1,
	"STMC5",	STMC5,
	"STMC6",	STMC6,
	"STMC7",	STMC7,
	"STMC8",	STMC8,
	"STMC9",	STMC9,
	"STMC21",	STMC21,
	"STMC23",	STMC23,
	"STMC24",	STMC24,
	"STMC25",	STMC25,
	"STMC28",	STMC28,
	"STMC29",	STMC29,
	"STMC34",	STMC34,
	"STMC35",	STMC35,
	"STMC36",	STMC36,
	"STMC39",	STMC39,
	"STMC40",	STMC40,
	"STMC41",	STMC41,
	"STMC42",	STMC42,
	"STMC43",	STMC43,
	"STMC44",	STMC44,
	"STMC45",	STMC45,
	"STMC46",	STMC46,
	"STMC47",	STMC47,
	"STMC52",	STMC52,
	"GPOSL",	GPOSL,
	"EOFJ",		EOFJ,
	"POSJ",		POSJ,
	"STRJ",		STRJ,
	"STRL",		STRL,
	"STRX",		STRX,
	"CHRL",		CHRL,
	"CRM",		CRM,
	"ERM",		ERM,
	"FILL",		FILL,
	"TRUN",		TRUN,
	"UCM",		UCM,
	"CHAIN",	CHAIN,
	"RETERR",	RETERR,
	"RETINT",	RETINT,
	"DELETE",	DELETE,
	"RENAME",	RENAME,
	"OPEN",		OPEN,
	"PEND",		PEND,
	"PSAVE",	PSAVE,
	"PREPLACE",	PREPLACE,
	"SPOS",		SPOS,
	"LOCKL",	LOCKL,
	"LOCKS",	LOCKS,
	"BLKRD",	BLKRD,
	"BLKRDD",	BLKRDD,
	"BLKWR",	BLKWR,
	"BLKWRD",	BLKWRD,
	"LOPNB",	LOPNB,
	"LOPNC",	LOPNC,
	"LRD",		LRD,
	"LWR",		LWR,
	"DELREC",	DELREC,
	"GETREC",	GETREC,
	"KADDL",	KADDL,
	"KADDS",	KADDS,
	"KDELL",	KDELL,
	"KDELS",	KDELS,
	"KFNDL",	KFNDL,
	"KFNDS",	KFNDS,
	"KNXTL",	KNXTL,
	"KNXTS",	KNXTS,
	"NEW",		NEW,
	"BYE",		BYE,
	"CLOSE",	CLOSE,
	"STOP",		STOP,
	"SYSTEM",	SYSTEM,
	"SBREAK",	SBREAK,
	"XCAL11",	XCAL11,
	"XCAL15",	XCAL15,
	"XCAL16",	XCAL16,
	"STRPOS",	STRPOS,
	"VALUE",	VALUE,
	"QADD",		QADD,
	"QSUB",		QSUB,
	"QMUL",		QMUL,
	"QDIV",		QDIV,
	"QLOAD",	QLOAD,
	"QSTORE",	QSTORE,
	"SWHILE",	SWHILE,
	"SUNTIL",	SUNTIL,
	"EXTRACT",	EXTRACT,
	"STMC17",	STMC17,
	"STMC22",	STMC22,
	"ABORT",	ABORT,
	"START",	START,

	/* 1 byte iops */
	"%nops",	1,
	"LDBJ",		LDBJ,
	"LDBL",		LDBL,
	"CALLFN",	CALLFN,

	/* 2 byte iops */
	"%nops",	2,
	"LDCJ",		LDCJ,
	"LDVJ",		LDVJ,
	"LDDL",		LDDL,
	"LDDJ",		LDDJ,
	"LDVL",		LDVL,
	"FORL",		FORL,
	"NXTL",		NXTL,
	"SBVL",		SBVL,
	"SBAL",		SBAL,
	"SBDL",		SBDL,
	"RFORM",	RFORM,
	"CALLFS",	CALLFS,
	"LDDA",		LDDA,
	"SBDA",		SBDA,
	"SWAP",		SWAP,
	"ONERR",	ONERR,
	"ONINT",	ONINT,
	"DELAY",	DELAY,
	"DIMA",		DIMA,
	"DIMJ",		DIMJ,
	"DIML",		DIML,
	"DIMX",		DIMX,
	"CLRSTK",	CLRSTK,
	"DFLTBL",	DFLTBL,

	/* 3 byte iops ( 1 byte & 1 word ) */
	"%nops",	3,
	"DEFFN",	DEFFN,

	/* 4 byte iops */
	"%nops",	4,
	"LDCL",		LDCL,
	"LDA",		LDA,
	"SBA",		SBA,
	"LDV",		LDV,
	"SBV",		SBV,

	/* pc address i-ops */
	"%nops",	(-1),
	"JMP",		JMP,
	"JMPF",		JMPF,
	"JMPT",		JMPT,
	"DATA",		DATA,
	"GOSUB",	GOSUB,
	"MAKDL",	MAKDL,
	"RESTOR",	RESTOR,

	/* Special case opcodes */
	"%nops",	(-2),
	"ONGO",		ONGO,
	"ONGS",		ONGS,
	"LDCA",		LDCA,

	/* ??? byte iops */
	"%nops",	0,
	"LDBX",		LDBX,
	"LDCX",		LDCX,
	"LDVX",		LDVX,
	"LDDX",		LDDX,
	"SBDJ",		SBDJ,
	"SBDX",		SBDX,
	"SBAJ",		SBAJ,
	"SBAX",		SBAX,
	"SBVJ",		SBVJ,
	"SBVX",		SBVX,
	"DPRJ",		DPRJ,
	"DPRX",		DPRX,
	"FORJ",		FORJ,
	"FORX",		FORX,
	"NXTJ",		NXTJ,
	"NXTX",		NXTX,
	"LDAV",		LDAV,
	"LDD",		LDD,
	"SBD",		SBD,
	"FCALL",	FCALL,
	"FRET",		FRET,
	"BREAK",	BREAK,
	"DEBUG",	DEBUG,
	"RNDMZ",	RNDMZ,
	"RSTFN",	RSTFN,
	"RSTGS",	RSTGS,
	"TRACE",	TRACE,
	"UNLOCK",	UNLOCK,

	/* end list */
	(char *)0,0
};
