/*************************************************************************
*
*
*	Name:  filefns.c
*
*	Description:  File descriptor 'functions'.
*				gpos()	= get file pos.
*				spos()	= set file pos.
*				eof()	= get EOF status.
*
*
*	History:
*	Date		By		Comments
*
*	10/27/83	waf		Created by segmenting bopen.c.
*						Changed eof() to return TRUE or FALSE.
*	10/28/83	waf		Use badchan()/badfchan() macros to chk legal channel #.
*	11/2/83		waf		Declare lseek() fn.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

11/2/83		waf
  Note that the lseek() fn MUST be declared as a function returning a long
value. If it is not, the file fn's do not work properly.

*/

#include	"/bb/include/ptype.h"
#include	"/bb/include/pextern.h"
#include	"/bb/include/bberms.h"
#include	"/bb/include/syerms.h"

extern	long	lseek();



spos (channel, position)
int	channel;
long	position;
{
	register struct frec *ftr;

	if ( badfchan(channel) )
		bberr(BEIFN);				/* illegal file number */

	ftr = &ust.ftab[channel];
	if (ftr->xfd == -1)
		bberr(BEFNO); 				/* file not open */

	if ((ftr->opmode & SEQ_FM) == SEQ_FM ||	/* error if sequential mode  */
		(ftr->opmode & CHAR_FM) == CHAR_FM)	/* or character only file */
		bberr(BEWRM); 		

	ftr->opmode &= ~EOF_FS;			/* reset EOF */
	lastfileno = channel;			/* set last-file-accessed */
	if (lseek(ftr->xfd, position, 0) < 0L)
		bberr(ERSCP);				/* error if couldn't position */
	}



long gpos (channel)
int	channel;
{
	register struct frec *ftr;

	if ( badchan(channel) )
		bberr(BEIFN);				/* illegal channel number */

	if (channel == 16)
		return(0L);				/* special for console */
	ftr = &ust.ftab[channel];
	if (ftr->xfd == -1)
		return(-1L); 				/* file not open */

	lastfileno = channel;			/* set last-file-accessed */
	return(lseek(ftr->xfd, 0L, 1));
	}

eof (channel)
int	channel;
{
	register struct frec *ftr;

	if ( badchan(channel) )
		bberr(BEIFN);				/* illegal channel number */

	if (channel == 16)
		return( FALSE );		/* special for console */

	ftr = &ust.ftab[channel];
	if (ftr->xfd == -1)
		return( TRUE ); 		/* file not open */
	lastfileno = channel;			/* set last-file-accessed */
	return((ftr->opmode & EOF_FS) ? TRUE : FALSE);
	}
