/*************************************************************************
*
*
*	Name:  getval.c
*
*	Description:  get and put value from/to numeric desc
*
*
*	History:
*	Date		By	Comments
*
*	2/16/83		mas
*	6/24/83 	mas		changed to use registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -
	getvj - Get int value given numeric descriptor
	getvl - Get long value given numeric descriptor
	putvj - Put int value given numeric descriptor
	putvl - Put long value given numeric descriptor
*/



#include "/bb/include/ptype.h"

long getvl(xnumdesc)
NUMDES	*xnumdesc;		/* source numeric descriptor */
{
register NUMDES *numdesc;

	numdesc = xnumdesc;

	if (isvar(numdesc) == FALSE)
		panic();

	switch (numdesc->ntype) {
		case 0: return(*numdesc->ndata.j);
		case 1:	return(*numdesc->ndata.l);
	}
}

getvj(xnumdesc)
NUMDES	*xnumdesc;		/* source numeric descriptor */
{
register NUMDES *numdesc;

	numdesc = xnumdesc;

	if (isvar(numdesc) == FALSE)
		panic();

	switch (numdesc->ntype) {
		case 0: return(*numdesc->ndata.j);
		case 1:	return(*numdesc->ndata.l);
	}
}

putvj(xnumdesc,value)
NUMDES	*xnumdesc;		/* destination numeric descriptor */
int	value;
{
register NUMDES *numdesc;

	numdesc = xnumdesc;

	if (isvar(numdesc) == FALSE)
		return;

	switch (numdesc->ntype) {
		case 0: *numdesc->ndata.j = value;
			return;
		case 1:	*numdesc->ndata.l = (long)value;
	}
}

putvl(xnumdesc,value)
NUMDES	*xnumdesc;		/* destination numeric descriptor */
long	value;
{
register NUMDES *numdesc;

	numdesc = xnumdesc;

	if (isvar(numdesc) == FALSE)
		return;

	switch (numdesc->ntype) {
		case 0: *numdesc->ndata.j = (int)value;
			return;
		case 1:	*numdesc->ndata.l = value;
	}
}
