/*************************************************************************
*
*
*	Name:  hdchksum.c
*
*	Description:  Compute header check-sum.
*
*
*	History:
*	Date		By		Comments
*
*	12/07/83	waf
*	03/06/84	waf		Fixed chksum computation.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	This module was created to centralize & make more efficient the chk sum
  computation for p-code headers. (Making it a fn allows the use of dedicated
  register vars).
	This module is used by the p-machine and the Debugger.
*/


#include	"/bb/include/ptype.h"



hdchksum ( hdptr )

/* Given ptr to header, computes chk sum value.

Description -
	The chksum value is the negated modulo 16 sum of all (unsigned) words
	in the header.

Return -
	Ret value = computed check sum.
*/

struct	phead	*hdptr;		/* ptr to *start* of header */
{
	register unsigned	*uptr;
	register unsigned	csum;


	csum = 0 ;
	for ( uptr = hdptr ; uptr < &(hdptr->chksum) ; )
		csum -= *uptr++ ;

	return(csum);
	}
