/*************************************************************************
*
*
*	Name:  pdata.c
*
*	Description:  Global data used by p-machine
*
*
*	History:
*	Date		By	Comments
*
*	03/01/83	mas
*	05/13/83	WEB	added default terminal characteristics
*	10/18/83	waf		Added gflags.
*	11/16/83	waf		Added baseheader.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include <setjmp.h>
#include "/bb/include/ptype.h"

	/* Global flags area */
	union	gflg	gflags;

	/* I/O buffer */
	char	iobuf[IOSIZE];

	/* Input status structure */
	struct	ios iostat;

	/* Terminal Buffer */
	char	termbuf[TERMSIZE];
	int	termcount;

	/* Default terminal characteristics */
	int	defterm;
	int	deflcan;
	int	defdel;
	int	defunp1;
	int	defunp2;
	int	defik1;
	int	defik2;

	/* valid IKEY jump vector flag */
	int	valikey;

	/* IKEY long jump environment */
	jmp_buf	ikeyenv;

	/* ERROR long jump environment */
	jmp_buf	errenv;

	/* valid Alarm jump vector flag */
	int	valalarm;

	/* Alarm long jump environment */
	jmp_buf	alarmenv;

	/* Last error number */
	int	lasterrno;

	/* PC of line in which IKEY occurred */
	char	*pcint;

	/* PC of Last line in error */
	char	*pcerr;

	/* PC of Last line executed */
	char	*pclast;

	/* Last file number used */
	int	lastfileno;

	/* Random number generator seed */
	unsigned randseed;

	/* Time left after timed input */
	unsigned timeleft;

	/* Time requested for timed input */
	unsigned alarmreq;

	/* CRM$ characters */
	char	cram[4];

	/*	User Status Table	*/
	struct usrtable ust;

	/*  Headers  */
	struct phead	pcheader;	/* P-code and push file header */
	struct bhead	basheader;	/* base pgm header */

	/* Environment of p-code */
	unsigned penviron;

	/* Begin of memory area */
	char	*begmem;

	/* End of memory */
	char	*endmem;

	/* Begin of evaluation stack */
	char	*begstk;

	/*  Base frame pointer - always points to bottom of stack */
	struct SFRAME *BFP;

	/* Global Frame Pointer - points to current global frame */
	struct GFRAME *GFP;

	/* Frame Pointer - points the the local frame */
	POINTER	FP;

	/* Line to begin execution at (used by START p-code) */
	unsigned startline;

	/* PMD DUMP switch - pmdump() checks this before allowing dump */
	unsigned pmdsw;

	/* Debug switch - causes a call to the debugger if START executed */
	unsigned debugsw;

	/* last error or int location */
	char	*sys20pc;

	/* dummy system and global frames used to capture errors during */
	/* periods where there is no stack as in a swap or chain */
	struct	SFRAME	DSF;
	struct	GFRAME	DGF;

	/* TRACE fd used to write trace output */
	int	tracefd;

	/* Temp holding area for PC and SP */
	char	*TPC;
	char	*TSP;

	/* Global switch set by parsecmd and used by sys(11) */
	long	globsw;

	/* INPUT label of next statement */
	int	inlabel;

	/* tty structures used by terminit + termreset + crts.c */
#include <sgtty.h>
	struct	sgttyb	oldmode;
	struct	sgttyb	newmode;
	struct	tchars	oldchar;

	/* PUSH file descriptor */
	int	pushfd;

	/* pointer to BBPATH string in environ */
	char	*bbpath;

	/* continue switch - when set the p-machine  registers are loaded
	   from the p-code header */
	int	contsw;

	/* fd of the error file (/bb/syslib/basic.er) */
	int	errfd;

	/* fd of the special number file (/bb/syslib/basic.no) */
	int	numfd;

	/* spool directory used in open ?xxx */
	char	*xspooldir = "/bb/spool/";

	/* debugger file name - must be complete path name */
	char	*xdebugger = "/bb/bbdeb";

	/* library directory - used in chkpath as second dir to search */
	char	*xlibdir = "/bb/syslib/";

	/* error file  - complete path name */
	char	*xerrfile = "/bb/syslib/basic.er";

	/* system program library - complete path name */
	char	*xproglib = "/bb/syslib/basic.pl";

	/* basic number file - job numbers and serial number */
	char	*xnumfile = "/bb/syslib/basic.no";

	/* push stack - keeps track of next location in push file */
	long	pushstk[12];

	/* push file name - if given */
	char	*pushname;
