/*************************************************************************
*
*
*	Name:  stmcopn.c
*
*	Description:  STMC calls which open files ( STMC 39-42 & 44 ).
*
*
*	History:
*	Date		By	Comments
*
*	10/11/83	waf		Use ust.ftab[].dev to make ust.ftab[].ino unique across
*					multiple file systems.
*	10/27/83	waf		Use BBCHANS param.
*	10/28/83	waf		Use badchan()/badfchan() macros to chk legal channel #.
*	11/11/83	waf		This module created to combine stmc 39,40,41,42,44 mods.
*
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

  The values of the p-codes for STMC 39,40,41,42,(43),&44 MUST be sequential
(see define's of s39-s44).

*/



#include <sys/types.h>
#include <sys/stat.h>

#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"
#include "/bb/include/pcondcomp.h"
#include "/bb/include/pextern.h"


/* define call flags (39-42,44). The value of the flag is the difference
   between the value of a given p-code and the value of STMC 39.
   Note - p-code vals must be sequential. */
#define	s39		0	/* STMC 39 */
#define	s40		1	/* STMC 40 */
#define	s41		2	/* STMC 41 */
#define	s42		3	/* STMC 42 */
#define	s44		5	/* STMC 44 */


#define ALL		0L			/* lock all of file */
#define NBRLOCK	4			/* Non-Blocking Read allowing LOCK */


stmcopn (type,err,file,mask,channel)

int		type;		/* type of call (STMC 39,40,41, or 42) */
NUMDES	err;		/* err ret var */
STRDES	file;		/* filename */
int	mask;
int	channel;

{
	register struct frec *ftr;
	register int e,fd;
	char 	filnam1[129];
	struct stat	stat;
	int		openmode;

	/** set up **/
	e = NOERC ;		/* init err code */
	movdb(&file, filnam1, 128);		/* copy filename */
	ftr = &ust.ftab[channel];		/* ptr to file table entry */

	if ( badfchan(channel) )
		e = ERFNO;	 /* Illegal File Number */
	else if (ftr->xfd != -1) 
		e = ERUFT;	 /* UFT in use */
	else {

		/* open file */
		fd = open( filnam1, (type == s41)? 0 : 2 );
		if ( fd < 0 ) {
			/* open error */
			e = errxlt(errno);		/* translate if error */
			}
		}

	if ( e != NOERC )
		goto reterr;	/* report error */

	/* lock file ( STMC 39,40,44 ) */
#ifndef NOLOCKING
	if ( type == s39 || type == s40 || type == s44 ) {
		if ( locking(fd,NBRLOCK,ALL) < 0 ) {
			e = ERFIU;			/* File In Use */
			goto reterr;
			}
		}
#endif

	/* do type specific stuff */
	switch ( type ) {

		case s39:	/* .APPEND */
			lseek(fd,0L,2);		/* position to end of file */
			ftr->opmode = RW_FM + EX_FM;
			break;

		case s44:	/* .TOPEN */
		case s40:	/* .EOPEN */
			ftr->opmode = RW_FM + EX_FM;
			break;

		case s41:	/* .ROPEN */
			ftr->opmode = RD_FM + SH_FM;
			break;

		case s42:	/* .OPEN */
			ftr->opmode = RW_FM + SH_FM;
			break;

		default:
			panic();	/* trap bad 'type' vals */
		}

	/* update file table entry */
	ftr->xfd = fd;			/* save fdesc */
	fstat(fd,&stat);			/* get status */
	ftr->ino = stat.st_ino;		/* save inode in file table */
	ftr->dev = stat.st_dev;		/* save dev codes in file table */

reterr:
	/* return error var */
	putvj(&err,-e);

	}
